/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.ColunasDbf;
import com.org.model.classes.agravos.AutoctoneMalariaPactuacao;
import com.org.negocio.Configuracao;
import com.org.negocio.Util;
import com.org.util.ArquivoUtils;
import com.org.util.SinanUtil;
import com.org.view.Master;
import java.io.IOException;
import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;

public class PreenchimentoOcupacaoTrabalhadorPactuacao
extends Agravo {
    static String ANO;
    Agravo municipioResidencia;
    HashMap<String, Agravo> municipiosBeans = new HashMap();
    DBFUtil utilDbf = new DBFUtil();

    public PreenchimentoOcupacaoTrabalhadorPactuacao(boolean isDbf) {
        this.setDBF(isDbf);
        this.setPeriodo("de Diagn\u00f3stico");
        this.setTipoAgregacao("de Resid\u00eancia");
        this.init("postgres");
    }

    @Override
    public void init(String tipoBanco) {
        this.setArquivo("ACIBIONETT");
        this.setTextoCompletitude("");
        this.setMultiplicador(100000);
        this.setTipo("");
        this.setTipo("populacao");
        this.setTitulo1("Propor\u00e7\u00e3o de preenchimento do campo \u201cocupa\u00e7\u00e3o\u201d nas notifica\u00e7\u00f5es de agravos relacionados ao trabalho");
        this.setTituloColuna("Indicador");
        this.setRodape("Indicador: Propor\u00e7\u00e3o de preenchimento do campo \u201cocupa\u00e7\u00e3o\u201d nas notifica\u00e7\u00f5es de agravos relacionados ao trabalho  \n");
        this.setSqlNumeradorCompletitude("");
        if (!this.isDBF()) {
            this.setSqlNumeradorMunicipioEspecifico("select count(*) as numerador from dbsinan.tb_notificacao as t1, dbsinan.tb_investiga_aids_crianca as t2 where  t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao and nu_idade < 4005 and tp_criterio_definicao not in (900,901) and (t1.dt_diagnostico_sintoma BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and t1.co_municipio_residencia = ?");
            this.setSqlDenominadorMunicipioEspecifico("select nu_pop1a4anos+nu_pop1ano as denominador from dblocalidade.tb_estatistica_ibge where co_uf_municipio_ibge = ? and nu_ano = ?");
            this.setSqlNumeradorEstado("select count(*) as numerador from dbsinan.tb_notificacao as t1, dbsinan.tb_investiga_aids_crianca as t2 where  t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao and nu_idade < 4005 and tp_criterio_definicao not in (900,901) and (t1.dt_diagnostico_sintoma BETWEEN ?  AND ?) and t1.co_uf_residencia= ? ");
            this.setSqlDenominandorEstado(this.getSqlDenominadorMunicipioEspecifico());
            this.setSqlNumeradorBeanMunicipios(this.getSqlNumeradorMunicipioEspecifico());
            this.setSqlDenominadorBeanMunicipios(this.getSqlDenominadorMunicipioEspecifico());
        }
    }

    private void calculaIndicador(Object[] rowObjects, Map parametros) throws ParseException {
        Boolean CID_Z209 = false;
        Boolean CID_Y96 = false;
        Boolean CID_T659 = false;
        Boolean ID_OCUPACAO_N = false;
        Boolean DOENCA_TRA = false;
        Boolean OCUPACAO_INVALIDA = false;
        int numerador = 0;
        int denominador = 0;
        int numeradorEstadual = 0;
        int denominadorEstadual = 0;
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        Object dtPrimeirosSintomas = null;
        Object dtTratamento = null;
        ArrayList<String> invalidos = new ArrayList<String>();
        invalidos.add("999991");
        invalidos.add("999992");
        invalidos.add("999993");
        invalidos.add("999994");
        invalidos.add("999995");
        invalidos.add("998999");
        CID_Z209 = this.utilDbf.getString(rowObjects, "ID_AGRAVO").equals("Z209");
        CID_Y96 = this.utilDbf.getString(rowObjects, "ID_AGRAVO").equals("Y96");
        CID_T659 = this.utilDbf.getString(rowObjects, "ID_AGRAVO").equals("T659");
        if (CID_T659.booleanValue() && this.utilDbf.getString(rowObjects, "DOENCA_TRA") != null) {
            DOENCA_TRA = this.utilDbf.getString(rowObjects, "DOENCA_TRA").equals("1");
        }
        if (this.utilDbf.getString(rowObjects, "ID_OCUPA_N") != null && !invalidos.contains(this.utilDbf.getString(rowObjects, "ID_OCUPA_N"))) {
            ID_OCUPACAO_N = !this.utilDbf.getString(rowObjects, "ID_OCUPA_N").isEmpty();
        }
        Date dtDiagnostico = this.utilDbf.getDate(rowObjects, "DT_NOTIFIC");
        if (this.municipioResidencia != null && (CID_Z209.booleanValue() || CID_Y96.booleanValue() || CID_T659.booleanValue() && DOENCA_TRA.booleanValue()) && this.isBetweenDates(dtDiagnostico, dataInicio, dataFim)) {
            numerador = Integer.parseInt(this.municipioResidencia.getNumerador());
            this.municipioResidencia.setNumerador(String.valueOf(++numerador));
            this.municipioResidencia.setNumeradorInt(numerador);
            numeradorEstadual = (Integer)parametros.get("numeradorTotal");
            parametros.put("numeradorTotal", ++numeradorEstadual);
            if (ID_OCUPACAO_N.booleanValue()) {
                denominador = Integer.parseInt(this.municipioResidencia.getDenominador());
                this.municipioResidencia.setDenominador(String.valueOf(++denominador));
                this.municipioResidencia.setDenominadorInt(denominador);
                denominadorEstadual = (Integer)parametros.get("denominadorTotal");
                parametros.put("denominadorTotal", ++denominadorEstadual);
            }
        }
    }

    private void calculaRegiao(DBFReader reader, Map parametros) throws ParseException {
        String ufResidencia = (String)parametros.get("parUf");
        String sgUfResidencia = (String)parametros.get("parSgUf");
        String codRegional = (String)parametros.get("parCodRegional");
        String codRegiao = (String)parametros.get("parCodRegiaoSaude");
        HashMap<Object, Object> regBeans = new HashMap();
        parametros.put("numeradorTotal", 0);
        parametros.put("denominadorTotal", 0);
        String idMunicipio = parametros.get("parMunicipio") != null ? (String)parametros.get("parMunicipio") : "TODOS";
        if (codRegional == null) {
            codRegional = "";
        }
        if (codRegiao == null) {
            codRegiao = "";
        }
        if (((Boolean)parametros.get("parIsRegiao")).booleanValue()) {
            this.municipiosBeans = this.populaRegiaoBeans(sgUfResidencia, codRegiao);
            regBeans = this.populaMunicipiosBeansMAL(sgUfResidencia, codRegiao, idMunicipio, parametros.get("parIsRegiao").toString());
        } else {
            this.municipiosBeans = this.populaRegionalBeans(sgUfResidencia, codRegional);
            regBeans = this.populaMunicipiosBeansMAL(sgUfResidencia, codRegional, idMunicipio, parametros.get("parIsRegiao").toString());
        }
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                this.utilDbf.mapearPosicoes(reader);
                double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (this.utilDbf.getString(rowObjects, "SG_UF_NOT") != null) {
                        try {
                            Agravo ag = null;
                            ag = (Agravo)regBeans.get(this.utilDbf.getString(rowObjects, "ID_MUNICIP"));
                            if (ag != null) {
                                this.municipioResidencia = (Boolean)parametros.get("parIsRegiao") != false ? this.municipiosBeans.get(ag.getCodRegiaoSaude()) : this.municipiosBeans.get(ag.getCodRegional());
                                this.calculaIndicador(rowObjects, parametros);
                            }
                        }
                        catch (Exception ex) {
                            Logger.getLogger(AutoctoneMalariaPactuacao.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                    this.getBarraStatus().setString("Calculando Indicador... " + (int)percentual + "% " + (k + 1) + " de " + arquivos.length + " (" + arquivos[k] + ")");
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException ex) {
                Master.mensagem("Erro:\n" + (Object)((Object)ex));
            }
        }
        String ano = dataInicio.substring(0, 4);
        this.setBeans(new ArrayList());
        Collection<Agravo> municipioBean = this.municipiosBeans.values();
        for (Agravo agravoDBF : municipioBean) {
            this.getBeans().add(agravoDBF);
            this.getBarraStatus().setString("Calculando indicador para: " + agravoDBF.getNomeMunicipio());
        }
        this.getBarraStatus().setString(null);
        ComparatorChain chain = new ComparatorChain(Arrays.asList(new BeanComparator("uf"), new BeanComparator("nomeMunicipio")));
        Collections.sort(this.getBeans(), chain);
        if (((Boolean)parametros.get("parIsRegiao")).booleanValue()) {
            this.getBeans().add(this.adicionaTotal(municipioBean, codRegiao));
        } else {
            this.getBeans().add(this.adicionaTotal(municipioBean, codRegional));
        }
    }

    private void calculaMunicipios(DBFReader reader, Map parametros) throws ParseException {
        String ufResidencia = (String)parametros.get("parUf");
        String sgUfResidencia = (String)parametros.get("parSgUf");
        String codRegional = (String)parametros.get("parCodRegional");
        String codRegiao = (String)parametros.get("parCodRegiaoSaude");
        String idMunicipio = parametros.get("parMunicipio") != null ? (String)parametros.get("parMunicipio") : "TODOS";
        parametros.put("numeradorTotal", 0);
        parametros.put("denominadorTotal", 0);
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        if (codRegional == null) {
            codRegional = "";
        }
        if (codRegiao == null) {
            codRegiao = "";
        }
        this.municipiosBeans = (Boolean)parametros.get("parIsRegiao") != false ? this.populaMunicipiosBeansMAL(sgUfResidencia, codRegiao, idMunicipio, parametros.get("parIsRegiao").toString()) : this.populaMunicipiosBeansMAL(sgUfResidencia, codRegional, idMunicipio, parametros.get("parIsRegiao").toString());
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                this.utilDbf.mapearPosicoes(reader);
                double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (this.utilDbf.getString(rowObjects, "SG_UF_NOT") != null) {
                        this.municipioResidencia = this.municipiosBeans.get(this.utilDbf.getString(rowObjects, "ID_MUNICIP"));
                        this.calculaIndicador(rowObjects, parametros);
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                    this.getBarraStatus().setString("Calculando Indicador... " + (int)percentual + "% " + (k + 1) + " de " + arquivos.length + " (" + arquivos[k] + ")");
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException ex) {
                Master.mensagem("Erro:\n" + (Object)((Object)ex));
            }
        }
        String ano = dataInicio.substring(0, 4);
        this.setBeans(new ArrayList());
        Collection<Agravo> municipioBean = this.municipiosBeans.values();
        for (Agravo agravoDBF : municipioBean) {
            this.getBeans().add(agravoDBF);
            this.getBarraStatus().setString("Calculando indicador para: " + agravoDBF.getNomeMunicipio());
        }
        this.getBarraStatus().setString(null);
        ComparatorChain chain = (Boolean)parametros.get("parIsRegiao") != false ? new ComparatorChain(Arrays.asList(new BeanComparator("uf"), new BeanComparator("regiaoSaude"), new BeanComparator("nomeMunicipio"))) : new ComparatorChain(Arrays.asList(new BeanComparator("uf"), new BeanComparator("regional"), new BeanComparator("nomeMunicipio")));
        Collections.sort(this.getBeans(), chain);
        if (((Boolean)parametros.get("parIsRegiao")).booleanValue()) {
            this.getBeans().add(this.adicionaTotal(municipioBean, codRegiao));
        } else {
            this.getBeans().add(this.adicionaTotal(municipioBean, codRegional));
        }
    }

    private void calculaSomenteMunicipios(DBFReader reader, Map parametros) throws ParseException {
        String ufResidencia = (String)parametros.get("parUf");
        String sgUfResidencia = (String)parametros.get("parSgUf");
        String idMunicipio = parametros.get("parMunicipio") != null ? (String)parametros.get("parMunicipio") : "TODOS";
        this.municipiosBeans = this.populaMunicipiosBeansMAL(sgUfResidencia, "", idMunicipio, "false");
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        parametros.put("numeradorTotal", 0);
        parametros.put("denominadorTotal", 0);
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                this.utilDbf.mapearPosicoes(reader);
                double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    this.municipioResidencia = this.municipiosBeans.get(this.utilDbf.getString(rowObjects, "ID_MUNICIP"));
                    this.calculaIndicador(rowObjects, parametros);
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                    this.getBarraStatus().setString("Calculando Indicador... " + (int)percentual + "% " + (k + 1) + " de " + arquivos.length + " (" + arquivos[k] + ")");
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException ex) {
                Master.mensagem("Erro:\n" + (Object)((Object)ex));
            }
        }
        String ano = dataInicio.substring(0, 4);
        this.setBeans(new ArrayList());
        Collection<Agravo> municipioBean = this.municipiosBeans.values();
        for (Agravo agravoDBF : municipioBean) {
            this.getBeans().add(agravoDBF);
            this.getBarraStatus().setString("Calculando indicador para: " + agravoDBF.getNomeMunicipio());
        }
        this.getBarraStatus().setString(null);
        ComparatorChain chain = new ComparatorChain(Arrays.asList(new BeanComparator("uf"), new BeanComparator("nomeMunicipio")));
        Collections.sort(this.getBeans(), chain);
        this.getBeans().add(this.adicionaTotal(municipioBean, ""));
    }

    public static int dataDiff(java.util.Date dataLow, java.util.Date dataHigh) {
        GregorianCalendar startTime = new GregorianCalendar();
        GregorianCalendar endTime = new GregorianCalendar();
        GregorianCalendar curTime = new GregorianCalendar();
        GregorianCalendar baseTime = new GregorianCalendar();
        try {
            startTime.setTime(dataLow);
            endTime.setTime(dataHigh);
            int dif_multiplier = 1;
            if (dataLow.compareTo(dataHigh) < 0) {
                baseTime.setTime(dataHigh);
                curTime.setTime(dataLow);
                dif_multiplier = 1;
            } else {
                baseTime.setTime(dataLow);
                curTime.setTime(dataHigh);
                dif_multiplier = -1;
            }
            int result_years = 0;
            int result_months = 0;
            int result_days = 0;
            while (curTime.get(1) < baseTime.get(1) || curTime.get(2) < baseTime.get(2)) {
                int max_day = curTime.getActualMaximum(5);
                result_months += max_day;
                curTime.add(2, 1);
            }
            return result_years + (result_months *= dif_multiplier) + (result_days += endTime.get(5) - startTime.get(5));
        }
        catch (Exception e) {
            System.out.println(e);
            return -1;
        }
    }

    @Override
    public void calcula(DBFReader reader, Map parametros) {
        Boolean municipios = (Boolean)parametros.get("parNenhum") == false;
        Boolean somenteMunicipios = parametros.get("parDesagregacao").equals("Somente munic\u00edpios");
        try {
            if (somenteMunicipios.booleanValue()) {
                this.calculaSomenteMunicipios(reader, parametros);
            } else if (municipios.booleanValue()) {
                this.calculaMunicipios(reader, parametros);
            } else {
                this.calculaRegiao(reader, parametros);
            }
        }
        catch (ParseException ex) {
            System.out.println(ex);
            ArquivoUtils.gerarLogErro(ex);
        }
    }

    @Override
    public Map getParametros() {
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parDataInicio", Util.formataData(this.getDtInicioAvaliacao()));
        parametros.put("parDataFim", Util.formataData(this.getDtFimAvaliacao()));
        parametros.put("parPeriodo", "de " + this.getDtInicioAvaliacao() + " a " + this.getDtFimAvaliacao());
        parametros.put("parTituloColuna", this.getTituloColuna());
        parametros.put("parFator", String.valueOf(this.getMultiplicador()));
        parametros.put("parAno", Util.getAno(this.getDtFimAvaliacao()));
        parametros.put("parRodape", this.getRodape());
        parametros.put("parConfig", "");
        parametros.put("parTitulo1", "Propor\u00e7ao de Casos de Mal\u00e1ria que iniciaram tratamento em tempo oportuno.");
        ANO = "";
        if (Util.getAno(this.getDtFimAvaliacao()).equals(Util.getAno(this.getDtInicioAvaliacao()))) {
            ANO = Util.getAno(this.getDtFimAvaliacao());
        }
        this.setDataInicio(this.getDtInicioAvaliacao());
        this.setDataFim(this.getDtFimAvaliacao());
        return parametros;
    }

    @Override
    public String[] getOrdemColunas() {
        return new String[]{"COUFNOT", "ID_LOCNOT", "DS_LOCNOT", "COD_CIR", "NOME_CIR", "N_OCPRE", "D_SAUTRA", "P_RACPRE", "ANO_NOTI", "DT_NOTIN", "DT_NOTIFI", "ORIGEM"};
    }

    @Override
    public HashMap<String, ColunasDbf> getColunas() {
        HashMap<String, ColunasDbf> hashColunas = new HashMap<String, ColunasDbf>();
        hashColunas.put("COUFNOT", new ColunasDbf(30));
        hashColunas.put("ID_LOCNOT", new ColunasDbf(30));
        hashColunas.put("DS_LOCNOT", new ColunasDbf(30));
        hashColunas.put("COD_CIR", new ColunasDbf(30));
        hashColunas.put("NOME_CIR", new ColunasDbf(30));
        hashColunas.put("N_OCPRE", new ColunasDbf(30));
        hashColunas.put("D_SAUTRA", new ColunasDbf(30));
        hashColunas.put("P_RACPRE", new ColunasDbf(30));
        hashColunas.put("ANO_NOTI", new ColunasDbf(30));
        hashColunas.put("DT_NOTIN", new ColunasDbf(30));
        hashColunas.put("DT_NOTIFI", new ColunasDbf(30));
        hashColunas.put("ORIGEM", new ColunasDbf(30));
        this.setColunas(hashColunas);
        return hashColunas;
    }

    @Override
    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        for (int i = 0; i < bean.size(); ++i) {
            Object[] rowData = new Object[colunas.size()];
            Agravo agravo = (Agravo)bean.get(i);
            if (agravo.getNomeMunicipio().equals("BRASIL") || agravo.getNomeMunicipio().equals("TOTAL")) {
                rowData[0] = null;
                rowData[1] = null;
                rowData[3] = null;
                rowData[4] = null;
            } else {
                rowData[0] = agravo.getCodIbgeUF(agravo.getUf());
                rowData[1] = agravo.getCodMunicipio();
                if (agravo.getRegional() != null && agravo.getRegional() != null) {
                    if (!agravo.getRegional().isEmpty()) {
                        rowData[0] = SinanUtil.siglaUFToIDUF(agravo.getUf());
                        rowData[3] = agravo.getCodRegional();
                        rowData[4] = agravo.getRegional();
                    } else if (!agravo.getRegiaoSaude().isEmpty()) {
                        rowData[3] = agravo.getCodRegiaoSaude();
                        rowData[4] = agravo.getRegiaoSaude();
                    }
                }
            }
            rowData[2] = agravo.getNomeMunicipio();
            rowData[5] = agravo.getDenominador();
            rowData[6] = agravo.getNumerador();
            if (Integer.valueOf(agravo.getNumerador()) <= 0) {
                rowData[7] = "0.0";
            } else {
                Double percentual = Double.valueOf(agravo.getDenominador()) / Double.valueOf(agravo.getNumerador()) * 100.0;
                rowData[7] = String.format("%.1f", percentual);
            }
            rowData[8] = String.valueOf(this.preencheAno(this.getDataInicio(), this.getDataFim()).intValue());
            rowData[9] = this.getDataInicio();
            rowData[10] = this.getDataFim();
            rowData[11] = "SaudeTrabalhador-SINANNET";
            writer.addRecord(rowData);
        }
        return writer;
    }

    @Override
    public String getCaminhoJasper() {
        return "/com/org/relatorios/PreenchimentoOcupacaoTrabalhadorPactuacao.jasper";
    }
}

