/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.agravos.oportunidade.CasoRecebimentoLote;
import com.org.model.classes.agravos.oportunidade.OportunidadeAgravoPQAVS;
import com.org.model.classes.agravos.oportunidade.RecebimentoLoteAgravo;
import com.org.negocio.Configuracao;
import com.org.negocio.Municipio;
import com.org.negocio.Util;
import com.org.util.SinanUtil;
import com.org.view.Master;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecebimentoLote
extends Agravo {
    private boolean periodoValido180dias = true;
    private boolean periodoValido60dias = true;
    private boolean porAgravo;
    private String dataAvaliacao;
    private String anoAvaliado;
    private String dtInicioAvaliacao;
    private String dtFimAvaliacao;
    private String dtInicioTransf;
    private String dtFimTransf;
    private String dtInicioReceb;
    private String dtFimReceb;
    private String nomeAgravo;
    private String uf;
    private String municipio;
    private String sqlCalculoAgravos180dias;
    private String sqlCalculoAgravos60dias;
    private String sqlCalculoAgravosMalaria60dias;
    private List<String> agravosValidos = new ArrayList<String>();
    private String sqlCalculoAgravoEspecifico;
    private List<Municipio> municipios = new ArrayList<Municipio>();
    private List<CasoRecebimentoLote> listExportacao = new ArrayList<CasoRecebimentoLote>();

    public List<CasoRecebimentoLote> getListExportacao() {
        return this.listExportacao;
    }

    public void setListExportacao(List<CasoRecebimentoLote> listExportacao) {
        this.listExportacao = listExportacao;
    }

    public RecebimentoLote(boolean isDbf) {
        this.setDBF(isDbf);
        this.setPeriodo("de avalia\u00e7\u00e3o");
        this.setTipoAgregacao("de Resid\u00eancia");
        this.init("postgres");
    }

    private String buscaRegiao(String uf) {
        if (uf.equals("TO")) {
            return "NORTE";
        }
        if (uf.equals("AC")) {
            return "NORTE";
        }
        if (uf.equals("AL")) {
            return "NORDESTE";
        }
        if (uf.equals("AM")) {
            return "NORTE";
        }
        if (uf.equals("AP")) {
            return "NORTE";
        }
        if (uf.equals("BA")) {
            return "NORDESTE";
        }
        if (uf.equals("CE")) {
            return "NORDESTE";
        }
        if (uf.equals("DF")) {
            return "CENTRO-OESTE";
        }
        if (uf.equals("ES")) {
            return "SUDESTE";
        }
        if (uf.equals("GO")) {
            return "CENTRO-OESTE";
        }
        if (uf.equals("MA")) {
            return "NORDESTE";
        }
        if (uf.equals("MG")) {
            return "SUDESTE";
        }
        if (uf.equals("MS")) {
            return "CENTRO-OESTE";
        }
        if (uf.equals("MT")) {
            return "CENTRO-OESTE";
        }
        if (uf.equals("PA")) {
            return "NORTE";
        }
        if (uf.equals("PB")) {
            return "NORDESTE";
        }
        if (uf.equals("PE")) {
            return "NORDESTE";
        }
        if (uf.equals("PI")) {
            return "NORDESTE";
        }
        if (uf.equals("PR")) {
            return "SUL";
        }
        if (uf.equals("RJ")) {
            return "SUDESTE";
        }
        if (uf.equals("RN")) {
            return "NORDESTE";
        }
        if (uf.equals("RO")) {
            return "NORTE";
        }
        if (uf.equals("RR")) {
            return "NORTE";
        }
        if (uf.equals("RS")) {
            return "SUL";
        }
        if (uf.equals("RO")) {
            return "NORTE";
        }
        if (uf.equals("SC")) {
            return "SUL";
        }
        if (uf.equals("SE")) {
            return "NORDESTE";
        }
        if (uf.equals("SP")) {
            return "SUDESTE";
        }
        return null;
    }

    @Override
    public String buscaRegiaoSaude(String idRegiao) throws SQLException {
        if (idRegiao == null) {
            return "";
        }
        DBFReader reader = SinanUtil.retornaObjetoDbfCaminhoArquivo("REGIAO", "dbf\\");
        DBFUtil utilDbf = new DBFUtil();
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            while ((rowObjects = reader.nextRecord()) != null) {
                if (!idRegiao.equals(utilDbf.getString(rowObjects, "ID_REGIAO"))) continue;
                return utilDbf.getString(rowObjects, "NM_REGIAO");
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro: regional nao encontrada.Verifique se existe a pasta DBF e se os arquivo REGIONET.DBF est\u00e1 l\u00e1:\n" + (Object)((Object)e));
        }
        return "";
    }

    public String formataData(String data) {
        return data.split("-")[2] + "/" + data.split("-")[1] + "/" + data.split("-")[0];
    }

    private int retornaDiferenca(String agravo) {
        if (agravo.equals("B19") || agravo.equals("B551") || agravo.equals("P350")) {
            return 180;
        }
        return 60;
    }

    private String classificaSituacao(String situacao) {
        if (situacao.equals("Oportuno")) {
            return "1";
        }
        if (situacao.equals("Inoportuno com outras categorias")) {
            return "2";
        }
        if (situacao.equals("Inconclusivo")) {
            return "2";
        }
        if (situacao.equals("N\u00e3o Encerrado")) {
            return "3";
        }
        if (situacao.equals("Data inv\u00e1lida")) {
            return "4";
        }
        return "";
    }

    private void populaBeanExportacaoDBF(String situacao, String agravo, String idMunicipioNotificacao, String idMunicipioResidencia, String dtNotificacao, String nmNotificacao, String idUnidade, String dtEncerramento) {
        CasoRecebimentoLote caso = new CasoRecebimentoLote();
        caso.setAgravo(agravo);
        caso.setSituacao(this.classificaSituacao(situacao));
        caso.setIdMunicipio(idMunicipioNotificacao);
        caso.setIdMunicipioResidencia(idMunicipioResidencia);
        caso.setDtNotificacao(dtNotificacao);
        caso.setNumNotificacao(nmNotificacao);
        caso.setIdUnidade(idUnidade);
        caso.setAno(dtNotificacao.substring(6, 10));
        caso.setSgUF(idMunicipioNotificacao.substring(0, 2));
        if (idMunicipioResidencia != null) {
            caso.setSgUFResidencia(idMunicipioResidencia.substring(0, 2));
        }
        caso.setDtEncerramento(dtEncerramento);
        this.getListExportacao().add(caso);
    }

    private String classificaNotificacao(int diferencaDatas, int diferencaValida, OportunidadeAgravoPQAVS agravoBean, int classificaoFinal) {
        String retorno = "";
        if (diferencaDatas < 0) {
            agravoBean.setQtdDataInvalida(agravoBean.getQtdDataInvalida() + 1);
            retorno = "Data Inv\u00e1lida";
        } else if (diferencaDatas > diferencaValida) {
            if (classificaoFinal == 8) {
                agravoBean.setQtdInoportuno(agravoBean.getQtdInoportuno() + 1);
                retorno = "Inconclusivo";
            } else {
                agravoBean.setQtdInoportunoOutras(agravoBean.getQtdInoportunoOutras() + 1);
                retorno = "Inoportuno com outras categorias";
            }
        } else if (diferencaDatas <= diferencaValida) {
            agravoBean.setQtdOportuno(agravoBean.getQtdOportuno() + 1);
            retorno = "Oportuno";
        }
        agravoBean.setTotal(agravoBean.getTotal() + 1);
        return retorno;
    }

    public HashMap<String, OportunidadeAgravoPQAVS> populaUfsBeansOportuno() {
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap uf = new HashMap();
        HashMap<String, OportunidadeAgravoPQAVS> ufsBeans = new HashMap<String, OportunidadeAgravoPQAVS>();
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("UF", "dbf\\");
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                OportunidadeAgravoPQAVS agravoDbf = new OportunidadeAgravoPQAVS();
                agravoDbf.setNmAgravo(utilDbf.getString(rowObjects1, "SG_UF"));
                agravoDbf.setUf(utilDbf.getString(rowObjects1, "SG_UF"));
                agravoDbf.setCodAgravo(utilDbf.getString(rowObjects1, "ID_UF"));
                agravoDbf.setRegiao(this.buscaRegiao(agravoDbf.getNmAgravo()));
                agravoDbf.setCodRegiaoSaude(utilDbf.getString(rowObjects1, "ID_REGIAO"));
                try {
                    agravoDbf.setRegiaoSaude(this.buscaRegiaoSaude(utilDbf.getString(rowObjects1, "ID_REGIAO")));
                }
                catch (SQLException ex) {
                    Logger.getLogger(RecebimentoLote.class.getName()).log(Level.SEVERE, null, ex);
                }
                agravoDbf.setQtdDataInvalida(0);
                agravoDbf.setQtdInoportuno(0);
                agravoDbf.setQtdNaoEncerrado(0);
                agravoDbf.setQtdOportuno(0);
                agravoDbf.setTotal(0);
                uf.put(utilDbf.getString(rowObjects1, "ID_UF"), utilDbf.getString(rowObjects1, "SG_UF"));
                ufsBeans.put(agravoDbf.getCodAgravo(), agravoDbf);
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        uf = this.sortHashMapByValues(uf, false);
        Set ufKeys = ((HashMap)uf).keySet();
        HashMap<String, OportunidadeAgravoPQAVS> ufsBeansRetorno = new HashMap<String, OportunidadeAgravoPQAVS>();
        for (String key : ufKeys) {
            ufsBeansRetorno.put(key, (OportunidadeAgravoPQAVS)ufsBeans.get(key));
        }
        return ufsBeansRetorno;
    }

    public void populaBeanRecebimento(Object[] rowObjects, RecebimentoLoteAgravo bean, DBFUtil utilDbf) throws NumberFormatException, ParseException {
        bean.setNu_lote(utilDbf.getString(rowObjects, "NU_LOTE"));
        bean.setDt_trans(utilDbf.getDate(rowObjects, "DT_TRANS"));
        bean.setDt_receb(utilDbf.getDate(rowObjects, "DT_RECEB"));
        bean.setNot_neg(utilDbf.getInt(rowObjects, "NOT_NEG"));
        bean.setNeg_excl(utilDbf.getInt(rowObjects, "NEG_EXCL"));
        bean.setNotsurto(utilDbf.getInt(rowObjects, "NOTSURTO"));
        bean.setInvestsur(utilDbf.getInt(rowObjects, "INVESTSUR"));
        bean.setAcompsur(utilDbf.getInt(rowObjects, "ACOMPSUR"));
        bean.setAcompagr(utilDbf.getInt(rowObjects, "ACOMPAGR"));
        bean.setConfig(utilDbf.getString(rowObjects, "CONFIG"));
        bean.setRemetent(utilDbf.getString(rowObjects, "REMETENT"));
    }

    public List getCalculaResultado(DBFReader reader, Map parametros) throws ParseException, DBFException {
        Object casoListado = null;
        HashMap municipiosBeans = new HashMap();
        DBFUtil utilDbf = new DBFUtil();
        Agravo agravodbf = new Agravo();
        RecebimentoLoteAgravo bean = new RecebimentoLoteAgravo();
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim60 = (String)parametros.get("parDataFim60");
        String dataFim180 = (String)parametros.get("parDataFim180");
        String dtInicioTransf = null;
        String dtFimTransf = null;
        String dtInicioReceb = null;
        String dtFimReceb = null;
        if (parametros.get("parDtInicioTrasnf") != null) {
            dtInicioTransf = (String)parametros.get("parDtInicioTrasnf");
        }
        if (parametros.get("parDtFimTransf") != null) {
            dtFimTransf = (String)parametros.get("parDtFimTransf");
        }
        if (parametros.get("parDtInicioReceb") != null) {
            dtInicioReceb = (String)parametros.get("parDtInicioReceb");
        }
        if (parametros.get("parDtFimReceb") != null) {
            dtFimReceb = (String)parametros.get("parDtFimReceb");
        }
        ArrayList<RecebimentoLoteAgravo> listaBeans = new ArrayList<RecebimentoLoteAgravo>();
        int i = 1;
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        if (dtInicioTransf != null && dtInicioReceb == null) {
            for (int a = 0; a < arquivos.length; ++a) {
                i = 1;
                try {
                    Object[] rowObjects;
                    reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[a].substring(0, arquivos[a].length() - 4), Configuracao.getPropriedade("caminho"));
                    utilDbf.mapearPosicoes(reader);
                    int TotalRegistroIntA = reader.getRecordCount();
                    while ((rowObjects = reader.nextRecord()) != null) {
                        Date dtTransferencia = utilDbf.getDate(rowObjects, "DT_TRANS");
                        Date dtRecebimento = utilDbf.getDate(rowObjects, "DT_RECEB");
                        if (agravodbf.isBetweenDates(dtTransferencia, dtInicioTransf, dtFimTransf)) {
                            this.populaBeanRecebimento(rowObjects, bean, utilDbf);
                        }
                        float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistroIntA)) * 100.0f;
                        this.getBarraStatus().setString((int)percentual + "%");
                        this.getBarraStatus().setValue((int)percentual);
                        ++i;
                        listaBeans.add(bean);
                    }
                    continue;
                }
                catch (DBFException ex) {
                    Master.mensagem("Erro:\n" + (Object)((Object)ex));
                }
            }
        } else if (dtInicioTransf == null && dtInicioReceb != null) {
            for (int b = 0; b < arquivos.length; ++b) {
                i = 1;
                try {
                    Object[] rowObjects;
                    reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[b].substring(0, arquivos[b].length() - 4), Configuracao.getPropriedade("caminho"));
                    utilDbf.mapearPosicoes(reader);
                    int TotalRegistroIntB = reader.getRecordCount();
                    while ((rowObjects = reader.nextRecord()) != null) {
                        Date dtTransferencia = utilDbf.getDate(rowObjects, "DT_TRANS");
                        Date dtRecebimento = utilDbf.getDate(rowObjects, "DT_RECEB");
                        if (agravodbf.isBetweenDates(dtTransferencia, dtInicioTransf, dtFimTransf)) {
                            this.populaBeanRecebimento(rowObjects, bean, utilDbf);
                        }
                        float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistroIntB)) * 100.0f;
                        this.getBarraStatus().setString((int)percentual + "%");
                        this.getBarraStatus().setValue((int)percentual);
                        ++i;
                        listaBeans.add(bean);
                    }
                    continue;
                }
                catch (DBFException ex) {
                    Master.mensagem("Erro:\n" + (Object)((Object)ex));
                }
            }
        } else {
            for (int c = 0; c < arquivos.length; ++c) {
                i = 1;
                try {
                    Object[] rowObjects;
                    reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[c].substring(0, arquivos[c].length() - 4), Configuracao.getPropriedade("caminho"));
                    utilDbf.mapearPosicoes(reader);
                    int TotalRegistroIntC = reader.getRecordCount();
                    while ((rowObjects = reader.nextRecord()) != null) {
                        Date dtTransferencia = utilDbf.getDate(rowObjects, "DT_TRANS");
                        Date dtRecebimento = utilDbf.getDate(rowObjects, "DT_RECEB");
                        if (agravodbf.isBetweenDates(dtTransferencia, dtInicioTransf, dtFimTransf)) {
                            this.populaBeanRecebimento(rowObjects, bean, utilDbf);
                        }
                        float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistroIntC)) * 100.0f;
                        this.getBarraStatus().setString((int)percentual + "%");
                        this.getBarraStatus().setValue((int)percentual);
                        ++i;
                        listaBeans.add(bean);
                    }
                    continue;
                }
                catch (DBFException ex) {
                    Master.mensagem("Erro:\n" + (Object)((Object)ex));
                }
            }
        }
        return listaBeans;
    }
}

