/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.Municipio;
import com.org.model.classes.Semana;
import com.org.model.classes.UF;
import com.org.negocio.Configuracao;
import com.org.negocio.Util;
import com.org.service.RegiaoRegularidadeService;
import com.org.util.ArquivoUtils;
import com.org.view.Master;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.BeanComparator;

public class Regularidade
extends Agravo {
    static String ANO;
    private String semanaInicioDbf;
    private String semanaFimDbf;
    private List<String> agravosCompulsorios = new ArrayList<String>();
    boolean gtSinan = false;

    public Regularidade(boolean isDbf) {
        this.setDBF(isDbf);
        this.setPeriodo("de Notifica\u00e7\u00e3o");
        this.setTipoAgregacao("de Notifica\u00e7\u00e3o");
        this.init("postgres");
        this.alimentaAgravosCompulsorios();
    }

    public void alimentaAgravosCompulsorios() {
        this.agravosCompulsorios.add("X29");
        this.agravosCompulsorios.add("W64");
        this.agravosCompulsorios.add("A080");
        this.agravosCompulsorios.add("A539");
        this.agravosCompulsorios.add("R36");
        this.agravosCompulsorios.add("O986");
        this.agravosCompulsorios.add("P371");
        this.agravosCompulsorios.add("J06");
        this.agravosCompulsorios.add("B24");
        this.agravosCompulsorios.add("A051");
        this.agravosCompulsorios.add("B571");
        this.agravosCompulsorios.add("A009");
        this.agravosCompulsorios.add("A90");
        this.agravosCompulsorios.add("A369");
        this.agravosCompulsorios.add("Z209");
        this.agravosCompulsorios.add("Y96");
        this.agravosCompulsorios.add("C80");
        this.agravosCompulsorios.add("L989");
        this.agravosCompulsorios.add("Z579");
        this.agravosCompulsorios.add("H833");
        this.agravosCompulsorios.add("J64");
        this.agravosCompulsorios.add("F99");
        this.agravosCompulsorios.add("A779");
        this.agravosCompulsorios.add("A010");
        this.agravosCompulsorios.add("Z21");
        this.agravosCompulsorios.add("A309");
        this.agravosCompulsorios.add("A988");
        this.agravosCompulsorios.add("T659");
        this.agravosCompulsorios.add("B551");
        this.agravosCompulsorios.add("A279");
        this.agravosCompulsorios.add("B54");
        this.agravosCompulsorios.add("G039");
        this.agravosCompulsorios.add("A809");
        this.agravosCompulsorios.add("A209");
        this.agravosCompulsorios.add("A829");
        this.agravosCompulsorios.add("O981");
        this.agravosCompulsorios.add("A35");
        this.agravosCompulsorios.add("A33");
        this.agravosCompulsorios.add("A169");
        this.agravosCompulsorios.add("A229");
        this.agravosCompulsorios.add("A810");
        this.agravosCompulsorios.add("Y59");
        this.agravosCompulsorios.add("A219");
        this.agravosCompulsorios.add("B03");
        this.agravosCompulsorios.add("P350");
        this.agravosCompulsorios.add("J07");
        this.agravosCompulsorios.add("R17");
        this.agravosCompulsorios.add("A379");
        this.agravosCompulsorios.add("A959");
        this.agravosCompulsorios.add("A509");
        this.agravosCompulsorios.add("B550");
        this.agravosCompulsorios.add("B19");
        this.agravosCompulsorios.add("J11");
        this.agravosCompulsorios.add("B09");
        this.agravosCompulsorios.add("EPI");
        this.agravosCompulsorios.add("Y09");
        this.agravosCompulsorios.add("A923");
        this.agravosCompulsorios.add("B659");
        this.agravosCompulsorios.add("Z206");
        this.agravosCompulsorios.add("B019");
        this.agravosCompulsorios.add("B749");
    }

    @Override
    public void init(String tipoBanco) {
    }

    @Override
    public String getTaxaEstado(Connection con, Map parametros) throws SQLException {
        return "";
    }

    @Override
    public String getCompletitude(Connection con, Map parametros) throws SQLException {
        return "";
    }

    private void calculaGtSinan(DBFReader reader, Map parametros) throws IOException {
        HashMap<String, Municipio> municipios = null;
        boolean calculaBrasil = false;
        if (parametros.get("parUf").toString().equals("brasil")) {
            municipios = this.getMunicipios(0, "", "", "");
            calculaBrasil = true;
        } else {
            if (parametros.get("parCodRegional") == null) {
                parametros.put("parCodRegional", "");
            }
            String municipioSelecionado = "";
            if (parametros.get("parMunicipio") != null) {
                municipioSelecionado = parametros.get("parMunicipio").toString();
            }
            municipios = this.getMunicipios(1, parametros.get("parCodRegional").toString(), parametros.get("parSgUf").toString(), municipioSelecionado);
        }
        String parSemanas = parametros.get("parSemanas").toString();
        String[] arraySemanas = parSemanas.split("\n");
        HashMap<String, Object> parametrosRegularidade = new HashMap<String, Object>();
        for (int y = 0; y < arraySemanas.length; ++y) {
            Set<Map.Entry<String, Municipio>> entries = municipios.entrySet();
            for (Map.Entry<String, Municipio> municipio : entries) {
                municipios.get(municipio.getKey().toString()).getSemanas().put(String.valueOf(y), new Semana(arraySemanas[y].substring(0, 6), arraySemanas[y].substring(9, 15), arraySemanas[y]));
            }
            String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
            for (int k = 0; k < arquivos.length; ++k) {
                int i;
                parametrosRegularidade.put("ARQUIVO" + k, arquivos[k].toString() + "; ");
                Vector<String> semanasAvaliacao = new Vector<String>();
                int semanaInicio = Integer.parseInt(arraySemanas[y].substring(4, 6));
                int semanaFim = Integer.parseInt(arraySemanas[y].substring(13, 15));
                this.setSemanaInicioDbf(arraySemanas[y].substring(0, 6));
                this.setSemanaFimDbf(arraySemanas[y].substring(9, 15));
                if (arraySemanas[y].substring(0, 4).equals(arraySemanas[y].substring(9, 13))) {
                    for (i = semanaInicio; i <= semanaFim; ++i) {
                        semanasAvaliacao.add(arraySemanas[y].substring(0, 4) + this.formataSemana(String.valueOf(i)));
                    }
                } else {
                    for (i = semanaInicio; i <= 53; ++i) {
                        semanasAvaliacao.add(arraySemanas[y].substring(0, 4) + this.formataSemana(String.valueOf(i)));
                    }
                    for (i = 1; i <= semanaFim; ++i) {
                        semanasAvaliacao.add(arraySemanas[y].substring(9, 13) + this.formataSemana(String.valueOf(i)));
                    }
                }
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                DBFUtil utilDbf = new DBFUtil();
                DecimalFormat df = new DecimalFormat("0.##");
                try {
                    Object[] rowObjects;
                    utilDbf.mapearPosicoes(reader);
                    int TotalRegistrosInt = reader.getRecordCount();
                    int i2 = 1;
                    while ((rowObjects = reader.nextRecord()) != null) {
                        String municipioAvaliacao;
                        String semanaNotificacao;
                        try {
                            semanaNotificacao = utilDbf.getString(rowObjects, "SEM_NOT");
                        }
                        catch (Exception e) {
                            Master.mensagem("Campo SEM_NOT n\u00e3o encontrado na base especificada: " + arquivos[k]);
                            return;
                        }
                        try {
                            municipioAvaliacao = utilDbf.getString(rowObjects, "ID_MUNICIP");
                        }
                        catch (Exception e) {
                            Master.mensagem("Campo ID_MUNICIP n\u00e3o encontrado na base especificada: " + arquivos[k]);
                            return;
                        }
                        if (semanasAvaliacao.contains(semanaNotificacao)) {
                            if (municipios.get(municipioAvaliacao) != null && arquivos[k].substring(0, 2).equals("NI")) {
                                if (this.agravosCompulsorios.contains(utilDbf.getString(rowObjects, "ID_AGRAVO"))) {
                                    municipios.get(municipioAvaliacao).getSemanas().get(String.valueOf(y)).setSituacao(true);
                                }
                            } else if (municipios.containsKey(municipioAvaliacao)) {
                                municipios.get(municipioAvaliacao).getSemanas().get(String.valueOf(y)).setSituacao(true);
                            }
                        }
                        float percentual = Float.parseFloat(String.valueOf(i2)) / Float.parseFloat(String.valueOf(TotalRegistrosInt)) * 100.0f;
                        this.getBarraStatus().setValue((int)percentual);
                        this.getBarraStatus().setStringPainted(true);
                        this.getBarraStatus().setString("Processando: " + arquivos[k].toString() + ", per\u00edodo: " + arraySemanas[y].toString() + "  (" + (int)percentual + "%)");
                        ++i2;
                    }
                    continue;
                }
                catch (DBFException e) {
                    Master.mensagem("Erro: " + (Object)((Object)e));
                }
            }
            float percentualGeral = Float.parseFloat(String.valueOf(y + 1)) / Float.parseFloat(String.valueOf(arraySemanas.length)) * 100.0f;
            this.getBarraStatusGeral().setValue((int)percentualGeral);
            this.getBarraStatusGeral().setStringPainted(true);
            this.getBarraStatusGeral().setString((int)percentualGeral + "%");
        }
        ArrayList<Municipio> beans = new ArrayList<Municipio>();
        ArrayList<Municipio> todosMunicipios = new ArrayList<Municipio>();
        Collection<Municipio> municipioBean = municipios.values();
        int countFields = 4;
        HashMap<String, String> mapaPeriodos = new HashMap<String, String>();
        for (Municipio agravoDBF : municipioBean) {
            Semana semana = new Semana();
            int qtdePeriodos = 0;
            int qtdeOK = 0;
            int periodo = 0;
            countFields = 4;
            for (String key : agravoDBF.getSemanas().keySet()) {
                periodo = Integer.parseInt(key) + 1;
                ++qtdePeriodos;
                ++countFields;
                parametrosRegularidade.put("periodo" + periodo, agravoDBF.getSemanas().get(key).getPeriodo());
                semana = agravoDBF.getSemanas().get(key);
                if (semana.isSituacao()) {
                    ++qtdeOK;
                    mapaPeriodos.put("periodo" + periodo, "");
                    continue;
                }
                mapaPeriodos.put("periodo" + periodo, "X");
            }
            if (qtdePeriodos != qtdeOK) {
                beans.add(agravoDBF);
                agravoDBF.setIrregular(true);
            } else {
                agravoDBF.setIrregular(false);
            }
            todosMunicipios.add(agravoDBF);
            if (mapaPeriodos.get("periodo1") != null) {
                agravoDBF.setPeriodo1(mapaPeriodos.get("periodo1").toString());
            }
            if (mapaPeriodos.get("periodo2") != null) {
                agravoDBF.setPeriodo2(mapaPeriodos.get("periodo2").toString());
            }
            if (mapaPeriodos.get("periodo3") != null) {
                agravoDBF.setPeriodo3(mapaPeriodos.get("periodo3").toString());
            }
            if (mapaPeriodos.get("periodo4") != null) {
                agravoDBF.setPeriodo4(mapaPeriodos.get("periodo4").toString());
            }
            if (mapaPeriodos.get("periodo5") != null) {
                agravoDBF.setPeriodo5(mapaPeriodos.get("periodo5").toString());
            }
            if (mapaPeriodos.get("periodo6") != null) {
                agravoDBF.setPeriodo6(mapaPeriodos.get("periodo6").toString());
            }
            if (mapaPeriodos.get("periodo7") != null) {
                agravoDBF.setPeriodo7(mapaPeriodos.get("periodo7").toString());
            }
            if (mapaPeriodos.get("periodo8") != null) {
                agravoDBF.setPeriodo8(mapaPeriodos.get("periodo8").toString());
            }
            if (mapaPeriodos.get("periodo9") != null) {
                agravoDBF.setPeriodo9(mapaPeriodos.get("periodo9").toString());
            }
            if (mapaPeriodos.get("periodo10") != null) {
                agravoDBF.setPeriodo10(mapaPeriodos.get("periodo10").toString());
            }
            if (mapaPeriodos.get("periodo11") != null) {
                agravoDBF.setPeriodo11(mapaPeriodos.get("periodo11").toString());
            }
            if (mapaPeriodos.get("periodo12") != null) {
                agravoDBF.setPeriodo12(mapaPeriodos.get("periodo12").toString());
            }
            if (mapaPeriodos.get("periodo13") != null) {
                agravoDBF.setPeriodo13(mapaPeriodos.get("periodo13").toString());
            }
            if (mapaPeriodos.get("periodo14") != null) {
                agravoDBF.setPeriodo14(mapaPeriodos.get("periodo14").toString());
            }
            if (mapaPeriodos.get("periodo15") != null) {
                agravoDBF.setPeriodo15(mapaPeriodos.get("periodo15").toString());
            }
            if (mapaPeriodos.get("periodo16") != null) {
                agravoDBF.setPeriodo16(mapaPeriodos.get("periodo16").toString());
            }
            if (mapaPeriodos.get("periodo17") != null) {
                agravoDBF.setPeriodo17(mapaPeriodos.get("periodo17").toString());
            }
            if (mapaPeriodos.get("periodo18") == null) continue;
            agravoDBF.setPeriodo18(mapaPeriodos.get("periodo18").toString());
        }
        Collections.sort(beans, new BeanComparator("nmMunicipio"));
        Collections.sort(beans, new BeanComparator("sgUF"));
        Collections.sort(beans, new BeanComparator("nmRegiao"));
        RegiaoRegularidadeService regiaoRegularidadeService = new RegiaoRegularidadeService();
        parametrosRegularidade.put("UF", parametros.get("parSgUf"));
        parametrosRegularidade.put("REGIONAL", parametros.get("parRegional"));
        parametrosRegularidade.put("MUNICIPIO", "TODOS");
        parametrosRegularidade.put("parIsRegiao", (Boolean)parametros.get("parIsRegiao"));
        parametrosRegularidade.put("parIsRegional", (Boolean)parametros.get("parIsRegional"));
        parametrosRegularidade.put("parDesagregacao", (String)parametros.get("parDesagregacao"));
        parametrosRegularidade.put("parIsRegional", (Boolean)parametros.get("parIsRegional"));
        if (parametros.get("tipoRelatorio").equals("analitico")) {
            regiaoRegularidadeService.gerarRelatorioRegularidade(beans, parametrosRegularidade, countFields, parametros.get("isDBF").toString());
        } else if (parametros.get("tipoRelatorio").equals("sintetico")) {
            regiaoRegularidadeService.gerarRelatorioPropMunicIrreg(todosMunicipios, parametrosRegularidade, countFields, parametros.get("isDBF").toString(), calculaBrasil);
        } else {
            regiaoRegularidadeService.gerarRelatorioRegularidade(beans, parametrosRegularidade, countFields, parametros.get("isDBF").toString());
            regiaoRegularidadeService.gerarRelatorioPropMunicIrreg(todosMunicipios, parametrosRegularidade, countFields, parametros.get("isDBF").toString(), calculaBrasil);
        }
        this.setBeans(beans);
    }

    @Override
    public void calcula(DBFReader reader, Map parametros) {
        Vector semanasParametro = new Vector();
        if (parametros.get("parGtSinan").toString().equals("true")) {
            this.gtSinan = true;
            try {
                this.calculaGtSinan(reader, parametros);
            }
            catch (IOException ex) {
                Logger.getLogger(Regularidade.class.getName()).log(Level.SEVERE, null, ex);
                ArquivoUtils.gerarLogErro(ex);
            }
        } else {
            int i;
            Vector<String> semanasAvaliacao = new Vector<String>();
            int semanaInicio = Integer.parseInt(parametros.get("parSemanaInicial").toString());
            int semanaFim = Integer.parseInt(parametros.get("parSemanaFinal").toString());
            this.setSemanaInicioDbf(parametros.get("parAnoInicial").toString() + this.formataSemana(parametros.get("parSemanaInicial").toString()));
            this.setSemanaFimDbf(parametros.get("parAnoFinal").toString() + this.formataSemana(parametros.get("parSemanaFinal").toString()));
            if (parametros.get("parAnoInicial").toString().equals(parametros.get("parAnoFinal").toString())) {
                for (i = semanaInicio; i <= semanaFim; ++i) {
                    semanasAvaliacao.add(parametros.get("parAnoInicial").toString() + this.formataSemana(String.valueOf(i)));
                }
            } else {
                for (i = semanaInicio; i <= 53; ++i) {
                    semanasAvaliacao.add(parametros.get("parAnoInicial").toString() + this.formataSemana(String.valueOf(i)));
                }
                for (i = 1; i <= semanaFim; ++i) {
                    semanasAvaliacao.add(parametros.get("parAnoInicial").toString() + this.formataSemana(String.valueOf(i)));
                }
            }
            ANO = parametros.get("parAnoInicial").toString().equals(parametros.get("parAnoFinal").toString()) ? parametros.get("parAnoFinal").toString() : "";
            HashMap<String, Municipio> municipios = null;
            if (parametros.get("parUf").toString().equals("brasil")) {
                municipios = this.getMunicipios(0, "", "", "");
            } else {
                if (parametros.get("parCodRegional") == null) {
                    parametros.put("parCodRegional", "");
                }
                municipios = this.getMunicipios(1, parametros.get("parCodRegional").toString(), parametros.get("parSgUf").toString(), "");
            }
            this.calcularQuantidadeMunicipios(municipios);
            String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
            for (int k = 0; k < arquivos.length; ++k) {
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                DBFUtil utilDbf = new DBFUtil();
                DecimalFormat df = new DecimalFormat("0.##");
                try {
                    Object[] rowObjects;
                    utilDbf.mapearPosicoes(reader);
                    int TotalRegistrosInt = reader.getRecordCount();
                    int i2 = 1;
                    while ((rowObjects = reader.nextRecord()) != null) {
                        String municipioAvaliacao;
                        String semanaNotificacao;
                        try {
                            semanaNotificacao = utilDbf.getString(rowObjects, "SEM_NOT");
                        }
                        catch (Exception e) {
                            Master.mensagem("Campo SEM_NOT n\u00e3o encontrado na base especificada: " + arquivos[k]);
                            return;
                        }
                        try {
                            municipioAvaliacao = utilDbf.getString(rowObjects, "ID_MUNICIP");
                        }
                        catch (Exception e) {
                            Master.mensagem("Campo ID_MUNICIP n\u00e3o encontrado na base especificada: " + arquivos[k]);
                            return;
                        }
                        if (semanasAvaliacao.contains(semanaNotificacao)) {
                            if (arquivos[k].substring(0, 2).equals("NI")) {
                                if (this.agravosCompulsorios.contains(utilDbf.getString(rowObjects, "ID_AGRAVO"))) {
                                    municipios.remove(municipioAvaliacao);
                                }
                            } else {
                                municipios.remove(municipioAvaliacao);
                            }
                        }
                        float percentual = Float.parseFloat(String.valueOf(i2)) / Float.parseFloat(String.valueOf(TotalRegistrosInt)) * 100.0f;
                        this.getBarraStatus().setValue((int)percentual);
                        ++i2;
                    }
                    continue;
                }
                catch (DBFException e) {
                    Master.mensagem("Erro: " + (Object)((Object)e));
                }
            }
            this.calcularQuantidadeMunicipiosRestantes(municipios);
            ArrayList<Municipio> beans = new ArrayList<Municipio>();
            Collection<Municipio> municipioBean = municipios.values();
            for (Municipio agravoDBF : municipioBean) {
                beans.add(agravoDBF);
            }
            Collections.sort(beans, new BeanComparator("nmMunicipio"));
            Collections.sort(beans, new BeanComparator("sgUF"));
            Collections.sort(beans, new BeanComparator("nmRegiao"));
            this.setBeans(beans);
        }
    }

    @Override
    public List getBeanMunicipios(Connection con, Map parametros) throws SQLException {
        this.calcula(null, parametros);
        return this.getBeans();
    }

    @Override
    public List getBeansMunicipioEspecifico(Connection con, Map parametros) throws SQLException {
        this.calcula(null, parametros);
        return this.getBeans();
    }

    @Override
    public List getBeansEstadoEspecifico(Connection con, Map parametros) throws SQLException {
        this.calcula(null, parametros);
        return this.getBeans();
    }

    @Override
    public Map getParametros() {
        HashMap parametros = new HashMap();
        return parametros;
    }

    @Override
    public String getCaminhoJasper() {
        return "/com/org/relatorios/semNotificacao.jasper";
    }

    private String formataSemana(String semana) {
        if (Integer.parseInt(semana) < 10) {
            return "0" + semana;
        }
        return semana;
    }

    private void calcularQuantidadeMunicipiosRestantes(HashMap<String, Municipio> municipios) {
        Collection<Municipio> municipioBean = municipios.values();
        HashMap<String, UF> ufs = new HashMap<String, UF>();
        for (Municipio itMunicipio : municipioBean) {
            if (!ufs.containsKey(itMunicipio.getUf().getNmUF())) {
                UF uf = itMunicipio.getUf();
                uf.setQtdMunicipiosSemNotificacao(1);
                ufs.put(itMunicipio.getUf().getNmUF(), uf);
                continue;
            }
            ((UF)ufs.get(itMunicipio.getUf().getNmUF())).setQtdMunicipiosSemNotificacao(((UF)ufs.get(itMunicipio.getUf().getNmUF())).getQtdMunicipiosSemNotificacao() + 1);
        }
        for (Municipio itMunicipio : municipioBean) {
            itMunicipio.setUf((UF)ufs.get(itMunicipio.getUf().getNmUF()));
        }
    }

    public HashMap<String, Municipio> getMunicipios(int UF2, String regional, String sgUf, String codMunicipio) {
        DBFReader reader = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
        DBFUtil utilDbf = new DBFUtil();
        HashMap<String, Municipio> municipios = new HashMap<String, Municipio>();
        if (regional.length() > 0) {
            DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
            try {
                Object[] rowObjects;
                utilDbf.mapearPosicoes(readerMunicipio);
                while ((rowObjects = readerMunicipio.nextRecord()) != null) {
                    String nmMunicipio = utilDbf.getString(rowObjects, "NM_MUNICIP");
                    String idMunicipio = utilDbf.getString(rowObjects, "ID_MUNICIP");
                    String sgUfPar = utilDbf.getString(rowObjects, "SG_UF");
                    String region = utilDbf.getString(rowObjects, "ID_REGIONA");
                    String regiao = utilDbf.getString(rowObjects, "ID_REGIAO");
                    if (!regional.equals(utilDbf.getString(rowObjects, "ID_REGIONA")) || nmMunicipio.startsWith("IGNORADO") || nmMunicipio.startsWith("MUNICIPIO") || nmMunicipio.lastIndexOf("TRANSF.") != -1 || nmMunicipio.lastIndexOf("ATUAL BENTO GONCALVES") != -1 || (!sgUfPar.equals("DF") || !idMunicipio.equals("530010") || !nmMunicipio.equals("BRASILIA")) && sgUfPar.equals("DF")) continue;
                    if (!codMunicipio.equals("") && codMunicipio != null && idMunicipio.equals(codMunicipio)) {
                        municipios.put(idMunicipio, new Municipio(nmMunicipio, idMunicipio, sgUfPar, region, regiao));
                        continue;
                    }
                    if (!codMunicipio.equals("") && codMunicipio != null) continue;
                    municipios.put(idMunicipio, new Municipio(nmMunicipio, idMunicipio, sgUfPar, region, regiao));
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
            }
        } else {
            try {
                Object[] rowObjects;
                utilDbf.mapearPosicoes(reader);
                while ((rowObjects = reader.nextRecord()) != null) {
                    String nmMunicipio = utilDbf.getString(rowObjects, "NM_MUNICIP");
                    String idMunicipio = utilDbf.getString(rowObjects, "ID_MUNICIP");
                    String sgUfPar = utilDbf.getString(rowObjects, "SG_UF");
                    String region = utilDbf.getString(rowObjects, "ID_REGIONA");
                    String regiao = utilDbf.getString(rowObjects, "ID_REGIAO");
                    if (!sgUf.equals(sgUfPar) && UF2 != 0 || nmMunicipio.startsWith("IGNORADO") || nmMunicipio.startsWith("MUNICIPIO") || nmMunicipio.lastIndexOf("TRANSF.") != -1 || nmMunicipio.lastIndexOf("ATUAL BENTO GONCALVES") != -1 || (!sgUfPar.equals("DF") || !idMunicipio.equals("530010") || !nmMunicipio.equals("BRASILIA")) && sgUfPar.equals("DF")) continue;
                    if (!codMunicipio.equals("") && codMunicipio != null && idMunicipio.equals(codMunicipio)) {
                        municipios.put(idMunicipio, new Municipio(nmMunicipio, idMunicipio, sgUfPar, region, regiao));
                        continue;
                    }
                    if (!codMunicipio.equals("") && codMunicipio != null) continue;
                    municipios.put(idMunicipio, new Municipio(nmMunicipio, idMunicipio, sgUfPar, region, regiao));
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
                System.out.println("Erro ao carregar municipios: " + (Object)((Object)e));
            }
        }
        return municipios;
    }

    private void calcularQuantidadeMunicipios(HashMap<String, Municipio> municipios) {
        Collection<Municipio> municipioBean = municipios.values();
        HashMap<String, UF> ufs = new HashMap<String, UF>();
        for (Municipio itMunicipio : municipioBean) {
            if (!ufs.containsKey(itMunicipio.getUf().getNmUF())) {
                UF uf = itMunicipio.getUf();
                uf.setQtdMunicipios(1);
                ufs.put(itMunicipio.getUf().getNmUF(), uf);
                continue;
            }
            ((UF)ufs.get(itMunicipio.getUf().getNmUF())).setQtdMunicipios(((UF)ufs.get(itMunicipio.getUf().getNmUF())).getQtdMunicipios() + 1);
        }
        for (Municipio itMunicipio : municipioBean) {
            itMunicipio.setUf((UF)ufs.get(itMunicipio.getUf().getNmUF()));
        }
    }

    public String getSemanaInicioDbf() {
        return this.semanaInicioDbf;
    }

    public void setSemanaInicioDbf(String semanaInicioDbf) {
        this.semanaInicioDbf = semanaInicioDbf;
    }

    public String getSemanaFimDbf() {
        return this.semanaFimDbf;
    }

    public void setSemanaFimDbf(String semanaFimDbf) {
        this.semanaFimDbf = semanaFimDbf;
    }
}

