/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.ColunasDbf;
import com.org.model.classes.Municipio;
import com.org.negocio.Configuracao;
import com.org.negocio.Util;
import com.org.view.Master;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;

public class SaudeTrabalhador
extends Agravo {
    private List<String> agravosValidos = new ArrayList<String>();
    private List<Municipio> municipios = new ArrayList<Municipio>();
    private String sqlAgravosGeraisNumerador;
    private String sqlIntoxicacaoNumerador;
    private String sqlAgravosGeraisDenominador;
    private String sqlIntoxicacaoDenominador;
    static String ANO;
    private Connection conexao;
    private boolean porAgravo;

    public SaudeTrabalhador(boolean isDbf) {
        this.setDBF(isDbf);
        this.setPeriodo("de Notifica\u00e7\u00e3o");
        this.setTipoAgregacao("de Notifica\u00e7\u00e3o");
        this.init("postgres");
    }

    public SaudeTrabalhador() {
    }

    @Override
    public void init(String tipoBanco) {
        this.setMultiplicador(1);
        this.setTitulo1("Sa\u00fade Trabalhador");
        this.setTextoCompletitude("");
        this.setTituloColuna("Incremento(%)");
        this.setRodape("Incremento: (N\u00ba notifica\u00e7\u00f5es no per\u00edodo selecionado \u2013 n\u00ba de notifica\u00e7\u00f5es em 2008) / N\u00ba de notifica\u00e7\u00f5es em 2008 *100");
        this.setTipo("trabalhador");
        this.setSqlNumeradorCompletitude("");
        if (!this.isDBF()) {
            this.setSqlIntoxicacaoNumerador("select count(*) from dbsinan.tb_investiga_intoxica_exogena where st_acidente_trabalho=1 and (dt_notificacao BETWEEN ?  AND ?) and co_municipio_notificacao = ?");
            this.setSqlAgravosGeraisNumerador("SELECT  count(*) FROM  dbsinan.tb_notificacao  where co_cid in('Z20.9','Y96','C80','L98.9','Z57.9','H83.3','J64','F99') and (dt_notificacao BETWEEN ?  AND ?) and co_uf_notificacao= ? and co_municipio_notificacao = ?");
            this.setSqlIntoxicacaoDenominador("select count(*) from dbsinan.tb_investiga_intoxica_exogena where st_acidente_trabalho=1 and (dt_notificacao BETWEEN '2008-01-01' AND '2008-12-31') and co_municipio_notificacao = ?");
            this.setSqlAgravosGeraisDenominador("SELECT  count(*) FROM  dbsinan.tb_notificacao  where co_cid in('Z20.9','Y96','C80','L98.9','Z57.9','H83.3','J64','F99') and (dt_notificacao BETWEEN '2008-01-01' AND '2008-12-31') and co_uf_notificacao= ? and co_municipio_notificacao = ?");
            this.setSqlNumeradorMunicipioEspecifico("SELECT  count(*) + (select count(*) from dbsinan.tb_investiga_intoxica_exogena where st_acidente_trabalho=1 and (dt_notificacao BETWEEN ?  AND ?) and co_municipio_notificacao = ?)  as numerador FROM  dbsinan.tb_notificacao  where co_cid in('Z20.9','Y96','C80','L98.9','Z57.9','H83.3','J64','F99') and (dt_diagnostico_sintoma BETWEEN ?  AND ?) and co_uf_notificacao= ? and co_municipio_notificacao = ?");
            this.setSqlDenominadorMunicipioEspecifico("SELECT  count(*) + (select count(*) from dbsinan.tb_investiga_intoxica_exogena where st_acidente_trabalho=1 and (dt_notificacao BETWEEN '2007-01-01' AND '2007-12-31') and co_municipio_notificacao = ?)  as denominador FROM  dbsinan.tb_notificacao  where co_cid in('Z20.9','Y96','C80','L98.9','Z57.9','H83.3','J64','F99') and (dt_diagnostico_sintoma BETWEEN '2007-01-01' AND '2007-12-31') and co_uf_notificacao= ? and co_municipio_notificacao = ?");
            this.setSqlNumeradorEstado("SELECT  count(*) + (select count(*) from dbsinan.tb_investiga_intoxica_exogena where st_acidente_trabalho=1 and (dt_notificacao BETWEEN ?  AND ?) and co_municipio_notificacao like ?)  as numerador FROM  dbsinan.tb_notificacao  where co_cid in('Z20.9','Y96','C80','L98.9','Z57.9','H83.3','J64','F99') and (dt_diagnostico_sintoma BETWEEN ?  AND ?) and co_uf_notificacao= ?");
            this.setSqlDenominandorEstado("SELECT  count(*) + (select count(*) from dbsinan.tb_investiga_intoxica_exogena where st_acidente_trabalho=1 and (dt_notificacao BETWEEN '2007-01-01' AND '2007-12-31') and co_municipio_notificacao like ?)  as denominador FROM  dbsinan.tb_notificacao  where co_cid in('Z20.9','Y96','C80','L98.9','Z57.9','H83.3','J64','F99') and (dt_diagnostico_sintoma BETWEEN '2007-01-01' AND '2007-12-31') and co_uf_notificacao= ?");
            this.setSqlNumeradorCompletitude("");
            this.setSqlNumeradorBeanMunicipios(this.getSqlNumeradorMunicipioEspecifico());
            this.setSqlDenominadorBeanMunicipios(this.getSqlDenominadorMunicipioEspecifico());
        }
    }

    public boolean verificaAgravo(String CID) {
        ArrayList<String> cids = new ArrayList<String>();
        cids.add("Z20.9");
        cids.add("Y96");
        cids.add("C80");
        cids.add("L98.9");
        cids.add("Z57.9");
        cids.add("H83.3");
        cids.add("J64");
        cids.add("F99");
        return cids.contains(CID);
    }

    private void iniciaAgravosValidos() {
        this.getAgravosValidos().add("Z209");
        this.getAgravosValidos().add("Y96");
        this.getAgravosValidos().add("C80");
        this.getAgravosValidos().add("L989");
        this.getAgravosValidos().add("Z579");
        this.getAgravosValidos().add("H833");
        this.getAgravosValidos().add("J64");
        this.getAgravosValidos().add("T659");
        this.getAgravosValidos().add("F99");
    }

    public String buscaNomeAgravo(String codAgravo) {
        String retorno = "";
        if (codAgravo.equals("Z209")) {
            retorno = "ACIDENTE DE TRABALHO COM EXPOSICAO A MATERIAL BIOLOGICO";
        }
        if (codAgravo.equals("Y96")) {
            retorno = "ACIDENTE DE TRABALHO GRAVE";
        }
        if (codAgravo.equals("C80")) {
            retorno = "CANCER RELACIONADO AO TRABALHO";
        }
        if (codAgravo.equals("L989")) {
            retorno = "DERMATOSES OCUPACIONAIS";
        }
        if (codAgravo.equals("Z579")) {
            retorno = "LER DORT";
        }
        if (codAgravo.equals("H833")) {
            retorno = "PAIR";
        }
        if (codAgravo.equals("J64")) {
            retorno = "PNEUMOCONIOSE";
        }
        if (codAgravo.equals("F99")) {
            retorno = "TRANSTORNO MENTAL";
        }
        if (codAgravo.equals("T659")) {
            retorno = "INTOXICACAO EXOGENA";
        }
        return retorno;
    }

    public HashMap<String, Agravo> populaAgravosBeans(String agravoSelecionado) {
        LinkedHashMap hashAgravos = new HashMap();
        HashMap<String, Agravo> agravosBeans = new HashMap<String, Agravo>();
        List<String> agravos = null;
        agravos = this.getAgravosValidos();
        for (int i = 0; i < agravos.size(); ++i) {
            Agravo agravoDbf = new Agravo();
            agravoDbf.setCodMunicipio(agravos.get(i));
            agravoDbf.setNomeMunicipio(this.buscaNomeAgravo(agravos.get(i)));
            agravoDbf.setDenominador("0");
            agravoDbf.setNumerador("0");
            hashAgravos.put(agravos.get(i), agravoDbf.getNomeMunicipio());
            agravosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
        }
        hashAgravos = this.sortHashMapByValues(hashAgravos, false);
        Set agravoKeys = ((HashMap)hashAgravos).keySet();
        HashMap<String, Agravo> agravosBeansRetorno = new HashMap<String, Agravo>();
        for (String key : agravoKeys) {
            agravosBeansRetorno.put(key, (Agravo)agravosBeans.get(key));
        }
        return agravosBeansRetorno;
    }

    public String formataData(String data) {
        return data.split("-")[2] + "/" + data.split("-")[1] + "/" + data.split("-")[0];
    }

    @Override
    public String getTaxaEstado(Connection con, Map parametros) throws SQLException {
        this.setConexao(con);
        return "";
    }

    @Override
    public String getCompletitude(Connection con, Map parametros) throws SQLException {
        return "";
    }

    public boolean verificaPeriodo(Map parametros, DBFUtil utilDbf, Object[] rowObjects) throws ParseException {
        return this.isBetweenDates(utilDbf.getDate(rowObjects, "DT_NOTIFIC"), (String)parametros.get("parDataInicio"), (String)parametros.get("parDataFim"));
    }

    public void incrementaDenominador(Agravo localNotificacao) {
        if (localNotificacao.getDenominador().equals("")) {
            localNotificacao.setDenominador("0");
        }
        int denominador = Integer.parseInt(localNotificacao.getDenominador());
        localNotificacao.setDenominador(String.valueOf(++denominador));
    }

    public void incrementaNumerador(Agravo localNotificacao) {
        if (localNotificacao.getNumerador().equals("")) {
            localNotificacao.setNumerador("0");
        }
        int numerador = Integer.parseInt(localNotificacao.getNumerador());
        localNotificacao.setNumerador(String.valueOf(++numerador));
    }

    public Agravo calculoPostgreInterno(Map parametros, String parametro1, String nmLocalNotificacao, String condicaoMunicipio) {
        try {
            String sql = "select count(*) as numerador from dbsinan.tb_investiga_intoxica_exogena where st_acidente_trabalho=1 and (dt_notificacao BETWEEN ? AND ?) and co_municipio_notificacao like ?";
            PreparedStatement stm2 = this.conexao.prepareStatement(sql);
            stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
            stm2.setDate(2, this.transformaDate(parametros.get("parDataFim").toString()));
            stm2.setString(3, parametro1 + "%");
            if (!condicaoMunicipio.equals("")) {
                stm2.setString(3, parametro1);
            }
            ResultSet rs2 = stm2.executeQuery();
            rs2.next();
            double numerador = rs2.getDouble("numerador");
            sql = "SELECT  count(*) as numerador FROM  dbsinan.tb_notificacao  where co_cid in('Z20.9','Y96','C80','L98.9','Z57.9','H83.3','J64','F99') and (dt_notificacao BETWEEN ?  AND ?) and co_uf_notificacao = ? " + condicaoMunicipio;
            stm2 = this.conexao.prepareStatement(sql);
            stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
            stm2.setDate(2, this.transformaDate(parametros.get("parDataFim").toString()));
            stm2.setString(3, parametro1.substring(0, 2));
            if (!condicaoMunicipio.equals("")) {
                stm2.setString(4, parametro1);
            }
            rs2 = stm2.executeQuery();
            rs2.next();
            numerador += rs2.getDouble("numerador");
            sql = "select count(*) as denominador from dbsinan.tb_investiga_intoxica_exogena where st_acidente_trabalho=1 and (dt_notificacao BETWEEN '2008-01-01' AND '2008-12-31') and co_municipio_notificacao like ?";
            stm2 = this.conexao.prepareStatement(sql);
            stm2.setString(1, parametro1 + "%");
            if (!condicaoMunicipio.equals("")) {
                stm2.setString(1, parametro1);
            }
            rs2 = stm2.executeQuery();
            rs2.next();
            double denominador = rs2.getDouble("denominador");
            sql = "SELECT  count(*) as denominador FROM  dbsinan.tb_notificacao  where co_cid in('Z20.9','Y96','C80','L98.9','Z57.9','H83.3','J64','F99') and (dt_notificacao BETWEEN '2008-01-01' AND '2008-12-31') and co_uf_notificacao = ? " + condicaoMunicipio;
            stm2 = this.conexao.prepareStatement(sql);
            stm2.setString(1, parametro1.substring(0, 2));
            if (!condicaoMunicipio.equals("")) {
                stm2.setString(2, parametro1);
            }
            rs2 = stm2.executeQuery();
            rs2.next();
            denominador += rs2.getDouble("denominador");
            Agravo agravoDbf = new Agravo();
            agravoDbf.init("");
            agravoDbf.setCodMunicipio(parametro1);
            agravoDbf.setNomeMunicipio(nmLocalNotificacao);
            agravoDbf.setDenominador(String.valueOf(numerador));
            agravoDbf.setNumerador(String.valueOf(denominador));
            return agravoDbf;
        }
        catch (SQLException e) {
            Master.mensagem("Erro na conex\u00e3o do banco de dados: " + e);
            return null;
        }
    }

    public HashMap<String, Agravo> retornaCalculoAgravos(Map parametros, String parametro1, String condicaoMunicipio) {
        HashMap<String, Agravo> municipiosBeans = new HashMap<String, Agravo>();
        try {
            String sql = "select count(*) as numerador from dbsinan.tb_investiga_intoxica_exogena where st_acidente_trabalho=1 and (dt_notificacao BETWEEN ? AND ?) and co_municipio_notificacao like ?";
            PreparedStatement stm2 = this.conexao.prepareStatement(sql);
            stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
            stm2.setDate(2, this.transformaDate(parametros.get("parDataFim").toString()));
            stm2.setString(3, parametro1 + "%");
            if (!condicaoMunicipio.equals("")) {
                stm2.setString(3, parametro1);
            }
            ResultSet rs2 = stm2.executeQuery();
            rs2.next();
            Agravo agravoDbf = new Agravo();
            agravoDbf.init("");
            agravoDbf.setCodMunicipio("T659");
            agravoDbf.setNomeMunicipio("INTOXICACAO EXOGENA");
            agravoDbf.setDenominador(String.valueOf(rs2.getDouble("numerador")));
            agravoDbf.setNumerador("0");
            municipiosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
            sql = "SELECT  t1.co_cid as co_cid,t2.no_agravo as no_agravo,count(*) as numerador FROM  dbsinan.tb_notificacao as t1 inner join dbsinan.tb_agravo as t2 on t1.co_cid=t2.co_cid  where t1.co_cid in('Z20.9','Y96','C80','L98.9','Z57.9','H83.3','J64','F99') and (dt_notificacao BETWEEN ?  AND ?) and co_uf_notificacao = ? " + condicaoMunicipio + " group by t1.co_cid,t2.no_agravo";
            stm2 = this.conexao.prepareStatement(sql);
            stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
            stm2.setDate(2, this.transformaDate(parametros.get("parDataFim").toString()));
            stm2.setString(3, parametro1.substring(0, 2));
            if (!condicaoMunicipio.equals("")) {
                stm2.setString(4, parametro1);
            }
            rs2 = stm2.executeQuery();
            while (rs2.next()) {
                agravoDbf = new Agravo();
                agravoDbf.init("");
                agravoDbf.setCodMunicipio(rs2.getString("co_cid"));
                agravoDbf.setNomeMunicipio(rs2.getString("no_agravo"));
                agravoDbf.setDenominador(String.valueOf(rs2.getDouble("numerador")));
                agravoDbf.setNumerador("0");
                municipiosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
            }
            sql = "select count(*) as numerador from dbsinan.tb_investiga_intoxica_exogena where st_acidente_trabalho=1 and (dt_notificacao BETWEEN '2008-01-01' AND '2008-12-31') and co_municipio_notificacao like ?";
            stm2 = this.conexao.prepareStatement(sql);
            stm2.setString(1, parametro1 + "%");
            if (!condicaoMunicipio.equals("")) {
                stm2.setString(1, parametro1);
            }
            rs2 = stm2.executeQuery();
            rs2.next();
            ((Agravo)municipiosBeans.get("T659")).setNumerador(String.valueOf(rs2.getDouble("numerador")));
            sql = "SELECT  t1.co_cid as co_cid,t2.no_agravo as no_agravo,count(*) as numerador FROM  dbsinan.tb_notificacao as t1 inner join dbsinan.tb_agravo as t2 on t1.co_cid=t2.co_cid  where t1.co_cid in('Z20.9','Y96','C80','L98.9','Z57.9','H83.3','J64','F99') and (dt_notificacao BETWEEN '2008-01-01' AND '2008-12-31') and co_uf_notificacao = ? " + condicaoMunicipio + " group by t1.co_cid,t2.no_agravo";
            stm2 = this.conexao.prepareStatement(sql);
            stm2.setString(1, parametro1.substring(0, 2));
            if (!condicaoMunicipio.equals("")) {
                stm2.setString(2, parametro1);
            }
            rs2 = stm2.executeQuery();
            while (rs2.next()) {
                if (municipiosBeans.get(rs2.getString("co_cid")) == null) {
                    agravoDbf = new Agravo();
                    agravoDbf.init("");
                    agravoDbf.setCodMunicipio(rs2.getString("co_cid"));
                    agravoDbf.setNomeMunicipio(rs2.getString("no_agravo"));
                    agravoDbf.setNumerador(String.valueOf(rs2.getDouble("numerador")));
                    agravoDbf.setDenominador("0");
                    municipiosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
                    continue;
                }
                municipiosBeans.get(rs2.getString("co_cid")).setNumerador(String.valueOf(rs2.getDouble("numerador")));
            }
            return municipiosBeans;
        }
        catch (SQLException e) {
            Master.mensagem("Erro na conex\u00e3o do banco de dados: " + e);
            return null;
        }
    }

    public HashMap<String, Agravo> calculoPostgres(Map parametros) {
        HashMap<String, Agravo> municipiosBeans = new HashMap<String, Agravo>();
        String nmParametro1 = "parUf";
        String nmParametro2 = "parSgUf";
        String condicaoMunicipio = "";
        if (parametros.get("municipios").equals("sim")) {
            if (parametros.get("parDiscriminarPorAgravo").toString().equals("true")) {
                Master.mensagem("Selecione uma UF ou um munic\u00edpio espec\u00edfico para emitir o relat\u00f3rio por agravo");
                return null;
            }
            condicaoMunicipio = "and co_municipio_notificacao = ?";
            try {
                String sql = parametros.get("parNomeRegional").equals("-- Selecione --") || parametros.get("parNomeRegional").equals("") ? "select co_municipio_ibge,no_municipio from dbgeral.tb_municipio where sg_uf = '" + parametros.get("parSgUf") + "' order by no_municipio" : "select t1.co_municipio_ibge,no_municipio from dbgeral.tb_municipio as t1, dblocalidade.rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + parametros.get("parUf") + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional = '" + parametros.get("parCodRegional") + "' and no_municipio not like '%Ignorado%'  order by no_municipio";
                Statement stm = this.getConexao().createStatement();
                ResultSet rs = stm.executeQuery(sql);
                while (rs.next()) {
                    String municipio = rs.getString("co_municipio_ibge");
                    String noMunicipio = rs.getString("no_municipio");
                    this.getBarraStatus().setString("Calculando munic\u00edpio: " + noMunicipio);
                    municipiosBeans.put(municipio, this.calculoPostgreInterno(parametros, municipio, noMunicipio, condicaoMunicipio));
                }
            }
            catch (SQLException e) {
                Master.mensagem("Erro na conex\u00e3o do banco de dados: " + e);
            }
        } else {
            if (parametros.get("parNomeMunicipio") != null) {
                condicaoMunicipio = "and co_municipio_notificacao = ?";
                nmParametro1 = "parMunicipio";
                nmParametro2 = "parNomeMunicipio";
            }
            if (!parametros.get("parDiscriminarPorAgravo").toString().equals("true")) {
                municipiosBeans.put(parametros.get(nmParametro1).toString(), this.calculoPostgreInterno(parametros, parametros.get(nmParametro1).toString(), parametros.get(nmParametro2).toString(), condicaoMunicipio));
            } else {
                municipiosBeans = this.retornaCalculoAgravos(parametros, parametros.get(nmParametro1).toString(), condicaoMunicipio);
            }
        }
        return municipiosBeans;
    }

    @Override
    public void calcula(DBFReader reader, Map parametros) {
        this.setPorAgravo(false);
        List<Object> municipiosRegionais = new ArrayList();
        if (parametros.get("parDiscriminarPorAgravo").toString().equals("true")) {
            this.setPorAgravo(true);
        }
        HashMap<Object, Object> municipiosBeans = new HashMap();
        if (!this.isDBF()) {
            municipiosBeans = this.calculoPostgres(parametros);
        } else {
            this.iniciaAgravosValidos();
            String colunaLocalNotificacao = "";
            String codRegional = (String)parametros.get("parCodRegional");
            if (codRegional == null) {
                codRegional = "";
            }
            String parametroUF = parametros.get("parUf").toString();
            if (parametros.get("parDiscriminarPorAgravo").toString().equals("true")) {
                for (int i = 0; i < this.agravosValidos.size(); ++i) {
                    Agravo agravoDbf = new Agravo();
                    agravoDbf.init("");
                    agravoDbf.setCodMunicipio(this.agravosValidos.get(i));
                    agravoDbf.setNomeMunicipio(this.buscaNomeAgravo(this.agravosValidos.get(i)));
                    agravoDbf.setDenominador("0");
                    agravoDbf.setNumerador("0");
                    municipiosBeans.put(this.agravosValidos.get(i), agravoDbf);
                    colunaLocalNotificacao = "ID_AGRAVO";
                }
                municipiosRegionais = this.verificaMunicipio(codRegional);
            } else if (parametroUF.equals("brasil")) {
                if (!parametros.get("parDiscriminarPorAgravo").toString().equals("true")) {
                    if (parametros.get("municipios").toString().equals("sim")) {
                        municipiosBeans = this.populaMunicipiosBeans("BR", "");
                        colunaLocalNotificacao = "ID_MUNICIP";
                    } else {
                        municipiosBeans = this.populaUfsBeans();
                        colunaLocalNotificacao = "SG_UF_NOT";
                    }
                }
            } else if (parametros.get("parNomeMunicipio") != null) {
                if (parametros.get("municipios").equals("sim")) {
                    municipiosBeans = this.populaMunicipiosBeans(parametros.get("parSgUf").toString(), codRegional);
                    colunaLocalNotificacao = "ID_MUNICIP";
                } else {
                    Agravo agravoDbf = new Agravo();
                    agravoDbf.init("");
                    agravoDbf.setCodMunicipio(parametros.get("parMunicipio").toString());
                    agravoDbf.setNomeMunicipio(parametros.get("parNomeMunicipio").toString());
                    agravoDbf.setDenominador("0");
                    agravoDbf.setNumerador("0");
                    municipiosBeans.put(parametros.get("parMunicipio").toString(), agravoDbf);
                    colunaLocalNotificacao = "ID_MUNICIP";
                }
            } else {
                Agravo agravoDbf = new Agravo();
                agravoDbf.init("");
                agravoDbf.setCodMunicipio(parametros.get("parUf").toString());
                agravoDbf.setNomeMunicipio(parametros.get("parSgUf").toString());
                agravoDbf.setDenominador("0");
                agravoDbf.setNumerador("0");
                municipiosBeans.put(parametros.get("parUf").toString(), agravoDbf);
                colunaLocalNotificacao = "SG_UF_NOT";
            }
            String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
            for (int k = 0; k < arquivos.length; ++k) {
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                Object var10_16 = null;
                DBFUtil utilDbf = new DBFUtil();
                DecimalFormat df = new DecimalFormat("0.##");
                try {
                    Object[] objectArray;
                    utilDbf.mapearPosicoes(reader);
                    int TotalRegistrosInt = reader.getRecordCount();
                    int i = 1;
                    while ((objectArray = reader.nextRecord()) != null) {
                        block46: {
                            if (utilDbf.getString(objectArray, colunaLocalNotificacao) != null) {
                                Agravo localNotificacao = (Agravo)municipiosBeans.get(utilDbf.getString(objectArray, colunaLocalNotificacao));
                                boolean continua1 = true;
                                if (this.isPorAgravo() && codRegional.length() > 0 && !municipiosRegionais.contains(utilDbf.getString(objectArray, "ID_MUNICIP"))) {
                                    continua1 = false;
                                }
                                if (localNotificacao != null && continua1) {
                                    boolean isBetween2008;
                                    boolean bl;
                                    try {
                                        bl = this.verificaPeriodo(parametros, utilDbf, objectArray);
                                        isBetween2008 = this.isBetweenDates(utilDbf.getDate(objectArray, "DT_NOTIFIC"), "2008-01-01", "2008-12-31");
                                    }
                                    catch (Exception e) {
                                        Master.mensagem("Erro no arquivo dbf: " + arquivos[k]);
                                        return;
                                    }
                                    boolean continua = true;
                                    if (parametros.get("parDiscriminarPorAgravo").toString().equals("true")) {
                                        continua = parametroUF.equals("brasil") ? true : (parametros.get("nivelAgregacao").equals("UF") ? parametroUF.equals(utilDbf.getString(objectArray, "SG_UF_NOT")) : parametros.get("parMunicipio").equals(utilDbf.getString(objectArray, "ID_MUNICIP")));
                                    }
                                    if (continua && (bl || isBetween2008)) {
                                        boolean isIntoxicacao = true;
                                        if (arquivos[k].substring(0, 4).equals("NIND")) {
                                            isIntoxicacao = false;
                                        }
                                        if (!isIntoxicacao) {
                                            try {
                                                String codCid = utilDbf.getString(objectArray, "ID_AGRAVO");
                                                if (codCid == null || !this.agravosValidos.contains(codCid) || codCid.equals("T659")) break block46;
                                                if (bl) {
                                                    this.incrementaDenominador(localNotificacao);
                                                }
                                                if (isBetween2008) {
                                                    this.incrementaNumerador(localNotificacao);
                                                }
                                            }
                                            catch (Exception e) {
                                                Master.mensagem("Erro 547: " + e);
                                            }
                                        } else {
                                            String doencaTrabalho = utilDbf.getString(objectArray, "DOENCA_TRA");
                                            if (doencaTrabalho != null && doencaTrabalho.equals("1")) {
                                                if (bl) {
                                                    this.incrementaDenominador(localNotificacao);
                                                }
                                                if (isBetween2008) {
                                                    this.incrementaNumerador(localNotificacao);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistrosInt)) * 100.0f;
                        this.getBarraStatus().setValue((int)percentual);
                        ++i;
                    }
                    continue;
                }
                catch (DBFException e) {
                    Master.mensagem("Erro 557: " + (Object)((Object)e));
                }
            }
        }
        ArrayList<Agravo> beans = new ArrayList<Agravo>();
        Collection<Object> municipioBean = municipiosBeans.values();
        DecimalFormat df = new DecimalFormat("0.00");
        DecimalFormat df2 = new DecimalFormat("0");
        for (Agravo agravo : municipioBean) {
            double d = Double.parseDouble(agravo.getNumerador());
            double den = Double.parseDouble(agravo.getDenominador());
            if (den == 0.0) {
                agravo.setTaxa("0.00");
            } else {
                double divisor = d == 0.0 ? 1.0 : d;
                agravo.setTaxa(String.valueOf(df.format((den - d) * 100.0 / divisor)));
            }
            try {
                agravo.setNumerador(agravo.getNumerador().substring(0, agravo.getNumerador().lastIndexOf(".")));
                agravo.setDenominador(agravo.getDenominador().substring(0, agravo.getDenominador().lastIndexOf(".")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            beans.add(agravo);
        }
        Collections.sort(beans, new BeanComparator("nomeMunicipio"));
        if (parametros.get("parUf").toString().equals("brasil") || parametros.get("parSgUf").toString().equals("TODAS")) {
            if (parametros.get("parUf").toString().equals("brasil") && !parametros.get("parDiscriminarPorAgravo").toString().equals("true") && !parametros.get("municipios").toString().equals("sim") && !parametros.get("parSgUf").toString().equals("TODAS")) {
                beans = new ArrayList();
            }
            Agravo agravoBean = new Agravo();
            agravoBean.setNomeMunicipio("BRASIL");
            agravoBean.setCodMunicipio("51");
            agravoBean.setNumerador("0");
            agravoBean.setDenominador("0");
            for (Agravo agravo : municipioBean) {
                agravoBean.setNumerador(String.valueOf(Integer.parseInt(agravo.getNumerador()) + Integer.parseInt(agravoBean.getNumerador())));
                agravoBean.setDenominador(String.valueOf(Integer.parseInt(agravo.getDenominador()) + Integer.parseInt(agravoBean.getDenominador())));
                double num = Double.parseDouble(agravoBean.getNumerador());
                double den = Double.parseDouble(agravoBean.getDenominador());
                if (agravoBean.getDenominador().equals("0")) {
                    agravoBean.setTaxa("0.00");
                    continue;
                }
                double divisor = num == 0.0 ? 1.0 : num;
                agravoBean.setTaxa(df.format((den - num) * 100.0 / divisor));
            }
            beans.add(agravoBean);
        }
        this.setBeans(beans);
    }

    @Override
    public List getBeanMunicipios(Connection con, Map parametros) throws SQLException {
        this.calcula(null, parametros);
        return this.getBeans();
    }

    @Override
    public List getBeansMunicipioEspecifico(Connection con, Map parametros) throws SQLException {
        this.calcula(null, parametros);
        return this.getBeans();
    }

    @Override
    public List getBeansEstadoEspecifico(Connection con, Map parametros) throws SQLException {
        this.calcula(null, parametros);
        return this.getBeans();
    }

    @Override
    public List getBeanMunicipioEspecifico(Connection con, Map parametros) throws SQLException {
        return this.getBeans();
    }

    @Override
    public Map getParametros() {
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parDataInicio", Util.formataData(this.getDataInicio()));
        parametros.put("parDataFim", Util.formataData(this.getDataFim()));
        parametros.put("parPeriodo", "de " + this.getDataInicio() + " a " + this.getDataFim());
        parametros.put("parTituloColuna", this.getTituloColuna());
        parametros.put("parFator", String.valueOf(this.getMultiplicador()));
        parametros.put("parAno", Util.getAno(this.getDataFim()));
        parametros.put("parRodape", this.getRodape());
        parametros.put("parConfig", "");
        parametros.put("parTituloDenominador", "Not per\u00edodo sel.");
        parametros.put("parTituloNumerador", "Not. em 2008");
        parametros.put("parTituloLocal", "Local de Notifica\u00e7\u00e3o");
        parametros.put("parTitulo1", "N\u00famero de notifica\u00e7\u00f5es dos agravos \u00e0 sa\u00fade do trabalhador");
        ANO = "";
        if (Util.getAno(this.getDataFim()).equals(Util.getAno(this.getDataInicio()))) {
            ANO = Util.getAno(this.getDataFim());
        }
        this.setDataInicio(this.getDataInicio());
        this.setDataFim(this.getDataFim());
        return parametros;
    }

    @Override
    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        for (int i = 0; i < bean.size(); ++i) {
            Object[] rowData = new Object[colunas.size()];
            Agravo agravo = (Agravo)bean.get(i);
            rowData[0] = agravo.getNomeMunicipio().equals("BRASIL") ? null : agravo.getCodMunicipio();
            rowData[1] = agravo.getNomeMunicipio();
            if (this.isPorAgravo()) {
                rowData[2] = Double.parseDouble(agravo.getNumerador());
                rowData[3] = Double.parseDouble(agravo.getDenominador());
                rowData[4] = Double.parseDouble(agravo.getTaxa().replace(",", "."));
                rowData[5] = this.preencheAno(this.getDataInicio(), this.getDataFim());
                rowData[6] = this.getDataInicio();
                rowData[7] = this.getDataFim();
                rowData[8] = "SAUDETRABALHADOR-SINANNET";
            } else {
                rowData[2] = agravo.getNomeMunicipio().equals("BRASIL") ? null : agravo.getCodMunicipio().substring(0, 2);
                rowData[3] = Double.parseDouble(agravo.getNumerador());
                rowData[4] = Double.parseDouble(agravo.getDenominador());
                rowData[5] = Double.parseDouble(agravo.getTaxa().replace(",", "."));
                rowData[6] = this.preencheAno(this.getDataInicio(), this.getDataFim());
                rowData[7] = this.getDataInicio();
                rowData[8] = this.getDataFim();
                rowData[9] = "SAUDETRABALHADOR-SINANNET";
            }
            writer.addRecord(rowData);
        }
        return writer;
    }

    @Override
    public String getCaminhoJasper() {
        return "/com/org/relatorios/agravo1.jasper";
    }

    @Override
    public HashMap<String, ColunasDbf> getColunas() {
        HashMap<String, ColunasDbf> hashColunas = new HashMap<String, ColunasDbf>();
        if (this.isPorAgravo()) {
            hashColunas.put("ID_AGRAVO", new ColunasDbf(7));
            hashColunas.put("DS_AGRAVO", new ColunasDbf(30));
        } else {
            hashColunas.put("ID_LOCNOT", new ColunasDbf(7));
            hashColunas.put("DS_LOCNOT", new ColunasDbf(30));
            hashColunas.put("ID_UFNOT", new ColunasDbf(2));
        }
        hashColunas.put("NUM_NOT08", new ColunasDbf(10, 0));
        hashColunas.put("I_NOTTRAB", new ColunasDbf(10, 0));
        hashColunas.put("INCREMENT", new ColunasDbf(10, 2));
        hashColunas.put("ANO_NOTIF", new ColunasDbf(4, 0));
        hashColunas.put("DT_NOTINI", new ColunasDbf(10));
        hashColunas.put("DT_NOTFIN", new ColunasDbf(10));
        hashColunas.put("ORIGEM", new ColunasDbf(30));
        this.setColunas(hashColunas);
        return hashColunas;
    }

    @Override
    public String[] getOrdemColunas() {
        if (this.isPorAgravo()) {
            return new String[]{"ID_AGRAVO", "DS_AGRAVO", "NUM_NOT08", "I_NOTTRAB", "INCREMENT", "ANO_NOTIF", "DT_NOTINI", "DT_NOTFIN", "ORIGEM"};
        }
        return new String[]{"ID_LOCNOT", "DS_LOCNOT", "ID_UFNOT", "NUM_NOT08", "I_NOTTRAB", "INCREMENT", "ANO_NOTIF", "DT_NOTINI", "DT_NOTFIN", "ORIGEM"};
    }

    public List<String> getAgravosValidos() {
        return this.agravosValidos;
    }

    public void setAgravosValidos(List<String> agravosValidos) {
        this.agravosValidos = agravosValidos;
    }

    public List<Municipio> getMunicipios() {
        return this.municipios;
    }

    public void setMunicipios(List<Municipio> municipios) {
        this.municipios = municipios;
    }

    public String getSqlAgravosGeraisNumerador() {
        return this.sqlAgravosGeraisNumerador;
    }

    public void setSqlAgravosGeraisNumerador(String sqlAgravosGeraisNumerador) {
        this.sqlAgravosGeraisNumerador = sqlAgravosGeraisNumerador;
    }

    public String getSqlIntoxicacaoNumerador() {
        return this.sqlIntoxicacaoNumerador;
    }

    public void setSqlIntoxicacaoNumerador(String sqlIntoxicacaoNumerador) {
        this.sqlIntoxicacaoNumerador = sqlIntoxicacaoNumerador;
    }

    public String getSqlAgravosGeraisDenominador() {
        return this.sqlAgravosGeraisDenominador;
    }

    public void setSqlAgravosGeraisDenominador(String sqlAgravosGeraisDenominador) {
        this.sqlAgravosGeraisDenominador = sqlAgravosGeraisDenominador;
    }

    public String getSqlIntoxicacaoDenominador() {
        return this.sqlIntoxicacaoDenominador;
    }

    public void setSqlIntoxicacaoDenominador(String sqlIntoxicacaoDenominador) {
        this.sqlIntoxicacaoDenominador = sqlIntoxicacaoDenominador;
    }

    public Connection getConexao() {
        return this.conexao;
    }

    public void setConexao(Connection conexao) {
        this.conexao = conexao;
    }

    public boolean isPorAgravo() {
        return this.porAgravo;
    }

    public void setPorAgravo(boolean porAgravo) {
        this.porAgravo = porAgravo;
    }
}

