/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.ColunasDbf;
import com.org.negocio.Configuracao;
import com.org.negocio.Util;
import com.org.util.SinanDateUtil;
import com.org.view.Master;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;

public class SemanaEpidemiologicaPactuacao
extends Agravo {
    static String ANO;
    Agravo municipioResidencia;
    HashMap<String, Agravo> municipiosBeans = new HashMap();
    HashMap<String, ArrayList<String>> semanas = new HashMap();
    DBFUtil utilDbf = new DBFUtil();

    public SemanaEpidemiologicaPactuacao(boolean isDbf) {
        this.setDBF(isDbf);
        this.setPeriodo("de Diagn\u00f3stico");
        this.setTipoAgregacao("de Resid\u00eancia");
        this.init("postgres");
    }

    @Override
    public void init(String tipoBanco) {
        this.setArquivo("NINDINET");
        this.setTextoCompletitude("");
        this.setMultiplicador(100000);
        this.setTipo("");
        this.setTipo("populacao");
        this.setTitulo1("N\u00famero de semanas epidemiol\u00f3gicas com informa\u00e7\u00e3o.");
        this.setTituloColuna("Indicador");
        this.setRodape("Indicador: N\u00famero de semanas epidemiol\u00f3gicas com informa\u00e7\u00e3o.  \n");
        this.setSqlNumeradorCompletitude("");
        if (!this.isDBF()) {
            this.setSqlNumeradorMunicipioEspecifico("select count(*) as numerador from dbsinan.tb_notificacao as t1, dbsinan.tb_investiga_aids_crianca as t2 where  t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao and nu_idade < 4005 and tp_criterio_definicao not in (900,901) and (t1.dt_diagnostico_sintoma BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and t1.co_municipio_residencia = ?");
            this.setSqlDenominadorMunicipioEspecifico("select nu_pop1a4anos+nu_pop1ano as denominador from dblocalidade.tb_estatistica_ibge where co_uf_municipio_ibge = ? and nu_ano = ?");
            this.setSqlNumeradorEstado("select count(*) as numerador from dbsinan.tb_notificacao as t1, dbsinan.tb_investiga_aids_crianca as t2 where  t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao and nu_idade < 4005 and tp_criterio_definicao not in (900,901) and (t1.dt_diagnostico_sintoma BETWEEN ?  AND ?) and t1.co_uf_residencia= ? ");
            this.setSqlDenominandorEstado(this.getSqlDenominadorMunicipioEspecifico());
            this.setSqlNumeradorBeanMunicipios(this.getSqlNumeradorMunicipioEspecifico());
            this.setSqlDenominadorBeanMunicipios(this.getSqlDenominadorMunicipioEspecifico());
        }
    }

    private void calculaIndicador(Object[] rowObjects, String anoAvaliacao, Integer semanaIni, Integer semanaFim) throws ParseException {
        Boolean semanaValida = false;
        int denominador = 0;
        String semEpidemilogica = this.utilDbf.getString(rowObjects, "SEM_NOT") != null ? this.utilDbf.getString(rowObjects, "SEM_NOT") : "";
        String anoEdpid = semEpidemilogica != null && semEpidemilogica.length() >= 4 ? semEpidemilogica.substring(0, 4) : "0";
        if (semEpidemilogica != null && semEpidemilogica.length() >= 4) {
            semanaValida = Integer.valueOf(semEpidemilogica) >= semanaIni && Integer.valueOf(semEpidemilogica) <= semanaFim;
        }
        ArrayList<Object> WeekAtual = new ArrayList<String>();
        if (this.municipioResidencia != null && anoEdpid.equals(anoAvaliacao) && semanaValida.booleanValue()) {
            if (this.semanas.get(this.municipioResidencia.getCodMunicipio()) != null) {
                WeekAtual = this.semanas.get(this.municipioResidencia.getCodMunicipio());
                if (!WeekAtual.contains(semEpidemilogica)) {
                    denominador = Integer.parseInt(this.municipioResidencia.getDenominador());
                    this.municipioResidencia.setDenominador(String.valueOf(++denominador));
                    this.municipioResidencia.setDenominadorInt(denominador);
                    this.semanas.get(this.municipioResidencia.getCodMunicipio()).add(semEpidemilogica);
                }
            } else {
                WeekAtual.add(semEpidemilogica);
                this.semanas.put(this.municipioResidencia.getCodMunicipio(), WeekAtual);
                denominador = Integer.parseInt(this.municipioResidencia.getDenominador());
                this.municipioResidencia.setDenominador(String.valueOf(++denominador));
                this.municipioResidencia.setDenominadorInt(denominador);
                this.semanas.get(this.municipioResidencia.getCodMunicipio()).add(semEpidemilogica);
            }
        }
    }

    private void calculaRegiao(DBFReader reader, Map parametros) throws ParseException {
        String ufResidencia = (String)parametros.get("parUf");
        String sgUfResidencia = (String)parametros.get("parSgUf");
        String codRegional = (String)parametros.get("parCodRegional");
        String codRegiao = (String)parametros.get("parCodRegiaoSaude");
        HashMap<Object, Object> regiaoBeans = new HashMap();
        parametros.put("numeradorTotal", 0);
        parametros.put("denominadorTotal", 0);
        if (codRegional == null) {
            codRegional = "";
        }
        if (codRegiao == null) {
            codRegiao = "";
        }
        String idMunicipio = parametros.get("parMunicipio") != null ? (String)parametros.get("parMunicipio") : "TODOS";
        if (((Boolean)parametros.get("parIsRegiao")).booleanValue()) {
            this.municipiosBeans = this.populaRegiaoBeans(sgUfResidencia, codRegiao);
            regiaoBeans = this.populaMunicipiosBeansMAL(sgUfResidencia, codRegiao, idMunicipio, parametros.get("parIsRegiao").toString());
        } else {
            this.municipiosBeans = this.populaRegionalBeans(sgUfResidencia, codRegional);
            regiaoBeans = this.populaMunicipiosBeansMAL(sgUfResidencia, codRegional, idMunicipio, parametros.get("parIsRegiao").toString());
        }
        DecimalFormat df = new DecimalFormat("0.00");
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        int semanaIni = 0;
        int semanaFim = 0;
        String anoAvaliacao = (String)parametros.get("parAnoAvaliacao");
        this.setAnoAvaliado(anoAvaliacao);
        semanaFim = Integer.valueOf(parametros.get("parSemanaFinal").toString()) < 10 ? (parametros.get("parSemanaFinal").toString().length() < 2 ? Integer.valueOf(anoAvaliacao + "0" + parametros.get("parSemanaFinal").toString()).intValue() : Integer.valueOf(anoAvaliacao + parametros.get("parSemanaFinal").toString()).intValue()) : Integer.valueOf(anoAvaliacao + parametros.get("parSemanaFinal").toString());
        semanaIni = Integer.valueOf(parametros.get("parSemanaInicial").toString()) < 10 ? (parametros.get("parSemanaInicial").toString().length() < 2 ? Integer.valueOf(anoAvaliacao + "0" + parametros.get("parSemanaInicial").toString()).intValue() : Integer.valueOf(anoAvaliacao + parametros.get("parSemanaInicial").toString()).intValue()) : Integer.valueOf(anoAvaliacao + parametros.get("parSemanaInicial").toString());
        int totalSemanas = Integer.valueOf(parametros.get("parSemanaFinal").toString()) - Integer.valueOf(parametros.get("parSemanaInicial").toString()) + 1;
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                this.utilDbf.mapearPosicoes(reader);
                double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    Agravo regiaoResidencia;
                    if (((Boolean)parametros.get("parIsRegiao")).booleanValue()) {
                        regiaoResidencia = (Agravo)regiaoBeans.get(this.utilDbf.getString(rowObjects, "ID_MUNICIP"));
                        if (regiaoResidencia != null) {
                            this.municipioResidencia = this.municipiosBeans.get(regiaoResidencia.getCodRegiaoSaude());
                        }
                    } else {
                        regiaoResidencia = (Agravo)regiaoBeans.get(this.utilDbf.getString(rowObjects, "ID_MUNICIP"));
                        if (regiaoResidencia != null) {
                            this.municipioResidencia = this.municipiosBeans.get(regiaoResidencia.getCodRegional());
                        }
                    }
                    this.calculaIndicador(rowObjects, anoAvaliacao, semanaIni, semanaFim);
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                    this.getBarraStatus().setString("Calculando Indicador... " + (int)percentual + "% " + (k + 1) + " de " + arquivos.length + " (" + arquivos[k] + ")");
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException ex) {
                Master.mensagem("Erro:\n" + (Object)((Object)ex));
            }
        }
        String ano = dataInicio.substring(0, 4);
        this.setBeans(new ArrayList());
        Collection<Agravo> municipioBean = this.municipiosBeans.values();
        for (Agravo agravoDBF : municipioBean) {
            this.getBeans().add(agravoDBF);
            agravoDBF.setNumerador(String.valueOf(totalSemanas));
            agravoDBF.setNumeradorInt(totalSemanas);
            this.getBarraStatus().setString("Calculando indicador para: " + agravoDBF.getNomeMunicipio());
        }
        this.getBarraStatus().setString(null);
        ComparatorChain chain = new ComparatorChain(Arrays.asList(new BeanComparator("uf"), new BeanComparator("nomeMunicipio")));
        Collections.sort(this.getBeans(), chain);
    }

    private void calculaMunicipios(DBFReader reader, Map parametros) throws ParseException {
        String ufResidencia = (String)parametros.get("parUf");
        String sgUfResidencia = (String)parametros.get("parSgUf");
        String codRegional = (String)parametros.get("parCodRegional");
        String codRegiao = (String)parametros.get("parCodRegiaoSaude");
        String idMunicipio = parametros.get("parMunicipio") != null ? (String)parametros.get("parMunicipio") : "TODOS";
        if (codRegional == null) {
            codRegional = "";
        }
        if (codRegiao == null) {
            codRegiao = "";
        }
        this.municipiosBeans = (Boolean)parametros.get("parIsRegiao") != false ? this.populaMunicipiosBeansMAL(sgUfResidencia, codRegiao, idMunicipio, parametros.get("parIsRegiao").toString()) : this.populaMunicipiosBeansMAL(sgUfResidencia, codRegional, idMunicipio, parametros.get("parIsRegiao").toString());
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        parametros.put("numeradorTotal", 0);
        parametros.put("denominadorTotal", 0);
        int semanaIni = 0;
        int semanaFim = 0;
        String anoAvaliacao = (String)parametros.get("parAnoAvaliacao");
        this.setAnoAvaliado(anoAvaliacao);
        semanaFim = Integer.valueOf(parametros.get("parSemanaFinal").toString()) < 10 ? (parametros.get("parSemanaFinal").toString().length() < 2 ? Integer.valueOf(anoAvaliacao + "0" + parametros.get("parSemanaFinal").toString()).intValue() : Integer.valueOf(anoAvaliacao + parametros.get("parSemanaFinal").toString()).intValue()) : Integer.valueOf(anoAvaliacao + parametros.get("parSemanaFinal").toString());
        semanaIni = Integer.valueOf(parametros.get("parSemanaInicial").toString()) < 10 ? (parametros.get("parSemanaInicial").toString().length() < 2 ? Integer.valueOf(anoAvaliacao + "0" + parametros.get("parSemanaInicial").toString()).intValue() : Integer.valueOf(anoAvaliacao + parametros.get("parSemanaInicial").toString()).intValue()) : Integer.valueOf(anoAvaliacao + parametros.get("parSemanaInicial").toString());
        int totalSemanas = Integer.valueOf(parametros.get("parSemanaFinal").toString()) - Integer.valueOf(parametros.get("parSemanaInicial").toString()) + 1;
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                this.utilDbf.mapearPosicoes(reader);
                double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    this.municipioResidencia = this.municipiosBeans.get(this.utilDbf.getString(rowObjects, "ID_MUNICIP"));
                    this.calculaIndicador(rowObjects, anoAvaliacao, semanaIni, semanaFim);
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                    this.getBarraStatus().setString("Calculando Indicador... " + (int)percentual + "% " + (k + 1) + " de " + arquivos.length + " (" + arquivos[k] + ")");
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException ex) {
                Master.mensagem("Erro:\n" + (Object)((Object)ex));
            }
        }
        String ano = dataInicio.substring(0, 4);
        this.setBeans(new ArrayList());
        Collection<Agravo> municipioBean = this.municipiosBeans.values();
        for (Agravo agravoDBF : municipioBean) {
            this.getBeans().add(agravoDBF);
            agravoDBF.setNumerador(String.valueOf(totalSemanas));
            agravoDBF.setNumeradorInt(totalSemanas);
            this.getBarraStatus().setString("Calculando indicador para: " + agravoDBF.getNomeMunicipio());
        }
        this.getBarraStatus().setString(null);
        ComparatorChain chain = (Boolean)parametros.get("parIsRegiao") != false ? new ComparatorChain(Arrays.asList(new BeanComparator("uf"), new BeanComparator("regiaoSaude"), new BeanComparator("nomeMunicipio"))) : new ComparatorChain(Arrays.asList(new BeanComparator("uf"), new BeanComparator("regional"), new BeanComparator("nomeMunicipio")));
        Collections.sort(this.getBeans(), chain);
    }

    private void calculaSomenteMunicipios(DBFReader reader, Map parametros) throws ParseException {
        String ufResidencia = (String)parametros.get("parUf");
        String sgUfResidencia = (String)parametros.get("parSgUf");
        String idMunicipio = parametros.get("parMunicipio") != null ? (String)parametros.get("parMunicipio") : "TODOS";
        this.municipiosBeans = this.populaMunicipiosBeansMAL(sgUfResidencia, "", idMunicipio, "false");
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        parametros.put("numeradorTotal", 0);
        parametros.put("denominadorTotal", 0);
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        int semanaIni = 0;
        int semanaFim = 0;
        String anoAvaliacao = (String)parametros.get("parAnoAvaliacao");
        this.setAnoAvaliado(anoAvaliacao);
        semanaFim = Integer.valueOf(parametros.get("parSemanaFinal").toString()) < 10 ? (parametros.get("parSemanaFinal").toString().length() < 2 ? Integer.valueOf(anoAvaliacao + "0" + parametros.get("parSemanaFinal").toString()).intValue() : Integer.valueOf(anoAvaliacao + parametros.get("parSemanaFinal").toString()).intValue()) : Integer.valueOf(anoAvaliacao + parametros.get("parSemanaFinal").toString());
        semanaIni = Integer.valueOf(parametros.get("parSemanaInicial").toString()) < 10 ? (parametros.get("parSemanaInicial").toString().length() < 2 ? Integer.valueOf(anoAvaliacao + "0" + parametros.get("parSemanaInicial").toString()).intValue() : Integer.valueOf(anoAvaliacao + parametros.get("parSemanaInicial").toString()).intValue()) : Integer.valueOf(anoAvaliacao + parametros.get("parSemanaInicial").toString());
        int totalSemanas = Integer.valueOf(parametros.get("parSemanaFinal").toString()) - Integer.valueOf(parametros.get("parSemanaInicial").toString()) + 1;
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                this.utilDbf.mapearPosicoes(reader);
                double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    this.municipioResidencia = this.municipiosBeans.get(this.utilDbf.getString(rowObjects, "ID_MUNICIP"));
                    if (this.municipioResidencia != null) {
                        this.calculaIndicador(rowObjects, anoAvaliacao, semanaIni, semanaFim);
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                    this.getBarraStatus().setString("Calculando Indicador... " + (int)percentual + "% " + (k + 1) + " de " + arquivos.length + " (" + arquivos[k] + ")");
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException ex) {
                Master.mensagem("Erro:\n" + (Object)((Object)ex));
            }
        }
        String ano = dataInicio.substring(0, 4);
        this.setBeans(new ArrayList());
        Collection<Agravo> municipioBean = this.municipiosBeans.values();
        for (Agravo agravoDBF : municipioBean) {
            agravoDBF.setNumerador(String.valueOf(totalSemanas));
            agravoDBF.setNumeradorInt(totalSemanas);
            this.getBeans().add(agravoDBF);
            this.getBarraStatus().setString("Calculando indicador para: " + agravoDBF.getNomeMunicipio());
        }
        this.getBarraStatus().setString(null);
        ComparatorChain chain = new ComparatorChain(Arrays.asList(new BeanComparator("uf"), new BeanComparator("nomeMunicipio")));
        Collections.sort(this.getBeans(), chain);
    }

    @Override
    public void calcula(DBFReader reader, Map parametros) {
        Boolean municipios = (Boolean)parametros.get("parNenhum") == false;
        Boolean somenteMunicipios = parametros.get("parDesagregacao").equals("Somente munic\u00edpios");
        try {
            if (somenteMunicipios.booleanValue()) {
                this.calculaSomenteMunicipios(reader, parametros);
            } else if (municipios.booleanValue()) {
                this.calculaMunicipios(reader, parametros);
            } else {
                this.calculaRegiao(reader, parametros);
            }
        }
        catch (ParseException ex) {
            System.out.println(ex);
        }
    }

    @Override
    public Map getParametros() {
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parDataInicio", Util.formataData(this.getDtInicioAvaliacao()));
        parametros.put("parDataFim", Util.formataData(this.getDtFimAvaliacao()));
        parametros.put("parDataInicioCoortePB", Util.formataData(SinanDateUtil.subtrairAno(this.getDtInicioAvaliacao(), -1)));
        parametros.put("parDataFimCoortePB", Util.formataData(SinanDateUtil.subtrairAno(this.getDtFimAvaliacao(), -1)));
        parametros.put("parPeriodoCoortePB", SinanDateUtil.subtrairAno(this.getDtInicioAvaliacao(), -1) + " a " + SinanDateUtil.subtrairAno(this.getDtFimAvaliacao(), -1) + " (PB)");
        parametros.put("parDataInicioCoorteMB", Util.formataData(SinanDateUtil.subtrairAno(this.getDtInicioAvaliacao(), -2)));
        parametros.put("parDataFimCoorteMB", Util.formataData(SinanDateUtil.subtrairAno(this.getDtFimAvaliacao(), -2)));
        parametros.put("parPeriodoCoorteMB", SinanDateUtil.subtrairAno(this.getDtInicioAvaliacao(), -2) + " a " + SinanDateUtil.subtrairAno(this.getDtFimAvaliacao(), -2) + " (MB)");
        parametros.put("parPeriodo", "de " + this.getDtInicioAvaliacao() + " a " + this.getDtFimAvaliacao());
        parametros.put("parTituloColuna", this.getTituloColuna());
        parametros.put("parFator", String.valueOf(this.getMultiplicador()));
        parametros.put("parAno", Util.getAno(this.getDtFimAvaliacao()));
        parametros.put("parRodape", this.getRodape());
        parametros.put("parConfig", "");
        parametros.put("parTitulo1", "N\u00famero de casos aut\u00f3ctones de mal\u00e1ria.");
        ANO = "";
        if (Util.getAno(this.getDtFimAvaliacao()).equals(Util.getAno(this.getDtInicioAvaliacao()))) {
            ANO = Util.getAno(this.getDtFimAvaliacao());
        }
        this.setDataInicio(this.getDtInicioAvaliacao());
        this.setDataFim(this.getDtFimAvaliacao());
        return parametros;
    }

    @Override
    public String[] getOrdemColunas() {
        return new String[]{"COUFNOT", "ID_LOCNOT", "DS_LOCNOT", "COD_CIR", "NOME_CIR", "DENOMINAD", "NUMERADOR", "RESULTADO", "ANO_AVALI", "ORIGEM"};
    }

    @Override
    public HashMap<String, ColunasDbf> getColunas() {
        HashMap<String, ColunasDbf> hashColunas = new HashMap<String, ColunasDbf>();
        hashColunas.put("COUFNOT", new ColunasDbf(30));
        hashColunas.put("ID_LOCNOT", new ColunasDbf(30));
        hashColunas.put("DS_LOCNOT", new ColunasDbf(30));
        hashColunas.put("COD_CIR", new ColunasDbf(30));
        hashColunas.put("NOME_CIR", new ColunasDbf(30));
        hashColunas.put("DENOMINAD", new ColunasDbf(30));
        hashColunas.put("NUMERADOR", new ColunasDbf(30));
        hashColunas.put("RESULTADO", new ColunasDbf(30));
        hashColunas.put("ANO_AVALI", new ColunasDbf(30));
        hashColunas.put("ORIGEM", new ColunasDbf(30));
        this.setColunas(hashColunas);
        return hashColunas;
    }

    @Override
    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        for (int i = 0; i < bean.size(); ++i) {
            Object[] rowData = new Object[colunas.size()];
            Agravo agravo = (Agravo)bean.get(i);
            if (agravo.getNomeMunicipio().equals("BRASIL") || agravo.getNomeMunicipio().equals("TOTAL")) {
                rowData[0] = null;
                rowData[1] = null;
                rowData[3] = null;
                rowData[4] = null;
            } else {
                rowData[0] = agravo.getCodMunicipio().substring(0, 2);
                rowData[1] = agravo.getCodMunicipio();
                if (agravo.getRegional() != null && agravo.getRegional() != null) {
                    if (!agravo.getRegional().isEmpty()) {
                        rowData[3] = agravo.getCodRegional();
                        rowData[4] = agravo.getRegional();
                    } else if (!agravo.getRegiaoSaude().isEmpty()) {
                        rowData[3] = agravo.getCodRegiaoSaude();
                        rowData[4] = agravo.getRegiaoSaude();
                    }
                }
            }
            rowData[2] = agravo.getNomeMunicipio();
            rowData[5] = agravo.getNumerador();
            rowData[6] = agravo.getDenominador();
            if (Integer.valueOf(agravo.getNumerador()) <= 0) {
                rowData[7] = "0.0";
            } else {
                Double percentual = Double.valueOf(agravo.getDenominador()) / Double.valueOf(agravo.getNumerador()) * 100.0;
                rowData[7] = String.format("%.1f", percentual);
            }
            rowData[8] = this.getAnoAvaliado();
            rowData[9] = "SINANNET";
            writer.addRecord(rowData);
        }
        return writer;
    }

    @Override
    public String getCaminhoJasper() {
        return "/com/org/relatorios/SemanaEpidemiologicaPactuacao.jasper";
    }
}

