/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.ColunasDbf;
import com.org.negocio.Configuracao;
import com.org.negocio.Util;
import com.org.view.Master;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;

public class SifilisCongenitaIncidencia
extends Agravo {
    static String ANO;

    public SifilisCongenitaIncidencia(boolean isDbf) {
        this.setDBF(isDbf);
        this.setPeriodo("de Diagn\u00f3stico");
        this.setTipoAgregacao("de Resid\u00eancia");
        this.init("postgres");
    }

    public SifilisCongenitaIncidencia() {
    }

    @Override
    public void init(String tipoBanco) {
        this.setMultiplicador(1);
        this.setTitulo1("SifilisCongenitaIncidencia");
        this.setTextoCompletitude("");
        this.setTituloColuna("Todas Idades");
        this.setRodape("N\u00famero absoluto de casos de S\u00edfilis Cong\u00eanita residentes em determinado local e per\u00edodo de diagn\u00f3stico selecionado");
        this.setTipo("sifilis");
        this.setSqlNumeradorCompletitude("");
        if (!this.isDBF()) {
            this.setSqlNumeradorMunicipioEspecifico("SELECT  count(*) as numerador FROM  dbsinan.tb_notificacao where co_cid = 'A50.9' and (dt_diagnostico_sintoma BETWEEN ?  AND ?) and co_uf_residencia= ? and co_municipio_residencia = ? and nu_idade < 4001");
            this.setSqlDenominadorMunicipioEspecifico("SELECT count(*) as denominador FROM  dbsinan.tb_notificacao where co_cid = 'A50.9' and (dt_diagnostico_sintoma BETWEEN  ?  AND ?) and co_uf_residencia= ? and co_municipio_residencia = ?  and (nu_idade is null or nu_idade > 4125 or nu_idade = 0000)");
            this.setSqlNumeradorEstado("SELECT  count(*) as numerador FROM  dbsinan.tb_notificacao where co_cid = 'A50.9' and (dt_diagnostico_sintoma BETWEEN ?  AND ?) and co_uf_residencia= ?  and nu_idade < 4001");
            this.setSqlDenominandorEstado("SELECT  count(*) as denominador FROM  dbsinan.tb_notificacao where co_cid = 'A50.9' and (dt_diagnostico_sintoma BETWEEN ?  AND ?) and co_uf_residencia= ?  and (nu_idade is null or nu_idade > 4125 or nu_idade = 0000)");
            this.setSqlNumeradorCompletitude("");
            this.setSqlNumeradorBeanMunicipios(this.getSqlNumeradorMunicipioEspecifico());
            this.setSqlDenominadorBeanMunicipios(this.getSqlDenominadorMunicipioEspecifico());
        }
    }

    public boolean verificaClassificacaoFinal(int classificacaoFinal) {
        return classificacaoFinal == 3 || classificacaoFinal == 4;
    }

    private void calculaBrasil(DBFReader reader, Map parametros) throws ParseException {
        String coluna;
        HashMap<Object, Object> municipiosBeans = new HashMap();
        DBFUtil utilDbf = new DBFUtil();
        if (parametros.get("municipios").toString().equals("sim")) {
            municipiosBeans = this.populaMunicipiosBeans("BR", "");
            coluna = "ID_MN_RESI";
        } else {
            municipiosBeans = this.populaUfsBeans();
            coluna = "SG_UF";
        }
        DecimalFormat df = new DecimalFormat("0.00");
        int denominador = 0;
        int numerador = 0;
        boolean totalNotificacoes = false;
        int numeradorEstadual = 0;
        int denominadorEstadual = 0;
        boolean isBetween = false;
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                utilDbf.mapearPosicoes(reader);
                double d = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (utilDbf.getString(rowObjects, coluna) != null) {
                        Agravo municipioResidencia = (Agravo)municipiosBeans.get(utilDbf.getString(rowObjects, coluna));
                        int idade = utilDbf.getInt(rowObjects, "NU_IDADE_N");
                        isBetween = this.isBetweenDates(utilDbf.getDate(rowObjects, "DT_DIAG"), dataInicio, dataFim);
                        if (municipioResidencia != null) {
                            if (idade == -1 || idade > 4125) {
                                if (isBetween) {
                                    denominador = Integer.parseInt(municipioResidencia.getDenominador());
                                    municipioResidencia.setDenominador(String.valueOf(++denominador));
                                }
                            } else if (isBetween && idade < 4001) {
                                numerador = Integer.parseInt(municipioResidencia.getNumerador());
                                municipioResidencia.setNumerador(String.valueOf(++numerador));
                            }
                            if (isBetween) {
                                if (municipioResidencia.getTaxa() == null) {
                                    municipioResidencia.setTaxa("0");
                                }
                                numerador = Integer.parseInt(municipioResidencia.getTaxa());
                                municipioResidencia.setTaxa(String.valueOf(++numerador));
                            }
                        }
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(d)) * 100.0f;
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException dBFException) {
                Master.mensagem("Erro:\n" + (Object)((Object)dBFException));
            }
        }
        String total = df.format(Double.parseDouble(String.valueOf(numeradorEstadual + numerador)) + Double.parseDouble(String.valueOf(denominadorEstadual + denominador)));
        this.setTaxaEstadual(total + " (Menor que 1 ano:" + String.valueOf(numeradorEstadual + numerador) + " / Sem informa\u00e7\u00e3o de idade: " + String.valueOf(denominadorEstadual + denominador) + ")");
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        if (parametros.get("parSgUf").toString().equals("TODAS") || parametros.get("municipios").toString().equals("sim")) {
            for (Agravo agravo : municipioBean) {
                if (agravo.getTaxa() == null) {
                    agravo.setTaxa("0");
                }
                if (!coluna.equals("ID_MN_RESI")) {
                    agravo.setCodMunicipio(agravo.getNomeMunicipio());
                }
                this.getBeans().add(agravo);
            }
            Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
        }
        this.getBeans().add(this.adicionaBrasil(municipioBean));
    }

    @Override
    public Agravo adicionaBrasil(Collection<Agravo> municipioBean) {
        Agravo agravoBean = new Agravo();
        agravoBean.setNomeMunicipio("BRASIL");
        agravoBean.setCodMunicipio("51");
        agravoBean.setNumerador("0");
        agravoBean.setDenominador("0");
        for (Agravo agravoUF : municipioBean) {
            agravoBean.setNumerador(String.valueOf(Integer.parseInt(agravoUF.getNumerador()) + Integer.parseInt(agravoBean.getNumerador())));
            agravoBean.setDenominador(String.valueOf(Integer.parseInt(agravoUF.getDenominador()) + Integer.parseInt(agravoBean.getDenominador())));
            if (agravoUF.getTaxa() == null) {
                agravoUF.setTaxa("0");
            }
            if (agravoBean.getTaxa() == null) {
                agravoBean.setTaxa("0");
            }
            agravoBean.setTaxa(String.valueOf(Integer.parseInt(agravoUF.getTaxa()) + Integer.parseInt(agravoBean.getTaxa())));
        }
        return agravoBean;
    }

    private void calculaMunicipios(DBFReader reader, Map parametros) throws ParseException {
        HashMap<Object, Object> municipiosBeans = new HashMap();
        String ufResidencia = (String)parametros.get("parUf");
        String sgUfResidencia = (String)parametros.get("parSgUf");
        String codRegional = (String)parametros.get("parCodRegional");
        DBFUtil utilDbf = new DBFUtil();
        if (codRegional == null) {
            codRegional = "";
        }
        municipiosBeans = this.populaMunicipiosBeans(sgUfResidencia, codRegional);
        DecimalFormat df = new DecimalFormat("0.00");
        int denominador = 0;
        int numerador = 0;
        int numeradorEstadual = 0;
        int denominadorEstadual = 0;
        int numeradorRegional = 0;
        int denominadorRegional = 0;
        boolean isBetween = false;
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                utilDbf.mapearPosicoes(reader);
                double d = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (utilDbf.getString(rowObjects, "SG_UF") != null) {
                        Agravo municipioResidencia = (Agravo)municipiosBeans.get(utilDbf.getString(rowObjects, "ID_MN_RESI"));
                        int idade = utilDbf.getInt(rowObjects, "NU_IDADE_N");
                        isBetween = this.isBetweenDates(utilDbf.getDate(rowObjects, "DT_DIAG"), dataInicio, dataFim);
                        if (municipioResidencia != null) {
                            if (idade == -1 || idade > 4125) {
                                if (isBetween) {
                                    denominador = Integer.parseInt(municipioResidencia.getDenominador());
                                    municipioResidencia.setDenominador(String.valueOf(++denominador));
                                    ++denominadorEstadual;
                                    ++denominadorRegional;
                                }
                            } else if (idade < 4001 && isBetween) {
                                numerador = Integer.parseInt(municipioResidencia.getNumerador());
                                municipioResidencia.setNumerador(String.valueOf(++numerador));
                                ++numeradorEstadual;
                                ++numeradorRegional;
                            }
                            if (isBetween) {
                                if (municipioResidencia.getTaxa() == null) {
                                    municipioResidencia.setTaxa("0");
                                }
                                numerador = Integer.parseInt(municipioResidencia.getTaxa());
                                municipioResidencia.setTaxa(String.valueOf(++numerador));
                            }
                        } else if (ufResidencia.equals(utilDbf.getString(rowObjects, "SG_UF"))) {
                            if (idade == -1) {
                                if (isBetween) {
                                    ++denominadorEstadual;
                                }
                            } else if (idade < 4001 && isBetween) {
                                ++numeradorEstadual;
                            }
                        }
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(d)) * 100.0f;
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException dBFException) {
                Master.mensagem("Erro:\n" + (Object)((Object)dBFException));
            }
        }
        String total = df.format(Double.parseDouble(String.valueOf(numeradorEstadual)) + Double.parseDouble(String.valueOf(denominadorEstadual)));
        this.setTaxaEstadual(total + " (Menor que 1 ano:" + String.valueOf(numeradorEstadual) + " / Sem informa\u00e7\u00e3o de idade: " + String.valueOf(denominadorEstadual) + ")");
        if (!codRegional.equals("")) {
            total = df.format(Double.parseDouble(String.valueOf(numeradorRegional)) + Double.parseDouble(String.valueOf(denominadorRegional)));
            this.setTaxaEstadual(this.getTaxaEstadual() + " Regional: " + total + " (Menor que 1 ano:" + String.valueOf(numeradorRegional) + " / Sem informa\u00e7\u00e3o de idade: " + String.valueOf(denominadorRegional) + ")");
        }
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        for (Agravo agravo : municipioBean) {
            if (agravo.getTaxa() == null) {
                agravo.setTaxa("0");
            }
            this.getBeans().add(agravo);
        }
        Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
    }

    @Override
    public void calcula(DBFReader reader, Map parametros) {
        String municipios = (String)parametros.get("municipios");
        String brasil = (String)parametros.get("parUf");
        if (municipios.equals("sim") && !brasil.equals("brasil")) {
            try {
                this.calculaMunicipios(reader, parametros);
            }
            catch (ParseException ex) {
                System.out.println(ex);
            }
        } else if (brasil.equals("brasil")) {
            try {
                this.calculaBrasil(reader, parametros);
            }
            catch (ParseException ex) {
                System.out.println(ex);
            }
        } else {
            DBFUtil utilDbf = new DBFUtil();
            DecimalFormat df = new DecimalFormat("0.00");
            int denominadorEstadual = 0;
            int numeradorEstadual = 0;
            int denominadorEspecifico = 0;
            int numeradorEspecifico = 0;
            int todasIdades = 0;
            boolean isBetween = false;
            String ufResidencia = (String)parametros.get("parUf");
            String municipioResidencia = (String)parametros.get("parMunicipio");
            if (municipioResidencia == null) {
                municipioResidencia = "";
            }
            String dataInicio = (String)parametros.get("parDataInicio");
            String dataFim = (String)parametros.get("parDataFim");
            String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
            for (int k = 0; k < arquivos.length; ++k) {
                int i = 1;
                try {
                    Object[] rowObjects;
                    reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                    utilDbf.mapearPosicoes(reader);
                    double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                    while ((rowObjects = reader.nextRecord()) != null) {
                        if (utilDbf.getString(rowObjects, "SG_UF") != null && utilDbf.getString(rowObjects, "SG_UF").equals(ufResidencia)) {
                            int idade = utilDbf.getInt(rowObjects, "NU_IDADE_N");
                            try {
                                isBetween = this.isBetweenDates(utilDbf.getDate(rowObjects, "DT_DIAG"), dataInicio, dataFim);
                            }
                            catch (ParseException ex) {
                                System.out.println(ex);
                            }
                            if (this.verificaMunicipio(municipioResidencia, utilDbf.getString(rowObjects, "ID_MN_RESI"))) {
                                if (idade == -1) {
                                    try {
                                        if (isBetween) {
                                            ++denominadorEspecifico;
                                            ++denominadorEstadual;
                                        }
                                    }
                                    catch (NumberFormatException ex) {
                                        Master.mensagem("Erro:\n" + ex);
                                    }
                                } else if (isBetween && idade < 4001) {
                                    ++numeradorEspecifico;
                                    ++numeradorEstadual;
                                }
                                if (isBetween) {
                                    ++todasIdades;
                                }
                            } else if (idade == -1) {
                                if (isBetween) {
                                    ++denominadorEstadual;
                                }
                            } else if (isBetween && idade < 4001) {
                                ++numeradorEstadual;
                            }
                        }
                        float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                        this.getBarraStatus().setValue((int)percentual);
                        ++i;
                    }
                    continue;
                }
                catch (DBFException ex) {
                    Master.mensagem("Erro:\n" + (Object)((Object)ex));
                    System.out.println((Object)ex);
                }
            }
            String total = df.format(Double.parseDouble(String.valueOf(numeradorEstadual)) + Double.parseDouble(String.valueOf(denominadorEstadual)));
            this.setTaxaEstadual(total + " (Menor que 1 ano:" + String.valueOf(numeradorEstadual) + " / Sem informa\u00e7\u00e3o de idade: " + String.valueOf(denominadorEstadual) + ")");
            Agravo d1 = new Agravo();
            if (municipioResidencia.equals("")) {
                d1.setNomeMunicipio((String)parametros.get("parSgUf"));
                d1.setCodMunicipio(ufResidencia);
            } else {
                d1.setNomeMunicipio((String)parametros.get("parNomeMunicipio"));
                d1.setCodMunicipio(municipioResidencia);
            }
            if (!String.valueOf(denominadorEspecifico).equals("0.0")) {
                d1.setNumerador(String.valueOf(NumberFormat.getNumberInstance().format(Double.parseDouble(String.valueOf(numeradorEspecifico)))));
                d1.setDenominador(String.valueOf(NumberFormat.getNumberInstance().format(Double.parseDouble(String.valueOf(denominadorEspecifico)))));
                total = df.format(Double.parseDouble(String.valueOf(numeradorEspecifico)) + Double.parseDouble(String.valueOf(denominadorEspecifico)));
                d1.setTaxa(String.valueOf(todasIdades));
            } else {
                d1.setNumerador("0");
                d1.setDenominador("0");
                d1.setTaxa(String.valueOf(todasIdades));
            }
            this.setBeans(new ArrayList());
            this.getBeans().add(d1);
        }
    }

    @Override
    public Map getParametros() {
        Util util = new Util();
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parDataInicio", Util.formataData(this.getDataInicio()));
        parametros.put("parDataFim", Util.formataData(this.getDataFim()));
        parametros.put("parPeriodo", "de " + this.getDataInicio() + " a " + this.getDataFim());
        parametros.put("parTituloColuna", this.getTituloColuna());
        parametros.put("parFator", String.valueOf(this.getMultiplicador()));
        parametros.put("parAno", Util.getAno(this.getDataFim()));
        parametros.put("parRodape", this.getRodape());
        parametros.put("parConfig", "");
        parametros.put("parTituloDenominador", "Idade ign ");
        parametros.put("parTituloNumerador", "Menor 1 ano");
        parametros.put("parTitulo1", "Incid\u00eancia de s\u00edfilis cong\u00eanita");
        ANO = "";
        if (Util.getAno(this.getDataFim()).equals(Util.getAno(this.getDataInicio()))) {
            ANO = Util.getAno(this.getDataFim());
        }
        this.setDataInicio(this.getDataInicio());
        this.setDataFim(this.getDataFim());
        return parametros;
    }

    @Override
    public String[] getOrdemColunas() {
        return new String[]{"ID_LOCRES", "DS_LOCRES", "ID_UFRES", "NOT_M1ANO", "NOT_IDIGN", "I_INCSIF", "ANO_DIAG", "DT_DIAGIN", "DT_DIAGFI", "ORIGEM"};
    }

    @Override
    public HashMap<String, ColunasDbf> getColunas() {
        HashMap<String, ColunasDbf> hashColunas = new HashMap<String, ColunasDbf>();
        hashColunas.put("ID_LOCRES", new ColunasDbf(7));
        hashColunas.put("DS_LOCRES", new ColunasDbf(30));
        hashColunas.put("ID_UFRES", new ColunasDbf(2));
        hashColunas.put("NOT_M1ANO", new ColunasDbf(10, 0));
        hashColunas.put("NOT_IDIGN", new ColunasDbf(10, 0));
        hashColunas.put("I_INCSIF", new ColunasDbf(6, 0));
        hashColunas.put("ANO_DIAG", new ColunasDbf(4, 0));
        hashColunas.put("DT_DIAGIN", new ColunasDbf(10));
        hashColunas.put("DT_DIAGFI", new ColunasDbf(10));
        hashColunas.put("ORIGEM", new ColunasDbf(30));
        this.setColunas(hashColunas);
        return hashColunas;
    }

    @Override
    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        for (int i = 0; i < bean.size(); ++i) {
            Object[] rowData = new Object[colunas.size()];
            Agravo agravo = (Agravo)bean.get(i);
            if (agravo.getNomeMunicipio().equals("BRASIL")) {
                rowData[0] = null;
                rowData[2] = null;
            } else {
                rowData[0] = agravo.getCodMunicipio();
                rowData[2] = agravo.getCodMunicipio().substring(0, 2);
            }
            rowData[1] = agravo.getNomeMunicipio();
            rowData[3] = Double.parseDouble(agravo.getNumerador());
            rowData[4] = Double.parseDouble(agravo.getDenominador());
            rowData[5] = Double.parseDouble(agravo.getTaxa().replace(",", "."));
            rowData[6] = this.preencheAno(this.getDataInicio(), this.getDataFim());
            rowData[7] = this.getDataInicio();
            rowData[8] = this.getDataFim();
            rowData[9] = "SIFILIS-SINANNET";
            writer.addRecord(rowData);
        }
        return writer;
    }

    @Override
    public String getCaminhoJasper() {
        return "/com/org/relatorios/agravo1.jasper";
    }
}

