/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.ColunasDbf;
import com.org.negocio.Configuracao;
import com.org.negocio.Util;
import com.org.util.SinanUtil;
import com.org.view.Master;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;

public class TuberculoseCoorte
extends Agravo {
    private String cura;
    private String abandono;
    private String transfMesmoMunicipio;
    private String transfOutroMunicipio;
    private String transfOutroUf;
    private String naoPreenchido;
    private String erroDiagnostico;
    private String perNaoPreenchido;
    private String subTotal;
    private String total;
    private String perAbandono;
    private String perCura;
    private String transfOutroPais;
    private String obitoComTuberculose;
    private String obitoPorTuberculose;
    private String outraCategoria;
    static String dtInicial;
    static String dtFinal;
    boolean situacaoEncerramento;

    public TuberculoseCoorte(boolean isDbf, boolean situacaoEncerramento) {
        this.setDBF(isDbf);
        this.setPeriodo("de Diagn\u00f3stico");
        this.setTipoAgregacao("de Resid\u00eancia Atual");
        this.init("postgres");
        this.setSituacaoEncerramento(situacaoEncerramento);
        if (!situacaoEncerramento) {
            this.setRodape("NOTA DE RODAP\u00c9: \n1) Mudan\u00e7a de esquema por intoler\u00e2ncia, fal\u00eancia, continua em tratamento e tb multiressistente est\u00e3o somadas em OUTRAS CATEGORIAS e podem ser avaliadas em separado utilizando o Tabwin. \n2) Os casos de tuberculose meningoencef\u00e1lica est\u00e3o exclu\u00eddos da an\u00e1lise da situa\u00e7\u00e3o at\u00e9 o 9\u00b0 m\u00eas. ");
        } else {
            this.setRodape("");
        }
    }

    public TuberculoseCoorte() {
    }

    @Override
    public void init(String tipoBanco) {
        this.setMultiplicador(100000);
        this.setTipo("tube");
        this.setSqlNumeradorCompletitude("");
        this.setCura("0");
        this.setAbandono("0");
        this.setTransfMesmoMunicipio("0");
        this.setTransfOutroMunicipio("0");
        this.setTransfOutroPais("0");
        this.setTransfOutroUf("0");
        this.setErroDiagnostico("0");
        this.setObitoPorTuberculose("0");
        this.setObitoComTuberculose("0");
        this.setNaoPreenchido("0");
        this.setSubTotal("0");
        this.setTransfNaoEspecificada("0");
        this.setOutraCategoria("0");
    }

    public static String formataData(String data) {
        String[] d = data.split("-");
        return d[2] + "/" + d[1] + "/" + d[0];
    }

    public void populaDatas(Map parametros) {
        dtFinal = TuberculoseCoorte.formataData(parametros.get("parDataFim1").toString());
        dtInicial = TuberculoseCoorte.formataData(parametros.get("parDataInicio1").toString());
    }

    private void calculaBrasil(DBFReader reader, Map parametros) throws ParseException {
        String coluna;
        this.populaDatas(parametros);
        HashMap<Object, Object> municipiosBeans = new HashMap();
        DBFUtil utilDbf = new DBFUtil();
        if (parametros.get("municipios").toString().equals("sim")) {
            municipiosBeans = this.populaMunicipiosBeansTuberc("BR", "");
            coluna = "ID_MUNIC_2";
        } else {
            municipiosBeans = this.populaUfsBeansTubec();
            coluna = "SG_UF_2";
        }
        String dataInicio1 = (String)parametros.get("parDataInicio1");
        String dataFim1 = (String)parametros.get("parDataFim1");
        String parTpForma1 = (String)parametros.get("parTpForma1");
        String parBaciloscopia = (String)parametros.get("parBaciloscopia");
        String parTpExtrapulmonar1 = (String)parametros.get("parTpExtrapulmonar1");
        String tpForma = "";
        String baciloscopia1 = "";
        String baciloscopia2 = "";
        String tpExtrapulmonar1 = "";
        String tpExtrapulmonar2 = "";
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                utilDbf.mapearPosicoes(reader);
                double d = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    boolean isOk = true;
                    boolean controleBaciloscopia = true;
                    if (utilDbf.getString(rowObjects, coluna) != null) {
                        TuberculoseCoorte municipioResidencia = (TuberculoseCoorte)municipiosBeans.get(utilDbf.getString(rowObjects, coluna));
                        String modoEntrada = utilDbf.getString(rowObjects, "TRATAMENTO", 1);
                        Date dtDiagnostico = utilDbf.getDate(rowObjects, "DT_DIAG");
                        if (municipioResidencia != null && modoEntrada != null && (modoEntrada.equals("1") || modoEntrada.equals("4")) && this.isBetweenDates(dtDiagnostico, dataInicio1, dataFim1)) {
                            if (parTpForma1 != null) {
                                tpForma = utilDbf.getString(rowObjects, "FORMA", 1);
                                if (tpForma == null) {
                                    isOk = false;
                                } else if (!tpForma.equals("1") && !tpForma.equals("3")) {
                                    isOk = false;
                                }
                            }
                            if (parBaciloscopia != null) {
                                baciloscopia1 = utilDbf.getString(rowObjects, "BACILOSC_E", 1);
                                baciloscopia2 = utilDbf.getString(rowObjects, "BACILOS_E2", 1);
                                if (baciloscopia1 == null && baciloscopia2 == null) {
                                    controleBaciloscopia = false;
                                } else if (baciloscopia1 != null && baciloscopia2 == null) {
                                    if (!baciloscopia1.equals("1")) {
                                        controleBaciloscopia = false;
                                    }
                                } else if (baciloscopia2 != null && baciloscopia1 == null) {
                                    if (!baciloscopia2.equals("1")) {
                                        controleBaciloscopia = false;
                                    }
                                } else {
                                    controleBaciloscopia = baciloscopia2.equals("1") || baciloscopia1.equals("1");
                                }
                            }
                            if (parTpExtrapulmonar1 != null) {
                                tpExtrapulmonar1 = utilDbf.getString(rowObjects, "EXTRAPU1_N", 2);
                                tpExtrapulmonar2 = utilDbf.getString(rowObjects, "EXTRAPU2_N", 2);
                                if (tpExtrapulmonar1 != null && tpExtrapulmonar1.equals("7")) {
                                    isOk = false;
                                }
                                if (tpExtrapulmonar2 != null && tpExtrapulmonar2.equals("7")) {
                                    isOk = false;
                                }
                            }
                            if (isOk && controleBaciloscopia) {
                                String tipoAlta;
                                if (parametros.get("parGroup").toString().equals("tp_situacao_encerramento")) {
                                    tipoAlta = utilDbf.getString(rowObjects, "SITUA_ENCE", 2);
                                    municipioResidencia = this.preencheValoresEncerramento(tipoAlta, municipioResidencia);
                                } else {
                                    tipoAlta = utilDbf.getString(rowObjects, "SITUA_9_M", 2);
                                    municipioResidencia = this.classificaAlta(tipoAlta, municipioResidencia);
                                }
                            }
                        }
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(d)) * 100.0f;
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException dBFException) {
                Master.mensagem("Erro:\n" + (Object)((Object)dBFException));
            }
        }
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        for (TuberculoseCoorte tuberculoseCoorte : municipioBean) {
            this.getBeans().add(this.insereNoBean(tuberculoseCoorte));
        }
        Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
    }

    @Override
    public List getBeanMunicipioEspecifico(Connection con, Map parametros) throws SQLException {
        ResultSet rs2;
        this.populaDatas(parametros);
        if (this.isDBF()) {
            return this.getBeans();
        }
        this.init("");
        String noMunicipio = null;
        ArrayList<TuberculoseCoorte> beans = new ArrayList<TuberculoseCoorte>();
        Object d1 = null;
        DecimalFormat df = new DecimalFormat("0.00");
        String municipio = parametros.get("parMunicipio").toString();
        noMunicipio = parametros.get("parNomeMunicipio").toString();
        String sql1 = "select distinct(" + parametros.get("parGroup").toString() + ") as alta,count(*) as c  from dbsinan.tb_investiga_tuberculose t1 inner join dbsinan.tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A16.9'  and  t1.co_municipio_residencia_atual= ? and (tp_entrada=1 or tp_entrada=4)  " + parametros.get("parSqlTuberculose").toString() + parametros.get("parSqlTuberculose9mes").toString() + "   dt_diagnostico_sintoma between ? and ? and ( tp_duplicidade is null or tp_duplicidade=1  )  group by " + parametros.get("parGroup").toString() + "";
        try {
            PreparedStatement stm2 = con.prepareStatement(sql1);
            stm2.setString(1, municipio);
            stm2.setString(2, parametros.get("parDataInicio1").toString());
            stm2.setString(3, parametros.get("parDataFim1").toString());
            rs2 = stm2.executeQuery();
        }
        catch (Exception exception) {
            sql1 = "select distinct(" + parametros.get("parGroup").toString() + ") as alta,count(*) as c  from tb_investiga_tuberculose t1 inner join tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A16.9' and  t1.co_municipio_residencia_atual= '" + municipio + "' and (tp_entrada=1 or tp_entrada=4)  " + parametros.get("parSqlTuberculose").toString() + parametros.get("parSqlTuberculose9mes").toString() + "   dt_diagnostico_sintoma between '" + parametros.get("parDataInicio1").toString() + "' and '" + parametros.get("parDataFim1").toString() + "' and ( tp_duplicidade is null or tp_duplicidade=1  )  group by " + parametros.get("parGroup").toString() + "";
            System.out.println(sql1);
            PreparedStatement stm2 = con.prepareStatement(sql1);
            rs2 = stm2.executeQuery();
        }
        if (parametros.get("parGroup").toString().equals("tp_situacao_encerramento")) {
            this.preencheValoresEncerramento(rs2);
        } else {
            this.preencheValores(rs2);
        }
        beans.add(this.insereNoBean(municipio, noMunicipio));
        System.out.println("terminou");
        return beans;
    }

    @Override
    public List getBeanEstadoEspecifico(Connection con, Map parametros) throws SQLException {
        ResultSet rs2;
        this.populaDatas(parametros);
        if (this.isDBF()) {
            return this.getBeans();
        }
        this.init("");
        String noUF = null;
        ArrayList<TuberculoseCoorte> beans = new ArrayList<TuberculoseCoorte>();
        Object d1 = null;
        DecimalFormat df = new DecimalFormat("0.00");
        String uf = parametros.get("parUf").toString();
        noUF = parametros.get("parSgUf").toString();
        String sql1 = "select distinct(" + parametros.get("parGroup").toString() + ") as alta,count(*) as c  from dbsinan.tb_investiga_tuberculose t1 inner join dbsinan.tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A16.9' and  t1.co_uf_residencia_atual= ? and (tp_entrada=1 or tp_entrada=4)  " + parametros.get("parSqlTuberculose").toString() + parametros.get("parSqlTuberculose9mes").toString() + "   dt_diagnostico_sintoma between ? and ? and ( tp_duplicidade is null or tp_duplicidade=1  )  group by " + parametros.get("parGroup").toString() + "";
        try {
            PreparedStatement stm2 = con.prepareStatement(sql1);
            stm2.setString(1, uf);
            stm2.setString(2, parametros.get("parDataInicio1").toString());
            stm2.setString(3, parametros.get("parDataFim1").toString());
            rs2 = stm2.executeQuery();
        }
        catch (Exception exception) {
            sql1 = "select distinct(" + parametros.get("parGroup").toString() + ") as alta,count(*) as c  from tb_investiga_tuberculose t1 inner join tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A16.9' and  t1.co_uf_residencia_atual= " + uf + "  and (tp_entrada=1 or tp_entrada=4)  " + parametros.get("parSqlTuberculose").toString() + parametros.get("parSqlTuberculose9mes").toString() + "   dt_diagnostico_sintoma between '" + parametros.get("parDataInicio1").toString() + "' and '" + parametros.get("parDataFim1").toString() + "' and ( tp_duplicidade is null or tp_duplicidade=1  )  group by " + parametros.get("parGroup").toString() + "";
            PreparedStatement stm2 = con.prepareStatement(sql1);
            rs2 = stm2.executeQuery();
        }
        if (parametros.get("parGroup").toString().equals("tp_situacao_encerramento")) {
            this.preencheValoresEncerramento(rs2);
        } else {
            this.preencheValores(rs2);
        }
        beans.add(this.insereNoBean(uf, noUF));
        System.out.println("terminou");
        return beans;
    }

    @Override
    public List getBeanMunicipios(Connection con, Map parametros) throws SQLException {
        ResultSet rs;
        this.populaDatas(parametros);
        if (this.isDBF()) {
            return this.getBeans();
        }
        Statement stm = con.createStatement();
        String noMunicipio = null;
        ArrayList<TuberculoseCoorte> beans = new ArrayList<TuberculoseCoorte>();
        Object d1 = null;
        String sql = parametros.get("parNomeRegional").equals("Todas Regionais") || parametros.get("parNomeRegional").equals("-- Selecione --") ? "select co_municipio_ibge,no_municipio from dbgeral.tb_municipio where sg_uf = '" + parametros.get("parSgUf") + "' order by no_municipio" : "select t1.co_municipio_ibge,no_municipio from dbgeral.tb_municipio as t1, dblocalidade.rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + parametros.get("parUf") + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional = '" + parametros.get("parCodRegional") + "' and no_municipio not like '%Ignorado%'  order by no_municipio";
        try {
            rs = stm.executeQuery(sql);
        }
        catch (Exception exception) {
            sql = parametros.get("parNomeRegional").equals("Todas Regionais") || parametros.get("parNomeRegional").equals("-- Selecione --") ? "select co_municipio_ibge,no_municipio from dbgeral.tb_municipio where sg_uf = '" + parametros.get("parSgUf") + "' order by no_municipio" : "select t1.co_municipio_ibge,no_municipio from dbgeral.tb_municipio as t1,  dblocalidade.rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + parametros.get("parUf") + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional = '" + parametros.get("parCodRegional") + "' and no_municipio not like '%Ignorado%'  order by no_municipio";
            rs = stm.executeQuery(sql);
        }
        this.init("");
        while (rs.next()) {
            ResultSet rs2;
            PreparedStatement stm2;
            this.init("");
            String municipio = rs.getString("co_municipio_ibge");
            noMunicipio = rs.getString("no_municipio");
            String sql1 = "select distinct(" + parametros.get("parGroup").toString() + ") as alta,count(*) as c  from dbsinan.tb_investiga_tuberculose t1 inner join dbsinan.tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A16.9' and  t1.co_municipio_residencia_atual= ? and (tp_entrada=1 or tp_entrada=4)  " + parametros.get("parSqlTuberculose").toString() + parametros.get("parSqlTuberculose9mes").toString() + "   dt_diagnostico_sintoma between ? and ? and ( tp_duplicidade is null or tp_duplicidade=1  )  group by " + parametros.get("parGroup").toString() + "";
            try {
                stm2 = con.prepareStatement(sql1);
                stm2.setString(1, municipio);
                stm2.setString(2, parametros.get("parDataInicio1").toString());
                stm2.setString(3, parametros.get("parDataFim1").toString());
                rs2 = stm2.executeQuery();
            }
            catch (Exception exception) {
                sql1 = "select distinct(" + parametros.get("parGroup").toString() + ") as alta,count(*) as c  from dbsinan.tb_investiga_tuberculose t1 inner join dbsinan.tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A16.9' and  t1.co_municipio_residencia_atual= '" + municipio + "' and (tp_entrada=1 or tp_entrada=4)  " + parametros.get("parSqlTuberculose").toString() + parametros.get("parSqlTuberculose9mes").toString() + "   dt_diagnostico_sintoma between '" + parametros.get("parDataInicio1").toString() + "' and '" + parametros.get("parDataFim1").toString() + "' and ( tp_duplicidade is null or tp_duplicidade=1  )  group by " + parametros.get("parGroup").toString() + "";
                stm2 = con.prepareStatement(sql1);
                rs2 = stm2.executeQuery();
            }
            if (parametros.get("parGroup").toString().equals("tp_situacao_encerramento")) {
                this.preencheValoresEncerramento(rs2);
            } else {
                this.preencheValores(rs2);
            }
            beans.add(this.insereNoBean(municipio, noMunicipio));
        }
        System.out.println("terminou");
        return beans;
    }

    private void calculaMunicipios(DBFReader reader, Map parametros) throws ParseException {
        this.populaDatas(parametros);
        HashMap<Object, Object> municipiosBeans = new HashMap();
        String ufResidencia = (String)parametros.get("parUf");
        String sgUfResidencia = (String)parametros.get("parSgUf");
        String codRegional = (String)parametros.get("parCodRegional");
        DBFUtil utilDbf = new DBFUtil();
        if (codRegional == null) {
            codRegional = "";
        }
        municipiosBeans = this.populaMunicipiosBeansTuberc(sgUfResidencia, codRegional);
        DecimalFormat df = new DecimalFormat("0.00");
        String dataInicio1 = (String)parametros.get("parDataInicio1");
        String dataFim1 = (String)parametros.get("parDataFim1");
        String parTpForma1 = (String)parametros.get("parTpForma1");
        String parTpForma2 = (String)parametros.get("parTpForma2");
        String parBaciloscopia = (String)parametros.get("parBaciloscopia");
        String parBaciloscopia2 = (String)parametros.get("parBaciloscopia2");
        String parTpExtrapulmonar1 = (String)parametros.get("parTpExtrapulmonar1");
        String parTpExtrapulmonar2 = (String)parametros.get("parTpExtrapulmonar2");
        String tpForma = "";
        String baciloscopia1 = "";
        String baciloscopia2 = "";
        String tpExtrapulmonar1 = "";
        String tpExtrapulmonar2 = "";
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                utilDbf.mapearPosicoes(reader);
                double d = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    boolean isOk = true;
                    boolean controleBaciloscopia = true;
                    if (utilDbf.getString(rowObjects, "SG_UF_2") != null) {
                        TuberculoseCoorte municipioResidencia = (TuberculoseCoorte)municipiosBeans.get(utilDbf.getString(rowObjects, "ID_MUNIC_2"));
                        String modoEntrada = utilDbf.getString(rowObjects, "TRATAMENTO", 1);
                        Date dtDiagnostico = utilDbf.getDate(rowObjects, "DT_DIAG");
                        if (municipioResidencia != null && modoEntrada != null && (modoEntrada.equals("1") || modoEntrada.equals("4")) && this.isBetweenDates(dtDiagnostico, dataInicio1, dataFim1)) {
                            if (parTpForma1 != null && !(tpForma = utilDbf.getString(rowObjects, "FORMA", 1)).equals("1") && !tpForma.equals("3")) {
                                isOk = false;
                            }
                            if (parBaciloscopia != null) {
                                baciloscopia1 = utilDbf.getString(rowObjects, "BACILOSC_E", 1);
                                baciloscopia2 = utilDbf.getString(rowObjects, "BACILOS_E2", 1);
                                if (baciloscopia1 == null && baciloscopia2 == null) {
                                    controleBaciloscopia = false;
                                } else if (baciloscopia1 != null && baciloscopia2 == null) {
                                    if (!baciloscopia1.equals("1")) {
                                        controleBaciloscopia = false;
                                    }
                                } else if (baciloscopia2 != null && baciloscopia1 == null) {
                                    if (!baciloscopia2.equals("1")) {
                                        controleBaciloscopia = false;
                                    }
                                } else {
                                    controleBaciloscopia = baciloscopia2.equals("1") || baciloscopia1.equals("1");
                                }
                            }
                            if (parTpExtrapulmonar1 != null) {
                                tpExtrapulmonar1 = utilDbf.getString(rowObjects, "EXTRAPU1_N", 2);
                                tpExtrapulmonar2 = utilDbf.getString(rowObjects, "EXTRAPU2_N", 2);
                                if (tpExtrapulmonar1 != null && tpExtrapulmonar1.equals("7")) {
                                    isOk = false;
                                }
                                if (tpExtrapulmonar2 != null && tpExtrapulmonar2.equals("7")) {
                                    isOk = false;
                                }
                            }
                            if (isOk && controleBaciloscopia) {
                                String tipoAlta;
                                if (parametros.get("parGroup").toString().equals("tp_situacao_encerramento")) {
                                    tipoAlta = utilDbf.getString(rowObjects, "SITUA_ENCE", 2);
                                    municipioResidencia = this.preencheValoresEncerramento(tipoAlta, municipioResidencia);
                                } else {
                                    tipoAlta = utilDbf.getString(rowObjects, "SITUA_9_M", 2);
                                    municipioResidencia = this.classificaAlta(tipoAlta, municipioResidencia);
                                }
                            }
                        }
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(d)) * 100.0f;
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException dBFException) {
                Master.mensagem("Erro:\n" + (Object)((Object)dBFException));
            }
        }
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        for (TuberculoseCoorte tuberculoseCoorte : municipioBean) {
            this.getBeans().add(this.insereNoBean(tuberculoseCoorte));
        }
        Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
    }

    @Override
    public void calcula(DBFReader reader, Map parametros) {
        this.populaDatas(parametros);
        this.init("");
        String municipios = (String)parametros.get("municipios");
        String brasil = (String)parametros.get("parUf");
        if (municipios.equals("sim") && !brasil.equals("brasil")) {
            try {
                this.calculaMunicipios(reader, parametros);
            }
            catch (ParseException ex) {
                System.out.println(ex);
            }
        } else {
            try {
                if (brasil.equals("brasil")) {
                    this.calculaBrasil(reader, parametros);
                } else {
                    DBFUtil utilDbf = new DBFUtil();
                    String ufResidencia = (String)parametros.get("parUf");
                    String municipioResidencia = (String)parametros.get("parMunicipio");
                    if (municipioResidencia == null) {
                        municipioResidencia = "";
                    }
                    String dataInicio1 = (String)parametros.get("parDataInicio1");
                    String dataFim1 = (String)parametros.get("parDataFim1");
                    String parTpForma1 = (String)parametros.get("parTpForma1");
                    String parBaciloscopia = (String)parametros.get("parBaciloscopia");
                    String parTpExtrapulmonar1 = (String)parametros.get("parTpExtrapulmonar1");
                    String tpForma = "";
                    String baciloscopia1 = "";
                    String baciloscopia2 = "";
                    String tpExtrapulmonar1 = "";
                    String tpExtrapulmonar2 = "";
                    String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
                    for (int k = 0; k < arquivos.length; ++k) {
                        Object[] rowObjects;
                        int i = 1;
                        reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                        utilDbf.mapearPosicoes(reader);
                        double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                        while ((rowObjects = reader.nextRecord()) != null) {
                            boolean isOk = true;
                            boolean controleBaciloscopia = true;
                            if (utilDbf.getString(rowObjects, "SG_UF_2") != null && utilDbf.getString(rowObjects, "SG_UF_2").equals(ufResidencia)) {
                                String modoEntrada = utilDbf.getString(rowObjects, "TRATAMENTO", 1);
                                Date dtDiagnostico = utilDbf.getDate(rowObjects, "DT_DIAG");
                                if (this.verificaMunicipio(municipioResidencia, utilDbf.getString(rowObjects, "ID_MUNIC_2")) && modoEntrada != null && (modoEntrada.equals("1") || modoEntrada.equals("4")) && this.isBetweenDates(dtDiagnostico, dataInicio1, dataFim1)) {
                                    if (parTpForma1 != null && !(tpForma = utilDbf.getString(rowObjects, "FORMA", 1)).equals("1") && !tpForma.equals("3")) {
                                        isOk = false;
                                    }
                                    if (parBaciloscopia != null) {
                                        baciloscopia1 = utilDbf.getString(rowObjects, "BACILOSC_E", 1);
                                        baciloscopia2 = utilDbf.getString(rowObjects, "BACILOS_E2", 1);
                                        if (baciloscopia1 == null && baciloscopia2 == null) {
                                            controleBaciloscopia = false;
                                        } else if (baciloscopia1 != null && baciloscopia2 == null) {
                                            if (!baciloscopia1.equals("1")) {
                                                controleBaciloscopia = false;
                                            }
                                        } else if (baciloscopia2 != null && baciloscopia1 == null) {
                                            if (!baciloscopia2.equals("1")) {
                                                controleBaciloscopia = false;
                                            }
                                        } else {
                                            controleBaciloscopia = baciloscopia2.equals("1") || baciloscopia1.equals("1");
                                        }
                                    }
                                    if (parTpExtrapulmonar1 != null) {
                                        tpExtrapulmonar1 = utilDbf.getString(rowObjects, "EXTRAPU1_N", 2);
                                        tpExtrapulmonar2 = utilDbf.getString(rowObjects, "EXTRAPU2_N", 2);
                                        if (tpExtrapulmonar1 != null && tpExtrapulmonar1.equals("7")) {
                                            isOk = false;
                                        }
                                        if (tpExtrapulmonar2 != null && tpExtrapulmonar2.equals("7")) {
                                            isOk = false;
                                        }
                                    }
                                    if (isOk && controleBaciloscopia) {
                                        String tipoAlta;
                                        if (parametros.get("parGroup").toString().equals("tp_situacao_encerramento")) {
                                            tipoAlta = utilDbf.getString(rowObjects, "SITUA_ENCE", 2);
                                            this.preencheValoresEncerramento(tipoAlta);
                                        } else {
                                            tipoAlta = utilDbf.getString(rowObjects, "SITUA_9_M", 2);
                                            this.classificaAlta(tipoAlta);
                                        }
                                    }
                                }
                            }
                            float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                            this.getBarraStatus().setValue((int)percentual);
                            ++i;
                        }
                    }
                    this.setBeans(new ArrayList());
                    String nomeElemento = municipioResidencia.equals("") ? (String)parametros.get("parSgUf") : (String)parametros.get("parNomeMunicipio");
                    this.getBeans().add(this.insereNoBean(municipioResidencia, nomeElemento));
                }
            }
            catch (NumberFormatException ex) {
                System.out.println(ex);
            }
            catch (ParseException ex) {
                System.out.println(ex);
            }
            catch (DBFException ex) {
                System.out.println((Object)ex);
            }
        }
    }

    @Override
    public List getBeansEstadoEspecifico(Connection con, Map parametros) throws SQLException {
        this.populaDatas(parametros);
        if (this.isDBF()) {
            return this.getBeans();
        }
        if (parametros.get("municipios").equals("nao")) {
            return this.getBeanEstadoEspecifico(con, parametros);
        }
        return this.getBeanMunicipios(con, parametros);
    }

    @Override
    public List getBeansMunicipioEspecifico(Connection con, Map parametros) throws SQLException {
        this.populaDatas(parametros);
        if (this.isDBF()) {
            return this.getBeans();
        }
        return this.getBeanMunicipioEspecifico(con, parametros);
    }

    public void preencheValores(ResultSet rs2) throws SQLException {
        int temp = 0;
        while (rs2.next()) {
            String tipoAlta = rs2.getString("alta");
            temp = rs2.getInt("c");
            if (tipoAlta != null && !tipoAlta.equals("")) {
                this.setSubTotal(String.valueOf(temp + Integer.parseInt(this.getSubTotal())));
                if (tipoAlta.equals("1")) {
                    this.setCura(String.valueOf(temp += Integer.parseInt(this.getCura())));
                }
                if (tipoAlta.equals("5")) {
                    this.setTransfMesmoMunicipio(String.valueOf(temp += Integer.parseInt(this.getTransfMesmoMunicipio())));
                }
                if (tipoAlta.equals("6")) {
                    this.setTransfOutroMunicipio(String.valueOf(temp += Integer.parseInt(this.getTransfOutroMunicipio())));
                }
                if (tipoAlta.equals("7")) {
                    this.setTransfOutroUf(String.valueOf(temp += Integer.parseInt(this.getTransfOutroUf())));
                }
                if (tipoAlta.equals("8")) {
                    this.setTransfOutroPais(String.valueOf(temp += Integer.parseInt(this.getTransfOutroPais())));
                }
                if (tipoAlta.equals("9") || tipoAlta.equals("11") || tipoAlta.equals("12") || tipoAlta.equals("13")) {
                    this.setOutraCategoria(String.valueOf(temp += Integer.parseInt(this.getOutraCategoria())));
                }
                if (tipoAlta.equals("3")) {
                    this.setObitoPorTuberculose(String.valueOf(temp += Integer.parseInt(this.getObitoPorTuberculose())));
                }
                if (tipoAlta.equals("4")) {
                    this.setObitoComTuberculose(String.valueOf(temp += Integer.parseInt(this.getObitoComTuberculose())));
                }
                if (tipoAlta.equals("2")) {
                    this.setAbandono(String.valueOf(temp += Integer.parseInt(this.getAbandono())));
                }
                if (!tipoAlta.equals("10")) continue;
                this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal()) - temp));
                this.setErroDiagnostico(String.valueOf(temp += Integer.parseInt(this.getErroDiagnostico())));
                continue;
            }
            this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal()) + temp));
            this.setNaoPreenchido(String.valueOf(temp += Integer.parseInt(this.getNaoPreenchido())));
        }
    }

    public void preencheValoresEncerramento(ResultSet rs2) throws SQLException {
        int temp = 0;
        while (rs2.next()) {
            String tipoAlta = rs2.getString("alta");
            temp = rs2.getInt("c");
            if (tipoAlta != null && !tipoAlta.equals("")) {
                this.setSubTotal(String.valueOf(temp + Integer.parseInt(this.getSubTotal())));
                if (tipoAlta.equals("1")) {
                    this.setCura(String.valueOf(temp += Integer.parseInt(this.getCura())));
                }
                if (tipoAlta.equals("5")) {
                    this.setTransfMesmoMunicipio(String.valueOf(temp += Integer.parseInt(this.getTransfMesmoMunicipio())));
                }
                if (tipoAlta.equals("7")) {
                    this.setTransfOutroUf(String.valueOf(temp += Integer.parseInt(this.getTransfOutroUf())));
                }
                if (tipoAlta.equals("3")) {
                    this.setObitoPorTuberculose(String.valueOf(temp += Integer.parseInt(this.getObitoPorTuberculose())));
                }
                if (tipoAlta.equals("4")) {
                    this.setObitoComTuberculose(String.valueOf(temp += Integer.parseInt(this.getObitoComTuberculose())));
                }
                if (tipoAlta.equals("2")) {
                    this.setAbandono(String.valueOf(temp += Integer.parseInt(this.getAbandono())));
                }
                if (!tipoAlta.equals("6")) continue;
                this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal()) - temp));
                this.setErroDiagnostico(String.valueOf(temp += Integer.parseInt(this.getErroDiagnostico())));
                continue;
            }
            this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal()) + temp));
            this.setNaoPreenchido(String.valueOf(temp += Integer.parseInt(this.getNaoPreenchido())));
        }
    }

    private TuberculoseCoorte preencheValoresEncerramento(String tipoAlta, TuberculoseCoorte municipioResidencia) {
        int temp = 1;
        if (tipoAlta != null && !tipoAlta.equals("")) {
            municipioResidencia.setSubTotal(String.valueOf(temp + Integer.parseInt(municipioResidencia.getSubTotal())));
            if (tipoAlta.equals("1")) {
                municipioResidencia.setCura(String.valueOf(temp += Integer.parseInt(municipioResidencia.getCura())));
            }
            if (tipoAlta.equals("5")) {
                municipioResidencia.setTransfMesmoMunicipio(String.valueOf(temp += Integer.parseInt(municipioResidencia.getTransfMesmoMunicipio())));
            }
            if (tipoAlta.equals("7")) {
                municipioResidencia.setTransfOutroUf(String.valueOf(temp += Integer.parseInt(municipioResidencia.getTransfOutroUf())));
            }
            if (tipoAlta.equals("3")) {
                municipioResidencia.setObitoPorTuberculose(String.valueOf(temp += Integer.parseInt(municipioResidencia.getObitoPorTuberculose())));
            }
            if (tipoAlta.equals("4")) {
                municipioResidencia.setObitoComTuberculose(String.valueOf(temp += Integer.parseInt(municipioResidencia.getObitoComTuberculose())));
            }
            if (tipoAlta.equals("2")) {
                municipioResidencia.setAbandono(String.valueOf(temp += Integer.parseInt(municipioResidencia.getAbandono())));
            }
            if (tipoAlta.equals("6")) {
                municipioResidencia.setSubTotal(String.valueOf(Integer.parseInt(municipioResidencia.getSubTotal()) - temp));
                municipioResidencia.setErroDiagnostico(String.valueOf(temp += Integer.parseInt(municipioResidencia.getErroDiagnostico())));
            }
        } else {
            municipioResidencia.setSubTotal(String.valueOf(Integer.parseInt(municipioResidencia.getSubTotal()) + temp));
            municipioResidencia.setNaoPreenchido(String.valueOf(temp += Integer.parseInt(municipioResidencia.getNaoPreenchido())));
        }
        return municipioResidencia;
    }

    private TuberculoseCoorte classificaAlta(String tipoAlta, TuberculoseCoorte beanMunicipioResidencia) {
        int temp = 1;
        if (tipoAlta != null && !tipoAlta.equals("")) {
            beanMunicipioResidencia.setSubTotal(String.valueOf(temp + Integer.parseInt(beanMunicipioResidencia.getSubTotal())));
            if (tipoAlta.equals("1")) {
                beanMunicipioResidencia.setCura(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getCura())));
            }
            if (tipoAlta.equals("5")) {
                beanMunicipioResidencia.setTransfMesmoMunicipio(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getTransfMesmoMunicipio())));
            }
            if (tipoAlta.equals("6")) {
                beanMunicipioResidencia.setTransfOutroMunicipio(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getTransfOutroMunicipio())));
            }
            if (tipoAlta.equals("7")) {
                beanMunicipioResidencia.setTransfOutroUf(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getTransfOutroUf())));
            }
            if (tipoAlta.equals("8")) {
                beanMunicipioResidencia.setTransfOutroPais(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getTransfOutroPais())));
            }
            if (tipoAlta.equals("9") || tipoAlta.equals("11") || tipoAlta.equals("12") || tipoAlta.equals("13")) {
                beanMunicipioResidencia.setOutraCategoria(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getOutraCategoria())));
            }
            if (tipoAlta.equals("3")) {
                beanMunicipioResidencia.setObitoPorTuberculose(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getObitoPorTuberculose())));
            }
            if (tipoAlta.equals("4")) {
                beanMunicipioResidencia.setObitoComTuberculose(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getObitoComTuberculose())));
            }
            if (tipoAlta.equals("2")) {
                beanMunicipioResidencia.setAbandono(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getAbandono())));
            }
            if (tipoAlta.equals("10")) {
                beanMunicipioResidencia.setSubTotal(String.valueOf(Integer.parseInt(beanMunicipioResidencia.getSubTotal()) - temp));
                beanMunicipioResidencia.setErroDiagnostico(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getErroDiagnostico())));
            }
        } else {
            beanMunicipioResidencia.setSubTotal(String.valueOf(Integer.parseInt(beanMunicipioResidencia.getSubTotal()) + temp));
            beanMunicipioResidencia.setNaoPreenchido(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getNaoPreenchido())));
        }
        beanMunicipioResidencia.setSubTotal(String.valueOf(Integer.parseInt(beanMunicipioResidencia.getSubTotal())));
        return beanMunicipioResidencia;
    }

    public TuberculoseCoorte insereNoBean(TuberculoseCoorte beanHans) {
        DecimalFormat df = new DecimalFormat("0.0");
        if (beanHans.getSubTotal().equals("-1")) {
            beanHans.setSubTotal("0");
        }
        String sub = beanHans.getSubTotal();
        if (beanHans.getSubTotal().equals("0")) {
            sub = "1";
        }
        beanHans.setTotal(String.valueOf(Integer.valueOf(beanHans.getSubTotal()) + Integer.valueOf(beanHans.getErroDiagnostico())));
        beanHans.setPerAbandono(df.format(Float.valueOf(beanHans.getAbandono()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        beanHans.setPerCura(df.format(Float.valueOf(beanHans.getCura()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        beanHans.setPerNaoPreenchido(df.format(Float.valueOf(beanHans.getNaoPreenchido()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        return beanHans;
    }

    public TuberculoseCoorte insereNoBean(String municipio, String noMunicipio) {
        DecimalFormat df = new DecimalFormat("0.00");
        TuberculoseCoorte d1 = new TuberculoseCoorte();
        d1.setCodMunicipio(municipio);
        d1.setNomeMunicipio(noMunicipio);
        this.getBarraStatus().setString("Calculando munic\u00edpio: " + noMunicipio);
        d1.setCura(this.getCura());
        d1.setTransfMesmoMunicipio(this.getTransfMesmoMunicipio());
        d1.setTransfOutroMunicipio(this.getTransfOutroMunicipio());
        d1.setTransfOutroPais(this.getTransfOutroPais());
        d1.setTransfOutroUf(this.getTransfOutroUf());
        d1.setObitoPorTuberculose(this.getObitoPorTuberculose());
        d1.setObitoComTuberculose(this.getObitoComTuberculose());
        d1.setAbandono(this.getAbandono());
        d1.setErroDiagnostico(this.getErroDiagnostico());
        d1.setOutraCategoria(this.getOutraCategoria());
        d1.setNaoPreenchido(this.getNaoPreenchido());
        d1.setTransfNaoEspecificada(this.getTransfNaoEspecificada());
        d1.setSubTotal(this.getSubTotal());
        String sub = this.getSubTotal();
        if (d1.getSubTotal().equals("0")) {
            sub = "1";
        }
        d1.setTotal(String.valueOf(Integer.valueOf(this.getSubTotal()) + Integer.valueOf(this.getErroDiagnostico())));
        d1.setPerAbandono(df.format(Float.valueOf(this.getAbandono()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        d1.setPerCura(df.format(Float.valueOf(this.getCura()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        d1.setPerNaoPreenchido(df.format(Float.valueOf(this.getNaoPreenchido()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        return d1;
    }

    public void reset() {
        this.setCura("0");
        this.setAbandono("0");
        this.setTransfMesmoMunicipio("0");
        this.setTransfOutroMunicipio("0");
        this.setTransfOutroPais("0");
        this.setTransfOutroUf("0");
        this.setErroDiagnostico("0");
        this.setObitoPorTuberculose("0");
        this.setObitoComTuberculose("0");
        this.setNaoPreenchido("0");
        this.setSubTotal("0");
        this.setTransfNaoEspecificada("0");
        this.setOutraCategoria("0");
    }

    @Override
    public String getTaxaEstado(Connection con, Map parametros) throws SQLException {
        if (this.isDBF()) {
            DBFReader reader = null;
            this.calcula(reader, parametros);
            return this.getTaxaEstadual();
        }
        return "";
    }

    public HashMap<String, TuberculoseCoorte> populaUfsBeansTubec() {
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap uf = new HashMap();
        HashMap<String, TuberculoseCoorte> ufsBeans = new HashMap<String, TuberculoseCoorte>();
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("UF", "dbf\\");
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                TuberculoseCoorte agravoDbf = new TuberculoseCoorte();
                agravoDbf.init("");
                agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_UF"));
                agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "SG_UF"));
                uf.put(utilDbf.getString(rowObjects1, "ID_UF"), utilDbf.getString(rowObjects1, "SG_UF"));
                ufsBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        uf = this.sortHashMapByValues(uf, false);
        Set ufKeys = ((HashMap)uf).keySet();
        HashMap<String, TuberculoseCoorte> ufsBeansRetorno = new HashMap<String, TuberculoseCoorte>();
        for (String key : ufKeys) {
            ufsBeansRetorno.put(key, (TuberculoseCoorte)ufsBeans.get(key));
        }
        return ufsBeansRetorno;
    }

    public HashMap<String, TuberculoseCoorte> populaMunicipiosBeansTuberc(String sgUfResidencia, String codRegional) {
        TuberculoseCoorte agravoDbf;
        Object[] rowObjects1;
        DBFReader readerMunicipio;
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap municipios = new HashMap();
        HashMap<String, TuberculoseCoorte> municipiosBeans = new HashMap<String, TuberculoseCoorte>();
        if (codRegional.length() > 0) {
            readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
            try {
                utilDbf.mapearPosicoes(readerMunicipio);
                while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                    if (!codRegional.equals(utilDbf.getString(rowObjects1, "ID_REGIONA"))) continue;
                    agravoDbf = new TuberculoseCoorte();
                    agravoDbf.init("");
                    agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                    agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipiosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
            }
        } else {
            readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
            try {
                utilDbf.mapearPosicoes(readerMunicipio);
                while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                    if (!sgUfResidencia.equals(utilDbf.getString(rowObjects1, "SG_UF")) && !sgUfResidencia.equals("BR") || utilDbf.getString(rowObjects1, "NM_MUNICIP").startsWith("IGNORADO") || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("TRANSF.") != -1 || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("ATUAL BENTO GONCALVES") != -1 || (!utilDbf.getString(rowObjects1, "SG_UF").equals("DF") || !utilDbf.getString(rowObjects1, "ID_MUNICIP").equals("530010")) && utilDbf.getString(rowObjects1, "SG_UF").equals("DF")) continue;
                    agravoDbf = new TuberculoseCoorte();
                    agravoDbf.init("");
                    agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                    agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipiosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
            }
        }
        municipios = this.sortHashMapByValues(municipios, false);
        Set municipiosKeys = ((HashMap)municipios).keySet();
        HashMap<String, TuberculoseCoorte> municipiosBeansRetorno = new HashMap<String, TuberculoseCoorte>();
        for (String key : municipiosKeys) {
            municipiosBeansRetorno.put(key, (TuberculoseCoorte)municipiosBeans.get(key));
        }
        return municipiosBeansRetorno;
    }

    private void preencheValoresEncerramento(String tipoAlta) {
        int temp = 1;
        if (tipoAlta != null && !tipoAlta.equals("")) {
            this.setSubTotal(String.valueOf(temp + Integer.parseInt(this.getSubTotal())));
            if (tipoAlta.equals("1")) {
                this.setCura(String.valueOf(temp += Integer.parseInt(this.getCura())));
            }
            if (tipoAlta.equals("5")) {
                this.setTransfMesmoMunicipio(String.valueOf(temp += Integer.parseInt(this.getTransfMesmoMunicipio())));
            }
            if (tipoAlta.equals("7")) {
                this.setTransfOutroUf(String.valueOf(temp += Integer.parseInt(this.getTransfOutroUf())));
            }
            if (tipoAlta.equals("3")) {
                this.setObitoPorTuberculose(String.valueOf(temp += Integer.parseInt(this.getObitoPorTuberculose())));
            }
            if (tipoAlta.equals("4")) {
                this.setObitoComTuberculose(String.valueOf(temp += Integer.parseInt(this.getObitoComTuberculose())));
            }
            if (tipoAlta.equals("2")) {
                this.setAbandono(String.valueOf(temp += Integer.parseInt(this.getAbandono())));
            }
            if (tipoAlta.equals("6")) {
                this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal()) - temp));
                this.setErroDiagnostico(String.valueOf(temp += Integer.parseInt(this.getErroDiagnostico())));
            }
        } else {
            this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal()) + temp));
            this.setNaoPreenchido(String.valueOf(temp += Integer.parseInt(this.getNaoPreenchido())));
        }
    }

    private void classificaAlta(String tipoAlta) {
        int temp = 1;
        if (tipoAlta != null && !tipoAlta.equals("")) {
            this.setSubTotal(String.valueOf(temp + Integer.parseInt(this.getSubTotal())));
            if (tipoAlta.equals("1")) {
                this.setCura(String.valueOf(temp += Integer.parseInt(this.getCura())));
            }
            if (tipoAlta.equals("5")) {
                this.setTransfMesmoMunicipio(String.valueOf(temp += Integer.parseInt(this.getTransfMesmoMunicipio())));
            }
            if (tipoAlta.equals("6")) {
                this.setTransfOutroMunicipio(String.valueOf(temp += Integer.parseInt(this.getTransfOutroMunicipio())));
            }
            if (tipoAlta.equals("7")) {
                this.setTransfOutroUf(String.valueOf(temp += Integer.parseInt(this.getTransfOutroUf())));
            }
            if (tipoAlta.equals("8")) {
                this.setTransfOutroPais(String.valueOf(temp += Integer.parseInt(this.getTransfOutroPais())));
            }
            if (tipoAlta.equals("9") || tipoAlta.equals("11") || tipoAlta.equals("12") || tipoAlta.equals("13")) {
                this.setOutraCategoria(String.valueOf(temp += Integer.parseInt(this.getOutraCategoria())));
            }
            if (tipoAlta.equals("3")) {
                this.setObitoPorTuberculose(String.valueOf(temp += Integer.parseInt(this.getObitoPorTuberculose())));
            }
            if (tipoAlta.equals("4")) {
                this.setObitoComTuberculose(String.valueOf(temp += Integer.parseInt(this.getObitoComTuberculose())));
            }
            if (tipoAlta.equals("2")) {
                this.setAbandono(String.valueOf(temp += Integer.parseInt(this.getAbandono())));
            }
            if (tipoAlta.equals("10")) {
                this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal()) - temp));
                this.setErroDiagnostico(String.valueOf(temp += Integer.parseInt(this.getErroDiagnostico())));
            }
        } else {
            this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal()) + temp));
            this.setNaoPreenchido(String.valueOf(temp += Integer.parseInt(this.getNaoPreenchido())));
        }
        this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal())));
    }

    @Override
    public HashMap<String, ColunasDbf> getColunas() {
        HashMap<String, ColunasDbf> hashColunas = new HashMap<String, ColunasDbf>();
        hashColunas.put("ID_LOCRES", new ColunasDbf(7));
        hashColunas.put("DS_LOCRES", new ColunasDbf(30));
        hashColunas.put("ID_UFRES", new ColunasDbf(2));
        hashColunas.put("N_CURATB", new ColunasDbf(10, 0));
        hashColunas.put("I_CURATB", new ColunasDbf(5, 2));
        hashColunas.put("ST_ABAND", new ColunasDbf(10, 0));
        hashColunas.put("P_STABAND", new ColunasDbf(5, 2));
        hashColunas.put("ST_OBITB", new ColunasDbf(10, 0));
        hashColunas.put("ST_OBITO", new ColunasDbf(10, 0));
        hashColunas.put("ST_IGNOR", new ColunasDbf(10, 0));
        hashColunas.put("P_STIGNOR", new ColunasDbf(5, 2));
        hashColunas.put("D_CURATB", new ColunasDbf(4, 0));
        hashColunas.put("ST_ERRDIA", new ColunasDbf(10, 0));
        hashColunas.put("TOTAL_NOT", new ColunasDbf(4, 0));
        hashColunas.put("ORIGEM", new ColunasDbf(30));
        hashColunas.put("ANO_DIAG", new ColunasDbf(4, 0));
        hashColunas.put("DT_DIAGIN", new ColunasDbf(10));
        hashColunas.put("DT_DIAGFI", new ColunasDbf(10));
        if (!this.isSituacaoEncerramento()) {
            hashColunas.put("ST_MESMUN", new ColunasDbf(10, 0));
            hashColunas.put("ST_OUTMUN", new ColunasDbf(10, 0));
            hashColunas.put("ST_OUTUF", new ColunasDbf(10, 0));
            hashColunas.put("ST_OUTPA", new ColunasDbf(10, 0));
            hashColunas.put("ST_OUTRA", new ColunasDbf(10, 0));
        } else {
            hashColunas.put("ST_TRANSF", new ColunasDbf(10, 0));
            hashColunas.put("ST_TBMULT", new ColunasDbf(10, 0));
        }
        this.setColunas(hashColunas);
        return hashColunas;
    }

    @Override
    public String[] getOrdemColunas() {
        if (!this.isSituacaoEncerramento()) {
            return new String[]{"ID_LOCRES", "DS_LOCRES", "ID_UFRES", "N_CURATB", "I_CURATB", "ST_ABAND", "P_STABAND", "ST_OBITB", "ST_OBITO", "ST_MESMUN", "ST_OUTMUN", "ST_OUTUF", "ST_OUTPA", "ST_IGNOR", "P_STIGNOR", "ST_OUTRA", "D_CURATB", "ST_ERRDIA", "TOTAL_NOT", "ANO_DIAG", "DT_DIAGIN", "DT_DIAGFI", "ORIGEM"};
        }
        return new String[]{"ID_LOCRES", "DS_LOCRES", "ID_UFRES", "N_CURATB", "I_CURATB", "ST_ABAND", "P_STABAND", "ST_OBITB", "ST_OBITO", "ST_TRANSF", "ST_IGNOR", "P_STIGNOR", "ST_TBMULT", "D_CURATB", "ST_ERRDIA", "TOTAL_NOT", "ANO_DIAG", "DT_DIAGIN", "DT_DIAGFI", "ORIGEM"};
    }

    @Override
    public Map getParametros() {
        Util util = new Util();
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parRodape", this.getRodape());
        parametros.put("parConfig", "");
        return parametros;
    }

    @Override
    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        for (int i = 0; i < bean.size(); ++i) {
            Object[] rowData = new Object[colunas.size()];
            TuberculoseCoorte agravo = (TuberculoseCoorte)bean.get(i);
            if (agravo.getNomeMunicipio().equals("BRASIL")) {
                rowData[0] = null;
                rowData[2] = null;
            } else if (agravo.getCodMunicipio() == null || agravo.getCodMunicipio().equals("")) {
                rowData[0] = SinanUtil.siglaUFToIDUF(agravo.getNomeMunicipio());
                rowData[2] = SinanUtil.siglaUFToIDUF(agravo.getNomeMunicipio());
            } else {
                rowData[0] = agravo.getCodMunicipio();
                rowData[2] = agravo.getCodMunicipio().substring(0, 2);
            }
            rowData[1] = agravo.getNomeMunicipio();
            rowData[3] = Double.parseDouble(agravo.getCura());
            rowData[4] = Double.parseDouble(agravo.getPerCura().replace(",", "."));
            rowData[5] = Double.parseDouble(agravo.getAbandono());
            rowData[6] = Double.parseDouble(agravo.getPerAbandono().replace(",", "."));
            rowData[7] = Double.parseDouble(agravo.getObitoPorTuberculose());
            rowData[8] = Double.parseDouble(agravo.getObitoComTuberculose());
            if (!this.isSituacaoEncerramento()) {
                rowData[9] = Double.parseDouble(agravo.getTransfMesmoMunicipio());
                rowData[10] = Double.parseDouble(agravo.getTransfOutroMunicipio());
                rowData[11] = Double.parseDouble(agravo.getTransfOutroUf());
                rowData[12] = Double.parseDouble(agravo.getTransfOutroPais());
                rowData[13] = Double.parseDouble(agravo.getNaoPreenchido());
                rowData[14] = Double.parseDouble(agravo.getPerNaoPreenchido().replace(",", "."));
                rowData[15] = Double.parseDouble(agravo.getOutraCategoria());
                rowData[16] = Double.parseDouble(agravo.getSubTotal());
                rowData[17] = Double.parseDouble(agravo.getErroDiagnostico());
                rowData[18] = Double.parseDouble(agravo.getTotal());
                rowData[19] = this.preencheAno(dtInicial, dtFinal);
                rowData[20] = dtInicial;
                rowData[21] = dtFinal;
                rowData[22] = "TUBERCULOSE-SINANNET";
            } else {
                rowData[9] = Double.parseDouble(agravo.getTransfMesmoMunicipio());
                rowData[10] = Double.parseDouble(agravo.getNaoPreenchido());
                rowData[11] = Double.parseDouble(agravo.getPerNaoPreenchido().replace(",", "."));
                rowData[12] = Double.parseDouble(agravo.getTransfOutroUf());
                rowData[13] = Double.parseDouble(agravo.getSubTotal());
                rowData[14] = Double.parseDouble(agravo.getErroDiagnostico());
                rowData[15] = Double.parseDouble(agravo.getTotal());
                rowData[16] = this.preencheAno(dtInicial, dtFinal);
                rowData[17] = dtInicial;
                rowData[18] = dtFinal;
                rowData[19] = "TUBERCULOSE-SINANNET";
            }
            writer.addRecord(rowData);
        }
        return writer;
    }

    @Override
    public String getCaminhoJasper() {
        return "/com/org/relatorios/hanseniase.jasper";
    }

    public String getCura() {
        return this.cura;
    }

    public void setCura(String cura) {
        this.cura = cura;
    }

    public String getAbandono() {
        return this.abandono;
    }

    public void setAbandono(String abandono) {
        this.abandono = abandono;
    }

    public String getTransfMesmoMunicipio() {
        return this.transfMesmoMunicipio;
    }

    public void setTransfMesmoMunicipio(String transfMesmoMunicipio) {
        this.transfMesmoMunicipio = transfMesmoMunicipio;
    }

    public String getTransfOutroMunicipio() {
        return this.transfOutroMunicipio;
    }

    public void setTransfOutroMunicipio(String transfOutroMunicipio) {
        this.transfOutroMunicipio = transfOutroMunicipio;
    }

    public String getTransfOutroUf() {
        return this.transfOutroUf;
    }

    public void setTransfOutroUf(String transfOutroUf) {
        this.transfOutroUf = transfOutroUf;
    }

    public String getNaoPreenchido() {
        return this.naoPreenchido;
    }

    public void setNaoPreenchido(String naoPreenchido) {
        this.naoPreenchido = naoPreenchido;
    }

    public String getErroDiagnostico() {
        return this.erroDiagnostico;
    }

    public void setErroDiagnostico(String erroDiagnostico) {
        this.erroDiagnostico = erroDiagnostico;
    }

    public String getPerNaoPreenchido() {
        return this.perNaoPreenchido;
    }

    public void setPerNaoPreenchido(String perNaoPreenchido) {
        this.perNaoPreenchido = perNaoPreenchido;
    }

    public String getSubTotal() {
        return this.subTotal;
    }

    public void setSubTotal(String subTotal) {
        this.subTotal = subTotal;
    }

    public String getTotal() {
        return this.total;
    }

    public void setTotal(String total) {
        this.total = total;
    }

    public String getPerAbandono() {
        return this.perAbandono;
    }

    public void setPerAbandono(String perAbandono) {
        this.perAbandono = perAbandono;
    }

    public String getPerCura() {
        return this.perCura;
    }

    public void setPerCura(String perCura) {
        this.perCura = perCura;
    }

    public String getTransfOutroPais() {
        return this.transfOutroPais;
    }

    public void setTransfOutroPais(String transfOutroPais) {
        this.transfOutroPais = transfOutroPais;
    }

    public String getObitoPorTuberculose() {
        return this.obitoPorTuberculose;
    }

    public void setObitoPorTuberculose(String obito) {
        this.obitoPorTuberculose = obito;
    }

    public String getObitoComTuberculose() {
        return this.obitoComTuberculose;
    }

    public void setObitoComTuberculose(String obito) {
        this.obitoComTuberculose = obito;
    }

    public String getOutraCategoria() {
        return this.outraCategoria;
    }

    public void setOutraCategoria(String outraCategoria) {
        this.outraCategoria = outraCategoria;
    }

    public boolean isSituacaoEncerramento() {
        return this.situacaoEncerramento;
    }

    public void setSituacaoEncerramento(boolean situacaoEncerramento) {
        this.situacaoEncerramento = situacaoEncerramento;
    }
}

