/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.ColunasDbf;
import com.org.negocio.Configuracao;
import com.org.negocio.Util;
import com.org.util.SinanUtil;
import com.org.view.Master;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;

public class ViolenciaAgravo
extends Agravo {
    static String ANO;
    private final int BRANCO = 1;
    private final int PRETA = 2;
    private final int AMARELO = 3;
    private final int PARDO = 4;
    private final int INDIGENA = 5;
    private boolean porRegiao;
    private boolean porRegional;
    private boolean semMunicipio;

    public ViolenciaAgravo(boolean isDbf) {
        this.setDBF(isDbf);
        this.setPeriodo("de Diagn\u00f3stico");
        this.setTipoAgregacao("de Resid\u00eancia");
        this.init("postgres");
    }

    @Override
    public void init(String tipoBanco) {
        this.setArquivo("VIOLENET");
        this.setTextoCompletitude("");
        this.setMultiplicador(100);
        this.setTipo("");
        this.setTipo("populacao");
        this.setTitulo1("Propor\u00e7\u00e3o de notifica\u00e7\u00f5es de viol\u00eancia interpessoal e autoprovocada com o campo ra\u00e7a/cor preenchido com informa\u00e7\u00e3o v\u00e1lida.");
        this.setTituloColuna("Indicador");
        this.setRodape("Indicador: N\u00ba de casos de violencia registrados em  determinado ano, por local de resid\u00eancia  \n");
        this.setSqlNumeradorCompletitude("");
        if (!this.isDBF()) {
            this.setSqlNumeradorMunicipioEspecifico("select count(*) as numerador from dbsinan.tb_notificacao as t1, dbsinan.tb_investiga_aids_crianca as t2 where  t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao and nu_idade < 4005 and tp_criterio_definicao not in (900,901) and (t1.dt_diagnostico_sintoma BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and t1.co_municipio_residencia = ?");
            this.setSqlDenominadorMunicipioEspecifico("select nu_pop1a4anos+nu_pop1ano as denominador from dblocalidade.tb_estatistica_ibge where co_uf_municipio_ibge = ? and nu_ano = ?");
            this.setSqlNumeradorEstado("select count(*) as numerador from dbsinan.tb_notificacao as t1, dbsinan.tb_investiga_aids_crianca as t2 where  t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao and nu_idade < 4005 and tp_criterio_definicao not in (900,901) and (t1.dt_diagnostico_sintoma BETWEEN ?  AND ?) and t1.co_uf_residencia= ? ");
            this.setSqlDenominandorEstado(this.getSqlDenominadorMunicipioEspecifico());
            this.setSqlNumeradorBeanMunicipios(this.getSqlNumeradorMunicipioEspecifico());
            this.setSqlDenominadorBeanMunicipios(this.getSqlDenominadorMunicipioEspecifico());
        }
    }

    private void setStatusBarra(int indexDoRegistroEmLeitura, double TotalRegistros) {
        float percentual = Float.parseFloat(String.valueOf(indexDoRegistroEmLeitura)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
        this.getBarraStatus().setValue((int)percentual);
    }

    /*
     * WARNING - void declaration
     */
    private void calculaRegiao(DBFReader reader, Map parametros) {
        try {
            void var31_30;
            HashMap<Object, Object> regiaoBeans = new HashMap();
            DBFUtil utilDbf = new DBFUtil();
            String ufResidencia = (String)parametros.get("parUf");
            String sgUfResidencia = (String)parametros.get("parSgUf");
            String codRegional = (String)parametros.get("parCodRegional");
            String codRegiao = (String)parametros.get("parCodRegiaoSaude");
            HashMap<Object, Object> municipioBeans = new HashMap();
            Agravo municipioResidencia = null;
            DecimalFormat df = new DecimalFormat("0.00");
            boolean completitude = false;
            int numeradorMunicipio = 0;
            int denominadorMunicipio = 0;
            boolean denominadorBrasil = false;
            int raca = 0;
            int numeradorEstadual = 0;
            int denominadorRegiao = 0;
            Agravo regNotificacao = null;
            String dataInicio = (String)parametros.get("parDataInicio");
            String dataFim = (String)parametros.get("parDataFim");
            String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
            String arquivoExportacao = "";
            if (codRegional == null) {
                codRegional = "";
            }
            if (codRegiao == null) {
                codRegiao = "";
            }
            String idMunicipio = parametros.get("parMunicipio") != null ? (parametros.get("parMunicipio").toString().isEmpty() ? "TODOS" : (String)parametros.get("parMunicipio")) : "TODOS";
            if (((Boolean)parametros.get("parIsRegiao")).booleanValue()) {
                regiaoBeans = this.populaRegiaoBeans(sgUfResidencia, codRegiao);
                municipioBeans = this.populaMunicipiosBeansMAL(sgUfResidencia, codRegiao, idMunicipio, parametros.get("parIsRegiao").toString());
            } else {
                regiaoBeans = this.populaRegionalBeans(sgUfResidencia, codRegional);
                municipioBeans = this.populaMunicipiosBeansMAL(sgUfResidencia, codRegional, idMunicipio, parametros.get("parIsRegiao").toString());
            }
            arquivoExportacao = "NU_NOTIFIC;SG_UF_NOT;ID_MUNICIP;NM_MUNICIP;REG;DT_NOTIFIC;CS_RACA\n";
            String[] stringArray = arquivos;
            int n = stringArray.length;
            boolean bl = false;
            while (var31_30 < n) {
                String arquivo = stringArray[var31_30];
                int indexDoRegistroEmLeitura = 1;
                try {
                    Object[] rowObjects;
                    reader = Util.retornaObjetoDbfCaminhoArquivo(arquivo.substring(0, arquivo.length() - 4), Configuracao.getPropriedade("caminho"));
                    utilDbf.mapearPosicoes(reader);
                    double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                    while ((rowObjects = reader.nextRecord()) != null) {
                        String sgUfNot = utilDbf.getString(rowObjects, "SG_UF_NOT");
                        String nomeMunicipio = "";
                        if (sgUfNot != null) {
                            String nuNotific = utilDbf.getString(rowObjects, "NU_NOTIFIC");
                            String idMunicip = utilDbf.getString(rowObjects, "ID_MUNICIP");
                            municipioResidencia = (Agravo)municipioBeans.get(idMunicip);
                            String string = nomeMunicipio = municipioResidencia != null ? municipioResidencia.getNomeMunicipio() : "";
                            if (((Boolean)parametros.get("parIsRegiao")).booleanValue()) {
                                if (municipioResidencia != null) {
                                    regNotificacao = (Agravo)regiaoBeans.get(municipioResidencia.getCodRegiaoSaude());
                                }
                            } else if (municipioResidencia != null) {
                                regNotificacao = (Agravo)regiaoBeans.get(municipioResidencia.getCodRegional());
                            }
                            Date dataNotificacao = utilDbf.getDate(rowObjects, "DT_NOTIFIC");
                            String racaCor = utilDbf.getString(rowObjects, "CS_RACA", 1);
                            int n2 = raca = racaCor != null ? Integer.parseInt(racaCor) : 0;
                            if ((ufResidencia.equals(sgUfNot) || ufResidencia.equals("TODOS") || ufResidencia.equals("TODAS") || ufResidencia.equalsIgnoreCase("Brasil")) && regNotificacao != null && this.isBetweenDates(dataNotificacao, dataInicio, dataFim)) {
                                if (raca >= 1 && raca <= 5) {
                                    numeradorMunicipio = Integer.parseInt(regNotificacao.getNumerador());
                                    regNotificacao.setNumerador(String.valueOf(++numeradorMunicipio));
                                    regNotificacao.setNumeradorInt(numeradorMunicipio);
                                    ++numeradorEstadual;
                                }
                                denominadorMunicipio = Integer.parseInt(regNotificacao.getDenominador());
                                ++denominadorRegiao;
                                regNotificacao.setTaxa("0");
                                regNotificacao.setDenominador(String.valueOf(++denominadorMunicipio));
                                regNotificacao.setDenominadorInt(denominadorMunicipio);
                                this.calcularTaxaIndividual(df, regNotificacao);
                            }
                        }
                        this.setStatusBarra(indexDoRegistroEmLeitura, TotalRegistros);
                        ++indexDoRegistroEmLeitura;
                    }
                }
                catch (DBFException ex) {
                    Master.mensagem("Erro:\n" + (Object)((Object)ex));
                }
                ++var31_30;
            }
            this.setTaxaEstadual("");
            this.setBeans(new ArrayList());
            Collection<Object> municipioBean = regiaoBeans.values();
            for (Agravo agravo : municipioBean) {
                if (null == agravo.getTaxa()) {
                    agravo.setTaxa("0");
                }
                this.getBeans().add(agravo);
                this.getBarraStatus().setString("Calculando indicador para: " + agravo.getNomeMunicipio());
            }
            this.getBarraStatus().setString(null);
            ComparatorChain chain = new ComparatorChain(Arrays.asList(new BeanComparator("uf"), new BeanComparator("nomeMunicipio")));
            Collections.sort(this.getBeans(), chain);
            Agravo agravo = new Agravo();
            if (((Boolean)parametros.get("parIsRegiao")).booleanValue()) {
                Agravo agravo2 = this.adicionaTotal(municipioBean, codRegiao);
                this.adicionaParamentrosTotais(parametros, agravo2);
            } else {
                Agravo agravo3 = this.adicionaTotal(municipioBean, codRegional);
                this.adicionaParamentrosTotais(parametros, agravo3);
            }
            Agravo finalAgravo = new Agravo();
            finalAgravo.setNomeMunicipio("TOTAL");
            this.getBeans().add(finalAgravo);
            this.setParametroRegiaoOuRegional(parametros);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
    }

    private Agravo getMunicipioPelaRegiaoOuRegional(Map parametros, HashMap<String, Agravo> municipiosBeans, DBFUtil utilDbf, Object[] rowObjects) {
        Agravo municipioResidencia = new Agravo();
        try {
            municipioResidencia = ((Boolean)parametros.get("parIsRegiao")).booleanValue() ? municipiosBeans.get(this.buscaIdRegiaoSaude(utilDbf.getString(rowObjects, "ID_MUNICIP"))) : municipiosBeans.get(this.buscaIdRegionalSaude(utilDbf.getString(rowObjects, "ID_MUNICIP")));
        }
        catch (SQLException ex) {
            Logger.getLogger(ViolenciaAgravo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return municipioResidencia;
    }

    /*
     * WARNING - void declaration
     */
    private void calculaMunicipios(DBFReader reader, Map parametros) {
        try {
            void var29_27;
            String[] arquivos;
            HashMap<Object, Object> municipiosBeans = new HashMap();
            String ufResidencia = (String)parametros.get("parUf");
            String sgUfResidencia = (String)parametros.get("parSgUf");
            String codRegional = (String)parametros.get("parCodRegional");
            String codRegiao = (String)parametros.get("parCodRegiaoSaude");
            DBFUtil utilDbf = new DBFUtil();
            if (codRegiao == null) {
                codRegiao = "";
            }
            if (codRegional == null) {
                codRegional = "";
            }
            String idMunicipio = parametros.get("parMunicipio") != null ? (String)parametros.get("parMunicipio") : "TODOS";
            municipiosBeans = parametros.get("parDesagregacao").equals("Somente munic\u00edpios") ? this.populaMunicipiosBeansMAL(sgUfResidencia, "", idMunicipio, "false") : ((Boolean)parametros.get("parIsRegiao") != false ? this.populaMunicipiosBeansMAL(sgUfResidencia, codRegiao, idMunicipio, parametros.get("parIsRegiao").toString()) : this.populaMunicipiosBeansMAL(sgUfResidencia, codRegional, idMunicipio, parametros.get("parIsRegiao").toString()));
            DecimalFormat df = new DecimalFormat("0");
            DecimalFormat df2 = new DecimalFormat("0.00");
            int numerador = 0;
            boolean numeradorEstadual = false;
            boolean denominadorEstadual = false;
            int denominadorMunicipal = 0;
            int raca = 0;
            boolean completitude = false;
            String dataInicio = (String)parametros.get("parDataInicio");
            String ano = dataInicio.substring(0, 4);
            String dataFim = (String)parametros.get("parDataFim");
            String[] stringArray = arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
            int n = stringArray.length;
            boolean bl = false;
            while (var29_27 < n) {
                String arquivo = stringArray[var29_27];
                int indexDoRegistroEmLeitura = 1;
                try {
                    Object[] rowObjects;
                    reader = Util.retornaObjetoDbfCaminhoArquivo(arquivo.substring(0, arquivo.length() - 4), Configuracao.getPropriedade("caminho"));
                    utilDbf.mapearPosicoes(reader);
                    double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                    while ((rowObjects = reader.nextRecord()) != null) {
                        if (utilDbf.getString(rowObjects, "SG_UF_NOT") != null) {
                            Agravo municipioResidencia = (Agravo)municipiosBeans.get(utilDbf.getString(rowObjects, "ID_MUNICIP"));
                            Date dataNotificacao = utilDbf.getDate(rowObjects, "DT_NOTIFIC");
                            String racaCor = utilDbf.getString(rowObjects, "CS_RACA", 1);
                            int n2 = raca = racaCor != null ? Integer.parseInt(racaCor) : 0;
                            if (municipioResidencia != null && raca >= 0 && this.isBetweenDates(dataNotificacao, dataInicio, dataFim)) {
                                if (raca >= 1 && raca <= 5) {
                                    numerador = Integer.parseInt(municipioResidencia.getNumerador());
                                    municipioResidencia.setNumerador(String.valueOf(++numerador));
                                    municipioResidencia.setNumeradorInt(numerador);
                                }
                                denominadorMunicipal = Integer.parseInt(municipioResidencia.getDenominador());
                                municipioResidencia.setDenominador(String.valueOf(++denominadorMunicipal));
                                municipioResidencia.setDenominadorInt(denominadorMunicipal);
                                municipioResidencia.setTaxa("0");
                                municipioResidencia.setTaxa(this.calcularTaxaIndividual(df2, municipioResidencia));
                            }
                        }
                        this.setStatusBarra(indexDoRegistroEmLeitura, TotalRegistros);
                        ++indexDoRegistroEmLeitura;
                    }
                }
                catch (DBFException ex) {
                    Master.mensagem("Erro:\n" + (Object)((Object)ex));
                }
                ++var29_27;
            }
            this.setBeans(new ArrayList());
            Collection<Object> municipioBean = municipiosBeans.values();
            for (Agravo agravo : municipioBean) {
                if (null == agravo.getTaxa()) {
                    agravo.setTaxa("0");
                }
                this.getBeans().add(agravo);
                this.getBarraStatus().setString("Calculando indicador para: " + agravo.getNomeMunicipio());
            }
            this.getBarraStatus().setString(null);
            ComparatorChain chain = parametros.get("parDesagregacao").equals("Somente munic\u00edpios") ? new ComparatorChain(Arrays.asList(new BeanComparator("uf"), new BeanComparator("nomeMunicipio"))) : ((Boolean)parametros.get("parIsRegiao") != false ? new ComparatorChain(Arrays.asList(new BeanComparator("uf"), new BeanComparator("regiaoSaude"), new BeanComparator("nomeMunicipio"))) : new ComparatorChain(Arrays.asList(new BeanComparator("uf"), new BeanComparator("regional"), new BeanComparator("nomeMunicipio"))));
            Collections.sort(this.getBeans(), chain);
            Agravo agravo = new Agravo();
            if (((Boolean)parametros.get("parIsRegiao")).booleanValue()) {
                Agravo agravo2 = this.adicionaTotal(municipioBean, codRegiao);
                this.adicionaParamentrosTotais(parametros, agravo2);
            } else {
                Agravo agravo3 = this.adicionaTotal(municipioBean, codRegional);
                this.adicionaParamentrosTotais(parametros, agravo3);
            }
            Agravo finalAgravo = new Agravo();
            finalAgravo.setNomeMunicipio("TOTAL");
            this.getBeans().add(finalAgravo);
            this.setParametroRegiaoOuRegional(parametros);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
    }

    private void setParametroRegiaoOuRegional(Map parametros) {
        if (((Boolean)parametros.get("parIsRegiao")).booleanValue()) {
            parametros.put("parDescricaoRegional", "Regi\u00e3o de notifica\u00e7\u00e3o:");
        } else if (((Boolean)parametros.get("parIsRegional")).booleanValue()) {
            parametros.put("parDescricaoRegional", "Regional de notifica\u00e7\u00e3o:");
        } else {
            parametros.put("parDescricaoRegional", "");
        }
    }

    private void adicionaParamentrosTotais(Map parametros, Agravo totalAgravo) {
        DecimalFormat df = new DecimalFormat("0.00");
        parametros.put("numeradorTotal", totalAgravo.getNumerador());
        parametros.put("denominadorTotal", totalAgravo.getDenominador());
        Double numerador = Double.parseDouble(totalAgravo.getNumerador());
        Double denominador = Double.parseDouble(totalAgravo.getDenominador());
        double taxa = numerador == 0.0 && denominador == 0.0 ? 0.0 : Double.parseDouble(totalAgravo.getNumerador()) / Double.parseDouble(totalAgravo.getDenominador()) * 100.0;
        parametros.put("taxaTotal", df.format(taxa));
    }

    private Agravo calcularTaxaTotal(DecimalFormat df) {
        Agravo agravo = (Agravo)this.getBeans().get(this.getBeans().size() - 1);
        if (null != agravo.getNumerador() && Double.parseDouble(agravo.getNumerador()) != 0.0 && null != agravo.getDenominador() && Double.parseDouble(agravo.getDenominador()) != 0.0) {
            agravo.setTaxa(df.format(Double.parseDouble(agravo.getNumerador()) / Double.parseDouble(agravo.getDenominador()) * 100.0));
        } else {
            agravo.setTaxa("0");
        }
        return agravo;
    }

    private String calcularTaxaIndividual(DecimalFormat df, Agravo municipioResidencia) {
        if (null != municipioResidencia.getNumerador() && Double.parseDouble(municipioResidencia.getNumerador()) != 0.0 && null != municipioResidencia.getDenominador() && Double.parseDouble(municipioResidencia.getDenominador()) != 0.0) {
            municipioResidencia.setTaxa(df.format(Double.parseDouble(municipioResidencia.getNumerador()) / Double.parseDouble(municipioResidencia.getDenominador()) * 100.0));
        } else {
            municipioResidencia.setTaxa("0");
        }
        return municipioResidencia.getTaxa();
    }

    @Override
    public void calcula(DBFReader reader, Map parametros) {
        boolean estadoEMunicipio;
        String municipios = (String)parametros.get("municipios");
        String municipioEspecifico = (String)parametros.get("municipioEspecifico");
        String filtroUF = (String)parametros.get("parUf");
        boolean isRegiaoSelecionada = (Boolean)parametros.get("parIsRegiao");
        boolean isRegionalSelecionada = (Boolean)parametros.get("parIsRegional");
        boolean bl = estadoEMunicipio = municipios.equals("sim") && !filtroUF.equals("brasil");
        if (isRegiaoSelecionada) {
            this.setPorRegiao(true);
        }
        if (isRegionalSelecionada) {
            this.setPorRegional(true);
        }
        if ((isRegionalSelecionada || isRegiaoSelecionada) && municipioEspecifico == "NENHUM") {
            this.setSemMunicipio(true);
            this.calculaRegiao(reader, parametros);
        } else if (municipios.equals("sim")) {
            this.calculaMunicipios(reader, parametros);
        } else {
            this.calculaMunicipioIndividual(municipios, filtroUF, reader, parametros);
        }
    }

    private void calculaMunicipioIndividual(String municipios, String filtroUF, DBFReader reader, Map parametros) {
        try {
            String total;
            DBFUtil utilDbf = new DBFUtil();
            DecimalFormat df = new DecimalFormat("0.00");
            int denominadorEstadual = 0;
            int numeradorEstadual = 0;
            int denominadorEspecifico = 0;
            int numeradorEspecifico = 0;
            int raca = 0;
            boolean completitude = false;
            String racaCor = "";
            String ufResidencia = (String)parametros.get("parUf");
            String municipioResidencia = (String)parametros.get("parMunicipio");
            String dataInicio = (String)parametros.get("parDataInicio");
            String dataFim = (String)parametros.get("parDataFim");
            String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
            String regiao = "";
            if (municipioResidencia == null) {
                municipioResidencia = "";
            }
            for (String arquivo : arquivos) {
                Object[] rowObjects;
                int indexDoRegistroEmLeitura = 1;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivo.substring(0, arquivo.length() - 4), Configuracao.getPropriedade("caminho"));
                utilDbf.mapearPosicoes(reader);
                double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (utilDbf.getString(rowObjects, "SG_UF_NOT") != null && utilDbf.getString(rowObjects, "SG_UF_NOT").equals(ufResidencia)) {
                        Date dtNotificacao = utilDbf.getDate(rowObjects, "DT_NOTIFIC");
                        racaCor = utilDbf.getString(rowObjects, "CS_RACA", 1);
                        int n = raca = racaCor != null ? Integer.parseInt(racaCor) : 0;
                        if (this.verificaMunicipio(municipioResidencia, utilDbf.getString(rowObjects, "ID_MUNICIP"))) {
                            if (this.isBetweenDates(dtNotificacao, dataInicio, dataFim)) {
                                ++denominadorEspecifico;
                                ++denominadorEstadual;
                                if (raca >= 1 && raca <= 5) {
                                    ++numeradorEspecifico;
                                    ++numeradorEstadual;
                                }
                            }
                        } else if (this.isBetweenDates(dtNotificacao, dataInicio, dataFim)) {
                            ++denominadorEstadual;
                            if (raca >= 1 && raca <= 5) {
                                ++numeradorEstadual;
                            }
                        }
                    }
                    this.setStatusBarra(indexDoRegistroEmLeitura, TotalRegistros);
                    ++indexDoRegistroEmLeitura;
                }
            }
            Agravo violenciaMunicipio = new Agravo();
            violenciaMunicipio.setCodMunicipio((String)parametros.get("parMunicipio"));
            violenciaMunicipio.setUf((String)parametros.get("parSgUf"));
            if (municipioResidencia.equals("")) {
                total = "";
                violenciaMunicipio.setNomeMunicipio((String)parametros.get("parSgUf"));
                violenciaMunicipio.setCodMunicipio(ufResidencia);
                this.preencheResultadoDaBusca(violenciaMunicipio, numeradorEstadual, denominadorEstadual, total, df);
            } else {
                violenciaMunicipio.setNomeMunicipio((String)parametros.get("parNomeMunicipio"));
                violenciaMunicipio.setCodMunicipio(municipioResidencia);
            }
            if (!String.valueOf(denominadorEspecifico).equals("0.0")) {
                total = "";
                this.preencheResultadoDaBusca(violenciaMunicipio, numeradorEspecifico, denominadorEspecifico, total, df);
            } else {
                violenciaMunicipio.setNumerador("0");
                violenciaMunicipio.setNumeradorInt(0);
                violenciaMunicipio.setDenominador("0");
                violenciaMunicipio.setDenominadorInt(0);
                violenciaMunicipio.setTaxa("0.00");
            }
            this.setBeans(new ArrayList());
            this.getBeans().add(violenciaMunicipio);
            this.setParametroRegiaoOuRegional(parametros);
        }
        catch (DBFException | NumberFormatException | ParseException ex) {
            ex.printStackTrace();
        }
    }

    private void preencheResultadoDaBusca(Agravo violenciaMunicipio, int numerador, int denominador, String total, DecimalFormat df) {
        violenciaMunicipio.setNumerador(String.valueOf(NumberFormat.getNumberInstance().format(Double.parseDouble(String.valueOf(numerador)))));
        violenciaMunicipio.setNumeradorInt(numerador);
        violenciaMunicipio.setDenominador(String.valueOf(NumberFormat.getNumberInstance().format(Double.parseDouble(String.valueOf(denominador)))));
        violenciaMunicipio.setDenominadorInt(denominador);
        total = df.format(Double.parseDouble(String.valueOf(numerador)) / Double.parseDouble(String.valueOf(denominador)) * 100.0);
        violenciaMunicipio.setTaxa(total);
    }

    @Override
    public Map getParametros() {
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parDataInicio", Util.formataData(this.getDataInicio()));
        parametros.put("parDataFim", Util.formataData(this.getDataFim()));
        parametros.put("parPeriodo", "de " + this.getDataInicio() + " a " + this.getDataFim());
        parametros.put("parTituloColuna", this.getTituloColuna());
        parametros.put("parFator", String.valueOf(this.getMultiplicador()));
        parametros.put("parAno", Util.getAno(this.getDataFim()));
        parametros.put("parRodape", this.getRodape());
        parametros.put("parConfig", "");
        parametros.put("parTitulo1", "Propor\u00e7\u00e3o de notifica\u00e7\u00f5es de viol\u00eancia interpessoal e autoprovocada com o campo ra\u00e7a/cor preenchido com informa\u00e7\u00e3o v\u00e1lida.");
        ANO = "";
        if (Util.getAno(this.getDataFim()).equals(Util.getAno(this.getDataInicio()))) {
            ANO = Util.getAno(this.getDataFim());
        }
        this.setDataInicio(this.getDataInicio());
        this.setDataFim(this.getDataFim());
        return parametros;
    }

    @Override
    public String[] getOrdemColunas() {
        if (this.isPorRegiao()) {
            return new String[]{"ID_LOCNOT", "DS_LOCNOT", "ID_UFNOT", "NOME_CIR", "COD_CIR", "N_RACA", "D_RACATO", "P_RACPRE", "ANO_NOTI", "DT_NOTIN", "DT_NOTIFI", "ORIGEM"};
        }
        if (this.isPorRegional()) {
            return new String[]{"ID_LOCNOT", "DS_LOCNOT", "ID_UFNOT", "REGIONAL", "ID_REGION", "N_RACA", "D_RACATO", "P_RACPRE", "ANO_NOTI", "DT_NOTIN", "DT_NOTIFI", "ORIGEM"};
        }
        return new String[]{"ID_LOCNOT", "DS_LOCNOT", "ID_UFNOT", "N_RACA", "D_RACATO", "P_RACPRE", "ANO_NOTI", "DT_NOTIN", "DT_NOTIFI", "ORIGEM"};
    }

    @Override
    public HashMap<String, ColunasDbf> getColunas() {
        HashMap<String, ColunasDbf> hashColunas = new HashMap<String, ColunasDbf>();
        hashColunas.put("ID_LOCNOT", new ColunasDbf(7));
        hashColunas.put("DS_LOCNOT", new ColunasDbf(30));
        hashColunas.put("ID_UFNOT", new ColunasDbf(2));
        if (this.isPorRegiao()) {
            hashColunas.put("NOME_CIR", new ColunasDbf(30));
            hashColunas.put("COD_CIR", new ColunasDbf(7));
        } else if (this.isPorRegional()) {
            hashColunas.put("REGIONAL", new ColunasDbf(30));
            hashColunas.put("ID_REGION", new ColunasDbf(7));
        }
        hashColunas.put("N_RACA", new ColunasDbf(10));
        hashColunas.put("D_RACATO", new ColunasDbf(10));
        hashColunas.put("P_RACPRE", new ColunasDbf(10));
        hashColunas.put("ANO_NOTI", new ColunasDbf(4));
        hashColunas.put("DT_NOTIN", new ColunasDbf(10));
        hashColunas.put("DT_NOTIFI", new ColunasDbf(10));
        hashColunas.put("ORIGEM", new ColunasDbf(10));
        this.setColunas(hashColunas);
        return hashColunas;
    }

    @Override
    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        Integer numeradorTotal = 0;
        Integer denominadorTotal = 0;
        Double taxaTotal = 0.0;
        String taxaFormatada = "";
        DecimalFormat df = new DecimalFormat("0.00");
        for (int i = 0; i < bean.size(); ++i) {
            Object[] rowData = new Object[colunas.size()];
            Agravo agravo = (Agravo)bean.get(i);
            numeradorTotal = numeradorTotal + agravo.getNumeradorInt();
            denominadorTotal = denominadorTotal + agravo.getDenominadorInt();
            if (i == bean.size() - 1) {
                taxaTotal = Double.parseDouble(numeradorTotal.toString()) / (double)denominadorTotal.intValue() * 100.0;
                taxaFormatada = df.format(taxaTotal);
            }
            rowData = this.preencherCamposDbf(agravo, rowData, numeradorTotal, denominadorTotal, taxaFormatada);
            writer.addRecord(rowData);
        }
        return writer;
    }

    private Object[] preencherCamposDbf(Agravo agravo, Object[] rowData, Integer numeradorTotal, Integer denominadorTotal, String taxaFormatada) {
        if (this.isPorRegiao() || this.isPorRegional()) {
            if (agravo.getNomeMunicipio().equals("BRASIL") || agravo.getNomeMunicipio().equals("TOTAL")) {
                rowData[0] = null;
                rowData[2] = null;
                rowData[5] = numeradorTotal.toString();
                rowData[6] = denominadorTotal.toString();
                rowData[7] = taxaFormatada.replace(",", ".");
            } else {
                rowData[0] = agravo.getCodMunicipio();
                rowData[2] = agravo.getCodMunicipio().substring(0, 2);
                if (this.isPorRegional()) {
                    rowData[2] = SinanUtil.siglaUFToIDUF(agravo.getUf());
                    rowData[3] = agravo.getRegional();
                    rowData[4] = agravo.getCodRegional();
                } else if (this.isPorRegiao()) {
                    rowData[3] = agravo.getRegiaoSaude();
                    rowData[4] = agravo.getCodRegiaoSaude();
                }
                rowData[5] = agravo.getNumerador();
                rowData[6] = agravo.getDenominador();
                rowData[7] = agravo.getTaxa();
            }
            rowData[1] = agravo.getNomeMunicipio();
            rowData[8] = String.valueOf(this.preencheAno(this.getDataInicio(), this.getDataFim()));
            rowData[9] = this.getDataInicio();
            rowData[10] = this.getDataFim();
            rowData[11] = "VIOLENET";
            return rowData;
        }
        if (agravo.getNomeMunicipio().equals("BRASIL") || agravo.getNomeMunicipio().equals("TOTAL")) {
            rowData[0] = null;
            rowData[2] = null;
            rowData[3] = numeradorTotal.toString();
            rowData[4] = denominadorTotal.toString();
            rowData[5] = taxaFormatada.replace(",", ".");
        } else {
            rowData[0] = agravo.getCodMunicipio();
            rowData[2] = agravo.getCodMunicipio().substring(0, 2);
            rowData[3] = agravo.getNumerador();
            rowData[4] = agravo.getDenominador();
            rowData[5] = agravo.getTaxa();
        }
        rowData[1] = agravo.getNomeMunicipio();
        rowData[6] = String.valueOf(this.preencheAno(this.getDataInicio(), this.getDataFim()));
        rowData[7] = this.getDataInicio();
        rowData[8] = this.getDataFim();
        rowData[9] = "VIOLENET";
        return rowData;
    }

    @Override
    public String getCaminhoJasper() {
        return "/com/org/relatorios/ViolenciaPactuacao.jasper";
    }

    public boolean isPorRegiao() {
        return this.porRegiao;
    }

    public void setPorRegiao(boolean porRegiao) {
        this.porRegiao = porRegiao;
    }

    public boolean isPorRegional() {
        return this.porRegional;
    }

    public void setPorRegional(boolean porRegional) {
        this.porRegional = porRegional;
    }

    public boolean isSemMunicipio() {
        return this.semMunicipio;
    }

    public void setSemMunicipio(boolean semMunicipio) {
        this.semMunicipio = semMunicipio;
    }
}

