/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos.oportunidade;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.agravos.oportunidade.CasoOportunidade;
import com.org.model.classes.agravos.oportunidade.OportunidadeAgravo;
import com.org.negocio.Municipio;
import com.org.negocio.Util;
import com.org.view.Master;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;

public class OportunidadePQAVS
extends Agravo {
    private String sqlCalculoAgravos180dias;
    private String sqlCalculoAgravos60dias;
    private String sqlCalculoAgravosMalaria60dias;
    private String sqlCalculoAgravoEspecifico;
    private String naoEncerrado;
    private String inoportuno;
    private String oportuno;
    private String dataInvalida;
    private List<String> agravosValidos = new ArrayList<String>();
    private List<CasoOportunidade> listagemCasos = new ArrayList<CasoOportunidade>();
    private boolean temListagem = false;
    private List<Municipio> municipios = new ArrayList<Municipio>();

    @Override
    public void init(String tipoBanco) {
        if (!tipoBanco.equals("INTERBASE")) {
            this.setSqlCalculoAgravoEspecifico("select (dt_encerramento-dt_notificacao) as  diff,dt_encerramento,tp_classificacao_final,dt_notificacao,tp_classificacao_final,no_agravo as co_cid,nu_notificacao,co_cnes as co_unidade_notificacao,co_municipio_notificacao,co_municipio_notificacao,no_municipio from dbsinan.tb_notificacao as t1 inner join dbsinan.tb_agravo t2 on t1.co_cid=t2.co_cid inner join dbgeral.tb_municipio t3 on t1.co_municipio_notificacao=t3.co_municipio_ibge  inner join dblocalidade.tb_estabelecimento_saude us on t1.co_unidade_notificacao = us.co_estabelecimento  where (dt_notificacao BETWEEN ?  AND ?) and co_uf_residencia= ? and t1.co_cid = ? and(tp_duplicidade <> 2 or tp_duplicidade is null) ");
            this.setSqlCalculoAgravos180dias("select (dt_encerramento-dt_notificacao) as  diff,dt_encerramento,tp_classificacao_final,dt_notificacao,tp_classificacao_final,no_agravo as co_cid,nu_notificacao,co_cnes as co_unidade_notificacao,co_municipio_notificacao,co_municipio_notificacao,no_municipio from dbsinan.tb_notificacao as t1 inner join dbsinan.tb_agravo t2 on t1.co_cid=t2.co_cid inner join dbgeral.tb_municipio t3 on t1.co_municipio_notificacao=t3.co_municipio_ibge  inner join dblocalidade.tb_estabelecimento_saude us on t1.co_unidade_notificacao = us.co_estabelecimento  where  t1.co_cid in( 'B19','B55.1','P35.0' ) and  (dt_notificacao BETWEEN ?  AND ?) and co_uf_residencia= ? and (tp_duplicidade <> 2 or tp_duplicidade is null) ");
            this.setSqlCalculoAgravos60dias("select (dt_encerramento-dt_notificacao) as  diff,dt_encerramento,tp_classificacao_final,tp_suspeita,dt_notificacao,tp_classificacao_final,no_agravo as co_cid,nu_notificacao,co_cnes as co_unidade_notificacao,co_municipio_notificacao,co_municipio_notificacao,no_municipio from dbsinan.tb_notificacao as t1 inner join dbsinan.tb_agravo t2 on t1.co_cid=t2.co_cid inner join dbgeral.tb_municipio t3 on t1.co_municipio_notificacao=t3.co_municipio_ibge   inner join dblocalidade.tb_estabelecimento_saude us on t1.co_unidade_notificacao = us.co_estabelecimento  where  (t1.co_cid in('A35','B09','B57.1','A00.9','A37.9','A36.9','A95.9','A01.0','A27.9','A80.9','A20.9','A82.9','A33','B55.0','A98.8','A77.9','G03.9','A05.1','A77.9','A92.3') or (t1.co_cid='A90' and tp_classificacao_final in(2,3,4))) and  (dt_notificacao BETWEEN ?  AND ?) and co_uf_residencia= ? and (tp_duplicidade <> 2 or tp_duplicidade is null)");
            this.setSqlCalculoAgravosMalaria60dias("select (dt_encerramento-dt_notificacao) as  diff,dt_encerramento,tp_classificacao_final,tp_suspeita,dt_notificacao,tp_classificacao_final,no_agravo as co_cid,nu_notificacao,co_cnes as co_unidade_notificacao,co_municipio_notificacao,co_municipio_notificacao,no_municipio from dbsinan.tb_notificacao as t1 inner join dbsinan.tb_agravo t2 on t1.co_cid=t2.co_cid inner join dbgeral.tb_municipio t3 on t1.co_municipio_notificacao=t3.co_municipio_ibge   inner join dblocalidade.tb_estabelecimento_saude us on t1.co_unidade_notificacao = us.co_estabelecimento  where  (t1.co_cid in('A35','B09','B57.1','A00.9','A37.9','A36.9','A95.9','A01.0','A27.9','A80.9','A20.9','A82.9','A33','B55.0','A98.8','A77.9','G03.9','A05.1','A77.9','A92.3','B54') or (t1.co_cid='A90' and tp_classificacao_final in(2,3,4))) and  (dt_notificacao BETWEEN ?  AND ?) and co_uf_residencia= ? and (tp_duplicidade <> 2 or tp_duplicidade is null)");
        }
        this.setSqlNumeradorCompletitude("");
        this.setSqlNumeradorBeanMunicipios(this.getSqlNumeradorMunicipioEspecifico());
        this.setSqlDenominadorBeanMunicipios(this.getSqlDenominadorMunicipioEspecifico());
        this.setTextoCompletitude("");
        this.setMultiplicador(100);
        this.setTipo("Oportunidade");
        this.setTitulo1("Propor\u00e7\u00e3o de doen\u00e7as exantem\u00e1ticas investigados oportunamente");
        this.setTituloColuna("Propor\u00e7\u00e3o");
        this.setRodape("Numerador: Total de casos suspeitos de sarampo e rub\u00e9ola investigados em at\u00e9 48 horas ap\u00f3s a notifica\u00e7\u00e3o, residentes em determinado local e notificados em determinado per\u00edodo \nDenominador: Total de casos suspeitos de sarampo e rub\u00e9ola,  residentes em determinado local e notificados em determinado per\u00edodo ");
    }

    /*
     * WARNING - void declaration
     */
    private List calculaEstadoMunicipio(DBFReader reader, Map parametros) throws ParseException, DBFException {
        HashMap<Object, Object> municipiosBeans = new HashMap();
        DBFUtil utilDbf = new DBFUtil();
        CasoOportunidade casoListado = null;
        String agravoSelecionado = parametros.get("parAgravo").toString();
        Agravo agravodbf = new Agravo();
        this.iniciaAgravosValidos();
        municipiosBeans = parametros.get("parNomeMunicipio").toString().equals("Todos Munic\u00edpios") ? this.populaMunicipiosBeans(parametros.get("parSgUf").toString()) : this.populaAgravosBeans(agravoSelecionado);
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim60 = (String)parametros.get("parDataFim60");
        String dataFim180 = (String)parametros.get("parDataFim180");
        String ufResidencia = (String)parametros.get("parUf");
        String ufResidenciaDbf = "";
        String parMunicipioResidencia = (String)parametros.get("parMunicipio");
        String parMunicipioResidenciaDbf = "";
        int i = 1;
        int anoAvaliadoMalaria = Integer.parseInt(parametros.get("parDataInicio").toString().split("-")[0]);
        if (anoAvaliadoMalaria == 2008 && agravoSelecionado.equals("B54")) {
            Master.mensagem("Mal\u00e1ria est\u00e1 dispon\u00edvel a partir do ano de 2009");
            return null;
        }
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
            while ((rowObjects = reader.nextRecord()) != null) {
                if (utilDbf.getString(rowObjects, "SG_UF") != null) {
                    Date dtNotificacao = utilDbf.getDate(rowObjects, "DT_NOTIFIC");
                    Date dtEncerramento = utilDbf.getDate(rowObjects, "DT_ENCERRA");
                    String agravo = utilDbf.getString(rowObjects, "ID_AGRAVO");
                    ufResidenciaDbf = utilDbf.getString(rowObjects, "SG_UF");
                    parMunicipioResidenciaDbf = utilDbf.getString(rowObjects, "ID_MN_RESI");
                    if (agravo.equals("B09")) {
                        int suspeita = utilDbf.getInt(rowObjects, "CS_SUSPEIT");
                        agravo = suspeita == 1 ? "B091" : "B092";
                    }
                    OportunidadeAgravo municipioResidencia = parametros.get("parNomeMunicipio").toString().equals("Todos Munic\u00edpios") ? (OportunidadeAgravo)municipiosBeans.get(parMunicipioResidenciaDbf) : (OportunidadeAgravo)municipiosBeans.get(agravo);
                    boolean continuaCalculo = true;
                    if (agravoSelecionado.equals("TODOS") && anoAvaliadoMalaria == 2008 && agravo.equals("B54")) {
                        continuaCalculo = false;
                    }
                    if (ufResidenciaDbf == null) {
                        continuaCalculo = false;
                    } else if (!ufResidencia.equals(ufResidenciaDbf)) {
                        continuaCalculo = false;
                    }
                    if (parMunicipioResidencia != null) {
                        if (parMunicipioResidenciaDbf == null) {
                            continuaCalculo = false;
                        } else if (!parMunicipioResidencia.equals(parMunicipioResidenciaDbf)) {
                            continuaCalculo = false;
                        }
                    }
                    if (agravo.equals("A90")) {
                        String string = utilDbf.getString(rowObjects, "EVOLUCAO", 1);
                        if (string == null) {
                            continuaCalculo = false;
                        } else {
                            int cf = Integer.parseInt(string);
                            if (cf < 2 || cf > 4) {
                                continuaCalculo = false;
                            }
                        }
                    }
                    if (municipioResidencia != null && this.verificaAgravoOportuno(agravo) && continuaCalculo) {
                        void var25_31;
                        String string = dataFim60;
                        if (agravo.equals("B19") || agravo.equals("P350") || agravo.equals("B551")) {
                            String string2 = dataFim180;
                        }
                        if (agravodbf.isBetweenDates(dtNotificacao, dataInicio, (String)var25_31)) {
                            casoListado = new CasoOportunidade();
                            if (dtEncerramento == null) {
                                if (this.temListagem) {
                                    casoListado.setAgravo(this.buscaNomeAgravo(agravo));
                                    casoListado.setDtNotificacao(this.formataData(dtNotificacao.toString()));
                                    casoListado.setIdUnidade(utilDbf.getString(rowObjects, "ID_UNIDADE"));
                                    casoListado.setNumNotificacao(utilDbf.getString(rowObjects, "NU_NOTIFIC"));
                                    casoListado.setIdMunicipio(utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                    String nomeMunicipio = this.retornaNome(utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                    if (nomeMunicipio.equals("")) {
                                        Municipio municipioNovo = new Municipio();
                                        municipioNovo.setCodMunicipio(utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                        municipioNovo.setNmMunicipio(agravodbf.getNomeMunicipio(utilDbf.getString(rowObjects, "ID_MUNICIP")));
                                        casoListado.setNmMunicipio(municipioNovo.getNmMunicipio());
                                        this.getMunicipios().add(municipioNovo);
                                    } else {
                                        casoListado.setNmMunicipio(nomeMunicipio);
                                    }
                                    casoListado.setSituacao("N\u00e3o Encerrado");
                                    this.getListagemCasos().add(casoListado);
                                }
                                municipioResidencia.setQtdNaoEncerrado(municipioResidencia.getQtdNaoEncerrado() + 1);
                                municipioResidencia.setTotal(municipioResidencia.getTotal() + 1);
                            } else {
                                int diferenca = OportunidadePQAVS.dataDiff(dtNotificacao, dtEncerramento);
                                int diferencaOportuna = this.retornaDiferenca(agravo);
                                String situacao = this.classificaNotificacao(diferenca, diferencaOportuna, municipioResidencia, utilDbf.getInt(rowObjects, "CLASSI_FIN"));
                                if (this.temListagem && !situacao.equals("Oportuno") && !situacao.equals("Inoportuno com outras categorias")) {
                                    casoListado.setAgravo(this.buscaNomeAgravo(agravo));
                                    casoListado.setDtNotificacao(this.formataData(dtNotificacao.toString()));
                                    casoListado.setIdUnidade(utilDbf.getString(rowObjects, "ID_UNIDADE"));
                                    casoListado.setNumNotificacao(utilDbf.getString(rowObjects, "NU_NOTIFIC"));
                                    casoListado.setIdMunicipio(utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                    String nomeMunicipio = this.retornaNome(utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                    if (nomeMunicipio.equals("")) {
                                        Municipio municipioNovo = new Municipio();
                                        municipioNovo.setCodMunicipio(utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                        municipioNovo.setNmMunicipio(agravodbf.getNomeMunicipio(utilDbf.getString(rowObjects, "ID_MUNICIP")));
                                        casoListado.setNmMunicipio(municipioNovo.getNmMunicipio());
                                        this.getMunicipios().add(municipioNovo);
                                    } else {
                                        casoListado.setNmMunicipio(nomeMunicipio);
                                    }
                                    casoListado.setSituacao(situacao);
                                    this.getListagemCasos().add(casoListado);
                                }
                            }
                        }
                    }
                }
                this.getLabel().setText("Registros: " + i + " de " + TotalRegistros);
                ++i;
            }
        }
        catch (DBFException ex) {
            Master.mensagem("Erro:\n" + (Object)((Object)ex));
        }
        ArrayList<OportunidadeAgravo> beans = new ArrayList<OportunidadeAgravo>();
        Collection<Object> municipioBean = municipiosBeans.values();
        for (OportunidadeAgravo oportunidadeAgravo : municipioBean) {
            if (oportunidadeAgravo.getTotal() <= 0) continue;
            beans.add(oportunidadeAgravo);
        }
        Collections.sort(beans, new BeanComparator("nmAgravo"));
        Collections.sort(this.getListagemCasos(), new BeanComparator("situacao"));
        Collections.sort(this.getListagemCasos(), new BeanComparator("nmMunicipio"));
        OportunidadeAgravo agravoBean = new OportunidadeAgravo();
        agravoBean.setNmAgravo("TOTAL");
        for (i = 0; i < beans.size(); ++i) {
            agravoBean.setQtdOportuno(((OportunidadeAgravo)beans.get(i)).getQtdOportuno() + agravoBean.getQtdOportuno());
            agravoBean.setQtdInoportuno(((OportunidadeAgravo)beans.get(i)).getQtdInoportuno() + agravoBean.getQtdInoportuno());
            agravoBean.setQtdInoportunoOutras(((OportunidadeAgravo)beans.get(i)).getQtdInoportunoOutras() + agravoBean.getQtdInoportunoOutras());
            agravoBean.setQtdNaoEncerrado(((OportunidadeAgravo)beans.get(i)).getQtdNaoEncerrado() + agravoBean.getQtdNaoEncerrado());
            agravoBean.setQtdDataInvalida(((OportunidadeAgravo)beans.get(i)).getQtdDataInvalida() + agravoBean.getQtdDataInvalida());
            agravoBean.setTotal(((OportunidadeAgravo)beans.get(i)).getTotal() + agravoBean.getTotal());
        }
        beans.add(agravoBean);
        return beans;
    }

    /*
     * WARNING - void declaration
     */
    public List getCalculaResultado(DBFReader reader, Map parametros) throws ParseException, DBFException {
        if (!parametros.get("parUf").equals("brasil")) {
            return this.calculaEstadoMunicipio(reader, parametros);
        }
        CasoOportunidade casoListado = null;
        HashMap<Object, Object> municipiosBeans = new HashMap();
        DBFUtil utilDbf = new DBFUtil();
        Agravo agravodbf = new Agravo();
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim60 = (String)parametros.get("parDataFim60");
        String dataFim180 = (String)parametros.get("parDataFim180");
        int i = 1;
        String agravoSelecionado = parametros.get("parAgravo").toString();
        municipiosBeans = this.populaUfsBeansOportunidade();
        this.iniciaAgravosValidos();
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            int TotalRegistrosInt = reader.getRecordCount();
            while ((rowObjects = reader.nextRecord()) != null) {
                if (utilDbf.getString(rowObjects, "SG_UF") != null) {
                    OportunidadeAgravo municipioResidencia = (OportunidadeAgravo)municipiosBeans.get(utilDbf.getString(rowObjects, "SG_UF"));
                    Date dtNotificacao = utilDbf.getDate(rowObjects, "DT_NOTIFIC");
                    Date dtEncerramento = utilDbf.getDate(rowObjects, "DT_ENCERRA");
                    boolean continuaCalculo = true;
                    String agravo = utilDbf.getString(rowObjects, "ID_AGRAVO");
                    if (agravo.equals("B09")) {
                        int suspeita = utilDbf.getInt(rowObjects, "CS_SUSPEIT");
                        agravo = suspeita == 1 ? "B091" : "B092";
                    }
                    if (agravo.equals("A90")) {
                        String evolucao = utilDbf.getString(rowObjects, "EVOLUCAO", 1);
                        if (evolucao == null) {
                            continuaCalculo = false;
                        } else {
                            int n = Integer.parseInt(evolucao);
                            if (n < 2 || n > 4) {
                                continuaCalculo = false;
                            }
                        }
                    }
                    if (!agravoSelecionado.equals("TODOS") && !agravoSelecionado.equals(agravo)) {
                        continuaCalculo = false;
                    }
                    int anoAvaliadoMalaria = Integer.parseInt(parametros.get("parDataInicio").toString().split("-")[0]);
                    if (agravoSelecionado.equals("TODOS") && anoAvaliadoMalaria == 2008 && agravo.equals("B54")) {
                        continuaCalculo = false;
                    }
                    if (anoAvaliadoMalaria == 2008 && agravoSelecionado.equals("B54")) {
                        Master.mensagem("Mal\u00e1ria est\u00e1 dispon\u00edvel a partir do ano de 2009");
                        return null;
                    }
                    if (municipioResidencia != null && this.verificaAgravoOportuno(agravo) && continuaCalculo) {
                        void var20_28;
                        String string = dataFim60;
                        if (agravo.equals("B19") || agravo.equals("P350") || agravo.equals("B551")) {
                            String string2 = dataFim180;
                        }
                        if (agravodbf.isBetweenDates(dtNotificacao, dataInicio, (String)var20_28)) {
                            casoListado = new CasoOportunidade();
                            if (dtEncerramento == null) {
                                if (this.temListagem) {
                                    casoListado.setAgravo(this.buscaNomeAgravo(agravo));
                                    casoListado.setDtNotificacao(this.formataData(dtNotificacao.toString()));
                                    casoListado.setIdUnidade(utilDbf.getString(rowObjects, "ID_UNIDADE"));
                                    casoListado.setNumNotificacao(utilDbf.getString(rowObjects, "NU_NOTIFIC"));
                                    casoListado.setIdMunicipio(utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                    String nomeMunicipio = this.retornaNome(utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                    if (nomeMunicipio.equals("")) {
                                        Municipio municipioNovo = new Municipio();
                                        municipioNovo.setCodMunicipio(utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                        municipioNovo.setNmMunicipio(agravodbf.getNomeMunicipio(utilDbf.getString(rowObjects, "ID_MUNICIP")));
                                        casoListado.setNmMunicipio(municipioNovo.getNmMunicipio());
                                        this.getMunicipios().add(municipioNovo);
                                    } else {
                                        casoListado.setNmMunicipio(nomeMunicipio);
                                    }
                                    casoListado.setSituacao("N\u00e3o Encerrado");
                                    this.getListagemCasos().add(casoListado);
                                }
                                municipioResidencia.setQtdNaoEncerrado(municipioResidencia.getQtdNaoEncerrado() + 1);
                                municipioResidencia.setTotal(municipioResidencia.getTotal() + 1);
                            } else {
                                int diferencaOportuna;
                                int diferenca = OportunidadePQAVS.dataDiff(dtNotificacao, dtEncerramento);
                                String situacao = this.classificaNotificacao(diferenca, diferencaOportuna = this.retornaDiferenca(agravo), municipioResidencia, utilDbf.getInt(rowObjects, "CLASSI_FIN"));
                                if (situacao.equals("Data Inv\u00e1lida")) {
                                    System.out.println("dt_notificacao:" + this.formataData(dtNotificacao.toString()) + "\nnum notificacao:" + utilDbf.getString(rowObjects, "NU_NOTIFIC") + "\nmunicipio:" + utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                }
                                if (this.temListagem && !situacao.equals("Oportuno") && !situacao.equals("Inoportuno com outras categorias")) {
                                    casoListado.setAgravo(this.buscaNomeAgravo(agravo));
                                    casoListado.setDtNotificacao(this.formataData(dtNotificacao.toString()));
                                    casoListado.setIdUnidade(utilDbf.getString(rowObjects, "ID_UNIDADE"));
                                    casoListado.setNumNotificacao(utilDbf.getString(rowObjects, "NU_NOTIFIC"));
                                    casoListado.setIdMunicipio(utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                    String nomeMunicipio = this.retornaNome(utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                    if (nomeMunicipio.equals("")) {
                                        Municipio municipioNovo = new Municipio();
                                        municipioNovo.setCodMunicipio(utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                        municipioNovo.setNmMunicipio(agravodbf.getNomeMunicipio(utilDbf.getString(rowObjects, "ID_MUNICIP")));
                                        casoListado.setNmMunicipio(municipioNovo.getNmMunicipio());
                                        this.getMunicipios().add(municipioNovo);
                                    } else {
                                        casoListado.setNmMunicipio(nomeMunicipio);
                                    }
                                    casoListado.setSituacao(situacao);
                                    this.getListagemCasos().add(casoListado);
                                }
                            }
                        }
                    }
                }
                this.getLabel().setText("Registros: " + i + " de " + TotalRegistrosInt);
                ++i;
            }
        }
        catch (DBFException ex) {
            Master.mensagem("Erro:\n" + (Object)((Object)ex));
        }
        ArrayList<OportunidadeAgravo> beans = new ArrayList<OportunidadeAgravo>();
        Collection<Object> municipioBean = municipiosBeans.values();
        for (OportunidadeAgravo oportunidadeAgravo : municipioBean) {
            beans.add(oportunidadeAgravo);
        }
        Collections.sort(beans, new BeanComparator("nmAgravo"));
        Collections.sort(beans, new BeanComparator("regiao"));
        Collections.sort(this.getListagemCasos(), new BeanComparator("situacao"));
        Collections.sort(this.getListagemCasos(), new BeanComparator("nmMunicipio"));
        OportunidadeAgravo agravoBean = new OportunidadeAgravo();
        agravoBean.setNmAgravo("TOTAL");
        for (i = 0; i < beans.size(); ++i) {
            agravoBean.setQtdOportuno(((OportunidadeAgravo)beans.get(i)).getQtdOportuno() + agravoBean.getQtdOportuno());
            agravoBean.setQtdInoportuno(((OportunidadeAgravo)beans.get(i)).getQtdInoportuno() + agravoBean.getQtdInoportuno());
            agravoBean.setQtdInoportunoOutras(((OportunidadeAgravo)beans.get(i)).getQtdInoportunoOutras() + agravoBean.getQtdInoportunoOutras());
            agravoBean.setQtdNaoEncerrado(((OportunidadeAgravo)beans.get(i)).getQtdNaoEncerrado() + agravoBean.getQtdNaoEncerrado());
            agravoBean.setQtdDataInvalida(((OportunidadeAgravo)beans.get(i)).getQtdDataInvalida() + agravoBean.getQtdDataInvalida());
            agravoBean.setTotal(((OportunidadeAgravo)beans.get(i)).getTotal() + agravoBean.getTotal());
        }
        beans.add(agravoBean);
        return beans;
    }

    public List getCalculaResultado(Connection con, Map parametros) throws SQLException, ParseException {
        ResultSet rs2;
        PreparedStatement stm2;
        String agravoSelecionado;
        String agravo = "";
        OportunidadeAgravo agravoBean = null;
        ArrayList<OportunidadeAgravo> beans = new ArrayList<OportunidadeAgravo>();
        CasoOportunidade casoListado = null;
        boolean prosseguir = true;
        if (parametros.get("parNomeMunicipio").toString().equals("Todos Munic\u00edpios")) {
            return this.getCalculaResultadoPorMunicipio(con, parametros);
        }
        String municipio = "";
        if (parametros.get("parMunicipio") != null) {
            municipio = " and co_municipio_residencia = ? ";
        }
        if ((agravoSelecionado = parametros.get("parAgravo").toString()).equals("TODOS") || agravoSelecionado.equals("B19") || agravoSelecionado.equals("B551") || agravoSelecionado.equals("P350")) {
            String sql;
            if (agravoSelecionado.equals("TODOS")) {
                sql = this.getSqlCalculoAgravos180dias() + municipio + " order by co_cid,tp_suspeita";
            } else {
                sql = this.getSqlCalculoAgravoEspecifico() + municipio + " order by co_cid,tp_suspeita";
                agravoSelecionado = this.converteCodigoParaCompleto(agravoSelecionado);
                prosseguir = false;
            }
            stm2 = con.prepareStatement(sql);
            stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
            stm2.setDate(2, this.transformaDate(parametros.get("parDataFim180").toString()));
            stm2.setString(3, parametros.get("parUf").toString());
            if (!municipio.equals("")) {
                if (!agravoSelecionado.equals("TODOS")) {
                    stm2.setString(4, agravoSelecionado);
                    stm2.setString(5, parametros.get("parMunicipio").toString());
                } else {
                    stm2.setString(4, parametros.get("parMunicipio").toString());
                }
            } else if (!agravoSelecionado.equals("TODOS")) {
                stm2.setString(4, agravoSelecionado);
            }
            rs2 = stm2.executeQuery();
            while (rs2.next()) {
                String codCid = rs2.getString("co_cid");
                if (!agravo.equals(codCid)) {
                    agravoBean = new OportunidadeAgravo();
                    agravoBean.setNmAgravo(codCid);
                    beans.add(agravoBean);
                    agravo = codCid;
                }
                casoListado = new CasoOportunidade();
                if (rs2.getDate("dt_encerramento") == null) {
                    if (this.temListagem) {
                        casoListado.setAgravo(codCid);
                        casoListado.setDtNotificacao(this.formataData(rs2.getDate("dt_notificacao").toString()));
                        casoListado.setIdUnidade(rs2.getString("co_unidade_notificacao"));
                        casoListado.setNumNotificacao(rs2.getString("nu_notificacao"));
                        casoListado.setIdMunicipio(rs2.getString("co_municipio_notificacao"));
                        casoListado.setNmMunicipio(rs2.getString("no_municipio"));
                        casoListado.setSituacao("N\u00e3o Encerrado");
                        this.getListagemCasos().add(casoListado);
                    }
                    agravoBean.setQtdNaoEncerrado(agravoBean.getQtdNaoEncerrado() + 1);
                    agravoBean.setTotal(agravoBean.getTotal() + 1);
                    continue;
                }
                String situacao = this.classificaNotificacao(rs2.getInt("diff"), 180, agravoBean, rs2.getInt("tp_classificacao_final"));
                if (!this.temListagem || situacao.equals("Oportuno") || situacao.equals("Inoportuno com outras categorias")) continue;
                casoListado.setAgravo(codCid);
                casoListado.setDtNotificacao(this.formataData(rs2.getDate("dt_notificacao").toString()));
                casoListado.setIdUnidade(rs2.getString("co_unidade_notificacao"));
                casoListado.setNumNotificacao(rs2.getString("nu_notificacao"));
                casoListado.setIdMunicipio(rs2.getString("co_municipio_notificacao"));
                casoListado.setNmMunicipio(rs2.getString("no_municipio"));
                casoListado.setSituacao(situacao);
                this.getListagemCasos().add(casoListado);
            }
        }
        if (prosseguir) {
            int anoAvaliadoMalaria = Integer.parseInt(parametros.get("parDataInicio").toString().split("-")[0]);
            if (agravoSelecionado.equals("TODOS")) {
                stm2 = anoAvaliadoMalaria > 2008 ? con.prepareStatement(this.getSqlCalculoAgravosMalaria60dias() + municipio + " order by co_cid,tp_suspeita") : con.prepareStatement(this.getSqlCalculoAgravos60dias() + municipio + " order by co_cid,tp_suspeita");
            } else {
                if (anoAvaliadoMalaria == 2008 && agravoSelecionado.equals("B54")) {
                    Master.mensagem("Mal\u00e1ria est\u00e1 dispon\u00edvel a partir do ano de 2009");
                    return null;
                }
                agravoSelecionado = this.converteCodigoParaCompleto(agravoSelecionado);
                stm2 = con.prepareStatement(this.getSqlCalculoAgravoEspecifico() + municipio + " order by co_cid,tp_suspeita");
            }
            stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
            stm2.setDate(2, this.transformaDate(parametros.get("parDataFim60").toString()));
            stm2.setString(3, parametros.get("parUf").toString());
            if (!municipio.equals("")) {
                if (!agravoSelecionado.equals("TODOS")) {
                    stm2.setString(4, agravoSelecionado);
                    stm2.setString(5, parametros.get("parMunicipio").toString());
                } else {
                    stm2.setString(4, parametros.get("parMunicipio").toString());
                }
            } else if (!agravoSelecionado.equals("TODOS")) {
                stm2.setString(4, agravoSelecionado);
            }
            rs2 = stm2.executeQuery();
            agravo = "";
            agravoBean = null;
            while (rs2.next()) {
                String codCid = rs2.getString("co_cid");
                if (codCid.equals("DOENCAS EXANTEMATICAS")) {
                    codCid = rs2.getInt("tp_suspeita") == 1 ? "SARAMPO" : "RUBEOLA";
                }
                if (!agravo.equals(codCid)) {
                    agravoBean = new OportunidadeAgravo();
                    agravoBean.setNmAgravo(codCid);
                    beans.add(agravoBean);
                    agravo = codCid;
                }
                casoListado = new CasoOportunidade();
                if (rs2.getDate("dt_encerramento") == null) {
                    if (this.temListagem) {
                        casoListado.setAgravo(codCid);
                        casoListado.setDtNotificacao(this.formataData(rs2.getDate("dt_notificacao").toString()));
                        casoListado.setIdUnidade(rs2.getString("co_unidade_notificacao"));
                        casoListado.setNumNotificacao(rs2.getString("nu_notificacao"));
                        casoListado.setIdMunicipio(rs2.getString("co_municipio_notificacao"));
                        casoListado.setNmMunicipio(rs2.getString("no_municipio"));
                        casoListado.setSituacao("N\u00e3o Encerrado");
                        this.getListagemCasos().add(casoListado);
                    }
                    agravoBean.setQtdNaoEncerrado(agravoBean.getQtdNaoEncerrado() + 1);
                    agravoBean.setTotal(agravoBean.getTotal() + 1);
                    continue;
                }
                String situacao = this.classificaNotificacao(rs2.getInt("diff"), 60, agravoBean, rs2.getInt("tp_classificacao_final"));
                if (!this.temListagem || situacao.equals("Oportuno") || situacao.equals("Inoportuno com outras categorias")) continue;
                casoListado.setAgravo(codCid);
                casoListado.setDtNotificacao(this.formataData(rs2.getDate("dt_notificacao").toString()));
                casoListado.setIdUnidade(rs2.getString("co_unidade_notificacao"));
                casoListado.setNumNotificacao(rs2.getString("nu_notificacao"));
                casoListado.setIdMunicipio(rs2.getString("co_municipio_notificacao"));
                casoListado.setNmMunicipio(rs2.getString("no_municipio"));
                casoListado.setSituacao(situacao);
                this.getListagemCasos().add(casoListado);
            }
        }
        agravoBean = new OportunidadeAgravo();
        agravoBean.setNmAgravo("TOTAL");
        for (int i = 0; i < beans.size(); ++i) {
            agravoBean.setQtdOportuno(((OportunidadeAgravo)beans.get(i)).getQtdOportuno() + agravoBean.getQtdOportuno());
            agravoBean.setQtdInoportuno(((OportunidadeAgravo)beans.get(i)).getQtdInoportuno() + agravoBean.getQtdInoportuno());
            agravoBean.setQtdInoportunoOutras(((OportunidadeAgravo)beans.get(i)).getQtdInoportunoOutras() + agravoBean.getQtdInoportunoOutras());
            agravoBean.setQtdNaoEncerrado(((OportunidadeAgravo)beans.get(i)).getQtdNaoEncerrado() + agravoBean.getQtdNaoEncerrado());
            agravoBean.setQtdDataInvalida(((OportunidadeAgravo)beans.get(i)).getQtdDataInvalida() + agravoBean.getQtdDataInvalida());
            agravoBean.setTotal(((OportunidadeAgravo)beans.get(i)).getTotal() + agravoBean.getTotal());
        }
        beans.add(agravoBean);
        Collections.sort(beans, new BeanComparator("nmAgravo"));
        Collections.sort(this.getListagemCasos(), new BeanComparator("situacao"));
        Collections.sort(this.getListagemCasos(), new BeanComparator("nmMunicipio"));
        return beans;
    }

    private List getCalculaResultadoPorMunicipio(Connection con, Map parametros) throws SQLException {
        ResultSet rs;
        String noMunicipio = null;
        Statement stm = con.createStatement();
        OportunidadeAgravo agravoBean = null;
        ArrayList<OportunidadeAgravo> beans = new ArrayList<OportunidadeAgravo>();
        CasoOportunidade casoListado = null;
        boolean prosseguir = true;
        String sql = parametros.get("parNomeRegional").equals("Todas Regionais") || parametros.get("parNomeRegional").equals("") ? "select co_municipio_ibge,no_municipio from dbgeral.tb_municipio where sg_uf = '" + parametros.get("parSgUf") + "' order by no_municipio" : "select t1.co_municipio_ibge,no_municipio from dbgeral.tb_municipio as t1, dblocalidade.rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + parametros.get("parUf") + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional = '" + parametros.get("parCodRegional") + "' and no_municipio not like '%Ignorado%'  order by no_municipio";
        try {
            rs = stm.executeQuery(sql);
        }
        catch (Exception exception) {
            sql = parametros.get("parNomeRegional").equals("Todas Regionais") || parametros.get("parNomeRegional").equals("") ? "select co_municipio_ibge,no_municipio from tb_municipio where sg_uf = '" + parametros.get("parSgUf") + "' order by no_municipio" : "select t1.co_municipio_ibge,no_municipio from tb_municipio as t1, rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + parametros.get("parUf") + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional = '" + parametros.get("parCodRegional") + "' and no_municipio not like '%Ignorado%'  order by no_municipio";
            rs = stm.executeQuery(sql);
        }
        while (rs.next()) {
            String codCid;
            ResultSet rs2;
            PreparedStatement stm2;
            String municipio = rs.getString("co_municipio_ibge");
            noMunicipio = rs.getString("no_municipio");
            this.getLabel().setText("Aguarde, calculado do munic\u00edpio de " + noMunicipio);
            agravoBean = new OportunidadeAgravo();
            agravoBean.setNmAgravo(noMunicipio);
            beans.add(agravoBean);
            String agravoSelecionado = parametros.get("parAgravo").toString();
            if (agravoSelecionado.equals("TODOS") || agravoSelecionado.equals("B19") || agravoSelecionado.equals("B551") || agravoSelecionado.equals("P350")) {
                if (agravoSelecionado.equals("TODOS")) {
                    sql = this.getSqlCalculoAgravos180dias() + " and co_municipio_residencia = ?  order by co_cid,tp_suspeita";
                } else {
                    sql = this.getSqlCalculoAgravoEspecifico() + " and co_municipio_residencia = ?  order by co_cid,tp_suspeita";
                    agravoSelecionado = this.converteCodigoParaCompleto(agravoSelecionado);
                    prosseguir = false;
                }
                stm2 = con.prepareStatement(sql);
                stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
                stm2.setDate(2, this.transformaDate(parametros.get("parDataFim180").toString()));
                stm2.setString(3, parametros.get("parUf").toString());
                if (!agravoSelecionado.equals("TODOS")) {
                    stm2.setString(4, agravoSelecionado);
                    stm2.setString(5, municipio);
                } else {
                    stm2.setString(4, municipio);
                }
                rs2 = stm2.executeQuery();
                while (rs2.next()) {
                    casoListado = new CasoOportunidade();
                    if (rs2.getDate("dt_encerramento") == null) {
                        if (this.temListagem) {
                            String codCid2 = rs2.getString("co_cid");
                            casoListado.setAgravo(codCid2);
                            casoListado.setDtNotificacao(this.formataData(rs2.getDate("dt_notificacao").toString()));
                            casoListado.setIdUnidade(rs2.getString("co_unidade_notificacao"));
                            casoListado.setNumNotificacao(rs2.getString("nu_notificacao"));
                            casoListado.setIdMunicipio(rs2.getString("co_municipio_notificacao"));
                            casoListado.setNmMunicipio(rs2.getString("no_municipio"));
                            casoListado.setSituacao("N\u00e3o Encerrado");
                            this.getListagemCasos().add(casoListado);
                        }
                        agravoBean.setQtdNaoEncerrado(agravoBean.getQtdNaoEncerrado() + 1);
                        agravoBean.setTotal(agravoBean.getTotal() + 1);
                        continue;
                    }
                    String situacao = this.classificaNotificacao(rs2.getInt("diff"), 180, agravoBean, rs2.getInt("tp_classificacao_final"));
                    if (!this.temListagem || situacao.equals("Oportuno") || situacao.equals("Inoportuno com outras categorias")) continue;
                    codCid = rs2.getString("co_cid");
                    casoListado.setAgravo(codCid);
                    casoListado.setDtNotificacao(this.formataData(rs2.getDate("dt_notificacao").toString()));
                    casoListado.setIdUnidade(rs2.getString("co_unidade_notificacao"));
                    casoListado.setNumNotificacao(rs2.getString("nu_notificacao"));
                    casoListado.setIdMunicipio(rs2.getString("co_municipio_notificacao"));
                    casoListado.setNmMunicipio(rs2.getString("no_municipio"));
                    casoListado.setSituacao(situacao);
                    this.getListagemCasos().add(casoListado);
                }
            }
            if (!prosseguir) continue;
            int anoAvaliadoMalaria = Integer.parseInt(parametros.get("parDataInicio").toString().split("-")[0]);
            if (agravoSelecionado.equals("TODOS")) {
                stm2 = anoAvaliadoMalaria > 2008 ? con.prepareStatement(this.getSqlCalculoAgravosMalaria60dias() + " and co_municipio_residencia = ?  order by co_cid,tp_suspeita") : con.prepareStatement(this.getSqlCalculoAgravos60dias() + " and co_municipio_residencia = ?  order by co_cid,tp_suspeita");
            } else {
                if (anoAvaliadoMalaria == 2008 && agravoSelecionado.equals("B54")) {
                    Master.mensagem("Mal\u00e1ria est\u00e1 dispon\u00edvel a partir do ano de 2009");
                    return null;
                }
                agravoSelecionado = this.converteCodigoParaCompleto(agravoSelecionado);
                stm2 = con.prepareStatement(this.getSqlCalculoAgravoEspecifico() + " and co_municipio_residencia = ?  order by co_cid,tp_suspeita");
            }
            stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
            stm2.setDate(2, this.transformaDate(parametros.get("parDataFim60").toString()));
            stm2.setString(3, parametros.get("parUf").toString());
            if (!agravoSelecionado.equals("TODOS")) {
                stm2.setString(4, agravoSelecionado);
                stm2.setString(5, municipio);
            } else {
                stm2.setString(4, municipio);
            }
            rs2 = stm2.executeQuery();
            while (rs2.next()) {
                codCid = rs2.getString("co_cid");
                if (codCid.equals("DOENCAS EXANTEMATICAS")) {
                    codCid = rs2.getInt("tp_suspeita") == 1 ? "SARAMPO" : "RUBEOLA";
                }
                casoListado = new CasoOportunidade();
                if (rs2.getDate("dt_encerramento") == null) {
                    if (this.temListagem) {
                        casoListado.setAgravo(codCid);
                        casoListado.setDtNotificacao(this.formataData(rs2.getDate("dt_notificacao").toString()));
                        casoListado.setIdUnidade(rs2.getString("co_unidade_notificacao"));
                        casoListado.setNumNotificacao(rs2.getString("nu_notificacao"));
                        casoListado.setIdMunicipio(rs2.getString("co_municipio_notificacao"));
                        casoListado.setNmMunicipio(rs2.getString("no_municipio"));
                        casoListado.setSituacao("N\u00e3o Encerrado");
                        this.getListagemCasos().add(casoListado);
                    }
                    agravoBean.setQtdNaoEncerrado(agravoBean.getQtdNaoEncerrado() + 1);
                    agravoBean.setTotal(agravoBean.getTotal() + 1);
                    continue;
                }
                String situacao = this.classificaNotificacao(rs2.getInt("diff"), 60, agravoBean, rs2.getInt("tp_classificacao_final"));
                if (!this.temListagem || situacao.equals("Oportuno") || situacao.equals("Inoportuno com outras categorias")) continue;
                casoListado.setAgravo(codCid);
                casoListado.setDtNotificacao(this.formataData(rs2.getDate("dt_notificacao").toString()));
                casoListado.setIdUnidade(rs2.getString("co_unidade_notificacao"));
                casoListado.setNumNotificacao(rs2.getString("nu_notificacao"));
                casoListado.setIdMunicipio(rs2.getString("co_municipio_notificacao"));
                casoListado.setNmMunicipio(rs2.getString("no_municipio"));
                casoListado.setSituacao(situacao);
                this.getListagemCasos().add(casoListado);
            }
        }
        Collections.sort(beans, new BeanComparator("nmAgravo"));
        Collections.sort(this.getListagemCasos(), new BeanComparator("situacao"));
        Collections.sort(this.getListagemCasos(), new BeanComparator("nmMunicipio"));
        agravoBean = new OportunidadeAgravo();
        agravoBean.setNmAgravo("TOTAL");
        for (int i = 0; i < beans.size(); ++i) {
            agravoBean.setQtdOportuno(((OportunidadeAgravo)beans.get(i)).getQtdOportuno() + agravoBean.getQtdOportuno());
            agravoBean.setQtdInoportuno(((OportunidadeAgravo)beans.get(i)).getQtdInoportuno() + agravoBean.getQtdInoportuno());
            agravoBean.setQtdInoportunoOutras(((OportunidadeAgravo)beans.get(i)).getQtdInoportunoOutras() + agravoBean.getQtdInoportunoOutras());
            agravoBean.setQtdNaoEncerrado(((OportunidadeAgravo)beans.get(i)).getQtdNaoEncerrado() + agravoBean.getQtdNaoEncerrado());
            agravoBean.setQtdDataInvalida(((OportunidadeAgravo)beans.get(i)).getQtdDataInvalida() + agravoBean.getQtdDataInvalida());
            agravoBean.setTotal(((OportunidadeAgravo)beans.get(i)).getTotal() + agravoBean.getTotal());
        }
        beans.add(agravoBean);
        return beans;
    }

    public String formataData(String data) {
        return data.split("-")[2] + "/" + data.split("-")[1] + "/" + data.split("-")[0];
    }

    public String getSqlCalculoAgravos180dias() {
        return this.sqlCalculoAgravos180dias;
    }

    public void setSqlCalculoAgravos180dias(String sqlCalculoAgravos180dias) {
        this.sqlCalculoAgravos180dias = sqlCalculoAgravos180dias;
    }

    public String getSqlCalculoAgravos60dias() {
        return this.sqlCalculoAgravos60dias;
    }

    public void setSqlCalculoAgravos60dias(String sqlCalculoAgravos60dias) {
        this.sqlCalculoAgravos60dias = sqlCalculoAgravos60dias;
    }

    public String getNaoEncerrado() {
        return this.naoEncerrado;
    }

    public String getInoportuno() {
        return this.inoportuno;
    }

    public String getOportuno() {
        return this.oportuno;
    }

    public String getDataInvalida() {
        return this.dataInvalida;
    }

    private String classificaNotificacao(int diferencaDatas, int diferencaValida, OportunidadeAgravo agravoBean, int classificaoFinal) {
        String retorno = "";
        if (diferencaDatas < 0) {
            agravoBean.setQtdDataInvalida(agravoBean.getQtdDataInvalida() + 1);
            retorno = "Data Inv\u00e1lida";
        } else if (diferencaDatas > diferencaValida) {
            if (classificaoFinal == 8) {
                agravoBean.setQtdInoportuno(agravoBean.getQtdInoportuno() + 1);
                retorno = "Inconclusivo";
            } else {
                agravoBean.setQtdInoportunoOutras(agravoBean.getQtdInoportunoOutras() + 1);
                retorno = "Inoportuno com outras categorias";
            }
        } else if (diferencaDatas <= diferencaValida) {
            agravoBean.setQtdOportuno(agravoBean.getQtdOportuno() + 1);
            retorno = "Oportuno";
        }
        agravoBean.setTotal(agravoBean.getTotal() + 1);
        return retorno;
    }

    public HashMap<String, OportunidadeAgravo> populaAgravosBeans(String agravoSelecionado) {
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap hashAgravos = new HashMap();
        HashMap<String, OportunidadeAgravo> agravosBeans = new HashMap<String, OportunidadeAgravo>();
        int exantematica = 1;
        List<String> agravos = null;
        if (agravoSelecionado.equals("TODOS")) {
            agravos = this.getAgravosValidos();
        } else {
            agravos = new ArrayList<String>();
            agravos.add(agravoSelecionado);
        }
        for (int i = 0; i < agravos.size(); ++i) {
            OportunidadeAgravo agravoDbf = new OportunidadeAgravo();
            if (agravos.get(i).equals("B09")) {
                agravoDbf.setCodAgravo("B09" + exantematica);
                if (exantematica == 1) {
                    agravoDbf.setNmAgravo("SARAMPO");
                    ++exantematica;
                    --i;
                } else {
                    agravoDbf.setNmAgravo("RUBEOLA");
                }
            } else {
                agravoDbf.setCodAgravo(agravos.get(i));
                agravoDbf.setNmAgravo(this.buscaNomeAgravo(agravos.get(i)));
            }
            agravoDbf.setQtdDataInvalida(0);
            agravoDbf.setQtdInoportuno(0);
            agravoDbf.setQtdNaoEncerrado(0);
            agravoDbf.setQtdOportuno(0);
            agravoDbf.setTotal(0);
            hashAgravos.put(agravoDbf.getCodAgravo(), agravoDbf.getNmAgravo());
            agravosBeans.put(agravoDbf.getCodAgravo(), agravoDbf);
        }
        hashAgravos = this.sortHashMapByValues(hashAgravos, false);
        Set agravoKeys = ((HashMap)hashAgravos).keySet();
        HashMap<String, OportunidadeAgravo> agravosBeansRetorno = new HashMap<String, OportunidadeAgravo>();
        for (String key : agravoKeys) {
            agravosBeansRetorno.put(key, (OportunidadeAgravo)agravosBeans.get(key));
        }
        return agravosBeansRetorno;
    }

    public String buscaNomeAgravo(String codAgravo) {
        String retorno = "";
        if (codAgravo.equals("A229")) {
            retorno = "ANTRAZ PNEUMONICO";
        }
        if (codAgravo.equals("A969")) {
            retorno = "ARENAVIRUS";
        }
        if (codAgravo.equals("A051")) {
            retorno = "BOTULISMO";
        }
        if (codAgravo.equals("A009")) {
            retorno = "COLERA";
        }
        if (codAgravo.equals("A90")) {
            retorno = "DENGUE (OBITOS)";
        }
        if (codAgravo.equals("A984")) {
            retorno = "EBOLA";
        }
        if (codAgravo.equals("Y59")) {
            retorno = "EVENTOS ADVERSOS GRAVES OU OBITOS POS-VACINACAO";
        }
        if (codAgravo.equals("A959")) {
            retorno = "FEBRE AMARELA";
        }
        if (codAgravo.equals("A920")) {
            retorno = "FEBRE DE CHIKUNGUNYA";
        }
        if (codAgravo.equals("A923")) {
            retorno = "FEBRE DO NILO OCIDENTAL";
        }
        if (codAgravo.equals("A779")) {
            retorno = "FEBRE MACULOSA E OUTRAS RIQUETISIOSES";
        }
        if (codAgravo.equals("A484")) {
            retorno = "FEBRE PURPURICA BRASILEIRA";
        }
        if (codAgravo.equals("J11")) {
            retorno = "INFLUENZA HUMANA PRODUZIDA POR NOVO SUBTIPO VIRAL";
        }
        if (codAgravo.equals("A962")) {
            retorno = "LASSA";
        }
        if (codAgravo.equals("B54")) {
            retorno = "MALARIA NA REGIAO EXTRA AMAZONICA";
        }
        if (codAgravo.equals("A983")) {
            retorno = "MARBURG";
        }
        if (codAgravo.equals("A809")) {
            retorno = "PARALISIA FLACIDA AGUDA";
        }
        if (codAgravo.equals("A209")) {
            retorno = "PESTE";
        }
        if (codAgravo.equals("A829")) {
            retorno = "RAIVA HUMANA";
        }
        if (codAgravo.equals("B092")) {
            retorno = "RUBEOLA";
        }
        if (codAgravo.equals("B091")) {
            retorno = "SARAMPO";
        }
        if (codAgravo.equals("P350")) {
            retorno = "SINDROME DA RUBEOLA CONGENITA";
        }
        if (codAgravo.equals("U049")) {
            retorno = "SINDROME RESPIRATORIA AGUDA GRAVE ASSOCIADA A CORONAVIRUS";
        }
        if (codAgravo.equals("A219")) {
            retorno = "TULAREMIA";
        }
        if (codAgravo.equals("B03")) {
            retorno = "VARIOLA";
        }
        return retorno;
    }

    public HashMap<String, OportunidadeAgravo> populaUfsBeansOportunidade() {
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap uf = new HashMap();
        HashMap<String, OportunidadeAgravo> ufsBeans = new HashMap<String, OportunidadeAgravo>();
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("UF", "dbf\\");
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                OportunidadeAgravo agravoDbf = new OportunidadeAgravo();
                agravoDbf.setNmAgravo(utilDbf.getString(rowObjects1, "SG_UF"));
                agravoDbf.setCodAgravo(utilDbf.getString(rowObjects1, "ID_UF"));
                agravoDbf.setRegiao(this.buscaRegiao(agravoDbf.getNmAgravo()));
                agravoDbf.setQtdDataInvalida(0);
                agravoDbf.setQtdInoportuno(0);
                agravoDbf.setQtdNaoEncerrado(0);
                agravoDbf.setQtdOportuno(0);
                agravoDbf.setTotal(0);
                uf.put(utilDbf.getString(rowObjects1, "ID_UF"), utilDbf.getString(rowObjects1, "SG_UF"));
                ufsBeans.put(agravoDbf.getCodAgravo(), agravoDbf);
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        uf = this.sortHashMapByValues(uf, false);
        Set ufKeys = ((HashMap)uf).keySet();
        HashMap<String, OportunidadeAgravo> ufsBeansRetorno = new HashMap<String, OportunidadeAgravo>();
        for (String key : ufKeys) {
            ufsBeansRetorno.put(key, (OportunidadeAgravo)ufsBeans.get(key));
        }
        return ufsBeansRetorno;
    }

    private String buscaRegiao(String uf) {
        String regiao = "";
        if (uf.equals("TO")) {
            return "NORTE";
        }
        if (uf.equals("AC")) {
            return "NORTE";
        }
        if (uf.equals("AL")) {
            return "NORDESTE";
        }
        if (uf.equals("AM")) {
            return "NORTE";
        }
        if (uf.equals("AP")) {
            return "NORTE";
        }
        if (uf.equals("BA")) {
            return "NORDESTE";
        }
        if (uf.equals("CE")) {
            return "NORDESTE";
        }
        if (uf.equals("DF")) {
            return "CENTRO-OESTE";
        }
        if (uf.equals("ES")) {
            return "SUDESTE";
        }
        if (uf.equals("GO")) {
            return "CENTRO-OESTE";
        }
        if (uf.equals("MA")) {
            return "NORDESTE";
        }
        if (uf.equals("MG")) {
            return "SUDESTE";
        }
        if (uf.equals("MS")) {
            return "CENTRO-OESTE";
        }
        if (uf.equals("MT")) {
            return "CENTRO-OESTE";
        }
        if (uf.equals("PA")) {
            return "NORTE";
        }
        if (uf.equals("PB")) {
            return "NORDESTE";
        }
        if (uf.equals("PE")) {
            return "NORDESTE";
        }
        if (uf.equals("PI")) {
            return "NORDESTE";
        }
        if (uf.equals("PR")) {
            return "SUL";
        }
        if (uf.equals("RJ")) {
            return "SUDESTE";
        }
        if (uf.equals("RN")) {
            return "NORDESTE";
        }
        if (uf.equals("RO")) {
            return "NORTE";
        }
        if (uf.equals("RR")) {
            return "NORTE";
        }
        if (uf.equals("RS")) {
            return "SUL";
        }
        if (uf.equals("RO")) {
            return "NORTE";
        }
        if (uf.equals("SC")) {
            return "SUL";
        }
        if (uf.equals("SE")) {
            return "NORDESTE";
        }
        if (uf.equals("SP")) {
            return "SUDESTE";
        }
        return null;
    }

    private int retornaDiferenca(String agravo) {
        if (agravo.equals("B19") || agravo.equals("B551") || agravo.equals("P350")) {
            return 180;
        }
        return 60;
    }

    private boolean verificaAgravoOportuno(String agravo) {
        return this.getAgravosValidos().contains(agravo);
    }

    public List<String> getAgravosValidos() {
        return this.agravosValidos;
    }

    public void setAgravosValidos(List<String> agravosValidos) {
        this.agravosValidos = agravosValidos;
    }

    private void iniciaAgravosValidos() {
        this.getAgravosValidos().add("A229");
        this.getAgravosValidos().add("A969");
        this.getAgravosValidos().add("A051");
        this.getAgravosValidos().add("A009");
        this.getAgravosValidos().add("A90");
        this.getAgravosValidos().add("A984");
        this.getAgravosValidos().add("Y59");
        this.getAgravosValidos().add("A959");
        this.getAgravosValidos().add("A920");
        this.getAgravosValidos().add("A923");
        this.getAgravosValidos().add("A779");
        this.getAgravosValidos().add("A484");
        this.getAgravosValidos().add("J11");
        this.getAgravosValidos().add("A962");
        this.getAgravosValidos().add("B54");
        this.getAgravosValidos().add("A983");
        this.getAgravosValidos().add("A809");
        this.getAgravosValidos().add("A209");
        this.getAgravosValidos().add("A829");
        this.getAgravosValidos().add("B092");
        this.getAgravosValidos().add("B091");
        this.getAgravosValidos().add("P350");
        this.getAgravosValidos().add("U049");
        this.getAgravosValidos().add("A219");
        this.getAgravosValidos().add("B03");
    }

    public String getSqlCalculoAgravosMalaria60dias() {
        return this.sqlCalculoAgravosMalaria60dias;
    }

    public void setSqlCalculoAgravosMalaria60dias(String sqlCalculoAgravosMalaria60dias) {
        this.sqlCalculoAgravosMalaria60dias = sqlCalculoAgravosMalaria60dias;
    }

    public String getSqlCalculoAgravoEspecifico() {
        return this.sqlCalculoAgravoEspecifico;
    }

    public void setSqlCalculoAgravoEspecifico(String sqlCalculoAgravoEspecifico) {
        this.sqlCalculoAgravoEspecifico = sqlCalculoAgravoEspecifico;
    }

    private String converteCodigoParaCompleto(String agravoSelecionado) {
        if (agravoSelecionado.length() > 4) {
            return agravoSelecionado.substring(0, 2) + "." + agravoSelecionado.substring(3);
        }
        return agravoSelecionado;
    }

    @Override
    public List<CasoOportunidade> getListagemCasos() {
        return this.listagemCasos;
    }

    @Override
    public void setListagemCasos(List<CasoOportunidade> listagemCasos) {
        this.listagemCasos = listagemCasos;
    }

    @Override
    public boolean isTemListagem() {
        return this.temListagem;
    }

    @Override
    public void setTemListagem(boolean temListagem) {
        this.temListagem = temListagem;
    }

    public List<Municipio> getMunicipios() {
        return this.municipios;
    }

    public void setMunicipios(List<Municipio> municipios) {
        this.municipios = municipios;
    }

    private String retornaNome(String codMunicipio) {
        String nomeMunicipio = "";
        for (int i = 0; i < this.getMunicipios().size(); ++i) {
            if (!this.getMunicipios().get(i).getCodMunicipio().equals(codMunicipio)) continue;
            nomeMunicipio = this.getMunicipios().get(i).getNmMunicipio();
        }
        return nomeMunicipio;
    }

    private HashMap<String, OportunidadeAgravo> populaMunicipiosBeans(String uf) {
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap municipios = new HashMap();
        HashMap<String, OportunidadeAgravo> municipiosBeans = new HashMap<String, OportunidadeAgravo>();
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                if (!uf.equals(utilDbf.getString(rowObjects1, "SG_UF"))) continue;
                OportunidadeAgravo agravoDbf = new OportunidadeAgravo();
                agravoDbf.setNmAgravo(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                agravoDbf.setCodAgravo(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                agravoDbf.setRegiao(this.buscaRegiao(agravoDbf.getNmAgravo()));
                agravoDbf.setQtdDataInvalida(0);
                agravoDbf.setQtdInoportuno(0);
                agravoDbf.setQtdNaoEncerrado(0);
                agravoDbf.setQtdOportuno(0);
                agravoDbf.setTotal(0);
                municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                municipiosBeans.put(agravoDbf.getCodAgravo(), agravoDbf);
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        municipios = this.sortHashMapByValues(municipios, false);
        Set municipiosKeys = ((HashMap)municipios).keySet();
        HashMap<String, OportunidadeAgravo> municipiosBeansRetorno = new HashMap<String, OportunidadeAgravo>();
        for (String key : municipiosKeys) {
            municipiosBeansRetorno.put(key, municipiosBeans.get(key));
        }
        return municipiosBeans;
    }
}

