/*
 * Decompiled with CFR 0.152.
 */
package com.org.service;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.org.bd.DBFUtil;
import com.org.beans.Arquivo;
import com.org.beans.Completitude;
import com.org.dao.TesteDAO;
import com.org.negocio.Util;
import com.org.util.SinanUtil;
import java.io.FileWriter;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JProgressBar;
import javax.swing.JTable;

public class CompletitudeService {
    Completitude bean;
    String diretorio = "";
    String arquivo;
    Completitude testeResultado;
    String agravo = "";
    String id_agravo;
    String ano;
    DBFUtil dbfUtil = new DBFUtil();
    Object[] rowObjects;
    Map<String, String> parametros;
    @Deprecated
    TesteDAO testeDAO = new TesteDAO();
    @Deprecated
    int qtdeRegistros = 0;

    @Deprecated
    public int getTotalRegistros(String diretorio, String banco) throws SQLException {
        if (this.qtdeRegistros > 0) {
            return this.qtdeRegistros;
        }
        return this.qtdeRegistros;
    }

    public boolean campoSistema(String campo) {
        return campo.equals("NDUPLIC_N") || campo.equals("DT_DIGITA") || campo.equals("DT_TRANSUS") || campo.equals("DT_TRANSDM") || campo.equals("DT_TRANSSM") || campo.equals("DT_TRANSRM") || campo.equals("DT_TRANSRS") || campo.equals("DT_TRANSSE") || campo.equals("NU_LOTE_V") || campo.equals("NU_LOTE_H") || campo.equals("CS_FLXRET") || campo.equals("FLXRECEBI") || campo.equals("IDENT_MICR") || campo.equals("MIGRADO_W");
    }

    public void listaCampos(DBFReader campos, JProgressBar jProgressBar, JCheckBox checkBox, List<Completitude> listaTabela, JCheckBox checkBox2) throws DBFException, NumberFormatException, ParseException {
        int totalRegistros = campos.getRecordCount();
        int totalCampos = campos.getFieldCount();
        this.dbfUtil.mapearPosicoes(campos);
        int i = 0;
        SinanUtil.initProgressBar(jProgressBar);
        DBFReader camposII = Util.retornaObjetoDbfCaminhoArquivo(this.arquivo, this.diretorio);
        this.dbfUtil.mapearPosicoes(camposII);
        HashMap<String, Double> mapa = new HashMap<String, Double>();
        while ((this.rowObjects = camposII.nextRecord()) != null) {
            for (int x = 0; x < totalCampos; ++x) {
                Arquivo arquivo = new Arquivo();
                arquivo.setNome(camposII.getField(x).getName());
                arquivo.setValor(this.dbfUtil.getString(this.rowObjects, arquivo.getNome()));
                this.agravo = this.getNomeAgravo(this.dbfUtil.getString(this.rowObjects, "ID_AGRAVO"));
                this.bean = new Completitude();
                this.id_agravo = this.dbfUtil.getString(this.rowObjects, "ID_AGRAVO");
                try {
                    this.ano = SinanUtil.dateToString(this.dbfUtil.getDate(this.rowObjects, "DT_NOTIFIC"), "yyyy");
                }
                catch (Exception ex) {
                    Logger.getLogger(CompletitudeService.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.bean.setAgravo(this.agravo);
                this.bean.setNome(camposII.getField(x).getName());
                if (mapa.containsKey(this.bean.getNome())) {
                    Double aux = (Double)mapa.get(this.bean.getNome());
                    if (arquivo.getValor() != null) {
                        mapa.put(this.bean.getNome(), aux + 1.0);
                    }
                } else if (arquivo.getValor() != null) {
                    mapa.put(this.bean.getNome(), 1.0);
                } else {
                    mapa.put(this.bean.getNome(), 0.0);
                }
                if (arquivo.getValor() != null && arquivo.getValor().equals("9")) {
                    if (mapa.containsKey(this.bean.getNome() + "9")) {
                        Double aux9 = (Double)mapa.get(this.bean.getNome() + "9");
                        mapa.put(this.bean.getNome() + "9", aux9 + 1.0);
                    } else {
                        mapa.put(this.bean.getNome() + "9", 1.0);
                    }
                }
                if (arquivo.getValor() == null || !arquivo.getValor().equals("99")) continue;
                if (mapa.containsKey(this.bean.getNome() + "99")) {
                    Double aux99 = (Double)mapa.get(this.bean.getNome() + "99");
                    mapa.put(this.bean.getNome() + "99", aux99 + 1.0 + 0.0);
                    continue;
                }
                mapa.put(this.bean.getNome() + "99", 1.0);
            }
            SinanUtil.refreshProgressBar(this.arquivo, jProgressBar, i, totalRegistros);
            ++i;
        }
        Double ultimo = new Double(0.0);
        Double ultimo9 = new Double(0.0);
        Double ultimo99 = new Double(0.0);
        Double aux999 = new Double(0.0);
        for (int l = 0; l < totalCampos; ++l) {
            this.bean = new Completitude();
            ultimo = (Double)mapa.get(campos.getField(l).getName());
            ultimo9 = (Double)mapa.get(campos.getField(l).getName() + "9");
            ultimo99 = (Double)mapa.get(campos.getField(l).getName() + "99");
            this.bean.setAgravo(this.agravo);
            this.bean.setNome(campos.getField(l).getName());
            if (this.bean.getNome().equals("ID_DISTRIT")) {
                SinanUtil.imprimirConsole(this.bean.getNome());
            }
            if (ultimo == null) {
                ultimo = new Double(0.0);
            }
            this.bean.setResultado(SinanUtil.converterDoubleUmaCasaDecimal(ultimo / (double)totalRegistros * 100.0));
            if (ultimo99 == null) {
                ultimo99 = new Double(0.0);
            }
            if (ultimo9 == null) {
                ultimo9 = new Double(0.0);
            }
            aux999 = ultimo99 > 0.0 ? Double.valueOf(ultimo - ultimo99) : Double.valueOf(ultimo - ultimo9);
            this.bean.setResultado_9_99(SinanUtil.converterDoubleUmaCasaDecimal(aux999 / (double)totalRegistros * 100.0));
            this.bean.setFaixa(this.getFaixa(this.bean.getResultado()));
            this.bean.setFaixa_9_9(this.getFaixa(this.bean.getResultado_9_99()));
            this.bean.setAno(this.ano);
            if (this.bean.getResultado() == null || this.campoSistema(this.bean.getNome()) || !this.possuiCampo(this.id_agravo, this.bean.getNome(), checkBox).booleanValue()) continue;
            if (checkBox2.isSelected()) {
                this.setArquivo(this.bean.getAgravo() + ";" + this.bean.getAno() + ";" + this.bean.getNome() + ";" + this.bean.getResultado() + ";" + this.bean.getFaixa() + ";" + this.bean.getResultado_9_99() + ";" + this.bean.getFaixa_9_9());
            }
            listaTabela.add(this.bean);
        }
    }

    public void executar(Map<String, String> parametros, List<String> arquivos, JProgressBar jProgressBar, JCheckBox checkBox, JTable jTable, JCheckBox checkBox2) throws SQLException, DBFException, ParseException {
        ArrayList<Completitude> listaTabela = new ArrayList<Completitude>();
        for (String item : arquivos) {
            DBFReader campos = Util.retornaObjetoDbfCaminhoArquivo(item, parametros.get("diretorio"));
            this.arquivo = item;
            this.diretorio = parametros.get("diretorio");
            this.parametros = parametros;
            this.listaCampos(campos, jProgressBar, checkBox, listaTabela, checkBox2);
        }
        SinanUtil.gerarTabela(listaTabela, jTable);
    }

    public int getFaixa(Double valor) {
        int faixa = 0;
        faixa = valor <= 25.0 ? 1 : (valor >= 25.1 && valor <= 50.0 ? 2 : (valor >= 50.1 && valor <= 75.0 ? 3 : 4));
        return faixa;
    }

    public String getNomeAgravo(String id_agravo) {
        if (id_agravo.equals("X29")) {
            return "Acidente por Animais Pe\u00e7onhentos";
        }
        if (id_agravo.equals("Z209")) {
            return "Acidente de Trabalho com Exposi\u00e7\u00e3o a Material Biol\u00f3gico";
        }
        if (id_agravo.equals("Y96")) {
            return "Acidente de Trabalho Grave";
        }
        if (id_agravo.equals("C80")) {
            return "Cancer Relacionado ao Trabalho";
        }
        if (id_agravo.equals("L989")) {
            return "Dermatoses Ocupacionais";
        }
        if (id_agravo.equals("J11")) {
            return "Influ\u00eanza Humana por Novo Subtipo (Pand\u00eamico)";
        }
        if (id_agravo.equals("Z579")) {
            return "LER DORT";
        }
        if (id_agravo.equals("F99")) {
            return "Transtorno Mental";
        }
        if (id_agravo.equals("H833")) {
            return "PAIR";
        }
        if (id_agravo.equals("J64")) {
            return "Pneumoconiose";
        }
        if (id_agravo.equals("B24")) {
            return "AIDS";
        }
        if (id_agravo.equals("W64")) {
            return "Atendimento Anti-R\u00e1bico Humano";
        }
        if (id_agravo.equals("A051")) {
            return "Botulismo";
        }
        if (id_agravo.equals("A229")) {
            return "Carb\u00fanculo ou Antraz";
        }
        if (id_agravo.equals("A009")) {
            return "C\u00f3lera";
        }
        if (id_agravo.equals("A379")) {
            return "Coqueluche";
        }
        if (id_agravo.equals("A90")) {
            return "Dengue";
        }
        if (id_agravo.equals("A369")) {
            return "Difteria";
        }
        if (id_agravo.equals("B571")) {
            return "Doen\u00e7as de Chagas Aguda";
        }
        if (id_agravo.equals("A810")) {
            return "Doen\u00e7a de Creutzfeldt-Jacob";
        }
        if (id_agravo.equals("B09")) {
            return "Doen\u00e7as Exantem\u00e1ticas";
        }
        if (id_agravo.equals("EPI")) {
            return "Epizootia";
        }
        if (id_agravo.equals("B659")) {
            return "Esquistossomose";
        }
        if (id_agravo.equals("Y59")) {
            return "Eventos Adversos P\u00f3s-vacina";
        }
        if (id_agravo.equals("A959")) {
            return "Febre Amarela";
        }
        if (id_agravo.equals("A923")) {
            return "Febre do Nilo";
        }
        if (id_agravo.equals("A779")) {
            return "Febre Maculosa";
        }
        if (id_agravo.equals("A010")) {
            return "Febre Tif\u00f3ide";
        }
        if (id_agravo.equals("Z21")) {
            return "Gestantes HIV +";
        }
        if (id_agravo.equals("A309")) {
            return "Hansen\u00edase";
        }
        if (id_agravo.equals("A988")) {
            return "Hantaviroses";
        }
        if (id_agravo.equals("B19")) {
            return "Hepatites Virais";
        }
        if (id_agravo.equals("T659")) {
            return "Intoxica\u00e7\u00f5es Ex\u00f3genas";
        }
        if (id_agravo.equals("B551")) {
            return "Leishmaniose Tegumentar Americana";
        }
        if (id_agravo.equals("B550")) {
            return "Leishmaniose Visceral";
        }
        if (id_agravo.equals("A279")) {
            return "Leptospirose";
        }
        if (id_agravo.equals("B54")) {
            return "Mal\u00e1ria";
        }
        if (id_agravo.equals("G039")) {
            return "Meningite";
        }
        if (id_agravo.equals("A809")) {
            return "Paralisia Fl\u00e1cida Aguda/Poliomielite";
        }
        if (id_agravo.equals("A209")) {
            return "Peste";
        }
        if (id_agravo.equals("A829")) {
            return "Raiva Humana";
        }
        if (id_agravo.equals("A080")) {
            return "Rotavirus";
        }
        if (id_agravo.equals("A539")) {
            return "S\u00edfilis Adquirida";
        }
        if (id_agravo.equals("A509")) {
            return "S\u00edfilis Cong\u00eanita";
        }
        if (id_agravo.equals("O981")) {
            return "S\u00edfilis em Gestante";
        }
        if (id_agravo.equals("D699")) {
            return "S\u00edndrome da Febre hemorr\u00e1gica Aguda";
        }
        if (id_agravo.equals("N199")) {
            return "S\u00edndrome da Insufici\u00eancia Renal Aguda";
        }
        if (id_agravo.equals("P350")) {
            return "S\u00edndrome da Rub\u00e9ola Cong\u00eanita";
        }
        if (id_agravo.equals("R36")) {
            return "S\u00edndrome do Corrimento Uretral Masculino";
        }
        if (id_agravo.equals("A08")) {
            return "S\u00edndrome Diarr\u00e9ica Aguda";
        }
        if (id_agravo.equals("R17")) {
            return "S\u00edndrome Ict\u00e9rica Aguda";
        }
        if (id_agravo.equals("G043")) {
            return "S\u00edndrome Neurol\u00f3gica Aguda";
        }
        if (id_agravo.equals("J07")) {
            return "S\u00edndrome Respirat\u00f3ria Aguda";
        }
        if (id_agravo.equals("R699")) {
            return "Outras S\u00edndromes";
        }
        if (id_agravo.equals("A35")) {
            return "T\u00e9tano Acidental";
        }
        if (id_agravo.equals("A33")) {
            return "T\u00e9tano Neonatal";
        }
        if (id_agravo.equals("A719")) {
            return "Tracoma";
        }
        if (id_agravo.equals("A169")) {
            return "Tuberculose";
        }
        if (id_agravo.equals("A219")) {
            return "Tularemia";
        }
        if (id_agravo.equals("B03")) {
            return "Var\u00edola";
        }
        if (id_agravo.equals("B019")) {
            return "Varicela";
        }
        if (id_agravo.equals("Y09")) {
            return "Viol\u00eancia dom\u00e9stica, sexual e/ou outras viol\u00eancias";
        }
        return id_agravo;
    }

    public Boolean possuiCampo(String id_agravo, String campo, JCheckBox checkBox) {
        if (!checkBox.isSelected()) {
            return true;
        }
        if (id_agravo.equals("X29")) {
            return SinanUtil.verificaCampos("acidente_animais_peconhentos.txt", campo);
        }
        if (id_agravo.equals("Z209")) {
            return SinanUtil.verificaCampos("acidente_trabalho_biologico.txt", campo);
        }
        if (id_agravo.equals("Y96")) {
            return SinanUtil.verificaCampos("acidente_trabalho_grave.txt", campo);
        }
        if (id_agravo.equals("C80")) {
            return SinanUtil.verificaCampos("cancer_relacionado_trabalho.txt", campo);
        }
        if (id_agravo.equals("L989")) {
            return SinanUtil.verificaCampos("dermatoses_ocupacionais.txt", campo);
        }
        if (id_agravo.equals("J11")) {
            return SinanUtil.verificaCampos("influenza.txt", campo);
        }
        if (id_agravo.equals("Z579")) {
            return SinanUtil.verificaCampos("ler_dort.txt", campo);
        }
        if (id_agravo.equals("F99")) {
            return SinanUtil.verificaCampos("transtornos_mentais_relacionados_trabalho.txt", campo);
        }
        if (id_agravo.equals("H833")) {
            return SinanUtil.verificaCampos("pair.txt", campo);
        }
        if (id_agravo.equals("J64")) {
            return SinanUtil.verificaCampos("pneumoconioses.txt", campo);
        }
        if (id_agravo.equals("B24")) {
            return SinanUtil.verificaCampos("aids.txt", campo);
        }
        if (id_agravo.equals("W64")) {
            return SinanUtil.verificaCampos("atendimento_anti_rabico.txt", campo);
        }
        if (id_agravo.equals("A051")) {
            return SinanUtil.verificaCampos("botulismo.txt", campo);
        }
        if (id_agravo.equals("A229")) {
            return true;
        }
        if (id_agravo.equals("A009")) {
            return SinanUtil.verificaCampos("colera.txt", campo);
        }
        if (id_agravo.equals("A379")) {
            return SinanUtil.verificaCampos("coqueluche.txt", campo);
        }
        if (id_agravo.equals("A90")) {
            return SinanUtil.verificaCampos("dengue.txt", campo);
        }
        if (id_agravo.equals("A369")) {
            return SinanUtil.verificaCampos("difiteria.txt", campo);
        }
        if (id_agravo.equals("B571")) {
            return SinanUtil.verificaCampos("chagas.txt", campo);
        }
        if (id_agravo.equals("A810")) {
            return true;
        }
        if (id_agravo.equals("EPI")) {
            return SinanUtil.verificaCampos("epizootia.txt", campo);
        }
        if (id_agravo.equals("B09")) {
            return SinanUtil.verificaCampos("exantematica.txt", campo);
        }
        if (id_agravo.equals("B659")) {
            return SinanUtil.verificaCampos("esquistossomose.txt", campo);
        }
        if (id_agravo.equals("Y59")) {
            return true;
        }
        if (id_agravo.equals("A959")) {
            return SinanUtil.verificaCampos("febre_amarela.txt", campo);
        }
        if (id_agravo.equals("A923")) {
            return SinanUtil.verificaCampos("febre_nilo.txt", campo);
        }
        if (id_agravo.equals("A779")) {
            return SinanUtil.verificaCampos("febre_maculosa.txt", campo);
        }
        if (id_agravo.equals("A010")) {
            return SinanUtil.verificaCampos("febre_tifoide.txt", campo);
        }
        if (id_agravo.equals("Z21")) {
            return SinanUtil.verificaCampos("gestante_hiv.txt", campo);
        }
        if (id_agravo.equals("A309")) {
            return SinanUtil.verificaCampos("hanseniase.txt", campo);
        }
        if (id_agravo.equals("A988")) {
            return SinanUtil.verificaCampos("hantavirose.txt", campo);
        }
        if (id_agravo.equals("B19")) {
            return SinanUtil.verificaCampos("hepatites_virais.txt", campo);
        }
        if (id_agravo.equals("T659")) {
            return SinanUtil.verificaCampos("intoxicacao_exogena.txt", campo);
        }
        if (id_agravo.equals("B551")) {
            return SinanUtil.verificaCampos("leishimaniose_tegumentar_americana.txt", campo);
        }
        if (id_agravo.equals("B550")) {
            return SinanUtil.verificaCampos("leishimaniose_visceral.txt", campo);
        }
        if (id_agravo.equals("A279")) {
            return SinanUtil.verificaCampos("leptospirose.txt", campo);
        }
        if (id_agravo.equals("B54")) {
            return SinanUtil.verificaCampos("malaria.txt", campo);
        }
        if (id_agravo.equals("G039")) {
            return SinanUtil.verificaCampos("meningite.txt", campo);
        }
        if (id_agravo.equals("A809")) {
            return SinanUtil.verificaCampos("paralisia_flacida_aguda.txt", campo);
        }
        if (id_agravo.equals("A209")) {
            return SinanUtil.verificaCampos("peste.txt", campo);
        }
        if (id_agravo.equals("A829")) {
            return SinanUtil.verificaCampos("raiva_humana.txt", campo);
        }
        if (id_agravo.equals("A080")) {
            return SinanUtil.verificaCampos("rotavirus.txt", campo);
        }
        if (id_agravo.equals("A539")) {
            return true;
        }
        if (id_agravo.equals("A509")) {
            return SinanUtil.verificaCampos("sifilis_congenita.txt", campo);
        }
        if (id_agravo.equals("O981")) {
            return SinanUtil.verificaCampos("sifilis_gestante.txt", campo);
        }
        if (id_agravo.equals("D699")) {
            return true;
        }
        if (id_agravo.equals("N199")) {
            return true;
        }
        if (id_agravo.equals("P350")) {
            return SinanUtil.verificaCampos("sindrome_rubeola_congenita.txt", campo);
        }
        if (id_agravo.equals("R36")) {
            return true;
        }
        if (id_agravo.equals("A08")) {
            return true;
        }
        if (id_agravo.equals("R17")) {
            return true;
        }
        if (id_agravo.equals("G043")) {
            return true;
        }
        if (id_agravo.equals("J07")) {
            return true;
        }
        if (id_agravo.equals("R699")) {
            return true;
        }
        if (id_agravo.equals("A35")) {
            return SinanUtil.verificaCampos("tetano_acidental.txt", campo);
        }
        if (id_agravo.equals("A33")) {
            return SinanUtil.verificaCampos("tetano_neonatal.txt", campo);
        }
        if (id_agravo.equals("A719")) {
            return SinanUtil.verificaCampos("tracoma.txt", campo);
        }
        if (id_agravo.equals("A169")) {
            return SinanUtil.verificaCampos("tuberculose.txt", campo);
        }
        if (id_agravo.equals("A219")) {
            return true;
        }
        if (id_agravo.equals("B03")) {
            return true;
        }
        if (id_agravo.equals("B019")) {
            return true;
        }
        if (id_agravo.equals("Y09")) {
            return SinanUtil.verificaCampos("violencia.txt", campo);
        }
        return true;
    }

    public void setArquivo(String conteudo) {
        try {
            FileWriter arquivo = new FileWriter(this.parametros.get("diretorioSalvar") + this.parametros.get("arquivoSalvar") + ".csv", true);
            arquivo.write(conteudo + "\r\n");
            arquivo.close();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }
}

