/*
 * Decompiled with CFR 0.152.
 */
package com.org.service;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.beans.CampoDBF;
import com.org.beans.RegiaoRegularidade;
import com.org.beans.RegiaoSaudePQAVS;
import com.org.beans.UFPQAVS;
import com.org.facade.SessionFacadeImpl;
import com.org.model.classes.Agravo;
import com.org.model.classes.Municipio;
import com.org.model.classes.UF;
import com.org.model.classes.agravos.oportunidade.OportunidadeAgravoPQAVS;
import com.org.util.Report;
import com.org.util.SinanDateUtil;
import com.org.util.SinanUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public class OportunidadePQAVSServicePactuacao
extends Agravo {
    public void gerarRelatorioPQAVS(List<RegiaoSaudePQAVS> listaRegiaoSaude, Map parametros, int countFields) throws IOException {
        Report report = new Report();
        JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource(listaRegiaoSaude);
        parametros.put("TITULO", "Encerramento Oportuno");
        report.adionarParametrosPadrao(parametros);
        report.gerarRelatorio((JRDataSource)jrds, parametros, "oportunidadePQAVSPactuacao.jasper", Boolean.TRUE);
    }

    public void gerarRelatorioPQAVSUFRegiaoSaude(List<UFPQAVS> lista, Map parametros, int countFields, String isDBF) throws IOException {
        Report report = new Report();
        JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource(lista);
        parametros.put("TITULO", "Encerramento Oportuno");
        report.adionarParametrosPadrao(parametros);
        report.gerarRelatorio((JRDataSource)jrds, parametros, "oportunidadePQAVSPactuacao.jasper", Boolean.TRUE);
    }

    public void somatorio(List<RegiaoSaudePQAVS> listaRegiaoSaude, Map parametros) {
        int countTotalMunic = 0;
        int countTotalOport = 0;
        int countTotalNot = 0;
        for (RegiaoSaudePQAVS regiaoSaude : listaRegiaoSaude) {
            int countOport = 0;
            int countNotif = 0;
            countTotalMunic += regiaoSaude.getLista().size();
            for (OportunidadeAgravoPQAVS municipio : regiaoSaude.getLista()) {
                countOport += municipio.getQtdOportuno().intValue();
                countNotif += municipio.getTotal().intValue();
                regiaoSaude.setUf(municipio.getUf());
            }
            regiaoSaude.setQtdOportuno(countOport);
            regiaoSaude.setTotal(countNotif);
            countTotalOport += countOport;
            countTotalNot += countNotif;
        }
        parametros.put("TOTAL1", "" + countTotalMunic);
        parametros.put("TOTAL2", "" + countTotalOport);
        parametros.put("TOTAL3", "" + countTotalNot);
    }

    public void somatorioUFRegiaoSaude(List<UFPQAVS> listaUF, Map parametros) {
        int countTotalRegiao = 0;
        int countTotalOport = 0;
        int countTotalNot = 0;
        for (UFPQAVS uf : listaUF) {
            int countOport = 0;
            int countNotif = 0;
            countTotalRegiao += uf.getLista().size();
            for (RegiaoSaudePQAVS regiaoSaude : uf.getLista()) {
                countOport += regiaoSaude.getQtdOportuno().intValue();
                countNotif += regiaoSaude.getTotal().intValue();
            }
            uf.setQtdOportuno(countOport);
            uf.setTotal(countNotif);
            countTotalOport += countOport;
            countTotalNot += countNotif;
        }
        parametros.put("TOTAL1", "" + countTotalRegiao);
        parametros.put("TOTAL2", "" + countTotalOport);
        parametros.put("TOTAL3", "" + countTotalNot);
    }

    @Deprecated
    public void gerarRelatorioPropMunicIrreg(List<Municipio> listaMunicipio, Map parametros, int countFields, String isDBF, boolean calculaBrasil) throws IOException {
        List<RegiaoRegularidade> listaRegiaoRegularidade = this.agruparPorRegiaoUF(listaMunicipio);
        this.calculaMunicipio(listaRegiaoRegularidade);
        this.calculaBrasil(listaRegiaoRegularidade, parametros, calculaBrasil);
        this.calculaRegiao(listaRegiaoRegularidade);
        Report report = new Report();
        JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource(listaRegiaoRegularidade);
        parametros.put("TITULO", "Munic\u00edpios Irregulares na Alimenta\u00e7\u00e3o do Sinan");
        report.adionarParametrosPadrao(parametros);
        report.gerarRelatorio((JRDataSource)jrds, parametros, "regularidade2.jasper", Boolean.TRUE);
    }

    private void calculaMunicipio(List<RegiaoRegularidade> listaRegiaoRegularidade) {
        for (RegiaoRegularidade regiaoRegularidade : listaRegiaoRegularidade) {
            for (UF uf : regiaoRegularidade.getListaUF()) {
                int qtdeMunic = 0;
                double qtdeIrregular = 0.0;
                for (Municipio municipio : regiaoRegularidade.getListaMunicipio()) {
                    if (!uf.getNmUF().equals(municipio.getUf().getNmUF())) continue;
                    if (municipio.isIrregular()) {
                        uf.setQtdMunicipiosSemNotificacao(uf.getQtdMunicipiosSemNotificacao() + 1);
                        qtdeIrregular += 1.0;
                    }
                    uf.setQtdMunicipios(uf.getQtdMunicipios() + 1);
                    ++qtdeMunic;
                }
                if (qtdeMunic != 0) {
                    uf.setPercentualIrregular(SinanUtil.converterDoubleDuasDecimais(qtdeIrregular / (double)qtdeMunic * 100.0));
                }
                uf.setNmUF(SinanUtil.siglaUFToNomeUF(uf.getNmUF()));
            }
        }
    }

    private void calculaRegiao(List<RegiaoRegularidade> listaRegiaoRegularidade) {
        for (RegiaoRegularidade regiaoRegularidade : listaRegiaoRegularidade) {
            int qtdeMunic = 0;
            double qtdeIrregular = 0.0;
            for (UF uf : regiaoRegularidade.getListaUF()) {
                qtdeMunic += uf.getQtdMunicipios();
                qtdeIrregular += (double)uf.getQtdMunicipiosSemNotificacao();
            }
            regiaoRegularidade.setQtdeMunicipio(qtdeMunic);
            regiaoRegularidade.setQtdeMunicIrregular((int)qtdeIrregular);
            regiaoRegularidade.setPercetualIrregular(SinanUtil.converterDoubleDuasDecimais(qtdeIrregular / (double)qtdeMunic * 100.0));
        }
    }

    private void calculaBrasil(List<RegiaoRegularidade> listaRegiaoRegularidade, Map<String, String> parametros, boolean calculaBrasil) {
        int qtdeMunic = 0;
        double qtdeIrregular = 0.0;
        double percentual = 0.0;
        for (RegiaoRegularidade regiaoRegularidade : listaRegiaoRegularidade) {
            for (UF uf : regiaoRegularidade.getListaUF()) {
                qtdeMunic += uf.getQtdMunicipios();
                qtdeIrregular += (double)uf.getQtdMunicipiosSemNotificacao();
            }
            SinanUtil.ordenaLista(regiaoRegularidade.getListaUF(), "nmUF");
        }
        percentual = SinanUtil.converterDoubleDuasDecimais(qtdeIrregular / (double)qtdeMunic * 100.0);
        if (calculaBrasil) {
            parametros.put("BRASIL1", qtdeMunic + "");
            parametros.put("BRASIL2", (int)qtdeIrregular + "");
            parametros.put("BRASIL3", percentual + "");
        } else {
            parametros.put("BRASIL1", "");
            parametros.put("BRASIL2", "");
            parametros.put("BRASIL3", "");
        }
    }

    private List<RegiaoRegularidade> agruparPorRegiaoUF(List<Municipio> listaMunicipio) {
        List<RegiaoRegularidade> listaRegiaoRegularidade = this.agruparPorRegiao(listaMunicipio);
        Map<Object, Object> mapaUF = new HashMap();
        if (!SinanUtil.isListEmpty(listaRegiaoRegularidade)) {
            for (RegiaoRegularidade regiao : listaRegiaoRegularidade) {
                if (SinanUtil.isListEmpty(regiao.getListaMunicipio())) continue;
                mapaUF = this.mapearUF(regiao.getListaMunicipio());
                Iterator<Map.Entry<Object, Object>> entries = mapaUF.entrySet().iterator();
                ArrayList<UF> listaUF = new ArrayList<UF>();
                while (entries.hasNext()) {
                    UF uf = new UF();
                    Map.Entry<Object, Object> thisEntry = entries.next();
                    uf.setNmUF(thisEntry.getValue().toString());
                    listaUF.add(uf);
                }
                regiao.setListaUF(listaUF);
            }
        }
        return listaRegiaoRegularidade;
    }

    private Map<String, String> mapearUF(List<Municipio> listaMunicipio) {
        HashMap<String, String> mapaUF = new HashMap<String, String>();
        for (Municipio municipio : listaMunicipio) {
            if (mapaUF.containsKey(municipio.getUf().getNmUF())) continue;
            mapaUF.put(municipio.getUf().getNmUF(), municipio.getUf().getNmUF());
        }
        return mapaUF;
    }

    public Map<String, List<OportunidadeAgravoPQAVS>> agruparRegiaoSaude(List<OportunidadeAgravoPQAVS> listaBean) {
        HashMap<String, List<OportunidadeAgravoPQAVS>> mapaRegiaoSaude = new HashMap<String, List<OportunidadeAgravoPQAVS>>();
        listaBean = SinanUtil.removeMunicipiosIgnoradosPQAVS(listaBean);
        for (OportunidadeAgravoPQAVS bean : listaBean) {
            if (bean.getNmAgravo().equals("TOTAL")) continue;
            List<OportunidadeAgravoPQAVS> listaMunicipios = new ArrayList<OportunidadeAgravoPQAVS>();
            if (bean.getUf() != null && bean.getUf().equals("DF")) {
                bean.setNmAgravo("BRASILIA");
            }
            if (mapaRegiaoSaude.containsKey(bean.getUf() + "       " + bean.getRegiaoSaude())) {
                listaMunicipios = (List)mapaRegiaoSaude.get(bean.getUf() + "       " + bean.getRegiaoSaude());
            }
            listaMunicipios.add(bean);
            SinanUtil.ordenaLista(listaMunicipios, "nmAgravo");
            mapaRegiaoSaude.put(bean.getUf() + "       " + bean.getRegiaoSaude(), listaMunicipios);
        }
        return mapaRegiaoSaude;
    }

    public Map<String, List<OportunidadeAgravoPQAVS>> agruparRegionalSaude(List<OportunidadeAgravoPQAVS> listaBean) {
        HashMap<String, List<OportunidadeAgravoPQAVS>> mapaRegiaoSaude = new HashMap<String, List<OportunidadeAgravoPQAVS>>();
        listaBean = SinanUtil.removeMunicipiosIgnoradosPQAVS(listaBean);
        for (OportunidadeAgravoPQAVS bean : listaBean) {
            if (bean.getNmAgravo().equals("TOTAL")) continue;
            List<OportunidadeAgravoPQAVS> listaMunicipios = new ArrayList<OportunidadeAgravoPQAVS>();
            if (bean.getUf() != null && bean.getUf().equals("DF")) {
                bean.setNmAgravo("BRASILIA");
            }
            if (mapaRegiaoSaude.containsKey(bean.getUf() + "       " + bean.getRegionalSaude())) {
                listaMunicipios = (List)mapaRegiaoSaude.get(bean.getUf() + "       " + bean.getRegionalSaude());
            }
            listaMunicipios.add(bean);
            SinanUtil.ordenaLista(listaMunicipios, "nmAgravo");
            mapaRegiaoSaude.put(bean.getUf() + "       " + bean.getRegionalSaude(), listaMunicipios);
        }
        return mapaRegiaoSaude;
    }

    public Map<String, List<OportunidadeAgravoPQAVS>> agruparRegiaoSaude2(List<OportunidadeAgravoPQAVS> listaBean) {
        HashMap<String, List<OportunidadeAgravoPQAVS>> mapaRegiaoSaude = new HashMap<String, List<OportunidadeAgravoPQAVS>>();
        listaBean = SinanUtil.removeMunicipiosIgnoradosPQAVS(listaBean);
        for (OportunidadeAgravoPQAVS bean : listaBean) {
            if (bean.getNmAgravo().equals("TOTAL")) continue;
            List<OportunidadeAgravoPQAVS> listaMunicipios = new ArrayList<OportunidadeAgravoPQAVS>();
            if (bean.getUf() != null && bean.getUf().equals("DF")) {
                bean.setNmAgravo("BRASILIA");
            }
            if (mapaRegiaoSaude.containsKey(bean.getCodRegiaoSaude())) {
                listaMunicipios = (List)mapaRegiaoSaude.get(bean.getCodRegiaoSaude());
            }
            listaMunicipios.add(bean);
            SinanUtil.ordenaLista(listaMunicipios, "nmAgravo");
            mapaRegiaoSaude.put(bean.getCodRegiaoSaude(), listaMunicipios);
        }
        return mapaRegiaoSaude;
    }

    public Map<String, List<OportunidadeAgravoPQAVS>> agruparRegionalSaude2(List<OportunidadeAgravoPQAVS> listaBean) {
        HashMap<String, List<OportunidadeAgravoPQAVS>> mapaRegiaoSaude = new HashMap<String, List<OportunidadeAgravoPQAVS>>();
        listaBean = SinanUtil.removeMunicipiosIgnoradosPQAVS(listaBean);
        for (OportunidadeAgravoPQAVS bean : listaBean) {
            if (bean.getNmAgravo().equals("TOTAL")) continue;
            List<OportunidadeAgravoPQAVS> listaMunicipios = new ArrayList<OportunidadeAgravoPQAVS>();
            if (bean.getUf() != null && bean.getUf().equals("DF")) {
                bean.setNmAgravo("BRASILIA");
            }
            if (mapaRegiaoSaude.containsKey(bean.getCodRegionalSaude())) {
                listaMunicipios = (List)mapaRegiaoSaude.get(bean.getCodRegionalSaude());
            }
            if (bean.getCodRegionalSaude() == null) continue;
            listaMunicipios.add(bean);
            SinanUtil.ordenaLista(listaMunicipios, "nmAgravo");
            mapaRegiaoSaude.put(bean.getCodRegionalSaude(), listaMunicipios);
        }
        return mapaRegiaoSaude;
    }

    public Map<String, List<RegiaoSaudePQAVS>> agruparUFRegiaoSaude2(List<RegiaoSaudePQAVS> listaBean) {
        HashMap<String, List<RegiaoSaudePQAVS>> mapaRegiaoSaude = new HashMap<String, List<RegiaoSaudePQAVS>>();
        for (RegiaoSaudePQAVS bean : listaBean) {
            List<RegiaoSaudePQAVS> listaRegiaoSaude = new ArrayList<RegiaoSaudePQAVS>();
            if (bean.getUf() != null && bean.getUf().equals("DF")) {
                bean.setNmAgravo("BRASILIA");
            }
            if (mapaRegiaoSaude.containsKey(bean.getUf())) {
                listaRegiaoSaude = (List)mapaRegiaoSaude.get(bean.getUf());
            }
            listaRegiaoSaude.add(bean);
            mapaRegiaoSaude.put(bean.getUf(), listaRegiaoSaude);
        }
        return mapaRegiaoSaude;
    }

    public List<UFPQAVS> converterMapaUFRegiaoSaudeEmLista(Map<String, List<RegiaoSaudePQAVS>> mapaUF, Map parametros) {
        ArrayList<UFPQAVS> listaUF = new ArrayList<UFPQAVS>();
        int count = 0;
        Iterator<Map.Entry<String, List<RegiaoSaudePQAVS>>> entries = mapaUF.entrySet().iterator();
        while (entries.hasNext()) {
            ++count;
            Map.Entry<String, List<RegiaoSaudePQAVS>> thisEntry = entries.next();
            SinanUtil.ordenaLista(mapaUF.get(thisEntry.getKey()), "nmAgravo");
            UFPQAVS uf = new UFPQAVS(thisEntry.getKey().toString(), mapaUF.get(thisEntry.getKey()));
            uf.setNmAgravo(SinanUtil.siglaUFToNomeUF(uf.getNmAgravo()));
            listaUF.add(uf);
        }
        SinanUtil.ordenaLista(listaUF, "nmAgravo");
        this.somatorioUFRegiaoSaude(listaUF, parametros);
        return listaUF;
    }

    public List<RegiaoSaudePQAVS> converterMapaRegiaoSaudeEmLista(Map<String, List<OportunidadeAgravoPQAVS>> mapaRegiaoSaude, Map parametros) {
        ArrayList<RegiaoSaudePQAVS> listaRegiaoSaude = new ArrayList<RegiaoSaudePQAVS>();
        int count = 0;
        Iterator<Map.Entry<String, List<OportunidadeAgravoPQAVS>>> entries = mapaRegiaoSaude.entrySet().iterator();
        while (entries.hasNext()) {
            ++count;
            Map.Entry<String, List<OportunidadeAgravoPQAVS>> thisEntry = entries.next();
            SinanUtil.ordenaLista(mapaRegiaoSaude.get(thisEntry.getKey()), "nmAgravo");
            RegiaoSaudePQAVS regiaoSaude = new RegiaoSaudePQAVS(thisEntry.getKey().toString(), OportunidadePQAVSServicePactuacao.regiaoSaudeNome(thisEntry.getKey().toString()), mapaRegiaoSaude.get(thisEntry.getKey()));
            listaRegiaoSaude.add(regiaoSaude);
        }
        SinanUtil.ordenaLista(listaRegiaoSaude, "nmAgravo");
        this.somatorio(listaRegiaoSaude, parametros);
        return listaRegiaoSaude;
    }

    public List<RegiaoSaudePQAVS> converterMapaRegionalSaudeEmLista(Map<String, List<OportunidadeAgravoPQAVS>> mapaRegiaoSaude, Map parametros) {
        ArrayList<RegiaoSaudePQAVS> listaRegiaoSaude = new ArrayList<RegiaoSaudePQAVS>();
        int count = 0;
        Iterator<Map.Entry<String, List<OportunidadeAgravoPQAVS>>> entries = mapaRegiaoSaude.entrySet().iterator();
        while (entries.hasNext()) {
            ++count;
            Map.Entry<String, List<OportunidadeAgravoPQAVS>> thisEntry = entries.next();
            SinanUtil.ordenaLista(mapaRegiaoSaude.get(thisEntry.getKey()), "nmAgravo");
            RegiaoSaudePQAVS regiaoSaude = new RegiaoSaudePQAVS(thisEntry.getKey().toString(), OportunidadePQAVSServicePactuacao.regionalSaudeNome(thisEntry.getKey().toString()), mapaRegiaoSaude.get(thisEntry.getKey()));
            listaRegiaoSaude.add(regiaoSaude);
        }
        SinanUtil.ordenaLista(listaRegiaoSaude, "nmAgravo");
        this.somatorio(listaRegiaoSaude, parametros);
        return listaRegiaoSaude;
    }

    public static String regiaoSaudeNome(String idRegiaoSaude) {
        DBFReader reader = OportunidadePQAVSServicePactuacao.retornaObjetoDbfCaminhoArquivo("REGIAO", "dbf\\");
        DBFUtil utilDbf = new DBFUtil();
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            while ((rowObjects = reader.nextRecord()) != null) {
                if (!idRegiaoSaude.equals(utilDbf.getString(rowObjects, "ID_REGIAO"))) continue;
                return utilDbf.getString(rowObjects, "NM_REGIAO");
            }
        }
        catch (DBFException e) {
            Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro ao carregar regi\u00e3o de sa\u00fade:\n" + (Object)((Object)e));
        }
        return idRegiaoSaude;
    }

    public static String regionalSaudeNome(String idRegiaoSaude) {
        DBFReader reader = OportunidadePQAVSServicePactuacao.retornaObjetoDbfCaminhoArquivo("REGIONET", "dbf\\");
        DBFUtil utilDbf = new DBFUtil();
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            while ((rowObjects = reader.nextRecord()) != null) {
                if (!idRegiaoSaude.equals(utilDbf.getString(rowObjects, "ID_REGIONA"))) continue;
                return utilDbf.getString(rowObjects, "NM_REGIONA");
            }
        }
        catch (DBFException e) {
            Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro ao carregar regi\u00e3o de sa\u00fade:\n" + (Object)((Object)e));
        }
        return idRegiaoSaude;
    }

    public static DBFReader retornaObjetoDbfCaminhoArquivo(String arquivo, String caminho) {
        DBFReader reader = null;
        FileInputStream inputStream = null;
        try {
            inputStream = System.getProperty("os.name").compareTo("Linux") == 0 ? new FileInputStream(caminho.replace("\\", "/") + arquivo + ".DBF") : new FileInputStream(caminho + arquivo + ".DBF");
        }
        catch (FileNotFoundException e) {
            Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro: tabela " + arquivo + ".dbf nao encontrada.\n" + e);
            return reader;
        }
        try {
            reader = new DBFReader((InputStream)inputStream);
        }
        catch (DBFException e) {
            Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro: tabela " + arquivo + ".dbf nao encontrada.\n" + (Object)((Object)e));
        }
        return reader;
    }

    private List<RegiaoRegularidade> agruparPorRegiao(List<Municipio> listaMunicipio) {
        ArrayList<RegiaoRegularidade> listaRegiaoRegularidade = new ArrayList<RegiaoRegularidade>();
        ArrayList<Municipio> listaNorte = new ArrayList<Municipio>();
        RegiaoRegularidade regiaoNorte = new RegiaoRegularidade();
        regiaoNorte.setNome("Norte");
        ArrayList<Municipio> listaNordeste = new ArrayList<Municipio>();
        RegiaoRegularidade regiaoNordeste = new RegiaoRegularidade();
        regiaoNordeste.setNome("Nordeste");
        ArrayList<Municipio> listaCentroOeste = new ArrayList<Municipio>();
        RegiaoRegularidade regiaoCentroOeste = new RegiaoRegularidade();
        regiaoCentroOeste.setNome("Centro-oeste");
        ArrayList<Municipio> listaSudeste = new ArrayList<Municipio>();
        RegiaoRegularidade regiaoSudeste = new RegiaoRegularidade();
        regiaoSudeste.setNome("Sudeste");
        ArrayList<Municipio> listaSul = new ArrayList<Municipio>();
        RegiaoRegularidade regiaoSul = new RegiaoRegularidade();
        regiaoSul.setNome("Sul");
        if (!SinanUtil.isListEmpty(listaMunicipio)) {
            for (Municipio item : listaMunicipio) {
                if (item.getNmRegiao().equals("NORTE")) {
                    listaNorte.add(item);
                    continue;
                }
                if (item.getNmRegiao().equals("NORDESTE")) {
                    listaNordeste.add(item);
                    continue;
                }
                if (item.getNmRegiao().equals("CENTRO-OESTE")) {
                    listaCentroOeste.add(item);
                    continue;
                }
                if (item.getNmRegiao().equals("SUDESTE")) {
                    listaSudeste.add(item);
                    continue;
                }
                if (!item.getNmRegiao().equals("SUL")) continue;
                listaSul.add(item);
            }
            regiaoNorte.setListaMunicipio(listaNorte);
            regiaoNordeste.setListaMunicipio(listaNordeste);
            regiaoCentroOeste.setListaMunicipio(listaCentroOeste);
            regiaoSudeste.setListaMunicipio(listaSudeste);
            regiaoSul.setListaMunicipio(listaSul);
        }
        if (!SinanUtil.isListEmpty(regiaoNorte.getListaMunicipio())) {
            listaRegiaoRegularidade.add(regiaoNorte);
        }
        if (!SinanUtil.isListEmpty(regiaoNordeste.getListaMunicipio())) {
            listaRegiaoRegularidade.add(regiaoNordeste);
        }
        if (!SinanUtil.isListEmpty(regiaoCentroOeste.getListaMunicipio())) {
            listaRegiaoRegularidade.add(regiaoCentroOeste);
        }
        if (!SinanUtil.isListEmpty(regiaoSudeste.getListaMunicipio())) {
            listaRegiaoRegularidade.add(regiaoSudeste);
        }
        if (!SinanUtil.isListEmpty(regiaoSul.getListaMunicipio())) {
            listaRegiaoRegularidade.add(regiaoSul);
        }
        return listaRegiaoRegularidade;
    }

    public void gerarDBFPQAVSDefineCampos(List<OportunidadeAgravoPQAVS> lista, Map parametros) throws IOException {
        int numCol = 0;
        Boolean naoPedeMunicipios = (Boolean)parametros.get("parDiscriminarPorAgravo") != false || (Boolean)parametros.get("parSomenteMunicipios") != false || (Boolean)parametros.get("parNenhum") != false;
        numCol = naoPedeMunicipios != false ? 10 : 12;
        DBFField[] fields = new DBFField[numCol];
        int i = 0;
        CampoDBF field = new CampoDBF("COUFRES", "String", 2, 0);
        fields[i] = field;
        if (!((Boolean)parametros.get("parSomenteMunicipios")).booleanValue() && !((Boolean)parametros.get("parDiscriminarPorAgravo")).booleanValue()) {
            if (((Boolean)parametros.get("parIsRegional")).booleanValue()) {
                field = new CampoDBF("ID_REGION", "String", 5, 0);
                fields[++i] = field;
                field = new CampoDBF("REGIONAL", "String", 80, 0);
                fields[++i] = field;
            } else if (((Boolean)parametros.get("parIsRegiao")).booleanValue()) {
                field = new CampoDBF("COD_CIR", "String", 5, 0);
                fields[++i] = field;
                field = new CampoDBF("REGIAO", "String", 80, 0);
                fields[++i] = field;
            }
        }
        if (((Boolean)parametros.get("parDiscriminarPorAgravo")).booleanValue()) {
            field = new CampoDBF("CID10", "String", 6, 0);
            fields[++i] = field;
            field = new CampoDBF("AGRAVO", "String", 80, 0);
            fields[++i] = field;
        } else if (!((Boolean)parametros.get("parNenhum")).booleanValue()) {
            field = new CampoDBF("COD_IBGE", "String", 6, 0);
            fields[++i] = field;
            field = new CampoDBF("MUNICIPIO", "String", 80, 0);
            fields[++i] = field;
        }
        field = new CampoDBF("AUSEN_CASO", "String", 1, 0);
        fields[++i] = field;
        field = new CampoDBF("NUMERADOR", "String", 12, 0);
        fields[++i] = field;
        field = new CampoDBF("DENOMINAD", "String", 12, 0);
        fields[++i] = field;
        field = new CampoDBF("RESULTADO", "String", 12, 0);
        fields[++i] = field;
        field = new CampoDBF("ANO_NOTI", "String", 4, 0);
        fields[++i] = field;
        field = new CampoDBF("DT_NOTIN", "String", 12, 0);
        fields[++i] = field;
        field = new CampoDBF("DT_NOTIFI", "String", 12, 0);
        fields[++i] = field;
        this.prepareDataToDBFPQAVS(lista, fields, parametros, numCol);
    }

    private void prepareDataToDBFPQAVS(List<OportunidadeAgravoPQAVS> lista, DBFField[] fields, Map parametros, int countFields) throws IOException {
        DBFWriter writer = new DBFWriter();
        Integer somaOportuno = 0;
        Double somaTotal = 0.0;
        String sgUf = (String)parametros.get("parSgUf");
        String codUf = SinanUtil.siglaUFToIDUF(sgUf);
        writer.setFields(fields);
        lista = SinanUtil.removeMunicipiosIgnoradosPQAVS(lista);
        lista = this.calculaTotal(lista);
        int i = 0;
        for (OportunidadeAgravoPQAVS item : lista) {
            Object[] rowData = new Object[countFields];
            rowData[i] = (Boolean)parametros.get("parDiscriminarPorAgravo") == false ? item.getUf() : codUf;
            if (!((Boolean)parametros.get("parDiscriminarPorAgravo")).booleanValue() && !((Boolean)parametros.get("parSomenteMunicipios")).booleanValue()) {
                if (((Boolean)parametros.get("parIsRegional")).booleanValue()) {
                    rowData[++i] = item.getCodRegionalSaude();
                    rowData[++i] = item.getRegionalSaude();
                } else if (((Boolean)parametros.get("parIsRegiao")).booleanValue()) {
                    rowData[++i] = item.getCodRegiaoSaude();
                    rowData[++i] = item.getRegiaoSaude();
                }
            }
            if (!((Boolean)parametros.get("parNenhum")).booleanValue()) {
                rowData[++i] = item.getCodAgravo();
                rowData[++i] = item.getNmAgravo();
            }
            rowData[++i] = item.getTotal() == 0 ? "X" : "";
            rowData[++i] = item.getQtdOportuno().toString();
            somaOportuno = somaOportuno + item.getQtdOportuno();
            rowData[++i] = item.getTotal().toString();
            somaTotal = somaTotal + (double)item.getTotal().intValue();
            if (item.getQtdOportuno() > 0 && item.getTotal() > 0) {
                Double oportuno = (double)new Double(item.getQtdOportuno().intValue());
                Double total = (double)new Double(item.getTotal().intValue());
                rowData[++i] = String.valueOf(SinanUtil.converterDoubleUmaCasaDecimal(oportuno / total * 100.0));
                SinanUtil.imprimirConsole("Resultado sem converter" + oportuno / total * 100.0);
            } else {
                rowData[++i] = "0";
            }
            String dt_notin = "01/01/" + parametros.get("parAnoPeriodoAvaliacao").toString();
            String dt_notifi = "31/12/" + parametros.get("parAnoPeriodoAvaliacao").toString();
            if (parametros.get("parAnoPeriodoAvaliacao").toString().length() > 4) {
                dt_notin = this.alteraDataParaPadrao(parametros.get("parDataInicio").toString());
                dt_notifi = this.alteraDataParaPadrao(parametros.get("parDataFim60").toString());
            }
            rowData[++i] = String.valueOf(this.preencheAno(dt_notin, dt_notifi).intValue());
            rowData[++i] = dt_notin;
            rowData[++i] = dt_notifi;
            writer.addRecord(rowData);
            i = 0;
        }
        SinanUtil.setNomeArquivoDBF();
        SinanUtil.gerarDBF(writer);
    }

    private List calculaTotal(List<OportunidadeAgravoPQAVS> lista) {
        OportunidadeAgravoPQAVS elemento = new OportunidadeAgravoPQAVS();
        for (OportunidadeAgravoPQAVS elem : lista) {
            elemento.setTotal(elemento.getTotal() + elem.getTotal());
            elemento.setQtdOportuno(elemento.getQtdOportuno() + elem.getQtdOportuno());
        }
        elemento.setNmAgravo("TOTAL");
        lista.add(elemento);
        return lista;
    }

    private String alteraDataParaPadrao(String data) {
        String[] dataPadrao = data.split("-");
        return dataPadrao[2] + "/" + dataPadrao[1] + "/" + dataPadrao[0];
    }

    @Deprecated
    public void gerarDBFRegularidade(List<RegiaoRegularidade> lista, Map periodos, int countFields) throws IOException {
        DBFField[] fields = new DBFField[countFields];
        CampoDBF field = new CampoDBF("ID_MUNIC", "String", 7, 0);
        fields[0] = field;
        field = new CampoDBF("NM_MUNIC", "String", 30, 0);
        fields[1] = field;
        field = new CampoDBF("SG_UF", "String", 2, 0);
        fields[2] = field;
        field = new CampoDBF("DT_AVALIA", "String", 10, 0);
        fields[3] = field;
        if (periodos.get("periodo1") != null) {
            field = new CampoDBF("PERIODO01", "String", 2, 0);
            fields[4] = field;
        }
        if (periodos.get("periodo2") != null) {
            field = new CampoDBF("PERIODO02", "String", 2, 0);
            fields[5] = field;
        }
        if (periodos.get("periodo3") != null) {
            field = new CampoDBF("PERIODO03", "String", 2, 0);
            fields[6] = field;
        }
        if (periodos.get("periodo4") != null) {
            field = new CampoDBF("PERIODO04", "String", 2, 0);
            fields[7] = field;
        }
        if (periodos.get("periodo5") != null) {
            field = new CampoDBF("PERIODO05", "String", 2, 0);
            fields[8] = field;
        }
        if (periodos.get("periodo6") != null) {
            field = new CampoDBF("PERIODO06", "String", 2, 0);
            fields[9] = field;
        }
        if (periodos.get("periodo7") != null) {
            field = new CampoDBF("PERIODO07", "String", 2, 0);
            fields[10] = field;
        }
        if (periodos.get("periodo8") != null) {
            field = new CampoDBF("PERIODO08", "String", 2, 0);
            fields[11] = field;
        }
        if (periodos.get("periodo9") != null) {
            field = new CampoDBF("PERIODO09", "String", 2, 0);
            fields[12] = field;
        }
        if (periodos.get("periodo10") != null) {
            field = new CampoDBF("PERIODO10", "String", 2, 0);
            fields[13] = field;
        }
        if (periodos.get("periodo11") != null) {
            field = new CampoDBF("PERIODO11", "String", 2, 0);
            fields[14] = field;
        }
        if (periodos.get("periodo12") != null) {
            field = new CampoDBF("PERIODO12", "String", 2, 0);
            fields[15] = field;
        }
        if (periodos.get("periodo13") != null) {
            field = new CampoDBF("PERIODO13", "String", 2, 0);
            fields[16] = field;
        }
        if (periodos.get("periodo14") != null) {
            field = new CampoDBF("PERIODO14", "String", 2, 0);
            fields[17] = field;
        }
        if (periodos.get("periodo15") != null) {
            field = new CampoDBF("PERIODO15", "String", 2, 0);
            fields[18] = field;
        }
        if (periodos.get("periodo16") != null) {
            field = new CampoDBF("PERIODO16", "String", 2, 0);
            fields[19] = field;
        }
        if (periodos.get("periodo17") != null) {
            field = new CampoDBF("PERIODO17", "String", 2, 0);
            fields[20] = field;
        }
        if (periodos.get("periodo18") != null) {
            field = new CampoDBF("PERIODO18", "String", 2, 0);
            fields[21] = field;
        }
        this.prepareDataToDBF(lista, fields, countFields);
    }

    @Deprecated
    private void prepareDataToDBF(List<RegiaoRegularidade> lista, DBFField[] fields, int countFields) throws IOException {
        DBFWriter writer = new DBFWriter();
        writer.setFields(fields);
        for (RegiaoRegularidade regiao : lista) {
            for (Municipio item : regiao.getListaMunicipio()) {
                Object[] rowData = new Object[countFields];
                rowData[0] = item.getCodMunicipio();
                rowData[1] = item.getNmMunicipio();
                rowData[2] = item.getSgUF();
                rowData[3] = SinanDateUtil.currentDateString();
                if (countFields > 4) {
                    rowData[4] = item.getPeriodo1();
                }
                if (countFields > 5) {
                    rowData[5] = item.getPeriodo2();
                }
                if (countFields > 6) {
                    rowData[6] = item.getPeriodo3();
                }
                if (countFields > 7) {
                    rowData[7] = item.getPeriodo4();
                }
                if (countFields > 8) {
                    rowData[8] = item.getPeriodo5();
                }
                if (countFields > 9) {
                    rowData[9] = item.getPeriodo6();
                }
                if (countFields > 10) {
                    rowData[10] = item.getPeriodo7();
                }
                if (countFields > 11) {
                    rowData[11] = item.getPeriodo8();
                }
                if (countFields > 12) {
                    rowData[12] = item.getPeriodo9();
                }
                if (countFields > 13) {
                    rowData[13] = item.getPeriodo10();
                }
                if (countFields > 14) {
                    rowData[14] = item.getPeriodo11();
                }
                if (countFields > 15) {
                    rowData[15] = item.getPeriodo12();
                }
                if (countFields > 16) {
                    rowData[16] = item.getPeriodo13();
                }
                if (countFields > 17) {
                    rowData[17] = item.getPeriodo14();
                }
                if (countFields > 18) {
                    rowData[18] = item.getPeriodo15();
                }
                if (countFields > 19) {
                    rowData[19] = item.getPeriodo16();
                }
                if (countFields > 20) {
                    rowData[20] = item.getPeriodo17();
                }
                if (countFields > 21) {
                    rowData[21] = item.getPeriodo18();
                }
                writer.addRecord(rowData);
            }
        }
        SinanUtil.setNomeArquivoDBF();
        SinanUtil.gerarDBF(writer);
    }
}

