/*
 * Decompiled with CFR 0.152.
 */
package com.org.service;

import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFWriter;
import com.org.beans.CampoDBF;
import com.org.beans.RegiaoRegularidade;
import com.org.model.classes.Municipio;
import com.org.model.classes.UF;
import com.org.util.Report;
import com.org.util.SinanDateUtil;
import com.org.util.SinanUtil;
import com.org.view.Master;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;

public class RegiaoRegularidadeService {
    public void gerarRelatorioRegularidade(List<Municipio> listaMunicipio, Map parametros, int countFields, String isDBF) throws IOException {
        List<RegiaoRegularidade> listaRegiaoRegularidade = null;
        boolean porRegiao = (Boolean)parametros.get("parIsRegiao");
        boolean porRegional = (Boolean)parametros.get("parIsRegional");
        listaRegiaoRegularidade = porRegiao ? this.agruparPorRegiaoSaude(listaMunicipio, (String)parametros.get("UF")) : (porRegional ? this.agruparPorRegionalSaude(listaMunicipio, (String)parametros.get("UF")) : this.agruparSomenteMunicipios(listaMunicipio, (String)parametros.get("UF")));
        Report report = new Report();
        if (listaRegiaoRegularidade.size() > 0) {
            if (listaRegiaoRegularidade.get(0).getListaMunicipio().size() > 0) {
                JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource(listaRegiaoRegularidade);
                parametros.put("TITULO", "Munic\u00edpios Irregulares na Alimenta\u00e7\u00e3o do Sinan");
                report.adionarParametrosPadrao(parametros);
                report.gerarRelatorio((JRDataSource)jrds, parametros, "regularidade.jasper", Boolean.TRUE);
                if (Boolean.parseBoolean(isDBF)) {
                    this.gerarDBFRegularidade(listaRegiaoRegularidade, parametros, countFields);
                }
            } else {
                Master.mensagem("N\u00e3o existem munic\u00edpios irregulares.");
            }
        } else {
            Master.mensagem("N\u00e3o existem munic\u00edpios irregulares.");
        }
    }

    private List<RegiaoRegularidade> agruparSomenteMunicipios(List<Municipio> listaMunicipio, String UF2) {
        ArrayList<RegiaoRegularidade> listaRetorno = new ArrayList<RegiaoRegularidade>();
        RegiaoRegularidade regiao = new RegiaoRegularidade();
        if (UF2.equals("Brasil") || UF2.equals("TODAS") || UF2.equals("TODOS")) {
            regiao.setNome("Brasil");
        } else {
            regiao.setNome(UF2);
        }
        ComparatorChain chain = new ComparatorChain(Arrays.asList(new BeanComparator("sgUF"), new BeanComparator("nmMunicipio")));
        Collections.sort(listaMunicipio, chain);
        regiao.setListaMunicipio(listaMunicipio);
        listaRetorno.add(regiao);
        return listaRetorno;
    }

    private List<RegiaoRegularidade> agruparPorRegiaoSaude(List<Municipio> listaMunicipio, String uf) {
        ArrayList<RegiaoRegularidade> listaRegiaoRegularidade = new ArrayList<RegiaoRegularidade>();
        Map<String, String> listaRegioes = SinanUtil.retornaListaRegioes(uf);
        HashMap regiaoEMunicipios = new HashMap();
        HashSet<String> setRegioes = new HashSet<String>(listaRegioes.values());
        for (String string : setRegioes) {
            ArrayList listaMunicipioRegiao = new ArrayList();
            regiaoEMunicipios.put(string, listaMunicipioRegiao);
        }
        if (!SinanUtil.isListEmpty(listaMunicipio)) {
            for (Municipio item : listaMunicipio) {
                String regiaoLine = listaRegioes.get(item.getCodRegiaoSaude());
                if (regiaoLine == null) continue;
                ((List)regiaoEMunicipios.get(regiaoLine)).add(item);
            }
        }
        for (String string : setRegioes) {
            List m = (List)regiaoEMunicipios.get(string);
            if (!SinanUtil.isListEmpty(m)) {
                RegiaoRegularidade regiao = new RegiaoRegularidade();
                regiao.setNome(((Municipio)m.get(0)).getSgUF() + " - " + string);
                regiao.setListaMunicipio(m);
                listaRegiaoRegularidade.add(regiao);
            }
            ComparatorChain chain = new ComparatorChain(Arrays.asList(new BeanComparator("nome")));
            Collections.sort(listaRegiaoRegularidade, chain);
        }
        return listaRegiaoRegularidade;
    }

    private List<RegiaoRegularidade> agruparPorRegionalSaude(List<Municipio> listaMunicipio, String uf) {
        ArrayList<RegiaoRegularidade> listaRegiaoRegularidade = new ArrayList<RegiaoRegularidade>();
        Map<String, String> listaRegionais = SinanUtil.retornaListaRegionais(uf);
        HashMap regiaoEMunicipios = new HashMap();
        HashSet<String> setRegionais = new HashSet<String>(listaRegionais.values());
        for (String string : setRegionais) {
            ArrayList listaMunicipioRegional = new ArrayList();
            regiaoEMunicipios.put(string, listaMunicipioRegional);
        }
        if (!SinanUtil.isListEmpty(listaMunicipio)) {
            for (Municipio item : listaMunicipio) {
                String regiaoLine = listaRegionais.get(item.getCodRegionalSaude());
                if (regiaoLine == null) continue;
                ((List)regiaoEMunicipios.get(regiaoLine)).add(item);
            }
        }
        for (String string : setRegionais) {
            List m = (List)regiaoEMunicipios.get(string);
            if (!SinanUtil.isListEmpty(m)) {
                RegiaoRegularidade regiao = new RegiaoRegularidade();
                regiao.setNome(((Municipio)m.get(0)).getSgUF() + " - " + string);
                regiao.setListaMunicipio(m);
                listaRegiaoRegularidade.add(regiao);
            }
            ComparatorChain chain = new ComparatorChain(Arrays.asList(new BeanComparator("nome")));
            Collections.sort(listaRegiaoRegularidade, chain);
        }
        return listaRegiaoRegularidade;
    }

    public void gerarRelatorioPropMunicIrreg(List<Municipio> listaMunicipio, Map parametros, int countFields, String isDBF, boolean calculaBrasil) throws IOException {
        List<RegiaoRegularidade> listaRegiaoRegularidade = this.agruparPorRegiaoUF(listaMunicipio);
        this.calculaMunicipio(listaRegiaoRegularidade);
        this.calculaBrasil(listaRegiaoRegularidade, parametros, calculaBrasil);
        this.calculaRegiao(listaRegiaoRegularidade);
        Report report = new Report();
        if (!SinanUtil.isListEmpty(listaRegiaoRegularidade)) {
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource(listaRegiaoRegularidade);
            parametros.put("TITULO", "Munic\u00edpios Irregulares na Alimenta\u00e7\u00e3o do Sinan");
            report.adionarParametrosPadrao(parametros);
            report.gerarRelatorio((JRDataSource)jrds, parametros, "regularidade2.jasper", Boolean.TRUE);
        } else {
            Master.mensagem("N\u00e3o existem munic\u00edpios irregulares.");
        }
    }

    private void calculaMunicipio(List<RegiaoRegularidade> listaRegiaoRegularidade) {
        for (RegiaoRegularidade regiaoRegularidade : listaRegiaoRegularidade) {
            for (UF uf : regiaoRegularidade.getListaUF()) {
                int qtdeMunic = 0;
                double qtdeIrregular = 0.0;
                for (Municipio municipio : regiaoRegularidade.getListaMunicipio()) {
                    if (!uf.getNmUF().equals(municipio.getUf().getNmUF())) continue;
                    if (municipio.isIrregular()) {
                        uf.setQtdMunicipiosSemNotificacao(uf.getQtdMunicipiosSemNotificacao() + 1);
                        qtdeIrregular += 1.0;
                    }
                    uf.setQtdMunicipios(uf.getQtdMunicipios() + 1);
                    ++qtdeMunic;
                }
                if (qtdeMunic != 0) {
                    uf.setPercentualIrregular(SinanUtil.converterDoubleDuasDecimais(qtdeIrregular / (double)qtdeMunic * 100.0));
                }
                uf.setNmUF(SinanUtil.siglaUFToNomeUF(uf.getNmUF()));
            }
        }
    }

    private void calculaRegiao(List<RegiaoRegularidade> listaRegiaoRegularidade) {
        for (RegiaoRegularidade regiaoRegularidade : listaRegiaoRegularidade) {
            int qtdeMunic = 0;
            double qtdeIrregular = 0.0;
            for (UF uf : regiaoRegularidade.getListaUF()) {
                qtdeMunic += uf.getQtdMunicipios();
                qtdeIrregular += (double)uf.getQtdMunicipiosSemNotificacao();
            }
            regiaoRegularidade.setQtdeMunicipio(qtdeMunic);
            regiaoRegularidade.setQtdeMunicIrregular((int)qtdeIrregular);
            regiaoRegularidade.setPercetualIrregular(SinanUtil.converterDoubleDuasDecimais(qtdeIrregular / (double)qtdeMunic * 100.0));
        }
    }

    private void calculaBrasil(List<RegiaoRegularidade> listaRegiaoRegularidade, Map<String, String> parametros, boolean calculaBrasil) {
        int qtdeMunic = 0;
        double qtdeIrregular = 0.0;
        double percentual = 0.0;
        for (RegiaoRegularidade regiaoRegularidade : listaRegiaoRegularidade) {
            for (UF uf : regiaoRegularidade.getListaUF()) {
                qtdeMunic += uf.getQtdMunicipios();
                qtdeIrregular += (double)uf.getQtdMunicipiosSemNotificacao();
            }
            SinanUtil.ordenaLista(regiaoRegularidade.getListaUF(), "nmUF");
        }
        percentual = SinanUtil.converterDoubleDuasDecimais(qtdeIrregular / (double)qtdeMunic * 100.0);
        if (calculaBrasil) {
            parametros.put("BRASIL1", qtdeMunic + "");
            parametros.put("BRASIL2", (int)qtdeIrregular + "");
            parametros.put("BRASIL3", percentual + "");
        } else {
            parametros.put("BRASIL1", "");
            parametros.put("BRASIL2", "");
            parametros.put("BRASIL3", "");
        }
    }

    private List<RegiaoRegularidade> agruparPorRegiaoUF(List<Municipio> listaMunicipio) {
        List<RegiaoRegularidade> listaRegiaoRegularidade = this.agruparPorRegiao(listaMunicipio);
        Map<Object, Object> mapaUF = new HashMap();
        if (!SinanUtil.isListEmpty(listaRegiaoRegularidade)) {
            for (RegiaoRegularidade regiao : listaRegiaoRegularidade) {
                if (SinanUtil.isListEmpty(regiao.getListaMunicipio())) continue;
                mapaUF = this.mapearUF(regiao.getListaMunicipio());
                Iterator<Map.Entry<Object, Object>> entries = mapaUF.entrySet().iterator();
                ArrayList<UF> listaUF = new ArrayList<UF>();
                while (entries.hasNext()) {
                    UF uf = new UF();
                    Map.Entry<Object, Object> thisEntry = entries.next();
                    uf.setNmUF(thisEntry.getValue().toString());
                    listaUF.add(uf);
                }
                regiao.setListaUF(listaUF);
            }
        }
        return listaRegiaoRegularidade;
    }

    private Map<String, String> mapearUF(List<Municipio> listaMunicipio) {
        HashMap<String, String> mapaUF = new HashMap<String, String>();
        for (Municipio municipio : listaMunicipio) {
            if (mapaUF.containsKey(municipio.getUf().getNmUF())) continue;
            mapaUF.put(municipio.getUf().getNmUF(), municipio.getUf().getNmUF());
        }
        return mapaUF;
    }

    private List<RegiaoRegularidade> agruparPorRegiao(List<Municipio> listaMunicipio) {
        ArrayList<RegiaoRegularidade> listaRegiaoRegularidade = new ArrayList<RegiaoRegularidade>();
        ArrayList<Municipio> listaNorte = new ArrayList<Municipio>();
        RegiaoRegularidade regiaoNorte = new RegiaoRegularidade();
        regiaoNorte.setNome("Norte");
        ArrayList<Municipio> listaNordeste = new ArrayList<Municipio>();
        RegiaoRegularidade regiaoNordeste = new RegiaoRegularidade();
        regiaoNordeste.setNome("Nordeste");
        ArrayList<Municipio> listaCentroOeste = new ArrayList<Municipio>();
        RegiaoRegularidade regiaoCentroOeste = new RegiaoRegularidade();
        regiaoCentroOeste.setNome("Centro-oeste");
        ArrayList<Municipio> listaSudeste = new ArrayList<Municipio>();
        RegiaoRegularidade regiaoSudeste = new RegiaoRegularidade();
        regiaoSudeste.setNome("Sudeste");
        ArrayList<Municipio> listaSul = new ArrayList<Municipio>();
        RegiaoRegularidade regiaoSul = new RegiaoRegularidade();
        regiaoSul.setNome("Sul");
        if (!SinanUtil.isListEmpty(listaMunicipio)) {
            for (Municipio item : listaMunicipio) {
                if (item.getNmRegiao().equals("NORTE")) {
                    listaNorte.add(item);
                    continue;
                }
                if (item.getNmRegiao().equals("NORDESTE")) {
                    listaNordeste.add(item);
                    continue;
                }
                if (item.getNmRegiao().equals("CENTRO-OESTE")) {
                    listaCentroOeste.add(item);
                    continue;
                }
                if (item.getNmRegiao().equals("SUDESTE")) {
                    listaSudeste.add(item);
                    continue;
                }
                if (!item.getNmRegiao().equals("SUL")) continue;
                listaSul.add(item);
            }
            regiaoNorte.setListaMunicipio(listaNorte);
            regiaoNordeste.setListaMunicipio(listaNordeste);
            regiaoCentroOeste.setListaMunicipio(listaCentroOeste);
            regiaoSudeste.setListaMunicipio(listaSudeste);
            regiaoSul.setListaMunicipio(listaSul);
        }
        if (!SinanUtil.isListEmpty(regiaoNorte.getListaMunicipio())) {
            listaRegiaoRegularidade.add(regiaoNorte);
        }
        if (!SinanUtil.isListEmpty(regiaoNordeste.getListaMunicipio())) {
            listaRegiaoRegularidade.add(regiaoNordeste);
        }
        if (!SinanUtil.isListEmpty(regiaoCentroOeste.getListaMunicipio())) {
            listaRegiaoRegularidade.add(regiaoCentroOeste);
        }
        if (!SinanUtil.isListEmpty(regiaoSudeste.getListaMunicipio())) {
            listaRegiaoRegularidade.add(regiaoSudeste);
        }
        if (!SinanUtil.isListEmpty(regiaoSul.getListaMunicipio())) {
            listaRegiaoRegularidade.add(regiaoSul);
        }
        return listaRegiaoRegularidade;
    }

    public void gerarDBFRegularidade(List<RegiaoRegularidade> lista, Map periodos, int countFields) throws IOException {
        DBFField[] fields = new DBFField[countFields];
        CampoDBF field = new CampoDBF("ID_MUNIC", "String", 7, 0);
        fields[0] = field;
        field = new CampoDBF("NM_MUNIC", "String", 30, 0);
        fields[1] = field;
        field = new CampoDBF("SG_UF", "String", 2, 0);
        fields[2] = field;
        field = new CampoDBF("DT_AVALIA", "String", 10, 0);
        fields[3] = field;
        if (periodos.get("periodo1") != null) {
            field = new CampoDBF("PERIODO01", "String", 2, 0);
            fields[4] = field;
        }
        if (periodos.get("periodo2") != null) {
            field = new CampoDBF("PERIODO02", "String", 2, 0);
            fields[5] = field;
        }
        if (periodos.get("periodo3") != null) {
            field = new CampoDBF("PERIODO03", "String", 2, 0);
            fields[6] = field;
        }
        if (periodos.get("periodo4") != null) {
            field = new CampoDBF("PERIODO04", "String", 2, 0);
            fields[7] = field;
        }
        if (periodos.get("periodo5") != null) {
            field = new CampoDBF("PERIODO05", "String", 2, 0);
            fields[8] = field;
        }
        if (periodos.get("periodo6") != null) {
            field = new CampoDBF("PERIODO06", "String", 2, 0);
            fields[9] = field;
        }
        if (periodos.get("periodo7") != null) {
            field = new CampoDBF("PERIODO07", "String", 2, 0);
            fields[10] = field;
        }
        if (periodos.get("periodo8") != null) {
            field = new CampoDBF("PERIODO08", "String", 2, 0);
            fields[11] = field;
        }
        if (periodos.get("periodo9") != null) {
            field = new CampoDBF("PERIODO09", "String", 2, 0);
            fields[12] = field;
        }
        if (periodos.get("periodo10") != null) {
            field = new CampoDBF("PERIODO10", "String", 2, 0);
            fields[13] = field;
        }
        if (periodos.get("periodo11") != null) {
            field = new CampoDBF("PERIODO11", "String", 2, 0);
            fields[14] = field;
        }
        if (periodos.get("periodo12") != null) {
            field = new CampoDBF("PERIODO12", "String", 2, 0);
            fields[15] = field;
        }
        if (periodos.get("periodo13") != null) {
            field = new CampoDBF("PERIODO13", "String", 2, 0);
            fields[16] = field;
        }
        if (periodos.get("periodo14") != null) {
            field = new CampoDBF("PERIODO14", "String", 2, 0);
            fields[17] = field;
        }
        if (periodos.get("periodo15") != null) {
            field = new CampoDBF("PERIODO15", "String", 2, 0);
            fields[18] = field;
        }
        if (periodos.get("periodo16") != null) {
            field = new CampoDBF("PERIODO16", "String", 2, 0);
            fields[19] = field;
        }
        if (periodos.get("periodo17") != null) {
            field = new CampoDBF("PERIODO17", "String", 2, 0);
            fields[20] = field;
        }
        if (periodos.get("periodo18") != null) {
            field = new CampoDBF("PERIODO18", "String", 2, 0);
            fields[21] = field;
        }
        this.prepareDataToDBF(lista, fields, countFields);
    }

    private void prepareDataToDBF(List<RegiaoRegularidade> lista, DBFField[] fields, int countFields) throws IOException {
        DBFWriter writer = new DBFWriter();
        writer.setFields(fields);
        for (RegiaoRegularidade regiao : lista) {
            for (Municipio item : regiao.getListaMunicipio()) {
                Object[] rowData = new Object[countFields];
                rowData[0] = item.getCodMunicipio();
                rowData[1] = item.getNmMunicipio();
                rowData[2] = item.getSgUF();
                rowData[3] = SinanDateUtil.currentDateString();
                if (countFields > 4) {
                    rowData[4] = item.getPeriodo1();
                }
                if (countFields > 5) {
                    rowData[5] = item.getPeriodo2();
                }
                if (countFields > 6) {
                    rowData[6] = item.getPeriodo3();
                }
                if (countFields > 7) {
                    rowData[7] = item.getPeriodo4();
                }
                if (countFields > 8) {
                    rowData[8] = item.getPeriodo5();
                }
                if (countFields > 9) {
                    rowData[9] = item.getPeriodo6();
                }
                if (countFields > 10) {
                    rowData[10] = item.getPeriodo7();
                }
                if (countFields > 11) {
                    rowData[11] = item.getPeriodo8();
                }
                if (countFields > 12) {
                    rowData[12] = item.getPeriodo9();
                }
                if (countFields > 13) {
                    rowData[13] = item.getPeriodo10();
                }
                if (countFields > 14) {
                    rowData[14] = item.getPeriodo11();
                }
                if (countFields > 15) {
                    rowData[15] = item.getPeriodo12();
                }
                if (countFields > 16) {
                    rowData[16] = item.getPeriodo13();
                }
                if (countFields > 17) {
                    rowData[17] = item.getPeriodo14();
                }
                if (countFields > 18) {
                    rowData[18] = item.getPeriodo15();
                }
                if (countFields > 19) {
                    rowData[19] = item.getPeriodo16();
                }
                if (countFields > 20) {
                    rowData[20] = item.getPeriodo17();
                }
                if (countFields > 21) {
                    rowData[21] = item.getPeriodo18();
                }
                writer.addRecord(rowData);
            }
        }
        SinanUtil.setNomeArquivoDBF();
        SinanUtil.gerarDBF(writer);
    }
}

