/*
 * Decompiled with CFR 0.152.
 */
package com.org.util;

import com.org.util.SinanUtil;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SinanDateUtil {
    private static DateFormat format = new SimpleDateFormat("dd/MM/yyyy");
    private static DateFormat formatPostgre = new SimpleDateFormat("yyyy-MM-dd");
    public static final Pattern PADRAO_DATA_DDMMYYYY = Pattern.compile("\\d\\d[/-]\\d\\d[/-]\\d\\d\\d\\d");
    public static final Pattern PADRAO_DATA_YYYYMMDD = Pattern.compile("\\d\\d\\d\\d[/-]\\d\\d[/-]\\d\\d");

    public static java.util.Date stringToDate(String strDate) throws ParseException, ParseException {
        return SinanDateUtil.stringToDate(strDate, "dd/MM/yyyy");
    }

    public static java.util.Date stringToDate(String strDate, String pattern) throws ParseException, ParseException {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        java.util.Date data = new java.util.Date(format.parse(strDate).getTime());
        return data;
    }

    public static Long calculaDiferencaDias(java.util.Date de, java.util.Date ate) {
        long dif = ate.getTime() - de.getTime();
        return dif /= 86400000L;
    }

    public static Date firstDateOfMonth() {
        Calendar firstData = Calendar.getInstance();
        firstData.set(5, firstData.getActualMinimum(5));
        Date data = new Date(firstData.getTimeInMillis());
        return data;
    }

    public static String subtrairAno(String data, int y) {
        if (data != null && !data.isEmpty()) {
            Calendar dt = Calendar.getInstance();
            try {
                dt.setTime(SinanDateUtil.stringToDate(data));
            }
            catch (ParseException ex) {
                Logger.getLogger(SinanDateUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
            dt.add(1, y);
            String dataInicioCoortePB = new SimpleDateFormat("dd/MM/yyyy").format(dt.getTime());
            return dataInicioCoortePB;
        }
        return "";
    }

    public static Date firstDateOfMonth(java.util.Date date) {
        Calendar firstData = SinanDateUtil.dateToCalendar(date);
        firstData.set(5, firstData.getActualMinimum(5));
        Date data = new Date(firstData.getTimeInMillis());
        return data;
    }

    public static Date currentDate() {
        return new Date(System.currentTimeMillis());
    }

    public static Boolean checkDateMajorCurrentDate(java.util.Date d) {
        if (d != null) {
            return d.getTime() > SinanDateUtil.currentDate().getTime();
        }
        return false;
    }

    public static String currentDateString() {
        return new SimpleDateFormat("dd/MM/yyyy").format(new java.util.Date());
    }

    public static Date lastDateOfMonth() {
        GregorianCalendar lastData = new GregorianCalendar();
        lastData.set(5, ((Calendar)lastData).getActualMaximum(5));
        Date data = new Date(lastData.getTimeInMillis());
        return data;
    }

    public static Date lastDateOfMonth(java.util.Date date) {
        Calendar lastData = SinanDateUtil.dateToCalendar(date);
        lastData.set(5, lastData.getActualMaximum(5));
        Date data = new Date(lastData.getTimeInMillis());
        return data;
    }

    public static Date incrementDate(Calendar data, int num, int field) {
        data.add(field, num);
        return (Date)new java.util.Date(data.getTimeInMillis());
    }

    public static String toString(java.util.Date date) {
        return format.format(date);
    }

    public static String toStringPostgre(java.util.Date date) {
        return formatPostgre.format(date);
    }

    public static String toString(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String dateToStringException(java.util.Date date, String format) {
        try {
            return new SimpleDateFormat(format).format(date);
        }
        catch (Exception e) {
            SinanUtil.mensagem("Favor preencher o campo Data corretamente.");
            return null;
        }
    }

    public static String dateToString(java.util.Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String toString(Timestamp date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String toString(Calendar calendar) {
        return SinanDateUtil.toString(new java.util.Date(calendar.getTimeInMillis()));
    }

    public static boolean equalsIgnoreHour(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 != null && d2 == null || d1 == null && d2 != null) {
            return false;
        }
        return SinanDateUtil.toString(d1).equals(SinanDateUtil.toString(d2));
    }

    public static String getDescricaoMes(java.util.Date data) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        String mes = "";
        switch (calendar.get(2)) {
            case 0: {
                mes = "Janeiro";
                break;
            }
            case 1: {
                mes = "Fevereiro";
                break;
            }
            case 2: {
                mes = "Mar\u00e7o";
                break;
            }
            case 3: {
                mes = "Abril";
                break;
            }
            case 4: {
                mes = "Maio";
                break;
            }
            case 5: {
                mes = "Junho";
                break;
            }
            case 6: {
                mes = "Julho";
                break;
            }
            case 7: {
                mes = "Agosto";
                break;
            }
            case 8: {
                mes = "Setembro";
                break;
            }
            case 9: {
                mes = "Outubro";
                break;
            }
            case 10: {
                mes = "Novembro";
                break;
            }
            case 11: {
                mes = "Dezembro";
                break;
            }
        }
        return mes;
    }

    public static Double calculaDiferencaHoras(String inicioStr, String fimStr) {
        String[] inicio = inicioStr.split(":");
        String[] fim = fimStr.split(":");
        Double inicioHora = Double.parseDouble(inicio[0]);
        Double fimHora = Double.parseDouble(fim[0]);
        Double inicioMin = Double.parseDouble(inicio[1]);
        Double fimMin = Double.parseDouble(fim[1]);
        inicioHora = inicioMin / 60.0 + inicioHora;
        fimHora = fimMin / 60.0 + fimHora;
        inicioHora = (double)Math.round(inicioHora * 100.0) / 100.0;
        fimHora = (double)Math.round(fimHora * 100.0) / 100.0;
        return fimHora - inicioHora;
    }

    public static Date stringToSqlDate(String data) {
        if (data == null) {
            return null;
        }
        if (PADRAO_DATA_YYYYMMDD.matcher(data = data.trim()).matches()) {
            data = data.replace('/', '-');
        } else if (PADRAO_DATA_DDMMYYYY.matcher(data).matches()) {
            String[] dt = data.split("[/-]");
            data = dt[2] + "-" + dt[1] + "-" + dt[0];
        } else {
            return null;
        }
        return Date.valueOf(data);
    }

    public static int diferencaDias(java.util.Date data1, java.util.Date data2) {
        return SinanDateUtil.diferencaHoras(data1, data2) / 24;
    }

    public static int diferencaMeses(java.util.Date data1, java.util.Date data2) {
        return SinanDateUtil.diferencaHoras(data1, data2) / 24 / 30;
    }

    public static int diferencaSemanas(java.util.Date data1, java.util.Date data2) {
        return SinanDateUtil.diferencaHoras(data1, data2) / 24 / 7;
    }

    public static int diferencaHoras(java.util.Date data1, java.util.Date data2) {
        Calendar calendar1 = SinanDateUtil.dateToCalendar(data1);
        calendar1.set(11, 0);
        calendar1.set(12, 0);
        calendar1.set(13, 0);
        calendar1.set(14, 0);
        Calendar calendar2 = SinanDateUtil.dateToCalendar(data2);
        calendar2.set(11, 0);
        calendar2.set(12, 0);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        return (int)((calendar1.getTimeInMillis() - calendar2.getTimeInMillis()) / 1000L / 60L / 60L);
    }

    public static Calendar dateToCalendar(java.util.Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }

    public static java.util.Date addDiasData(java.util.Date dtReferencia, int dias) {
        Calendar dtLimiteAux = Calendar.getInstance();
        dtLimiteAux.setTimeInMillis(dtReferencia.getTime());
        dtLimiteAux.add(5, dias);
        return new java.util.Date(dtLimiteAux.getTimeInMillis());
    }

    public static java.util.Date addMesData(java.util.Date dtReferencia, int meses) {
        Calendar dtLimiteAux = Calendar.getInstance();
        dtLimiteAux.setTimeInMillis(dtReferencia.getTime());
        dtLimiteAux.add(2, meses);
        return new java.util.Date(dtLimiteAux.getTimeInMillis());
    }

    public static java.util.Date dataToEndOfDay(java.util.Date data) {
        if (data != null) {
            return SinanDateUtil.dataToEndOfDay(new Date(data.getTime()));
        }
        return null;
    }

    public static Integer mesesEntre(java.util.Date dtInicio, java.util.Date dtFim) {
        Calendar dtInicioAux = Calendar.getInstance();
        Calendar dtFimAux = Calendar.getInstance();
        dtInicioAux.setTimeInMillis(dtInicio.getTime());
        dtFimAux.setTimeInMillis(dtFim.getTime());
        return SinanDateUtil.mesesEntre(dtInicioAux, dtFimAux);
    }

    public static Integer mesesEntre(Calendar dtInicio, Calendar dtFim) {
        if (dtInicio == null || dtFim == null) {
            return null;
        }
        int diaIni = dtInicio.get(5);
        int mesIni = dtInicio.get(2) + 1;
        int anoIni = dtInicio.get(1);
        int diaFim = dtFim.get(5);
        int mesFim = dtFim.get(2) + 1;
        int anoFim = dtFim.get(1);
        int anos = 0;
        int meses = 0;
        if (anoFim < anoIni || anoFim == anoIni && mesFim < mesIni) {
            return 0;
        }
        anos = anoFim - anoIni;
        if (mesFim < mesIni) {
            meses = 12 - mesIni + mesFim;
            if (anos > 0) {
                --anos;
            }
        } else {
            meses = mesFim - mesIni;
        }
        if (diaFim < diaIni) {
            if (meses == 0) {
                if (anos > 0) {
                    --anos;
                    meses = 11;
                }
            } else {
                --meses;
            }
        }
        return meses += anos * 12;
    }

    public static java.util.Date convertToDate(String data) throws ParseException {
        try {
            String mes = data.substring(5, 7);
            String dia = data.substring(8, 10);
            String ano = data.substring(2, 4);
            String str = mes + "/" + dia + "/" + ano;
            DateFormat dt = DateFormat.getDateInstance(3, Locale.US);
            java.util.Date date = dt.parse(str);
            return new java.util.Date(date.getTime());
        }
        catch (NumberFormatException ex) {
            SinanUtil.mensagem("Erro:\n" + ex);
        }
        catch (ParseException ex) {
            SinanUtil.mensagem("Erro:\n" + ex);
        }
        return null;
    }

    public static boolean isBetweenDates(java.util.Date dataParametro, String dataInicio, String dataFim) throws ParseException {
        java.util.Date dtInicio = SinanDateUtil.convertToDate(dataInicio);
        java.util.Date dtFim = SinanDateUtil.convertToDate(dataFim);
        return !(dataParametro == null || !dataParametro.after(dtInicio) && !dataParametro.equals(dtInicio) || !dataParametro.before(dtFim) && !dataParametro.equals(dtFim));
    }

    public static boolean isBetweenDates2(java.util.Date dataParametro, String dataInicio, String dataFim) throws ParseException {
        Date dtInicio = SinanDateUtil.stringToSqlDate(dataInicio);
        Date dtFim = SinanDateUtil.stringToSqlDate(dataFim);
        return !(dataParametro == null || !dataParametro.after(dtInicio) && !dataParametro.equals(dtInicio) || !dataParametro.before(dtFim) && !dataParametro.equals(dtFim));
    }

    public static String getIntervaloDatas(Integer ano, Integer semanaInicial, Integer semanaFinal) {
        String intervaloDatas = "";
        Calendar calendar = Calendar.getInstance();
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"dd/MM/YYYY");
        calendar.set(ano, 0, 0);
        DateTime dataInicial = new DateTime((Object)calendar.getTime()).plusWeeks(semanaInicial.intValue()).weekOfWeekyear().roundFloorCopy().minusDays(1);
        DateTime dataFinal = new DateTime((Object)calendar.getTime()).plusWeeks(semanaFinal.intValue()).weekOfWeekyear().roundCeilingCopy().minusDays(1);
        intervaloDatas = formatter.print((ReadableInstant)dataInicial) + " a " + formatter.print((ReadableInstant)dataFinal);
        return intervaloDatas;
    }
}

