/*
 * Decompiled with CFR 0.152.
 */
package com.org.util;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.beans.Completitude;
import com.org.facade.SessionFacadeImpl;
import com.org.model.classes.agravos.oportunidade.OportunidadeAgravoCOAP;
import com.org.model.classes.agravos.oportunidade.OportunidadeAgravoPQAVS;
import com.org.negocio.Configuracao;
import com.org.negocio.FiltroArquivo;
import com.org.negocio.Util;
import com.org.util.SinanDateUtil;
import com.org.view.Master;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.beanutils.BeanComparator;

public class SinanUtil {
    private static File arquivoDbfSalvo;

    public String getDescricaoPeriodo(Date dtInicio, Date dtFim) {
        String periodo = null;
        if (dtInicio != null && dtFim != null) {
            periodo = SinanDateUtil.toString(dtInicio) + " \u00e0 " + SinanDateUtil.toString(dtFim);
        } else if (dtInicio != null) {
            periodo = "A partir de " + SinanDateUtil.toString(dtInicio);
        } else if (dtFim != null) {
            periodo = "At\u00e9 " + SinanDateUtil.toString(dtFim);
        }
        return periodo;
    }

    public static boolean isListEmpty(Collection<?> list) {
        return !SinanUtil.isListNotEmpty(list);
    }

    public static boolean isListNotEmpty(Collection<?> list) {
        return list != null && list.size() > 0;
    }

    public Boolean isPrazoOportuno(Date dt_notificacao, Date dt_investigacao, String codAgravo) {
        Long dias = SinanDateUtil.calculaDiferencaDias(dt_notificacao, dt_investigacao);
        if (dias <= (long)this.prazoOportuno(codAgravo).intValue()) {
            return true;
        }
        return false;
    }

    private Integer prazoOportuno(String codAgravo) {
        if (codAgravo.equals("A051") || codAgravo.equals("A009") || codAgravo.equals("A379") || codAgravo.equals("A90") || codAgravo.equals("A369") || codAgravo.equals("B571") || codAgravo.equals("A959") || codAgravo.equals("A923") || codAgravo.equals("A779") || codAgravo.equals("A010") || codAgravo.equals("A988") || codAgravo.equals("B550") || codAgravo.equals("A279") || codAgravo.equals("B54") || codAgravo.equals("G039") || codAgravo.equals("A809") || codAgravo.equals("A209") || codAgravo.equals("A829") || codAgravo.equals("P350") || codAgravo.equals("A35") || codAgravo.equals("A33")) {
            return 60;
        }
        if (codAgravo.equals("B551") || codAgravo.equals("B19") || codAgravo.equals("P350")) {
            return 180;
        }
        SinanUtil.mensagem("Erro ao calcular o prazo oportuno", "C\u00f3digo do agravo n\u00e3o encontrado.");
        return 0;
    }

    public static void mensagem(String description, String message) {
        JOptionPane.showMessageDialog(new JFrame(), message, description, 1);
    }

    public static void mensagem(String message) {
        JOptionPane.showMessageDialog(new JFrame(), message);
    }

    public static String getVersaoSinanRelatorios() {
        return "5.0";
    }

    public static void gerarDBF(DBFWriter writer) throws IOException {
        try {
            FileOutputStream fos = new FileOutputStream(Configuracao.getPropriedade("arquivo"));
            writer.write((OutputStream)fos);
            fos.close();
            System.out.println("ok");
        }
        catch (Exception DBFException2) {
            System.out.print(DBFException2);
        }
    }

    public static boolean setNomeArquivoDBF() {
        JFileChooser filesave = new JFileChooser();
        FiltroArquivo filtro = new FiltroArquivo();
        filtro.addExtension("dbf");
        filtro.setDescription("Arquivo DBF");
        filtro.addInicioNome(SessionFacadeImpl.getNomeDbf());
        filesave.setSelectedFile(new File("output.dbf"));
        filesave.setDialogTitle("Informe o local e nome do arquivo DBF a ser salvo");
        filesave.addChoosableFileFilter(filtro);
        Configuracao conf = new Configuracao();
        File file2 = new File(conf.getCaminho());
        filesave.setCurrentDirectory(file2);
        int ret = filesave.showSaveDialog(filesave);
        if (ret == 0) {
            arquivoDbfSalvo = filesave.getSelectedFile();
            System.out.println(arquivoDbfSalvo.getName());
            Configuracao.setPropriedade("arquivo", arquivoDbfSalvo.getPath());
            System.out.println(arquivoDbfSalvo);
            return true;
        }
        return false;
    }

    public static void imprimirConsole(String conteudo) {
        System.out.println(conteudo);
    }

    public static Integer intervaloSemanas(String anoSemanaDe, String anoSemanaAte) {
        Integer anoDe = Integer.parseInt(anoSemanaDe.substring(0, 4));
        Integer semanaDe = Integer.parseInt(anoSemanaDe.substring(4, 6));
        Integer anoAte = Integer.parseInt(anoSemanaAte.substring(0, 4));
        Integer semanaAte = Integer.parseInt(anoSemanaAte.substring(4, 6));
        if (anoDe.equals(anoAte)) {
            return semanaAte - semanaDe;
        }
        if (anoAte - anoDe > 1) {
            return (anoAte - anoDe - 1) * 53 + semanaAte + (53 - semanaDe);
        }
        return 53 - semanaDe + semanaAte;
    }

    public static double converterDoubleDuasDecimais(double valorDouble) {
        DecimalFormat fmt = new DecimalFormat("0.00");
        String string = fmt.format(valorDouble);
        String[] part = string.split("[,]");
        String string2 = part[0] + "." + part[1];
        double valor = Double.parseDouble(string2);
        return valor;
    }

    public static String siglaUFToNomeUF(String siglaUF) {
        if (siglaUF.equals("TO")) {
            return "TOCANTINS";
        }
        if (siglaUF.equals("AC")) {
            return "ACRE";
        }
        if (siglaUF.equals("AL")) {
            return "ALAGOAS";
        }
        if (siglaUF.equals("AM")) {
            return "AMAZONAS";
        }
        if (siglaUF.equals("AP")) {
            return "AMAPA";
        }
        if (siglaUF.equals("BA")) {
            return "BAHIA";
        }
        if (siglaUF.equals("CE")) {
            return "CEARA";
        }
        if (siglaUF.equals("DF")) {
            return "DISTRITO FEDERAL";
        }
        if (siglaUF.equals("ES")) {
            return "ESPIRITO SANTO";
        }
        if (siglaUF.equals("GO")) {
            return "GOIAS";
        }
        if (siglaUF.equals("MA")) {
            return "MARANHAO";
        }
        if (siglaUF.equals("MG")) {
            return "MINAS GERAIS";
        }
        if (siglaUF.equals("MS")) {
            return "MATO GROSSO DO SUL";
        }
        if (siglaUF.equals("MT")) {
            return "MATO GROSSO";
        }
        if (siglaUF.equals("PA")) {
            return "PARA";
        }
        if (siglaUF.equals("PB")) {
            return "PARAIBA";
        }
        if (siglaUF.equals("PE")) {
            return "PERNAMBUCO";
        }
        if (siglaUF.equals("PI")) {
            return "PIAUI";
        }
        if (siglaUF.equals("PR")) {
            return "PARANA";
        }
        if (siglaUF.equals("RJ")) {
            return "RIO DE JANEIRO";
        }
        if (siglaUF.equals("RN")) {
            return "RIO GRANDE DO NORTE";
        }
        if (siglaUF.equals("RO")) {
            return "RONDONIA";
        }
        if (siglaUF.equals("RR")) {
            return "RORAIMA";
        }
        if (siglaUF.equals("RS")) {
            return "RIO GRANDE DO SUL";
        }
        if (siglaUF.equals("SC")) {
            return "SANTA CATARINA";
        }
        if (siglaUF.equals("SE")) {
            return "SERGIPE";
        }
        if (siglaUF.equals("SP")) {
            return "SAO PAULO";
        }
        return "O nome da UF " + siglaUF + "n\u00e3o foi encontrado";
    }

    public static String siglaUFToIDUF(String siglaUF) {
        if (siglaUF.equals("TO")) {
            return "17";
        }
        if (siglaUF.equals("AC")) {
            return "12";
        }
        if (siglaUF.equals("AL")) {
            return "27";
        }
        if (siglaUF.equals("AM")) {
            return "13";
        }
        if (siglaUF.equals("AP")) {
            return "16";
        }
        if (siglaUF.equals("BA")) {
            return "29";
        }
        if (siglaUF.equals("CE")) {
            return "23";
        }
        if (siglaUF.equals("DF")) {
            return "53";
        }
        if (siglaUF.equals("ES")) {
            return "32";
        }
        if (siglaUF.equals("GO")) {
            return "52";
        }
        if (siglaUF.equals("MA")) {
            return "21";
        }
        if (siglaUF.equals("MG")) {
            return "31";
        }
        if (siglaUF.equals("MS")) {
            return "50";
        }
        if (siglaUF.equals("MT")) {
            return "51";
        }
        if (siglaUF.equals("PA")) {
            return "15";
        }
        if (siglaUF.equals("PB")) {
            return "25";
        }
        if (siglaUF.equals("PE")) {
            return "26";
        }
        if (siglaUF.equals("PI")) {
            return "22";
        }
        if (siglaUF.equals("PR")) {
            return "41";
        }
        if (siglaUF.equals("RJ")) {
            return "33";
        }
        if (siglaUF.equals("RN")) {
            return "24";
        }
        if (siglaUF.equals("RO")) {
            return "11";
        }
        if (siglaUF.equals("RR")) {
            return "14";
        }
        if (siglaUF.equals("RS")) {
            return "43";
        }
        if (siglaUF.equals("SC")) {
            return "42";
        }
        if (siglaUF.equals("SE")) {
            return "28";
        }
        if (siglaUF.equals("SP")) {
            return "35";
        }
        return "O ID da UF " + siglaUF + "n\u00e3o foi encontrado";
    }

    public static String idUFToSiglaUF(String idUF) {
        if (idUF.equals("17")) {
            return "TO";
        }
        if (idUF.equals("12")) {
            return "AC";
        }
        if (idUF.equals("27")) {
            return "AL";
        }
        if (idUF.equals("13")) {
            return "AM";
        }
        if (idUF.equals("16")) {
            return "AP";
        }
        if (idUF.equals("29")) {
            return "BA";
        }
        if (idUF.equals("23")) {
            return "CE";
        }
        if (idUF.equals("53")) {
            return "DF";
        }
        if (idUF.equals("32")) {
            return "ES";
        }
        if (idUF.equals("52")) {
            return "GO";
        }
        if (idUF.equals("21")) {
            return "MA";
        }
        if (idUF.equals("31")) {
            return "MG";
        }
        if (idUF.equals("50")) {
            return "MS";
        }
        if (idUF.equals("51")) {
            return "MT";
        }
        if (idUF.equals("15")) {
            return "PA";
        }
        if (idUF.equals("25")) {
            return "PB";
        }
        if (idUF.equals("26")) {
            return "PE";
        }
        if (idUF.equals("22")) {
            return "PI";
        }
        if (idUF.equals("41")) {
            return "PR";
        }
        if (idUF.equals("33")) {
            return "RJ";
        }
        if (idUF.equals("24")) {
            return "RN";
        }
        if (idUF.equals("11")) {
            return "RO";
        }
        if (idUF.equals("14")) {
            return "RR";
        }
        if (idUF.equals("43")) {
            return "RS";
        }
        if (idUF.equals("42")) {
            return "SC";
        }
        if (idUF.equals("28")) {
            return "SE";
        }
        if (idUF.equals("35")) {
            return "SP";
        }
        return "A sigla da UF " + idUF + "n\u00e3o foi encontrada";
    }

    public static void ordenaLista(List lista, String campo) {
        Collections.sort(lista, new BeanComparator(campo));
    }

    public static boolean verificaDBDengueOnLine(String[] arquivos) {
        for (int i = 0; i < arquivos.length; ++i) {
            if (!arquivos[i].substring(0, 6).equals("DENGON")) continue;
            return true;
        }
        return false;
    }

    public static boolean verificaDBChikoOnLine(String[] arquivos) {
        for (int i = 0; i < arquivos.length; ++i) {
            if (!arquivos[i].substring(0, 6).equals("CHIKON")) continue;
            return true;
        }
        return false;
    }

    public static void gerarTabela(File[] files, JTable tabela) {
        ArrayList<String> listaArquivos = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            listaArquivos.add(files[i].getName());
        }
        int count = 1;
        String arquivo = "Arquivo";
        Vector<String> colunas = new Vector<String>();
        Vector linhas = new Vector();
        Vector<String> registros = new Vector<String>();
        for (String item : listaArquivos) {
            arquivo = arquivo + "" + count++;
            colunas.addElement(arquivo);
            registros.add(item);
            arquivo = "Arquivo";
        }
        linhas.addElement(registros);
        DefaultTableModel modelo = new DefaultTableModel(linhas, colunas);
        modelo.setColumnCount(files.length);
        modelo.setRowCount(1);
        tabela.setAutoResizeMode(0);
        tabela.setModel(modelo);
    }

    public static void gerarTabela(List<Completitude> listaTabela, JTable tabela) {
        Vector<String> colunas = new Vector<String>();
        Vector linhas = new Vector();
        Vector<Object> registros = new Vector<Object>();
        colunas.addElement("Agravo");
        colunas.addElement("Ano");
        colunas.addElement("Campo");
        colunas.addElement("Completitude (%)");
        colunas.addElement("* Faixa");
        colunas.addElement("Completitude (%) S/Ign.");
        colunas.addElement("* Faixa  S/Ign.");
        for (Completitude item : listaTabela) {
            registros.addElement(item.getAgravo());
            registros.addElement(item.getAno());
            registros.addElement(item.getNome());
            registros.addElement(item.getResultado());
            registros.addElement(item.getFaixa());
            registros.addElement(item.getResultado_9_99());
            registros.addElement(item.getFaixa_9_9());
            linhas.addElement(registros);
            registros = new Vector();
        }
        DefaultTableModel modelo = new DefaultTableModel(linhas, colunas);
        modelo.setColumnCount(7);
        modelo.setRowCount(listaTabela.size());
        tabela.setAutoResizeMode(30);
        tabela.setModel(modelo);
    }

    public static List<String> lerArquivo(String nomeArquivo) {
        ArrayList<String> listaCampos = new ArrayList<String>();
        String diretorio = "campos";
        File file = new File(diretorio + "//" + nomeArquivo);
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            props.load(fis);
            for (Object key : props.keySet()) {
                listaCampos.add(key.toString());
            }
            fis.close();
            return listaCampos;
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static List<String> lerArquivo1(String nomeArquivo) {
        ArrayList<String> listaCampos = new ArrayList<String>();
        try {
            int ln;
            String diretorio = "campos";
            StringBuilder campo = new StringBuilder();
            boolean quebra = false;
            File arquivo = new File(diretorio + "//" + nomeArquivo);
            FileInputStream fis = new FileInputStream(arquivo);
            while ((ln = fis.read()) != -1) {
                if (ln != 13 && ln != 10) {
                    System.out.print((char)ln);
                    campo.append((char)ln);
                    continue;
                }
                listaCampos.add(campo.toString());
                campo = new StringBuilder();
            }
            listaCampos.add(campo.toString());
            fis.close();
            return listaCampos;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return null;
        }
    }

    public static Boolean verificaCampos(String arquivo, String campo) {
        List<String> listaCampos = SinanUtil.lerArquivo(arquivo);
        if (SinanUtil.isListNotEmpty(listaCampos)) {
            for (String item : listaCampos) {
                if (!campo.equals(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static String dateToString(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static void initProgressBar(JProgressBar jProgressBar) {
        jProgressBar.setStringPainted(true);
        jProgressBar.setValue(0);
    }

    public static void refreshProgressBar(JProgressBar jProgressBar, int count, int totalRegistros) {
        float percentualGeral = Float.parseFloat(String.valueOf(count + 1)) / (float)totalRegistros * 100.0f;
        jProgressBar.setValue((int)percentualGeral);
        jProgressBar.setStringPainted(true);
        jProgressBar.setString((int)percentualGeral + "%");
    }

    public static void refreshProgressBarSimple(JProgressBar jProgressBar, int count, int totalRegistros) {
        float percentualGeral = Float.parseFloat(String.valueOf(count + 1)) / (float)totalRegistros * 100.0f;
        jProgressBar.setValue((int)percentualGeral);
        jProgressBar.setStringPainted(true);
        jProgressBar.setString((int)percentualGeral + "%");
    }

    public static void refreshProgressBar(String arquivo, JProgressBar jProgressBar, int count, int totalRegistros) {
        float percentualGeral = Float.parseFloat(String.valueOf(count + 1)) / (float)totalRegistros * 100.0f;
        jProgressBar.setValue((int)percentualGeral);
        jProgressBar.setStringPainted(true);
        jProgressBar.setString(arquivo + " (" + (int)percentualGeral + "%)");
    }

    public static double converterDoubleDuasCasasDecimais(double valorDouble) {
        DecimalFormat fmt = new DecimalFormat("0.00");
        String string = fmt.format(valorDouble);
        String[] part = string.split("[,]");
        String string2 = part[0] + "." + part[1];
        double valor = Double.parseDouble(string2);
        return valor;
    }

    public static double converterDoubleUmaCasaDecimal(double valorDouble) {
        DecimalFormat fmt = new DecimalFormat("0.0");
        String string = fmt.format(valorDouble);
        String[] part = string.split("[,]");
        String string2 = part[0] + "." + part[1];
        double valor = Double.parseDouble(string2);
        return valor;
    }

    @Deprecated
    public static void populaComboAgravo1(JComboBox cbAgravo) {
        cbAgravo.removeAllItems();
        cbAgravo.addItem("Selecione um Agravo");
        cbAgravo.addItem("ACIDENTE DE TRABALHO COM EXPOSI\u00c7\u00c3O \u00c0 MATERIAL BIOL\u00d3GICO");
        cbAgravo.addItem("ACIDENTE DE TRABALHO GRAVE");
        cbAgravo.addItem("ACIDENTE POR ANIMAIS PE\u00c7ONHENTOS");
        cbAgravo.addItem("AIDS ADULTO");
        cbAgravo.addItem("AIDS CRIAN\u00c7A");
        cbAgravo.addItem("ATENDIMENTO ANTI-R\u00c1BICO HUMANO");
        cbAgravo.addItem("BOTULISMO");
        cbAgravo.addItem("C\u00c2NCER RELACIONADO AO TRABALHO");
        cbAgravo.addItem("C\u00d3LERA");
        cbAgravo.addItem("COQUELUCHE");
        cbAgravo.addItem("DENGUE");
        cbAgravo.addItem("DERMATOSES OCUPACIONAIS");
        cbAgravo.addItem("DIFTERIA");
        cbAgravo.addItem("DOEN\u00c7AS DE CHAGAS AGUDA");
        cbAgravo.addItem("DOEN\u00c7AS EXANTEM\u00c1TICAS");
        cbAgravo.addItem("ESQUISTOSSOMOSE");
        cbAgravo.addItem("FEBRE AMARELA");
        cbAgravo.addItem("FEBRE DO NILO");
        cbAgravo.addItem("FEBRE MACULOSA");
        cbAgravo.addItem("FEBRE TIF\u00d3IDE");
        cbAgravo.addItem("GESTANTES HIV +");
        cbAgravo.addItem("HANSEN\u00cdASE");
        cbAgravo.addItem("HANTAVIROSES");
        cbAgravo.addItem("HEPATITES VIRAIS");
        cbAgravo.addItem("INFLUENZA");
        cbAgravo.addItem("INTOXICA\u00c7\u00d5ES EX\u00d3GENAS");
        cbAgravo.addItem("LEISHMANIOSE TEGUMENTAR AMERICANA");
        cbAgravo.addItem("LEISHMANIOSE VISCERAL");
        cbAgravo.addItem("LEPTOSPIROSE");
        cbAgravo.addItem("LER/DORT");
        cbAgravo.addItem("MAL\u00c1RIA");
        cbAgravo.addItem("MENINGITE");
        cbAgravo.addItem("PAIR");
        cbAgravo.addItem("PARALISIA FL\u00c1CIDA AGUDA/POLIOMIELITE");
        cbAgravo.addItem("PESTE");
        cbAgravo.addItem("PNEUMOCONIOSES");
        cbAgravo.addItem("RAIVA HUMANA");
        cbAgravo.addItem("ROTAVIRUS");
        cbAgravo.addItem("S\u00cdFILIS CONG\u00caNITA");
        cbAgravo.addItem("S\u00cdFILIS EM GESTANTE");
        cbAgravo.addItem("S\u00cdNDROME DA RUB\u00c9OLA CONG\u00caNITA");
        cbAgravo.addItem("T\u00c9TANO ACIDENTAL");
        cbAgravo.addItem("T\u00c9TANO NEONATAL");
        cbAgravo.addItem("TRACOMA");
        cbAgravo.addItem("TRANSTORNOS MENTAIS");
        cbAgravo.addItem("TUBERCULOSE");
        cbAgravo.addItem("VIOL\u00caNCIA DOM\u00c9STICA, SEXUAL E/OU OUTRAS VIOL\u00caNCIAS");
    }

    public static void populaComboAgravo(JComboBox cbAgravo) {
        cbAgravo.removeAllItems();
        cbAgravo.addItem("Selecione um Agravo");
        cbAgravo.addItem("AIDS ADULTO");
        cbAgravo.addItem("AIDS CRIAN\u00c7A");
        cbAgravo.addItem("COQUELUCHE");
        cbAgravo.addItem("DENGUE");
        cbAgravo.addItem("DIFTERIA");
        cbAgravo.addItem("DOEN\u00c7AS DE CHAGAS AGUDA");
        cbAgravo.addItem("DOEN\u00c7AS EXANTEM\u00c1TICAS");
        cbAgravo.addItem("FEBRE AMARELA");
        cbAgravo.addItem("GESTANTES HIV +");
        cbAgravo.addItem("HANSEN\u00cdASE");
        cbAgravo.addItem("HEPATITES VIRAIS");
        cbAgravo.addItem("LEISHMANIOSE TEGUMENTAR AMERICANA");
        cbAgravo.addItem("LEISHMANIOSE VISCERAL");
        cbAgravo.addItem("LEPTOSPIROSE");
        cbAgravo.addItem("MENINGITE");
        cbAgravo.addItem("PARALISIA FL\u00c1CIDA AGUDA/POLIOMIELITE");
        cbAgravo.addItem("RAIVA HUMANA");
        cbAgravo.addItem("S\u00cdFILIS CONG\u00caNITA");
        cbAgravo.addItem("S\u00cdFILIS EM GESTANTE");
        cbAgravo.addItem("TUBERCULOSE");
        cbAgravo.addItem("VIOL\u00caNCIA DOM\u00c9STICA, SEXUAL E/OU OUTRAS VIOL\u00caNCIAS");
    }

    public static String bancoAgravo(String agravo) {
        if (agravo.equals("AIDS ADULTO")) {
            return "AIDSA";
        }
        if (agravo.equals("AIDS CRIAN\u00c7A")) {
            return "AIDSC";
        }
        if (agravo.equals("COQUELUCHE")) {
            return "COQUE";
        }
        if (agravo.equals("DENGUE")) {
            return "DENGN";
        }
        if (agravo.equals("DIFTERIA")) {
            return "DIFTE";
        }
        if (agravo.equals("DOEN\u00c7AS DE CHAGAS AGUDA")) {
            return "CHAGA";
        }
        if (agravo.equals("DOEN\u00c7AS EXANTEM\u00c1TICAS")) {
            return "EXANT";
        }
        if (agravo.equals("FEBRE AMARELA")) {
            return "FAMAR";
        }
        if (agravo.equals("GESTANTES HIV +")) {
            return "HIVGE";
        }
        if (agravo.equals("HANSEN\u00cdASE")) {
            return "HANSN";
        }
        if (agravo.equals("HEPATITES VIRAIS")) {
            return "HEPAN";
        }
        if (agravo.equals("LEISHMANIOSE TEGUMENTAR AMERICANA")) {
            return "LTAN";
        }
        if (agravo.equals("LEISHMANIOSE VISCERAL")) {
            return "LEISH";
        }
        if (agravo.equals("LEPTOSPIROSE")) {
            return "LEPTO";
        }
        if (agravo.equals("MENINGITE")) {
            return "MENIN";
        }
        if (agravo.equals("PARALISIA FL\u00c1CIDA AGUDA/POLIOMIELITE")) {
            return "PFAN";
        }
        if (agravo.equals("RAIVA HUMANA")) {
            return "RAIVA";
        }
        if (agravo.equals("S\u00cdFILIS CONG\u00caNITA")) {
            return "SIFIC";
        }
        if (agravo.equals("S\u00cdFILIS EM GESTANTE")) {
            return "SIFGE";
        }
        if (agravo.equals("TUBERCULOSE")) {
            return "TUBEN";
        }
        if (agravo.equals("VIOL\u00caNCIA DOM\u00c9STICA, SEXUAL E/OU OUTRAS VIOL\u00caNCIAS")) {
            return "VIOLE";
        }
        return "";
    }

    @Deprecated
    public static String bancoAgravo1(String agravo) {
        if (agravo.equals("ACIDENTE DE TRABALHO COM EXPOSI\u00c7\u00c3O \u00c0 MATERIAL BIOL\u00d3GICO")) {
            return "ACBIO";
        }
        if (agravo.equals("ACIDENTE DE TRABALHO GRAVE")) {
            return "ACGRA";
        }
        if (agravo.equals("ACIDENTE POR ANIMAIS PE\u00c7ONHENTOS")) {
            return "ANIMP";
        }
        if (agravo.equals("AIDS ADULTO")) {
            return "AIDSA";
        }
        if (agravo.equals("AIDS CRIAN\u00c7A")) {
            return "AIDSC";
        }
        if (agravo.equals("ATENDIMENTO ANTI-R\u00c1BICO HUMANO")) {
            return "ANTRA";
        }
        if (agravo.equals("BOTULISMO")) {
            return "BOTUN";
        }
        if (agravo.equals("C\u00c2NCER RELACIONADO AO TRABALHO")) {
            return "CANCE";
        }
        if (agravo.equals("C\u00d3LERA")) {
            return "COLEN";
        }
        if (agravo.equals("COQUELUCHE")) {
            return "COQUE";
        }
        if (agravo.equals("DENGUE")) {
            return "DENGN";
        }
        if (agravo.equals("DERMATOSES OCUPACIONAIS")) {
            return "DERMA";
        }
        if (agravo.equals("DIFTERIA")) {
            return "DIFTE";
        }
        if (agravo.equals("DOEN\u00c7AS DE CHAGAS AGUDA")) {
            return "CHAGA";
        }
        if (agravo.equals("DOEN\u00c7AS EXANTEM\u00c1TICAS")) {
            return "EXANT";
        }
        if (agravo.equals("ESQUISTOSSOMOSE")) {
            return "ESQUI";
        }
        if (agravo.equals("FEBRE AMARELA")) {
            return "FAMAR";
        }
        if (agravo.equals("FEBRE DO NILO")) {
            return "NILON";
        }
        if (agravo.equals("FEBRE MACULOSA")) {
            return "FMACU";
        }
        if (agravo.equals("FEBRE TIF\u00d3IDE")) {
            return "FTIFO";
        }
        if (agravo.equals("GESTANTES HIV +")) {
            return "HIVGE";
        }
        if (agravo.equals("HANSEN\u00cdASE")) {
            return "HANSN";
        }
        if (agravo.equals("HANTAVIROSES")) {
            return "HANTA";
        }
        if (agravo.equals("HEPATITES VIRAIS")) {
            return "HEPAN";
        }
        if (agravo.equals("INFLUENZA")) {
            return "INFLU";
        }
        if (agravo.equals("INTOXICA\u00c7\u00d5ES EX\u00d3GENAS")) {
            return "IEXOG";
        }
        if (agravo.equals("LEISHMANIOSE TEGUMENTAR AMERICANA")) {
            return "LTAN";
        }
        if (agravo.equals("LEISHMANIOSE VISCERAL")) {
            return "LEISH";
        }
        if (agravo.equals("LEPTOSPIROSE")) {
            return "LEPTO";
        }
        if (agravo.equals("LER/DORT")) {
            return "LERN";
        }
        if (agravo.equals("MAL\u00c1RIA")) {
            return "MALAN";
        }
        if (agravo.equals("MENINGITE")) {
            return "MENIN";
        }
        if (agravo.equals("PAIR")) {
            return "PAIRN";
        }
        if (agravo.equals("PARALISIA FL\u00c1CIDA AGUDA/POLIOMIELITE")) {
            return "PFAN";
        }
        if (agravo.equals("PESTE")) {
            return "PESTE";
        }
        if (agravo.equals("PNEUMOCONIOSES")) {
            return "PNEUM";
        }
        if (agravo.equals("RAIVA HUMANA")) {
            return "RAIVA";
        }
        if (agravo.equals("ROTAVIRUS")) {
            return "ROTAN";
        }
        if (agravo.equals("S\u00cdFILIS CONG\u00caNITA")) {
            return "SIFIC";
        }
        if (agravo.equals("S\u00cdFILIS EM GESTANTE")) {
            return "SIFGE";
        }
        if (agravo.equals("S\u00cdNDROME DA RUB\u00c9OLA CONG\u00caNITA")) {
            return "SRCN";
        }
        if (agravo.equals("T\u00c9TANO ACIDENTAL")) {
            return "TETAC";
        }
        if (agravo.equals("T\u00c9TANO NEONATAL")) {
            return "TETAN";
        }
        if (agravo.equals("TRACOMA")) {
            return "TRACO";
        }
        if (agravo.equals("TRANSTORNOS MENTAIS")) {
            return "MENTA";
        }
        if (agravo.equals("TUBERCULOSE")) {
            return "TUBEN";
        }
        if (agravo.equals("VIOL\u00caNCIA DOM\u00c9STICA, SEXUAL E/OU OUTRAS VIOL\u00caNCIAS")) {
            return "VIOLE";
        }
        return "";
    }

    public static String extrairNomeSobrenome(String nomeCompleto) {
        String[] nome = nomeCompleto.split(" ");
        return nome[0] + nome[nome.length - 1];
    }

    public static DBFReader retornaObjetoDbfCaminhoArquivo(String arquivo, String caminho) {
        DBFReader reader = null;
        FileInputStream inputStream = null;
        try {
            inputStream = System.getProperty("os.name").compareTo("Linux") == 0 ? new FileInputStream(caminho.replace("\\", "/") + arquivo + ".DBF") : new FileInputStream(caminho + arquivo + ".DBF");
        }
        catch (FileNotFoundException e) {
            Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro: tabela " + arquivo + ".dbf nao encontrada.\n" + e);
            return reader;
        }
        try {
            reader = new DBFReader((InputStream)inputStream);
        }
        catch (DBFException e) {
            Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro: tabela " + arquivo + ".dbf nao encontrada.\n" + (Object)((Object)e));
        }
        return reader;
    }

    public static String municipioCodigoToNome(String idMunicipio) throws SQLException {
        if (idMunicipio == null) {
            return "";
        }
        DBFReader reader = SinanUtil.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
        DBFUtil utilDbf = new DBFUtil();
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            while ((rowObjects = reader.nextRecord()) != null) {
                if (!idMunicipio.equals(utilDbf.getString(rowObjects, "ID_MUNICIP"))) continue;
                return utilDbf.getString(rowObjects, "NM_MUNICIP");
            }
        }
        catch (DBFException e) {
            SinanUtil.mensagem("Erro: regional nao encontrada.Verifique se existe a pasta DBF e se os arquivo REGIONET.DBF est\u00e1 l\u00e1:\n" + (Object)((Object)e));
        }
        return "";
    }

    public static List<OportunidadeAgravoCOAP> removeMunicipiosIgnorados(List<OportunidadeAgravoCOAP> lista) {
        ArrayList<OportunidadeAgravoCOAP> listaMunicipio = new ArrayList<OportunidadeAgravoCOAP>();
        for (OportunidadeAgravoCOAP municipio : lista) {
            if (SinanUtil.verificaMunicipioIgnorado(municipio).booleanValue()) continue;
            listaMunicipio.add(municipio);
        }
        return listaMunicipio;
    }

    public static Boolean verificaMunicipioIgnorado(OportunidadeAgravoCOAP municipio) {
        if (municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - RO") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - RN") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - AL") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - SE") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - MG") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - ES") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - RJ") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - SP") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - RS") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - MS") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - MT") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - GO") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - DF") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - RR") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - PA") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - AP") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - TO") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - MA") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - PI") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - CE") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - PB") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - PE") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - BA") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - PR") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - SC") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - AC") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - AM")) {
            return true;
        }
        return false;
    }

    public static List<OportunidadeAgravoPQAVS> removeMunicipiosIgnoradosPQAVS(List<OportunidadeAgravoPQAVS> lista) {
        ArrayList<OportunidadeAgravoPQAVS> listaMunicipio = new ArrayList<OportunidadeAgravoPQAVS>();
        for (OportunidadeAgravoPQAVS municipio : lista) {
            if (SinanUtil.verificaMunicipioIgnorado(municipio).booleanValue()) continue;
            listaMunicipio.add(municipio);
        }
        return listaMunicipio;
    }

    public static Boolean verificaMunicipioIgnorado(OportunidadeAgravoPQAVS municipio) {
        if (municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - RO") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - RN") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - AL") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - SE") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - MG") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - ES") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - RJ") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - SP") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - RS") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - MS") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - MT") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - GO") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - DF") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - RR") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - PA") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - AP") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - TO") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - MA") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - PI") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - CE") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - PB") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - PE") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - BA") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - PR") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - SC") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - AC") || municipio.getNmAgravo().equals("MUNICIPIO IGNORADO - AM")) {
            return true;
        }
        return false;
    }

    public static Map<String, String> retornaListaRegioes(String uf) {
        HashMap<String, String> listaRegioes = new HashMap<String, String>();
        DBFUtil utilDbf = new DBFUtil();
        Boolean temReg = false;
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("REGIAO", "dbf\\");
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                if ((uf.equals("TODAS") || uf.equals("Brasil") || uf.equals("TODOS")) && utilDbf.getString(rowObjects1, "ID_REGIAO") != null) {
                    temReg = true;
                }
                if (!temReg.booleanValue() && !uf.equals(utilDbf.getString(rowObjects1, "SG_UF"))) continue;
                listaRegioes.put(utilDbf.getString(rowObjects1, "ID_REGIAO"), utilDbf.getString(rowObjects1, "NM_REGIAO"));
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        Set regKeys = listaRegioes.keySet();
        HashMap<String, String> listaRegioesRetorno = new HashMap<String, String>();
        for (String key : regKeys) {
            listaRegioesRetorno.put(key, (String)listaRegioes.get(key));
        }
        return listaRegioesRetorno;
    }

    public static Map<String, String> retornaListaRegionais(String uf) {
        HashMap<String, String> listaRegionais = new HashMap<String, String>();
        DBFUtil utilDbf = new DBFUtil();
        Boolean temReg = false;
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("REGIONET", "dbf\\");
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                if ((uf.equals("TODAS") || uf.equals("Brasil") || uf.equals("TODOS")) && utilDbf.getString(rowObjects1, "ID_REGIONA") != null) {
                    temReg = true;
                }
                if (!temReg.booleanValue() && !utilDbf.getString(rowObjects1, "SG_UF").equals(uf)) continue;
                listaRegionais.put(utilDbf.getString(rowObjects1, "ID_REGIONA"), utilDbf.getString(rowObjects1, "NM_REGIONA"));
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        Set regKeys = listaRegionais.keySet();
        HashMap<String, String> listaRegionaisRetorno = new HashMap<String, String>();
        for (String key : regKeys) {
            listaRegionaisRetorno.put(key, (String)listaRegionais.get(key));
        }
        return listaRegionaisRetorno;
    }
}

