/*
 * Decompiled with CFR 0.152.
 */
package com.org.view;

import com.org.facade.SessionFacadeImpl;
import com.org.model.classes.Agravo;
import com.org.negocio.Configuracao;
import com.org.negocio.FiltroArquivo;
import com.org.util.SinanDateUtil;
import com.org.view.DengueLetalidade;
import com.org.view.Master;
import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;

public class AidsTaxaCrianca
extends DengueLetalidade {
    SessionFacadeImpl session = new SessionFacadeImpl();
    private JButton btCalcular;
    private JButton btLimpar;
    private JButton btnLimparSelecao;
    private JButton btnSelecionarArquivos;
    private JComboBox cbMunicipio;
    private JComboBox cbRegional;
    private JComboBox cbUf;
    private JCheckBox chkExportarDbf;
    private JDateChooser dataFim;
    private JDateChooser dataInicio;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jpDataPrimeiroSintomas;
    private JLabel lblArquivosSelecionados;
    private JLabel lblAviso;
    private JLabel lblUF;
    private JPanel pnlArquivos;
    private JProgressBar prbStatus;

    public AidsTaxaCrianca() {
        this.initComponents();
        this.session.setBrasil(true);
        this.session.setTodosMunicipios(true);
        DefaultComboBoxModel<String> modelo = new DefaultComboBoxModel<String>(this.session.retornaUFs());
        this.cbUf.setModel(modelo);
        if (SessionFacadeImpl.isDbf()) {
            this.pnlArquivos.setVisible(true);
        } else {
            this.pnlArquivos.setVisible(false);
        }
    }

    private boolean preencheuFormulario() {
        if (this.cbUf.getSelectedItem().toString().equals("-- Selecione --")) {
            Master.mensagem("Selecione a UF de resid\u00eancia");
            return false;
        }
        if (SinanDateUtil.dateToStringException(this.dataInicio.getDate(), "dd/MM/yyyy").equals("")) {
            Master.mensagem("Informe o per\u00edodo inicial");
            return false;
        }
        if (SinanDateUtil.dateToStringException(this.dataFim.getDate(), "dd/MM/yyyy").equals("")) {
            Master.mensagem("Informe o per\u00edodo final");
            return false;
        }
        if (Integer.parseInt(SinanDateUtil.dateToStringException(this.dataInicio.getDate(), "dd/MM/yyyy").substring(6, 10)) < 2007) {
            Master.mensagem("N\u00e3o \u00e9 poss\u00edvel utilizar esse relat\u00f3rio para datas anteriores a 2007");
            return false;
        }
        try {
            Date dtInicio = Agravo.converterParaData(SinanDateUtil.dateToStringException(this.dataInicio.getDate(), "dd/MM/yyyy"));
            Date dtFim = Agravo.converterParaData(SinanDateUtil.dateToStringException(this.dataFim.getDate(), "dd/MM/yyyy"));
            if (dtFim.before(dtInicio)) {
                Master.mensagem("Data final deve ser maior que inicial");
                return false;
            }
        }
        catch (Exception e) {
            Master.mensagem("Data inv\u00e1lida");
            return false;
        }
        if (this.lblArquivosSelecionados.getText().equals("Nenhum arquivo selecionado") && SessionFacadeImpl.isDbf()) {
            Master.mensagem("Selecione um arquivo.");
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.cbRegional = new JComboBox();
        this.jLabel4 = new JLabel();
        this.cbUf = new JComboBox();
        this.chkExportarDbf = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.cbMunicipio = new JComboBox();
        this.lblUF = new JLabel();
        this.jpDataPrimeiroSintomas = new JPanel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.lblAviso = new JLabel();
        this.dataInicio = new JDateChooser("dd/MM/yyyy", "##/##/#####", '_');
        this.dataFim = new JDateChooser("dd/MM/yyyy", "##/##/#####", '_');
        this.prbStatus = new JProgressBar();
        this.btCalcular = new JButton();
        this.btLimpar = new JButton();
        this.pnlArquivos = new JPanel();
        this.btnSelecionarArquivos = new JButton();
        this.btnLimparSelecao = new JButton();
        this.lblArquivosSelecionados = new JLabel();
        this.cbRegional.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AidsTaxaCrianca.this.cbRegionalActionPerformed(evt);
            }
        });
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText("Munic\u00edpio de Resid\u00eancia:");
        this.cbUf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AidsTaxaCrianca.this.cbUfActionPerformed(evt);
            }
        });
        this.chkExportarDbf.setText("Salvar resultado em DBF");
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Regional de Resid\u00eancia:");
        this.cbMunicipio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AidsTaxaCrianca.this.cbMunicipioActionPerformed(evt);
            }
        });
        this.lblUF.setFont(new Font("Tahoma", 1, 11));
        this.lblUF.setText("UF de Resid\u00eancia:");
        this.jpDataPrimeiroSintomas.setBorder(BorderFactory.createTitledBorder(null, "Data de Diagn\u00f3stico\n", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel7.setText("De");
        this.jLabel8.setText("at\u00e9");
        this.lblAviso.setFont(new Font("Tahoma", 1, 11));
        this.lblAviso.setForeground(new Color(255, 0, 0));
        this.dataInicio.getJCalendar().setWeekOfYearVisible(false);
        this.dataFim.getJCalendar().setWeekOfYearVisible(false);
        GroupLayout jpDataPrimeiroSintomasLayout = new GroupLayout(this.jpDataPrimeiroSintomas);
        this.jpDataPrimeiroSintomas.setLayout(jpDataPrimeiroSintomasLayout);
        jpDataPrimeiroSintomasLayout.setHorizontalGroup(jpDataPrimeiroSintomasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpDataPrimeiroSintomasLayout.createSequentialGroup().addContainerGap().addGroup(jpDataPrimeiroSintomasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpDataPrimeiroSintomasLayout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dataInicio, -2, 130, -2).addGap(52, 52, 52).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dataFim, -2, 130, -2)).addComponent(this.lblAviso)).addContainerGap(55, Short.MAX_VALUE)));
        jpDataPrimeiroSintomasLayout.setVerticalGroup(jpDataPrimeiroSintomasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jpDataPrimeiroSintomasLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jpDataPrimeiroSintomasLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.dataFim, -2, -1, -2).addComponent((Component)this.dataInicio, -2, -1, -2).addGroup(jpDataPrimeiroSintomasLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jLabel8))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblAviso)));
        this.btCalcular.setLabel("Calcular");
        this.btCalcular.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AidsTaxaCrianca.this.btCalcularActionPerformed(evt);
            }
        });
        this.btLimpar.setText("Limpar");
        this.btLimpar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AidsTaxaCrianca.this.btLimparActionPerformed(evt);
            }
        });
        this.pnlArquivos.setBorder(BorderFactory.createTitledBorder("Selecione os DBF "));
        this.btnSelecionarArquivos.setText("Selecionar arquivos");
        this.btnSelecionarArquivos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AidsTaxaCrianca.this.btnSelecionarArquivosActionPerformed(evt);
            }
        });
        this.btnLimparSelecao.setText("Limpar Sele\u00e7\u00e3o");
        this.btnLimparSelecao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AidsTaxaCrianca.this.btnLimparSelecaoActionPerformed(evt);
            }
        });
        this.lblArquivosSelecionados.setText("Nenhum arquivo selecionado");
        this.lblArquivosSelecionados.setVerticalAlignment(1);
        this.lblArquivosSelecionados.setBorder(new SoftBevelBorder(0));
        GroupLayout pnlArquivosLayout = new GroupLayout(this.pnlArquivos);
        this.pnlArquivos.setLayout(pnlArquivosLayout);
        pnlArquivosLayout.setHorizontalGroup(pnlArquivosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 414, Short.MAX_VALUE).addGroup(pnlArquivosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlArquivosLayout.createSequentialGroup().addContainerGap().addGroup(pnlArquivosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblArquivosSelecionados, -1, 404, Short.MAX_VALUE).addGroup(pnlArquivosLayout.createSequentialGroup().addComponent(this.btnSelecionarArquivos).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLimparSelecao).addContainerGap(166, Short.MAX_VALUE))))));
        pnlArquivosLayout.setVerticalGroup(pnlArquivosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 61, Short.MAX_VALUE).addGroup(pnlArquivosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlArquivosLayout.createSequentialGroup().addGap(1, 1, 1).addGroup(pnlArquivosLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSelecionarArquivos).addComponent(this.btnLimparSelecao)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblArquivosSelecionados).addContainerGap(-1, Short.MAX_VALUE))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(32, 32, 32).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblUF).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cbMunicipio, 0, -1, Short.MAX_VALUE).addComponent(this.cbRegional, 0, -1, Short.MAX_VALUE).addComponent(this.cbUf, -2, 229, -2).addComponent(this.chkExportarDbf))).addGroup(layout.createSequentialGroup().addGap(139, 139, 139).addComponent(this.btCalcular).addGap(26, 26, 26).addComponent(this.btLimpar))).addContainerGap(44, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.prbStatus, -1, 415, Short.MAX_VALUE).addGap(21, 21, 21)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jpDataPrimeiroSintomas, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.pnlArquivos, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblUF).addComponent(this.cbUf, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbRegional, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.cbMunicipio, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkExportarDbf).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jpDataPrimeiroSintomas, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlArquivos, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prbStatus, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btCalcular, -1, -1, Short.MAX_VALUE).addComponent(this.btLimpar))));
    }

    private void cbRegionalActionPerformed(ActionEvent evt) {
        DefaultComboBoxModel<String> modelo = new DefaultComboBoxModel<String>(this.session.retornaMunicipios(this.cbUf.getSelectedItem().toString(), this.cbRegional.getSelectedItem().toString()));
        this.cbMunicipio.setModel(modelo);
    }

    private void cbUfActionPerformed(ActionEvent evt) {
        DefaultComboBoxModel<String> modelo = new DefaultComboBoxModel<String>(this.session.retornaRegionais(this.cbUf.getSelectedItem().toString()));
        this.cbRegional.setModel(modelo);
        modelo = new DefaultComboBoxModel<String>(this.session.retornaMunicipios(this.cbUf.getSelectedItem().toString()));
        this.cbMunicipio.setModel(modelo);
    }

    private void cbMunicipioActionPerformed(ActionEvent evt) {
    }

    private void btCalcularActionPerformed(ActionEvent evt) {
        if (!this.preencheuFormulario()) {
            return;
        }
        this.session = new SessionFacadeImpl();
        this.session.setBrasil(true);
        SessionFacadeImpl.setNomeDbf("AIDSC");
        this.session.setTodosMunicipios(true);
        if (this.chkExportarDbf.isSelected()) {
            this.session.setExportarDbf(true);
        } else {
            this.session.setExportarDbf(false);
        }
        this.prbStatus.setStringPainted(true);
        this.prbStatus.setValue(0);
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parArquivos", this.lblArquivosSelecionados.getText());
        parametros.put("parVariosArquivos", "sim");
        this.session.setParametros(parametros);
        this.session.setDataFim(SinanDateUtil.dateToStringException(this.dataFim.getDate(), "dd/MM/yyyy"));
        this.session.setDataInicio(SinanDateUtil.dateToStringException(this.dataInicio.getDate(), "dd/MM/yyyy"));
        this.session.setJprogress(this.prbStatus);
        this.session.setMunicipio(this.cbMunicipio.getSelectedItem().toString());
        this.session.setRegional(this.cbRegional.getSelectedItem().toString());
        this.session.setUf(this.cbUf.getSelectedItem().toString());
        this.session.setRelatorio("AidsTaxaCrianca");
        this.session.execute();
    }

    private void btLimparActionPerformed(ActionEvent evt) {
        this.cbMunicipio.removeAllItems();
        this.cbRegional.removeAllItems();
        this.cbUf.setSelectedIndex(0);
    }

    private void btnSelecionarArquivosActionPerformed(ActionEvent evt) {
        JFileChooser fileopen = new JFileChooser();
        fileopen.setMultiSelectionEnabled(true);
        FiltroArquivo filtro = new FiltroArquivo();
        filtro.addExtension("dbf");
        filtro.setDescription("Arquivo DBF");
        filtro.addInicioNome("AIDSC");
        fileopen.addChoosableFileFilter(filtro);
        fileopen.setFileFilter(filtro);
        File file2 = new File(new Configuracao().getCaminho());
        fileopen.setCurrentDirectory(file2);
        int ret = fileopen.showDialog(null, "Abrir DBF");
        if (ret == 0) {
            File[] files = fileopen.getSelectedFiles();
            if (this.lblArquivosSelecionados.getText().equals("Nenhum arquivo selecionado")) {
                this.lblArquivosSelecionados.setText("");
            }
            for (int i = 0; i < files.length; ++i) {
                if (this.lblArquivosSelecionados.getText().lastIndexOf(files[i].getName()) == -1) {
                    this.lblArquivosSelecionados.setText(this.lblArquivosSelecionados.getText() + files[i].getName() + "||");
                }
                Configuracao.setPropriedade("caminho", files[i].getParent() + "\\\\");
            }
        }
    }

    private void btnLimparSelecaoActionPerformed(ActionEvent evt) {
        this.lblArquivosSelecionados.setText("Nenhum arquivo selecionado");
    }
}

