/*
 * Decompiled with CFR 0.152.
 */
package com.org.view;

import com.org.facade.SessionFacadeImpl;
import com.org.negocio.Configuracao;
import com.org.negocio.FiltroArquivo;
import com.org.util.SinanUtil;
import com.org.view.Master;
import com.org.view.Oportunidade;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Regularidade
extends JPanel {
    SessionFacadeImpl session = new SessionFacadeImpl();
    boolean gtSinan = false;
    Map<Integer, String> mapaPeriodo = new HashMap<Integer, String>();
    private JButton btCalcular;
    private JButton btLimpar;
    private JButton btnInserirPeriodo;
    private JButton btnLimparSelecao;
    private JButton btnSelecionarArquivos;
    private ButtonGroup buttonGroup1;
    private JComboBox cbAnoFinalMunicipio;
    private JComboBox cbAnoInicialMunicipio;
    private JComboBox<String> cbDesagregacao;
    private JComboBox cbMunicipio;
    private JComboBox cbRegional;
    private JComboBox cbUf;
    private JCheckBox chkExportarDbf;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel30;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JLabel lblArquivosSelecionados;
    private JLabel lblDesagregacao;
    private JLabel lblRegional;
    private JLabel lblUF;
    private JPanel panelMunicipioSemNotificacao;
    private JProgressBar prbStatus;
    private JProgressBar prbStatusGeral;
    private JRadioButton rbRegAnalitico;
    private JRadioButton rbRegAnaliticoSintetico;
    private JRadioButton rbRegSintetico;
    private JSpinner spSemanaFinal;
    private JSpinner spSemanaInicial;
    private JTextArea txtPeriodos;

    public Regularidade() {
        this.initComponents();
        Oportunidade.preencheAnos(this.cbAnoInicialMunicipio, 2009);
        Oportunidade.preencheAnos(this.cbAnoFinalMunicipio, 2009);
        this.session.setBrasil(true);
        this.session.setTodosMunicipios(true);
        this.session.setTemOpcaoTodasUFs(false);
        DefaultComboBoxModel<String> modelo = new DefaultComboBoxModel<String>(this.session.retornaUFs());
        this.cbUf.setModel(modelo);
        Configuracao conf = new Configuracao();
        if (Configuracao.getPropriedade("gtsinan").toString().equals("1")) {
            this.txtPeriodos.setVisible(true);
            this.btnInserirPeriodo.setVisible(true);
            this.gtSinan = true;
            this.chkExportarDbf.setSelected(true);
        } else {
            this.txtPeriodos.setVisible(false);
            this.btnInserirPeriodo.setVisible(false);
        }
    }

    private boolean preencheuFormulario() {
        if (this.txtPeriodos.getText().isEmpty()) {
            Master.mensagem("N\u00e3o h\u00e1 per\u00edodos para emiss\u00e3o do relat\u00f3rio.");
            return false;
        }
        if (this.cbUf.getSelectedItem().toString().equals("-- Selecione --")) {
            Master.mensagem("Selecione a UF de resid\u00eancia");
            return false;
        }
        if (Integer.parseInt(this.spSemanaInicial.getValue().toString()) > 53 || Integer.parseInt(this.spSemanaFinal.getValue().toString()) > 53) {
            Master.mensagem("Semana deve ser menor que 54");
            return false;
        }
        int anoInicial = Integer.parseInt(this.cbAnoInicialMunicipio.getSelectedItem().toString());
        int anoFinal = Integer.parseInt(this.cbAnoFinalMunicipio.getSelectedItem().toString());
        int semanaIncial = Integer.parseInt(this.spSemanaInicial.getValue().toString());
        int semanaFinal = Integer.parseInt(this.spSemanaFinal.getValue().toString());
        if (anoFinal < anoInicial) {
            Master.mensagem("Ano final deve ser maior que inicial");
            return false;
        }
        if (anoInicial == anoFinal && semanaFinal < semanaIncial) {
            Master.mensagem("Semana final deve ser maior que inicial");
            return false;
        }
        if (this.txtPeriodos.getLineCount() > 18) {
            SinanUtil.mensagem("Mensagem", "N\u00e3o \u00e9 poss\u00edvel inserir mais de 18 per\u00edodos.");
            return false;
        }
        return true;
    }

    public boolean validaSemana() {
        return Integer.parseInt(this.spSemanaInicial.getValue().toString()) > 53 || Integer.parseInt(this.spSemanaFinal.getValue().toString()) > 53;
    }

    public boolean validaAno() {
        int anoInicial = Integer.parseInt(this.cbAnoInicialMunicipio.getSelectedItem().toString());
        int anoFinal = Integer.parseInt(this.cbAnoFinalMunicipio.getSelectedItem().toString());
        return anoFinal < anoInicial;
    }

    public boolean validaPeriodoSemana() {
        int anoInicial = Integer.parseInt(this.cbAnoInicialMunicipio.getSelectedItem().toString());
        int anoFinal = Integer.parseInt(this.cbAnoFinalMunicipio.getSelectedItem().toString());
        int semanaIncial = Integer.parseInt(this.spSemanaInicial.getValue().toString());
        int semanaFinal = Integer.parseInt(this.spSemanaFinal.getValue().toString());
        return anoInicial == anoFinal && semanaFinal < semanaIncial;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.panelMunicipioSemNotificacao = new JPanel();
        this.btnSelecionarArquivos = new JButton();
        this.lblArquivosSelecionados = new JLabel();
        this.btnLimparSelecao = new JButton();
        this.jLabel26 = new JLabel();
        this.cbAnoInicialMunicipio = new JComboBox();
        this.jLabel27 = new JLabel();
        this.jLabel28 = new JLabel();
        this.spSemanaInicial = new JSpinner();
        this.jLabel29 = new JLabel();
        this.cbAnoFinalMunicipio = new JComboBox();
        this.jLabel30 = new JLabel();
        this.spSemanaFinal = new JSpinner();
        this.jScrollPane1 = new JScrollPane();
        this.txtPeriodos = new JTextArea();
        this.btnInserirPeriodo = new JButton();
        this.prbStatus = new JProgressBar();
        this.btLimpar = new JButton();
        this.btCalcular = new JButton();
        this.cbUf = new JComboBox();
        this.chkExportarDbf = new JCheckBox();
        this.lblRegional = new JLabel();
        this.cbMunicipio = new JComboBox();
        this.jLabel4 = new JLabel();
        this.cbRegional = new JComboBox();
        this.lblUF = new JLabel();
        this.jPanel1 = new JPanel();
        this.rbRegAnalitico = new JRadioButton();
        this.rbRegSintetico = new JRadioButton();
        this.rbRegAnaliticoSintetico = new JRadioButton();
        this.prbStatusGeral = new JProgressBar();
        this.lblDesagregacao = new JLabel();
        this.cbDesagregacao = new JComboBox();
        this.panelMunicipioSemNotificacao.setBorder(BorderFactory.createTitledBorder("Arquivos DBF selecionados"));
        this.btnSelecionarArquivos.setText("Selecionar arquivos");
        this.btnSelecionarArquivos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Regularidade.this.btnSelecionarArquivosActionPerformed(evt);
            }
        });
        this.lblArquivosSelecionados.setText("Nenhum arquivo selecionado");
        this.lblArquivosSelecionados.setVerticalAlignment(1);
        this.lblArquivosSelecionados.setBorder(new SoftBevelBorder(0));
        this.btnLimparSelecao.setText("Limpar Sele\u00e7\u00e3o");
        this.btnLimparSelecao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Regularidade.this.btnLimparSelecaoActionPerformed(evt);
            }
        });
        this.jLabel26.setFont(new Font("Tahoma", 1, 11));
        this.jLabel26.setForeground(Color.red);
        this.jLabel26.setText("Selecione os seguintes arquivos DBF: Notifica\u00e7\u00e3o Individual, Negativa, Surto, Tracoma e Epizootia");
        this.cbAnoInicialMunicipio.setModel(new DefaultComboBoxModel<String>(new String[]{"2001", "2002", "2003", "2004", "2005", "2006", "2007", "2008"}));
        this.cbAnoInicialMunicipio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Regularidade.this.cbAnoInicialMunicipioActionPerformed(evt);
            }
        });
        this.jLabel27.setText("DE   Ano:");
        this.jLabel28.setText("Semana:");
        this.spSemanaInicial.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Regularidade.this.spSemanaInicialStateChanged(evt);
            }
        });
        this.jLabel29.setText("AT\u00c9  Ano:");
        this.cbAnoFinalMunicipio.setModel(new DefaultComboBoxModel<String>(new String[]{"2001", "2002", "2003", "2004", "2005", "2006", "2007", "2008"}));
        this.cbAnoFinalMunicipio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Regularidade.this.cbAnoFinalMunicipioActionPerformed(evt);
            }
        });
        this.jLabel30.setText("Semana:");
        this.spSemanaFinal.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Regularidade.this.spSemanaFinalStateChanged(evt);
            }
        });
        this.txtPeriodos.setColumns(20);
        this.txtPeriodos.setRows(5);
        this.jScrollPane1.setViewportView(this.txtPeriodos);
        this.btnInserirPeriodo.setText("Inserir");
        this.btnInserirPeriodo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Regularidade.this.btnInserirPeriodoActionPerformed(evt);
            }
        });
        GroupLayout panelMunicipioSemNotificacaoLayout = new GroupLayout(this.panelMunicipioSemNotificacao);
        this.panelMunicipioSemNotificacao.setLayout(panelMunicipioSemNotificacaoLayout);
        panelMunicipioSemNotificacaoLayout.setHorizontalGroup(panelMunicipioSemNotificacaoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelMunicipioSemNotificacaoLayout.createSequentialGroup().addContainerGap().addGroup(panelMunicipioSemNotificacaoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelMunicipioSemNotificacaoLayout.createSequentialGroup().addGap(0, 22, Short.MAX_VALUE).addGroup(panelMunicipioSemNotificacaoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblArquivosSelecionados, -2, 567, -2).addGroup(panelMunicipioSemNotificacaoLayout.createSequentialGroup().addComponent(this.btnSelecionarArquivos).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLimparSelecao)).addGroup(panelMunicipioSemNotificacaoLayout.createSequentialGroup().addGroup(panelMunicipioSemNotificacaoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelMunicipioSemNotificacaoLayout.createSequentialGroup().addGroup(panelMunicipioSemNotificacaoLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(panelMunicipioSemNotificacaoLayout.createSequentialGroup().addComponent(this.jLabel29).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbAnoFinalMunicipio, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel30).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.spSemanaFinal, -2, 41, -2)).addGroup(panelMunicipioSemNotificacaoLayout.createSequentialGroup().addComponent(this.jLabel27).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbAnoInicialMunicipio, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel28).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.spSemanaInicial, -2, 42, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(GroupLayout.Alignment.TRAILING, panelMunicipioSemNotificacaoLayout.createSequentialGroup().addComponent(this.btnInserirPeriodo).addGap(75, 75, 75))).addComponent(this.jScrollPane1, -2, 298, -2)))).addGroup(panelMunicipioSemNotificacaoLayout.createSequentialGroup().addComponent(this.jLabel26).addGap(0, 0, Short.MAX_VALUE)))));
        panelMunicipioSemNotificacaoLayout.setVerticalGroup(panelMunicipioSemNotificacaoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelMunicipioSemNotificacaoLayout.createSequentialGroup().addComponent(this.jLabel26).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelMunicipioSemNotificacaoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSelecionarArquivos).addComponent(this.btnLimparSelecao)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblArquivosSelecionados).addGroup(panelMunicipioSemNotificacaoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelMunicipioSemNotificacaoLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(panelMunicipioSemNotificacaoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel27).addComponent(this.cbAnoInicialMunicipio, -2, -1, -2).addComponent(this.jLabel28).addComponent(this.spSemanaInicial, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelMunicipioSemNotificacaoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel29).addComponent(this.cbAnoFinalMunicipio, -2, -1, -2).addComponent(this.jLabel30).addComponent(this.spSemanaFinal, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnInserirPeriodo)).addGroup(GroupLayout.Alignment.TRAILING, panelMunicipioSemNotificacaoLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -2, 96, -2))).addContainerGap()));
        this.btLimpar.setText("Limpar");
        this.btLimpar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Regularidade.this.btLimparActionPerformed(evt);
            }
        });
        this.btCalcular.setLabel("Calcular");
        this.btCalcular.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Regularidade.this.btCalcularActionPerformed(evt);
            }
        });
        this.cbUf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Regularidade.this.cbUfActionPerformed(evt);
            }
        });
        this.chkExportarDbf.setText("Salvar resultado em DBF");
        this.lblRegional.setFont(new Font("Tahoma", 1, 11));
        this.lblRegional.setText("Regional:");
        this.cbMunicipio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Regularidade.this.cbMunicipioActionPerformed(evt);
            }
        });
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText("Munic\u00edpio:");
        this.cbRegional.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Regularidade.this.cbRegionalActionPerformed(evt);
            }
        });
        this.lblUF.setFont(new Font("Tahoma", 1, 11));
        this.lblUF.setText("UF de Notifica\u00e7\u00e3o:");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Tipo de relat\u00f3rio"));
        this.buttonGroup1.add(this.rbRegAnalitico);
        this.rbRegAnalitico.setSelected(true);
        this.rbRegAnalitico.setText("Anal\u00edtico");
        this.rbRegAnalitico.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Regularidade.this.rbRegAnaliticoActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.rbRegSintetico);
        this.rbRegSintetico.setText("Sint\u00e9tico");
        this.buttonGroup1.add(this.rbRegAnaliticoSintetico);
        this.rbRegAnaliticoSintetico.setText("Anal\u00edtico e Sint\u00e9tico");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbRegAnalitico).addComponent(this.rbRegSintetico).addComponent(this.rbRegAnaliticoSintetico)).addContainerGap(38, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.rbRegAnalitico).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbRegSintetico).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.rbRegAnaliticoSintetico)));
        this.lblDesagregacao.setFont(new Font("Tahoma", 1, 11));
        this.lblDesagregacao.setText("Desagrega\u00e7\u00e3o:");
        this.cbDesagregacao.setModel(new DefaultComboBoxModel<String>(new String[]{"-- Selecione --", "UF subdividida por Regi\u00f5es de Sa\u00fade", "UF subdividida por Regionais de Sa\u00fade", "Somente munic\u00edpios"}));
        this.cbDesagregacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Regularidade.this.cbDesagregacaoActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblUF).addComponent(this.lblRegional).addComponent(this.jLabel4).addComponent(this.lblDesagregacao)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cbMunicipio, 0, -1, Short.MAX_VALUE).addComponent(this.cbRegional, 0, -1, Short.MAX_VALUE).addComponent(this.cbUf, 0, 229, Short.MAX_VALUE).addComponent(this.chkExportarDbf).addComponent(this.cbDesagregacao, 0, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2)).addComponent(this.panelMunicipioSemNotificacao, -2, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.prbStatusGeral, -1, -1, Short.MAX_VALUE).addComponent(this.prbStatus, -1, 410, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btCalcular, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btLimpar, -2, 65, -2))).addContainerGap(24, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblUF).addComponent(this.cbUf, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDesagregacao).addComponent(this.cbDesagregacao, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbRegional, -2, -1, -2).addComponent(this.lblRegional)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.cbMunicipio, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkExportarDbf))).addGap(27, 27, 27).addComponent(this.panelMunicipioSemNotificacao, -2, 192, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.prbStatus, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prbStatusGeral, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btCalcular).addComponent(this.btLimpar))).addGap(18, 18, 18)));
    }

    private void btnSelecionarArquivosActionPerformed(ActionEvent evt) {
        JFileChooser fileopen = new JFileChooser();
        fileopen.setMultiSelectionEnabled(true);
        FiltroArquivo filtro = new FiltroArquivo();
        filtro.addExtension("dbf");
        filtro.setDescription("Arquivo DBF");
        filtro.addInicioNome("NINDI");
        filtro.addInicioNome("NNEGA");
        filtro.addInicioNome("EPIZO");
        filtro.addInicioNome("NSURT");
        filtro.addInicioNome("DENGO");
        filtro.addInicioNome("NTRAC");
        fileopen.addChoosableFileFilter(filtro);
        fileopen.setFileFilter(filtro);
        File file2 = new File(new Configuracao().getCaminho());
        fileopen.setCurrentDirectory(file2);
        int ret = fileopen.showDialog(null, "Abrir DBF");
        String[] arquivos = null;
        if (ret == 0) {
            File[] files = fileopen.getSelectedFiles();
            if (this.lblArquivosSelecionados.getText().equals("Nenhum arquivo selecionado")) {
                this.lblArquivosSelecionados.setText("");
            }
            for (int i = 0; i < files.length; ++i) {
                if (this.lblArquivosSelecionados.getText().lastIndexOf(files[i].getName()) == -1) {
                    this.lblArquivosSelecionados.setText(this.lblArquivosSelecionados.getText() + files[i].getName() + "||");
                }
                Configuracao.setPropriedade("caminho", files[i].getParent() + "\\\\");
                System.out.println(files[i].getParent());
            }
        }
        if ((arquivos = this.lblArquivosSelecionados.getText().split("\\|\\|")) != null && arquivos.length < 5) {
            Master.mensagem("\u00c9 necess\u00e1rio selecionar 5 bases: Notifica\u00e7\u00e3o Individual, Notifica\u00e7\u00e3o Negativa, Surto, Tracoma e Epizootia");
        }
    }

    private void btnLimparSelecaoActionPerformed(ActionEvent evt) {
        this.lblArquivosSelecionados.setText("Nenhum arquivo selecionado");
    }

    private void cbAnoInicialMunicipioActionPerformed(ActionEvent evt) {
    }

    private void spSemanaInicialStateChanged(ChangeEvent evt) {
        if (Integer.parseInt(this.spSemanaInicial.getValue().toString()) > 53) {
            this.spSemanaInicial.setValue(53);
        }
    }

    private void cbAnoFinalMunicipioActionPerformed(ActionEvent evt) {
    }

    private void spSemanaFinalStateChanged(ChangeEvent evt) {
        if (Integer.parseInt(this.spSemanaFinal.getValue().toString()) > 53) {
            this.spSemanaFinal.setValue(53);
        }
    }

    private void btCalcularActionPerformed(ActionEvent evt) {
        if (!this.preencheuFormulario()) {
            return;
        }
        this.session = new SessionFacadeImpl();
        SessionFacadeImpl.setNomeDbf("");
        this.session.setBrasil(true);
        this.session.setTodosMunicipios(true);
        if (this.chkExportarDbf.isSelected()) {
            this.session.setExportarDbf(false);
        } else {
            this.session.setExportarDbf(false);
        }
        this.prbStatus.setStringPainted(true);
        this.prbStatus.setValue(0);
        this.prbStatusGeral.setStringPainted(false);
        this.prbStatus.setValue(0);
        HashMap<String, Object> parametros = new HashMap<String, Object>();
        parametros.put("parArquivos", this.lblArquivosSelecionados.getText());
        parametros.put("parAnoInicial", this.cbAnoInicialMunicipio.getSelectedItem().toString());
        parametros.put("parAnoFinal", this.cbAnoFinalMunicipio.getSelectedItem().toString());
        parametros.put("parSemanaInicial", this.spSemanaInicial.getValue().toString());
        parametros.put("parSemanaFinal", this.spSemanaFinal.getValue().toString());
        parametros.put("parConfig", "");
        parametros.put("parRodape", "");
        parametros.put("parIsRegiao", false);
        parametros.put("parIsRegional", false);
        parametros.put("parTitulo1", "Munic\u00edpios que n\u00e3o notificaram no Sinan");
        parametros.put("parDataHoje", new SimpleDateFormat("dd/MM/yyyy").format(new Date()));
        if (this.cbUf.getSelectedItem().toString().equals("Brasil")) {
            parametros.put("parSgUf", "Brasil");
        } else {
            parametros.put("parSgUf", this.cbUf.getSelectedItem().toString());
        }
        parametros.put("parDesagregacao", this.cbDesagregacao.getSelectedItem().toString());
        if (this.cbDesagregacao.getSelectedItem().toString().equals("UF subdividida por Regi\u00f5es de Sa\u00fade")) {
            parametros.put("parIsRegiao", true);
            parametros.put("parRegiaoSaude", this.cbRegional.getSelectedItem().toString());
        } else if (this.cbDesagregacao.getSelectedItem().toString().equals("UF subdividida por Regionais de Sa\u00fade")) {
            parametros.put("parRegionalSaude", this.cbRegional.getSelectedItem().toString());
            parametros.put("parIsRegional", true);
            this.session.setRegional(this.cbRegional.getSelectedItem().toString());
        }
        if (this.cbRegional.getSelectedItem().toString().equals("-- Selecione --")) {
            parametros.put("parRegional", "TODAS");
        } else {
            parametros.put("parRegional", this.cbRegional.getSelectedItem().toString());
        }
        parametros.put("parNomeMunicipio", "TODOS");
        if (this.gtSinan) {
            parametros.put("parSemanas", this.txtPeriodos.getText());
        }
        if (this.chkExportarDbf.isSelected()) {
            parametros.put("isDBF", true);
        } else {
            parametros.put("isDBF", false);
        }
        parametros.put("parGtSinan", this.gtSinan);
        if (this.rbRegAnalitico.isSelected()) {
            parametros.put("tipoRelatorio", "analitico");
        } else if (this.rbRegSintetico.isSelected()) {
            parametros.put("tipoRelatorio", "sintetico");
        } else {
            parametros.put("tipoRelatorio", "analiticoSintetico");
        }
        this.session.setParametros(parametros);
        this.session.setJprogress(this.prbStatus);
        this.session.setJprogressGeral(this.prbStatusGeral);
        this.session.setMunicipio(this.cbMunicipio.getSelectedItem().toString());
        this.session.setRegional(this.cbRegional.getSelectedItem().toString());
        this.session.setUf(this.cbUf.getSelectedItem().toString());
        this.session.setRelatorio("Regularidade");
        this.session.execute();
    }

    private void btLimparActionPerformed(ActionEvent evt) {
        this.cbMunicipio.removeAllItems();
        this.cbRegional.removeAllItems();
        this.cbUf.setSelectedIndex(0);
    }

    private void cbUfActionPerformed(ActionEvent evt) {
        DefaultComboBoxModel<String> modelo = new DefaultComboBoxModel<String>(this.session.retornaRegionais(this.cbUf.getSelectedItem().toString()));
        this.cbRegional.setModel(modelo);
        modelo = new DefaultComboBoxModel<String>(this.session.retornaMunicipios(this.cbUf.getSelectedItem().toString()));
        this.cbMunicipio.setModel(modelo);
    }

    private void cbMunicipioActionPerformed(ActionEvent evt) {
    }

    private void cbRegionalActionPerformed(ActionEvent evt) {
        DefaultComboBoxModel<String> modelo = new DefaultComboBoxModel<String>(this.session.retornaMunicipios(this.cbUf.getSelectedItem().toString(), this.cbRegional.getSelectedItem().toString()));
        this.cbMunicipio.setModel(modelo);
    }

    private String formataSemana(String semana) {
        if (Integer.parseInt(semana) < 10) {
            return "0" + semana;
        }
        return semana;
    }

    private void btnInserirPeriodoActionPerformed(ActionEvent evt) {
        if (this.txtPeriodos.getLineCount() <= 18) {
            boolean periodoIgual = false;
            String periodoDe = this.cbAnoInicialMunicipio.getSelectedItem().toString() + this.formataSemana(this.spSemanaInicial.getValue().toString());
            String peridoAte = this.cbAnoFinalMunicipio.getSelectedItem().toString() + this.formataSemana(this.spSemanaFinal.getValue().toString());
            this.mapaPeriodo.put(this.txtPeriodos.getLineCount(), periodoDe + peridoAte);
            if (this.txtPeriodos.getLineCount() > 1) {
                for (int i = 1; i < this.txtPeriodos.getLineCount(); ++i) {
                    if (!this.mapaPeriodo.get(i).equals(periodoDe + peridoAte)) continue;
                    periodoIgual = true;
                    break;
                }
            }
            String valor = this.cbAnoInicialMunicipio.getSelectedItem().toString() + this.formataSemana(this.spSemanaInicial.getValue().toString()) + " a " + this.cbAnoFinalMunicipio.getSelectedItem().toString() + this.formataSemana(this.spSemanaFinal.getValue().toString()) + "\n";
            if (this.validaSemana()) {
                SinanUtil.mensagem("Mensagem", "A semana deve ser menor que 54.");
            } else if (this.validaAno()) {
                SinanUtil.mensagem("Mensagem", "Ano final deve ser maior que o inicial.");
            } else if (this.validaPeriodoSemana()) {
                SinanUtil.mensagem("Mensagem", "Semana final deve ser maior que a inicial.");
            } else if (periodoIgual) {
                SinanUtil.mensagem("Mensagem", "N\u00e3o \u00e9 permitido per\u00edodos iguais.");
            } else if (SinanUtil.intervaloSemanas(periodoDe, peridoAte) > 8) {
                SinanUtil.mensagem("Mensagem", "N\u00e3o \u00e9 permitido intervalo entre semanas maior do que 8.");
            } else {
                this.txtPeriodos.setText(this.txtPeriodos.getText() + valor);
            }
        } else {
            SinanUtil.mensagem("Mensagem", "N\u00e3o \u00e9 poss\u00edvel inserir mais de 18 per\u00edodos.");
        }
    }

    private void rbRegAnaliticoActionPerformed(ActionEvent evt) {
    }

    private void cbDesagregacaoActionPerformed(ActionEvent evt) {
        DefaultComboBoxModel<String> modelo;
        if (this.cbDesagregacao.getSelectedItem().toString().equals("Somente munic\u00edpios")) {
            this.lblRegional.setVisible(false);
            this.cbRegional.setVisible(false);
        } else if (this.cbDesagregacao.getSelectedItem().toString().equals("UF subdividida por Regi\u00f5es de Sa\u00fade")) {
            this.lblRegional.setText("Regi\u00e3o de Sa\u00fade:");
            this.lblRegional.setVisible(true);
            this.cbRegional.setVisible(true);
            modelo = new DefaultComboBoxModel<String>(this.session.retornaRegioes(this.cbUf.getSelectedItem().toString()));
            this.cbRegional.setModel(modelo);
        } else if (this.cbDesagregacao.getSelectedItem().toString().equals("UF subdividida por Regionais de Sa\u00fade")) {
            this.lblRegional.setText("Regional:");
            this.lblRegional.setVisible(true);
            this.cbRegional.setVisible(true);
            modelo = new DefaultComboBoxModel<String>(this.session.retornaRegionais(this.cbUf.getSelectedItem().toString()));
            this.cbRegional.setModel(modelo);
        }
        modelo = new DefaultComboBoxModel<String>(this.session.retornaMunicipios(this.cbUf.getSelectedItem().toString()));
        this.cbMunicipio.setModel(modelo);
    }
}

