/*
 * Decompiled with CFR 0.152.
 */
package com.org.view;

import com.org.facade.SessionFacadeImpl;
import com.org.negocio.Configuracao;
import com.org.negocio.FiltroArquivo;
import com.org.util.SinanUtil;
import com.org.view.Master;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;

public class SemEpidPQAVS
extends JPanel {
    SessionFacadeImpl session = new SessionFacadeImpl();
    private JComboBox anoAvaliadoOportunidade;
    private JButton btCalcular;
    private JButton btLimpar;
    private JButton btnLimparSelecao;
    private JButton btnSelecionarArquivos;
    private ButtonGroup buttonGroup1;
    private JComboBox cbDesagregacao;
    private JComboBox cbMunicipio;
    private JComboBox cbRegional;
    private JComboBox cbUf;
    private JCheckBox chkExportarDbf;
    private JLabel jLabel10;
    private JLabel jLabel23;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel lblArquivosSelecionados;
    private JLabel lblUF;
    private JPanel panelOportunidade;
    private JPanel pnlArquivos;
    private JProgressBar prbStatus;

    public SemEpidPQAVS() {
        this.initComponents();
        this.iniciaCombos();
        SemEpidPQAVS.preencheAnos(this.anoAvaliadoOportunidade, 2007);
        this.session.setTodosMunicipios(true);
    }

    public static void preencheAnos(JComboBox combo, int anoInicial) {
        int anoFinal;
        combo.removeAllItems();
        for (int i = anoFinal = Integer.parseInt(new SimpleDateFormat("yyyy").format(new Date())); i >= anoInicial; --i) {
            combo.addItem(i);
        }
    }

    private boolean preencheuFormulario() {
        if (this.cbDesagregacao.getSelectedItem().toString().equals("-- Selecione --")) {
            SinanUtil.mensagem("Selecione o n\u00edvel de desagrega\u00e7\u00e3o");
            return false;
        }
        if (this.cbUf.getSelectedItem().toString().equals("-- Selecione --")) {
            Master.mensagem("Selecione a UF de resid\u00eancia");
            return false;
        }
        if (this.cbRegional.getSelectedItem().toString().equals("-- Selecione --") && !this.cbDesagregacao.getSelectedItem().toString().equals("Somente munic\u00edpios")) {
            SinanUtil.mensagem("Selecione regi\u00e3o ou regional de sa\u00fade");
            return false;
        }
        if (this.cbMunicipio.getSelectedItem().toString().equals("-- Selecione --") && this.cbDesagregacao.getSelectedItem().toString().equals("Somente munic\u00edpios")) {
            SinanUtil.mensagem("Selecione munic\u00edpio");
            return false;
        }
        if (this.lblArquivosSelecionados.getText().equals("Nenhum arquivo selecionado")) {
            SinanUtil.mensagem("Nenhum arquivo foi selecionado");
            return false;
        }
        return true;
    }

    private void iniciaCombo(JComboBox cbAgravo) {
        cbAgravo.removeAllItems();
        cbAgravo.addItem("TODOS");
        if (this.cbDesagregacao.getSelectedIndex() == 3) {
            cbAgravo.addItem("ANTRAZ PNEUMONICO");
            cbAgravo.addItem("ARENAVIRUS");
            cbAgravo.addItem("BOTULISMO");
            cbAgravo.addItem("COLERA");
            cbAgravo.addItem("DENGUE (OBITOS)");
            cbAgravo.addItem("EBOLA");
            cbAgravo.addItem("EVENTOS ADVERSOS GRAVES OU OBITOS POS-VACINACAO");
            cbAgravo.addItem("FEBRE AMARELA");
            cbAgravo.addItem("FEBRE DE CHIKUNGUNYA");
            cbAgravo.addItem("FEBRE DO NILO OCIDENTAL");
            cbAgravo.addItem("FEBRE MACULOSA E OUTRAS RIQUETISIOSES");
            cbAgravo.addItem("FEBRE PURPURICA BRASILEIRA");
            cbAgravo.addItem("INFLUENZA HUMANA PRODUZIDA POR NOVO SUBTIPO VIRAL");
            cbAgravo.addItem("LASSA");
            cbAgravo.addItem("MALARIA NA REGIAO EXTRA AMAZONICA");
            cbAgravo.addItem("MARBURG");
            cbAgravo.addItem("PARALISIA FLACIDA AGUDA");
            cbAgravo.addItem("PESTE");
            cbAgravo.addItem("RAIVA HUMANA");
            cbAgravo.addItem("RUBEOLA");
            cbAgravo.addItem("SARAMPO");
            cbAgravo.addItem("SINDROME DA RUBEOLA CONGENITA");
            cbAgravo.addItem("SINDROME RESPIRATORIA AGUDA GRAVE ASSOCIADA A CORONAVIRUS");
            cbAgravo.addItem("TULAREMIA");
            cbAgravo.addItem("VARIOLA");
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.panelOportunidade = new JPanel();
        this.anoAvaliadoOportunidade = new JComboBox();
        this.cbMunicipio = new JComboBox();
        this.cbRegional = new JComboBox();
        this.lblUF = new JLabel();
        this.cbUf = new JComboBox();
        this.chkExportarDbf = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.prbStatus = new JProgressBar();
        this.btCalcular = new JButton();
        this.btLimpar = new JButton();
        this.pnlArquivos = new JPanel();
        this.btnSelecionarArquivos = new JButton();
        this.btnLimparSelecao = new JButton();
        this.lblArquivosSelecionados = new JLabel();
        this.cbDesagregacao = new JComboBox();
        this.jLabel10 = new JLabel();
        this.jLabel23 = new JLabel();
        this.setPreferredSize(new Dimension(800, 373));
        this.panelOportunidade.setPreferredSize(new Dimension(300, 99));
        this.anoAvaliadoOportunidade.setModel(new DefaultComboBoxModel<String>(new String[]{"2001", "2002", "2003", "2004", "2005", "2006", "2007", "2008"}));
        this.anoAvaliadoOportunidade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SemEpidPQAVS.this.anoAvaliadoOportunidadeActionPerformed(evt);
            }
        });
        GroupLayout panelOportunidadeLayout = new GroupLayout(this.panelOportunidade);
        this.panelOportunidade.setLayout(panelOportunidadeLayout);
        panelOportunidadeLayout.setHorizontalGroup(panelOportunidadeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelOportunidadeLayout.createSequentialGroup().addComponent(this.anoAvaliadoOportunidade, -2, -1, -2).addGap(0, 495, Short.MAX_VALUE)));
        panelOportunidadeLayout.setVerticalGroup(panelOportunidadeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelOportunidadeLayout.createSequentialGroup().addComponent(this.anoAvaliadoOportunidade, -2, -1, -2).addGap(0, 15, Short.MAX_VALUE)));
        this.cbMunicipio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SemEpidPQAVS.this.cbMunicipioActionPerformed(evt);
            }
        });
        this.cbRegional.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SemEpidPQAVS.this.cbRegionalActionPerformed(evt);
            }
        });
        this.lblUF.setFont(new Font("Tahoma", 1, 11));
        this.lblUF.setText("UF de Notifica\u00e7\u00e3o:");
        this.cbUf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SemEpidPQAVS.this.cbUfActionPerformed(evt);
            }
        });
        this.chkExportarDbf.setText("Salvar resultado em DBF");
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Regi\u00e3o de Sa\u00fade:");
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText("Munic\u00edpio de Notifica\u00e7\u00e3o:");
        this.btCalcular.setLabel("Calcular");
        this.btCalcular.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SemEpidPQAVS.this.btCalcularActionPerformed(evt);
            }
        });
        this.btLimpar.setText("Limpar");
        this.btLimpar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SemEpidPQAVS.this.btLimparActionPerformed(evt);
            }
        });
        this.pnlArquivos.setBorder(BorderFactory.createTitledBorder("Selecione os DBF "));
        this.btnSelecionarArquivos.setText("Selecionar arquivos");
        this.btnSelecionarArquivos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SemEpidPQAVS.this.btnSelecionarArquivosActionPerformed(evt);
            }
        });
        this.btnLimparSelecao.setText("Limpar Sele\u00e7\u00e3o");
        this.btnLimparSelecao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SemEpidPQAVS.this.btnLimparSelecaoActionPerformed(evt);
            }
        });
        this.lblArquivosSelecionados.setText("Nenhum arquivo selecionado");
        this.lblArquivosSelecionados.setVerticalAlignment(1);
        this.lblArquivosSelecionados.setBorder(new SoftBevelBorder(0));
        GroupLayout pnlArquivosLayout = new GroupLayout(this.pnlArquivos);
        this.pnlArquivos.setLayout(pnlArquivosLayout);
        pnlArquivosLayout.setHorizontalGroup(pnlArquivosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlArquivosLayout.createSequentialGroup().addGap(33, 33, 33).addComponent(this.btnSelecionarArquivos).addGap(18, 18, 18).addComponent(this.btnLimparSelecao).addContainerGap(-1, Short.MAX_VALUE)).addGroup(pnlArquivosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlArquivosLayout.createSequentialGroup().addContainerGap().addComponent(this.lblArquivosSelecionados, -2, 521, -2).addContainerGap(-1, Short.MAX_VALUE))));
        pnlArquivosLayout.setVerticalGroup(pnlArquivosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlArquivosLayout.createSequentialGroup().addGroup(pnlArquivosLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSelecionarArquivos).addComponent(this.btnLimparSelecao)).addContainerGap(38, Short.MAX_VALUE)).addGroup(pnlArquivosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlArquivosLayout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.lblArquivosSelecionados).addContainerGap(-1, Short.MAX_VALUE))));
        this.cbDesagregacao.setModel(new DefaultComboBoxModel<String>(new String[]{"-- Selecione --", "Somente munic\u00edpios", "UF subdividida por Regi\u00f5es de Sa\u00fade", "UF subdividida por Regional de Sa\u00fade"}));
        this.cbDesagregacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SemEpidPQAVS.this.cbDesagregacaoActionPerformed(evt);
            }
        });
        this.jLabel10.setFont(new Font("Tahoma", 1, 11));
        this.jLabel10.setText("Desagrega\u00e7\u00e3o:");
        this.jLabel23.setText("           Ano Epidemiol\u00f3gico:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(145, 145, 145).addComponent(this.btCalcular).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btLimpar)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.prbStatus, -1, -1, Short.MAX_VALUE)).addComponent(this.pnlArquivos, GroupLayout.Alignment.LEADING, -2, 550, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel23, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelOportunidade, -2, 564, -2)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jLabel4)).addGroup(layout.createSequentialGroup().addGap(41, 41, 41).addComponent(this.lblUF))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbUf, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.cbMunicipio, GroupLayout.Alignment.LEADING, 0, 225, Short.MAX_VALUE).addComponent(this.cbRegional, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE)).addComponent(this.chkExportarDbf).addComponent(this.cbDesagregacao, -2, 280, -2)).addGap(0, 0, Short.MAX_VALUE))).addGap(185, 185, 185)).addGroup(layout.createSequentialGroup().addGap(67, 67, 67).addComponent(this.jLabel10).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblUF).addComponent(this.cbUf, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbDesagregacao, -2, -1, -2).addComponent(this.jLabel10, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbRegional, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.cbMunicipio, -2, -1, -2)).addGap(17, 17, 17).addComponent(this.chkExportarDbf).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel23, -1, 42, Short.MAX_VALUE).addComponent(this.panelOportunidade, -1, 42, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlArquivos, -2, -1, -2).addGap(1, 1, 1).addComponent(this.prbStatus, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btLimpar).addComponent(this.btCalcular, -1, -1, Short.MAX_VALUE)).addGap(31, 31, 31)));
    }

    private void cbMunicipioActionPerformed(ActionEvent evt) {
    }

    private void cbRegionalActionPerformed(ActionEvent evt) {
        DefaultComboBoxModel<String> modelo = new DefaultComboBoxModel<String>(this.session.retornaMunicipiosPQAVS(this.cbUf.getSelectedItem().toString(), this.cbRegional.getSelectedItem().toString()));
        this.cbMunicipio.setModel(modelo);
    }

    private void anoAvaliadoOportunidadeActionPerformed(ActionEvent evt) {
    }

    private void btnLimparSelecaoActionPerformed(ActionEvent evt) {
        this.lblArquivosSelecionados.setText("Nenhum arquivo selecionado");
    }

    private void btnSelecionarArquivosActionPerformed(ActionEvent evt) {
        JFileChooser fileopen = new JFileChooser();
        fileopen.setMultiSelectionEnabled(true);
        FiltroArquivo filtro = new FiltroArquivo();
        filtro.addExtension("dbf");
        filtro.setDescription("Arquivo DBF");
        filtro.addInicioNome("NINDI");
        filtro.addInicioNome("NSURT");
        filtro.addInicioNome("NNEGA");
        fileopen.addChoosableFileFilter(filtro);
        fileopen.setFileFilter(filtro);
        File file2 = new File(new Configuracao().getCaminho());
        fileopen.setCurrentDirectory(file2);
        int ret = fileopen.showDialog(null, "Abrir DBF");
        if (ret == 0) {
            File[] files = fileopen.getSelectedFiles();
            if (this.lblArquivosSelecionados.getText().equals("Nenhum arquivo selecionado")) {
                this.lblArquivosSelecionados.setText("");
            }
            for (int i = 0; i < files.length; ++i) {
                if (this.lblArquivosSelecionados.getText().lastIndexOf(files[i].getName()) == -1) {
                    this.lblArquivosSelecionados.setText(this.lblArquivosSelecionados.getText() + files[i].getName() + "||");
                }
                Configuracao.setPropriedade("caminho", files[i].getParent() + "\\\\");
            }
        }
    }

    private void cbUfActionPerformed(ActionEvent evt) {
        DefaultComboBoxModel<String> modelo = new DefaultComboBoxModel<String>(this.session.retornaRegioes(this.cbUf.getSelectedItem().toString()));
        this.cbRegional.setModel(modelo);
    }

    private void btCalcularActionPerformed(ActionEvent evt) {
        if (!this.preencheuFormulario()) {
            return;
        }
        this.btCalcular.setEnabled(false);
        this.session = new SessionFacadeImpl();
        this.session.setTodosMunicipios(true);
        SessionFacadeImpl.setNomeDbf("NINDI");
        this.session.setExportarDbf(false);
        this.prbStatus.setStringPainted(true);
        this.prbStatus.setValue(0);
        HashMap<String, Object> parametros = new HashMap<String, Object>();
        parametros.put("parArquivos", this.lblArquivosSelecionados.getText());
        parametros.put("parVariosArquivos", "sim");
        if (this.chkExportarDbf.isSelected()) {
            parametros.put("exportarDBF", true);
        } else {
            parametros.put("exportarDBF", false);
        }
        if (this.cbDesagregacao.getSelectedItem().toString().equals("Discriminar por Agravo")) {
            parametros.put("parDiscriminarPorAgravo", true);
        } else {
            parametros.put("parDiscriminarPorAgravo", false);
        }
        this.session.setAnoAvaliado(this.anoAvaliadoOportunidade.getSelectedItem().toString());
        this.session.setDataAvaliacao("");
        this.session.setNomeAgravo("");
        this.session.setDtInicioAvaliacao("");
        this.session.setDtFimAvaliacao("");
        parametros.put("parDiscriminarPorAgravo", "");
        parametros.put("parAnoPeriodoAvaliacao", "");
        parametros.put("parAnoEpid", this.anoAvaliadoOportunidade.getSelectedItem().toString());
        parametros.put("parNenhum", false);
        parametros.put("parDesagregacao", "UF subdividida por Regi\u00f5es de Sa\u00fade e Munic\u00edpios");
        parametros.put("parRegiaoSaude", this.cbRegional.getSelectedItem().toString());
        parametros.put("parMunic", this.cbMunicipio.getSelectedItem().toString());
        this.session.setParametros(parametros);
        this.session.setJprogress(this.prbStatus);
        this.session.setMunicipio(this.cbMunicipio.getSelectedItem().toString());
        this.session.setRegional(this.cbRegional.getSelectedItem().toString());
        this.session.setUf(this.cbUf.getSelectedItem().toString());
        this.session.setRelatorio("SemEpidPQAVS");
        this.session.execute();
        this.btCalcular.setEnabled(true);
    }

    private void btLimparActionPerformed(ActionEvent evt) {
        this.cbMunicipio.removeAllItems();
        this.cbRegional.removeAllItems();
        this.cbUf.setSelectedIndex(0);
    }

    private void cbDesagregacaoActionPerformed(ActionEvent evt) {
        DefaultComboBoxModel<String> modelo;
        this.chkExportarDbf.setSelected(false);
        if (this.cbDesagregacao.getSelectedItem().toString().equals("Somente munic\u00edpios")) {
            this.jLabel3.setVisible(false);
            this.cbRegional.setVisible(false);
        } else if (this.cbDesagregacao.getSelectedItem().toString().equals("UF subdividida por Regi\u00f5es de Sa\u00fade")) {
            this.jLabel3.setText("Regi\u00e3o de Resid\u00eancia");
            this.jLabel3.setVisible(true);
            this.cbRegional.setVisible(true);
            modelo = new DefaultComboBoxModel<String>(this.session.retornaRegioes(this.cbUf.getSelectedItem().toString()));
            this.cbRegional.setModel(modelo);
        } else if (this.cbDesagregacao.getSelectedItem().toString().equals("UF subdividida por Regional de Sa\u00fade")) {
            this.jLabel3.setText("Regional de Resid\u00eancia");
            this.jLabel3.setVisible(true);
            this.cbRegional.setVisible(true);
            modelo = new DefaultComboBoxModel<String>(this.session.retornaRegionais(this.cbUf.getSelectedItem().toString()));
            this.cbRegional.setModel(modelo);
        }
        modelo = new DefaultComboBoxModel<String>(this.session.retornaMunicipios(this.cbUf.getSelectedItem().toString()));
        this.cbMunicipio.setModel(modelo);
    }

    private void iniciaCombos() {
        DefaultComboBoxModel<String> modelo = new DefaultComboBoxModel<String>(this.session.retornaUFs());
        this.cbUf.setModel(modelo);
        modelo = new DefaultComboBoxModel<String>(this.session.retornaRegioes(this.cbUf.getSelectedItem().toString()));
        this.cbRegional.setModel(modelo);
        modelo = new DefaultComboBoxModel<String>(this.session.retornaMunicipios(this.cbUf.getSelectedItem().toString()));
        this.cbMunicipio.setModel(modelo);
        this.chkExportarDbf.setSelected(false);
    }
}

