/*
 * Decompiled with CFR 0.152.
 */
package com.org.view;

import com.org.facade.SessionFacadeImpl;
import com.org.model.classes.Agravo;
import com.org.negocio.Configuracao;
import com.org.negocio.FiltroArquivo;
import com.org.util.SinanDateUtil;
import com.org.util.SinanUtil;
import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;

public class Violencia
extends JPanel {
    SessionFacadeImpl session = new SessionFacadeImpl();
    private JButton btCalcular;
    private JButton btLimpar;
    private JButton btnLimparSelecao;
    private JButton btnSelecionarArquivos;
    private JComboBox cbDesagregacao;
    private JComboBox cbMunicipio;
    private JComboBox cbRegional;
    private JComboBox cbUf;
    private JCheckBox chkExportarDbf;
    private JDateChooser dataFim;
    private JDateChooser dataInicio;
    private JLabel jLabel;
    private JLabel jLabel10;
    private JLabel jLabel9;
    private JPanel jpDataPrimeiroSintomas;
    private JLabel lblArquivosSelecionados;
    private JLabel lblAviso;
    private JLabel lblDesagregacao;
    private JLabel lblRegional;
    private JLabel lblUF;
    private JPanel pnlArquivos;
    private JProgressBar prbStatus;

    public Violencia() {
        this.initComponents();
        this.session.setTodosMunicipios(true);
        DefaultComboBoxModel<String> modelo = new DefaultComboBoxModel<String>(this.session.retornaUFs());
        this.cbUf.setModel(modelo);
        if (SessionFacadeImpl.isDbf()) {
            this.pnlArquivos.setVisible(true);
        } else {
            this.pnlArquivos.setVisible(false);
        }
    }

    private boolean preencheuFormulario() {
        if (this.cbUf.getSelectedItem().toString().equals("-- Selecione --")) {
            SinanUtil.mensagem("Selecione a UF de resid\u00eancia");
            return false;
        }
        if (this.cbDesagregacao.getSelectedItem().toString().equals("-- Selecione --")) {
            SinanUtil.mensagem("Selecione a Desagrega\u00e7\u00e3o desejada");
            return false;
        }
        if (null != this.cbRegional.getSelectedItem() && this.cbRegional.getSelectedItem().toString().equals("-- Selecione --") && (this.cbDesagregacao.getSelectedItem().toString().equals("UF subdividida por Regi\u00f5es de Sa\u00fade") || this.cbDesagregacao.getSelectedItem().toString().equals("UF subdividida por Regional de Sa\u00fade"))) {
            SinanUtil.mensagem("Selecione a Regi\u00e3o ou Regional de resid\u00eancia");
            return false;
        }
        if (this.cbMunicipio.getSelectedItem().toString().equals("-- Selecione --")) {
            SinanUtil.mensagem("Selecione o Munic\u00edpio de resid\u00eancia");
            return false;
        }
        if (SinanDateUtil.dateToStringException(this.dataInicio.getDate(), "dd/MM/yyyy").equals("")) {
            SinanUtil.mensagem("Informe o per\u00edodo inicial");
            return false;
        }
        if (SinanDateUtil.dateToStringException(this.dataFim.getDate(), "dd/MM/yyyy").equals("")) {
            SinanUtil.mensagem("Informe o per\u00edodo final");
            return false;
        }
        if (Integer.parseInt(SinanDateUtil.dateToStringException(this.dataInicio.getDate(), "dd/MM/yyyy").substring(6, 10)) < 2007) {
            SinanUtil.mensagem("O per\u00edodo inicial deve ser maior que 2007");
            return false;
        }
        try {
            Date dtInicio = Agravo.converterParaData(SinanDateUtil.dateToStringException(this.dataInicio.getDate(), "dd/MM/yyyy"));
            Date dtFim = Agravo.converterParaData(SinanDateUtil.dateToStringException(this.dataFim.getDate(), "dd/MM/yyyy"));
            if (dtFim.before(dtInicio)) {
                SinanUtil.mensagem("Data final deve ser maior que inicial");
                return false;
            }
        }
        catch (Exception e) {
            SinanUtil.mensagem("Data inv\u00e1lida");
            return false;
        }
        if (this.lblArquivosSelecionados.getText().equals("Nenhum arquivo selecionado") && SessionFacadeImpl.isDbf()) {
            SinanUtil.mensagem("Selecione um arquivo.");
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.lblRegional = new JLabel();
        this.chkExportarDbf = new JCheckBox();
        this.cbUf = new JComboBox();
        this.lblDesagregacao = new JLabel();
        this.jLabel = new JLabel();
        this.cbDesagregacao = new JComboBox();
        this.cbRegional = new JComboBox();
        this.btCalcular = new JButton();
        this.jpDataPrimeiroSintomas = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.lblAviso = new JLabel();
        this.dataInicio = new JDateChooser("dd/MM/yyyy", "##/##/#####", '_');
        this.dataFim = new JDateChooser("dd/MM/yyyy", "##/##/#####", '_');
        this.btLimpar = new JButton();
        this.lblUF = new JLabel();
        this.prbStatus = new JProgressBar();
        this.cbMunicipio = new JComboBox();
        this.pnlArquivos = new JPanel();
        this.btnSelecionarArquivos = new JButton();
        this.btnLimparSelecao = new JButton();
        this.lblArquivosSelecionados = new JLabel();
        this.lblRegional.setFont(new Font("Tahoma", 1, 11));
        this.lblRegional.setText("Regional de Notifica\u00e7\u00e3o:");
        this.chkExportarDbf.setText("Salvar resultado em DBF");
        this.cbUf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Violencia.this.cbUfActionPerformed(evt);
            }
        });
        this.lblDesagregacao.setFont(new Font("Tahoma", 1, 11));
        this.lblDesagregacao.setText("Desagrega\u00e7\u00e3o:");
        this.jLabel.setFont(new Font("Tahoma", 1, 11));
        this.jLabel.setText("Munic\u00edpio de Notifica\u00e7\u00e3o:");
        this.cbDesagregacao.setModel(new DefaultComboBoxModel<String>(new String[]{"-- Selecione --", "UF subdividida por Regi\u00f5es de Sa\u00fade", "UF subdividida por Regional de Sa\u00fade", "Somente munic\u00edpios"}));
        this.cbDesagregacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Violencia.this.cbDesagregacaoActionPerformed(evt);
            }
        });
        this.cbRegional.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Violencia.this.cbRegionalActionPerformed(evt);
            }
        });
        this.btCalcular.setLabel("Calcular");
        this.btCalcular.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Violencia.this.btCalcularActionPerformed(evt);
            }
        });
        this.jpDataPrimeiroSintomas.setBorder(BorderFactory.createTitledBorder(null, "Data de Notifica\u00e7\u00e3o", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel9.setText("De");
        this.jLabel10.setText("at\u00e9");
        this.lblAviso.setFont(new Font("Tahoma", 1, 11));
        this.lblAviso.setForeground(new Color(255, 0, 0));
        this.dataInicio.getJCalendar().setWeekOfYearVisible(false);
        this.dataFim.getJCalendar().setWeekOfYearVisible(false);
        GroupLayout jpDataPrimeiroSintomasLayout = new GroupLayout(this.jpDataPrimeiroSintomas);
        this.jpDataPrimeiroSintomas.setLayout(jpDataPrimeiroSintomasLayout);
        jpDataPrimeiroSintomasLayout.setHorizontalGroup(jpDataPrimeiroSintomasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpDataPrimeiroSintomasLayout.createSequentialGroup().addContainerGap().addGroup(jpDataPrimeiroSintomasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpDataPrimeiroSintomasLayout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dataInicio, -2, 130, -2).addGap(52, 52, 52).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dataFim, -2, 130, -2)).addComponent(this.lblAviso)).addContainerGap(-1, Short.MAX_VALUE)));
        jpDataPrimeiroSintomasLayout.setVerticalGroup(jpDataPrimeiroSintomasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpDataPrimeiroSintomasLayout.createSequentialGroup().addContainerGap().addGroup(jpDataPrimeiroSintomasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dataFim, -2, -1, -2).addComponent((Component)this.dataInicio, -2, -1, -2).addGroup(jpDataPrimeiroSintomasLayout.createSequentialGroup().addGroup(jpDataPrimeiroSintomasLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblAviso))).addContainerGap(13, Short.MAX_VALUE)));
        this.btLimpar.setText("Limpar");
        this.btLimpar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Violencia.this.btLimparActionPerformed(evt);
            }
        });
        this.lblUF.setFont(new Font("Tahoma", 1, 11));
        this.lblUF.setText("UF de Notifica\u00e7\u00e3o:");
        this.cbMunicipio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Violencia.this.cbMunicipioActionPerformed(evt);
            }
        });
        this.pnlArquivos.setBorder(BorderFactory.createTitledBorder("Selecione os DBF "));
        this.btnSelecionarArquivos.setText("Selecionar arquivos");
        this.btnSelecionarArquivos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Violencia.this.btnSelecionarArquivosActionPerformed(evt);
            }
        });
        this.btnLimparSelecao.setText("Limpar Sele\u00e7\u00e3o");
        this.btnLimparSelecao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Violencia.this.btnLimparSelecaoActionPerformed(evt);
            }
        });
        this.lblArquivosSelecionados.setText("Nenhum arquivo selecionado");
        this.lblArquivosSelecionados.setVerticalAlignment(1);
        this.lblArquivosSelecionados.setBorder(new SoftBevelBorder(0));
        GroupLayout pnlArquivosLayout = new GroupLayout(this.pnlArquivos);
        this.pnlArquivos.setLayout(pnlArquivosLayout);
        pnlArquivosLayout.setHorizontalGroup(pnlArquivosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE).addGroup(pnlArquivosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlArquivosLayout.createSequentialGroup().addContainerGap().addGroup(pnlArquivosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblArquivosSelecionados, -2, 377, -2).addGroup(pnlArquivosLayout.createSequentialGroup().addComponent(this.btnSelecionarArquivos).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLimparSelecao))).addContainerGap(-1, Short.MAX_VALUE))));
        pnlArquivosLayout.setVerticalGroup(pnlArquivosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 71, Short.MAX_VALUE).addGroup(pnlArquivosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlArquivosLayout.createSequentialGroup().addGap(1, 1, 1).addGroup(pnlArquivosLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSelecionarArquivos).addComponent(this.btnLimparSelecao)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblArquivosSelecionados).addContainerGap(-1, Short.MAX_VALUE))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.prbStatus, -1, -1, Short.MAX_VALUE).addGap(11, 11, 11)).addGroup(layout.createSequentialGroup().addComponent(this.jpDataPrimeiroSintomas, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(134, 134, 134).addComponent(this.btCalcular).addGap(26, 26, 26).addComponent(this.btLimpar)).addComponent(this.pnlArquivos, -2, 399, -2)).addContainerGap(-1, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addGap(34, 34, 34).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblRegional).addComponent(this.jLabel).addComponent(this.lblDesagregacao).addComponent(this.lblUF)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkExportarDbf).addComponent(this.cbUf, -2, 229, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cbMunicipio, 0, -1, Short.MAX_VALUE).addComponent(this.cbRegional, 0, -1, Short.MAX_VALUE).addComponent(this.cbDesagregacao, -2, 229, -2))).addContainerGap(444, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbUf, -2, -1, -2).addComponent(this.lblUF)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbDesagregacao, -2, -1, -2).addComponent(this.lblDesagregacao)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbRegional, -2, -1, -2).addComponent(this.lblRegional)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel).addComponent(this.cbMunicipio, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkExportarDbf).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jpDataPrimeiroSintomas, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlArquivos, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prbStatus, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btCalcular, -1, -1, Short.MAX_VALUE).addComponent(this.btLimpar)).addContainerGap()));
        this.jpDataPrimeiroSintomas.getAccessibleContext().setAccessibleName("Data de Notifica\u00e7\u00e3o\n");
    }

    private void cbUfActionPerformed(ActionEvent evt) {
        this.cbDesagregacao.setSelectedIndex(1);
    }

    private void cbDesagregacaoActionPerformed(ActionEvent evt) {
        DefaultComboBoxModel<String> modelo;
        if (this.cbDesagregacao.getSelectedItem().toString().equals("Somente munic\u00edpios")) {
            this.lblRegional.setVisible(false);
            this.cbRegional.setVisible(false);
        } else if (this.cbDesagregacao.getSelectedItem().toString().equals("UF subdividida por Regi\u00f5es de Sa\u00fade")) {
            this.lblRegional.setText("Regi\u00e3o de Notifica\u00e7\u00e3o");
            this.lblRegional.setVisible(true);
            this.cbRegional.setVisible(true);
            modelo = new DefaultComboBoxModel<String>(this.session.retornaRegioes(this.cbUf.getSelectedItem().toString()));
            this.cbRegional.setModel(modelo);
        } else if (this.cbDesagregacao.getSelectedItem().toString().equals("UF subdividida por Regional de Sa\u00fade")) {
            this.lblRegional.setText("Regional de Notifica\u00e7\u00e3o");
            this.lblRegional.setVisible(true);
            this.cbRegional.setVisible(true);
            modelo = new DefaultComboBoxModel<String>(this.session.retornaRegionais(this.cbUf.getSelectedItem().toString()));
            this.cbRegional.setModel(modelo);
        }
        modelo = new DefaultComboBoxModel<String>(this.session.retornaMunicipios(this.cbUf.getSelectedItem().toString()));
        this.cbMunicipio.setModel(modelo);
    }

    private void cbRegionalActionPerformed(ActionEvent evt) {
        int isRegiao = this.cbDesagregacao.getSelectedIndex();
        if (this.cbRegional.getSelectedItem() != null) {
            Vector<String> municipiosPactuacao = this.session.retornaMunicipiosPactuacao(isRegiao, this.cbUf.getSelectedItem().toString(), this.cbRegional.getSelectedItem().toString());
            if (!this.cbDesagregacao.getSelectedItem().toString().equals("Somente munic\u00edpios")) {
                municipiosPactuacao.add(2, "NENHUM");
            }
            DefaultComboBoxModel<String> modelo = new DefaultComboBoxModel<String>(municipiosPactuacao);
            this.cbMunicipio.setModel(modelo);
        }
    }

    private void btCalcularActionPerformed(ActionEvent evt) {
        if (!this.preencheuFormulario()) {
            return;
        }
        this.session = new SessionFacadeImpl();
        this.session.setBrasil(true);
        SessionFacadeImpl.setNomeDbf("VIOLENET");
        this.session.setTodosMunicipios(true);
        if (this.chkExportarDbf.isSelected()) {
            this.session.setExportarDbf(true);
        } else {
            this.session.setExportarDbf(false);
        }
        this.prbStatus.setStringPainted(true);
        this.prbStatus.setValue(0);
        HashMap<String, Object> parametros = new HashMap<String, Object>();
        parametros.put("parArquivos", this.lblArquivosSelecionados.getText());
        parametros.put("parVariosArquivos", "sim");
        parametros.put("parIsRegiao", false);
        parametros.put("parIsRegional", false);
        if (!this.cbMunicipio.getSelectedItem().toString().equals("NENHUM")) {
            parametros.put("parNenhum", false);
        }
        parametros.put("parDesagregacao", this.cbDesagregacao.getSelectedItem().toString());
        parametros.put("parSgUf", this.cbUf.getSelectedItem().toString());
        parametros.put("parRegionalSaude", "");
        parametros.put("parRegiaoSaude", "");
        parametros.put("parAnoPeriodoAvaliacao", SinanDateUtil.dateToStringException(this.dataInicio.getDate(), "dd/MM/yyyy") + " a " + SinanDateUtil.dateToStringException(this.dataFim.getDate(), "dd/MM/yyyy"));
        if (this.cbDesagregacao.getSelectedItem().toString().equals("UF subdividida por Regi\u00f5es de Sa\u00fade")) {
            parametros.put("parIsRegiao", true);
            parametros.put("parRegiaoSaude", this.cbRegional.getSelectedItem().toString());
        } else if (this.cbDesagregacao.getSelectedItem().toString().equals("UF subdividida por Regional de Sa\u00fade")) {
            parametros.put("parRegionalSaude", this.cbRegional.getSelectedItem().toString());
            parametros.put("parIsRegional", true);
            this.session.setRegional(this.cbRegional.getSelectedItem().toString());
        }
        if (this.cbMunicipio.getSelectedItem().toString().isEmpty()) {
            parametros.put("municipioEspecifico", "");
        } else if (this.cbMunicipio.getSelectedItem().toString().equals("TODOS")) {
            parametros.put("municipioEspecifico", "TODOS");
        } else if (this.cbMunicipio.getSelectedItem().toString().equals("NENHUM")) {
            parametros.put("municipioEspecifico", "NENHUM");
            parametros.put("parNenhum", true);
        } else {
            parametros.put("municipioEspecifico", this.cbMunicipio.getSelectedItem().toString());
        }
        this.session.setParametros(parametros);
        this.session.setDataFim(SinanDateUtil.dateToStringException(this.dataFim.getDate(), "dd/MM/yyyy"));
        this.session.setDataInicio(SinanDateUtil.dateToStringException(this.dataInicio.getDate(), "dd/MM/yyyy"));
        this.session.setJprogress(this.prbStatus);
        this.session.setMunicipio(this.cbMunicipio.getSelectedItem().toString());
        if (this.cbRegional.getSelectedItem() != null) {
            this.session.setRegional(this.cbRegional.getSelectedItem().toString());
        }
        this.session.setUf(this.cbUf.getSelectedItem().toString());
        this.session.setRelatorio("Violencia");
        this.session.execute();
    }

    private void btLimparActionPerformed(ActionEvent evt) {
        this.cbMunicipio.removeAllItems();
        this.cbRegional.removeAllItems();
        this.cbUf.setSelectedIndex(0);
    }

    private void cbMunicipioActionPerformed(ActionEvent evt) {
    }

    private void btnSelecionarArquivosActionPerformed(ActionEvent evt) {
        JFileChooser fileopen = new JFileChooser();
        fileopen.setMultiSelectionEnabled(true);
        FiltroArquivo filtro = new FiltroArquivo();
        filtro.addExtension("dbf");
        filtro.setDescription("Arquivo DBF");
        filtro.addInicioNome("VIOLE");
        fileopen.addChoosableFileFilter(filtro);
        fileopen.setFileFilter(filtro);
        File file2 = new File(new Configuracao().getCaminho());
        fileopen.setCurrentDirectory(file2);
        int ret = fileopen.showDialog(null, "Abrir DBF");
        if (ret == 0) {
            File[] files = fileopen.getSelectedFiles();
            if (this.lblArquivosSelecionados.getText().equals("Nenhum arquivo selecionado")) {
                this.lblArquivosSelecionados.setText("");
            }
            for (int i = 0; i < files.length; ++i) {
                if (this.lblArquivosSelecionados.getText().lastIndexOf(files[i].getName()) == -1) {
                    this.lblArquivosSelecionados.setText(this.lblArquivosSelecionados.getText() + files[i].getName() + "||");
                }
                Configuracao.setPropriedade("caminho", files[i].getParent() + "\\\\");
            }
        }
    }

    private void btnLimparSelecaoActionPerformed(ActionEvent evt) {
        this.lblArquivosSelecionados.setText("Nenhum arquivo selecionado");
    }
}

