/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.io.InputStream;
import java.util.Properties;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class GDSExceptionHelper {
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$gds$GDSExceptionHelper != null ? class$org$firebirdsql$gds$GDSExceptionHelper : (class$org$firebirdsql$gds$GDSExceptionHelper = GDSExceptionHelper.class$("org.firebirdsql.gds.GDSExceptionHelper")), false);
    private static final String MESSAGES = "isc_error_msg";
    private static Properties messages = new Properties();
    private static boolean initialized = false;
    static /* synthetic */ Class class$org$firebirdsql$gds$GDSExceptionHelper;
    static /* synthetic */ Class class$org$firebirdsql$gds$GDSException;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static GDSMessage getMessage(int code) {
        if (!initialized) {
            GDSExceptionHelper.init();
        }
        return new GDSMessage(messages.getProperty(String.valueOf(code), "No message for code " + code + " found."));
    }

    private static void init() {
        try {
            block6: {
                try {
                    ClassLoader cl = (class$org$firebirdsql$gds$GDSException != null ? class$org$firebirdsql$gds$GDSException : (class$org$firebirdsql$gds$GDSException = GDSExceptionHelper.class$("org.firebirdsql.gds.GDSException"))).getClassLoader();
                    String res = String.valueOf(MESSAGES.replace('.', '/')) + ".properties";
                    InputStream in = cl.getResourceAsStream(res);
                    if (in == null) {
                        cl = Thread.currentThread().getContextClassLoader();
                        in = cl.getResourceAsStream(res);
                    }
                    if (in != null) {
                        messages.load(in);
                    }
                }
                catch (Exception ex) {
                    if (log == null) break block6;
                    log.info("Exception in init of GDSExceptionHelper", ex);
                }
            }
            Object var1_4 = null;
            initialized = true;
        }
        catch (Throwable throwable) {
            Object var1_5 = null;
            initialized = true;
            throw throwable;
        }
    }

    public static class GDSMessage {
        private String template;
        private String[] params;

        public GDSMessage(String template) {
            this.template = template;
            this.params = new String[this.getParamCount()];
        }

        public int getParamCount() {
            int count = 0;
            int i = 0;
            while (i < this.template.length()) {
                if (this.template.charAt(i) == '{') {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        public void setParameter(int position, String text) {
            if (position < this.params.length) {
                this.params[position] = text;
            }
        }

        public String toString() {
            String message = this.template;
            int i = 0;
            while (i < this.params.length) {
                String param = "{" + i + "}";
                int pos = message.indexOf(param);
                if (pos > -1) {
                    String temp = message.substring(0, pos);
                    temp = String.valueOf(temp) + (this.params[i] == null ? "" : this.params[i]);
                    message = temp = String.valueOf(temp) + message.substring(pos + param.length());
                }
                ++i;
            }
            return message;
        }
    }
}

