/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.XSQLDA;
import org.firebirdsql.gds.isc_blob_handle;
import org.firebirdsql.gds.isc_db_handle;
import org.firebirdsql.gds.isc_stmt_handle;
import org.firebirdsql.gds.isc_tr_handle;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBLocalTransaction;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jca.FBManagedConnectionMetaData;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBTpb;
import org.firebirdsql.jca.FBXid;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class FBManagedConnection
implements ManagedConnection,
XAResource {
    private final Logger log = LoggerFactory.getLogger(this.getClass(), false);
    private FBManagedConnectionFactory mcf;
    private ArrayList connectionEventListeners = new ArrayList();
    private ArrayList connectionHandles = new ArrayList();
    private int timeout = 0;
    protected FBConnectionRequestInfo cri;
    private isc_tr_handle currentTr;
    private isc_db_handle currentDbHandle;
    public boolean autoCommit = true;
    private final FBTpb tpb;
    private static final String RECOVERY_QUERY = "SELECT RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION FROM RDB$TRANSACTIONS WHERE RDB$TRANSACTION_STATE = 1";
    static final CELNotifier connectionClosedNotifier = new CELNotifier(){

        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.connectionClosed(ce);
        }
    };
    static final CELNotifier connectionErrorOccurredNotifier = new CELNotifier(){

        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.connectionErrorOccurred(ce);
        }
    };
    static final CELNotifier localTransactionStartedNotifier = new CELNotifier(){

        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.localTransactionStarted(ce);
        }
    };
    static final CELNotifier localTransactionCommittedNotifier = new CELNotifier(){

        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.localTransactionCommitted(ce);
        }
    };
    static final CELNotifier localTransactionRolledbackNotifier = new CELNotifier(){

        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.localTransactionRolledback(ce);
        }
    };

    FBManagedConnection(Subject subject, ConnectionRequestInfo cri, FBManagedConnectionFactory mcf) throws ResourceException {
        this.mcf = mcf;
        this.cri = this.getCombinedConnectionRequestInfo(subject, cri);
        this.tpb = mcf.getTpb();
        try {
            this.currentDbHandle = mcf.createDbHandle(this.cri);
        }
        catch (GDSException ge) {
            if (this.log != null) {
                this.log.debug("Could not get a db connection!", ge);
            }
            throw new FBResourceException(ge);
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    public void associateConnection(Object connection) throws ResourceException {
        try {
            ((FBConnection)connection).setManagedConnection(this);
            this.connectionHandles.add(connection);
        }
        catch (ClassCastException cce) {
            throw new FBResourceException("invalid connection supplied to associateConnection.", cce);
        }
    }

    private void checkFatal(GDSException ge) {
        if (ge.isFatal()) {
            this.mcf.destroyDbHandle(this.currentDbHandle, this.cri);
            this.currentTr = null;
            ConnectionEvent ce = new ConnectionEvent(this, 5, ge);
            this.notify(connectionErrorOccurredNotifier, ce);
        }
    }

    private void checkFatalXA(GDSException ge, isc_db_handle committingDbHandle) {
        if (ge.isFatal()) {
            this.mcf.destroyDbHandle(committingDbHandle, this.cri);
            if (this.currentDbHandle == committingDbHandle) {
                this.currentTr = null;
                ConnectionEvent ce = new ConnectionEvent(this, 5, ge);
                this.notify(connectionErrorOccurredNotifier, ce);
            }
        }
    }

    public void cleanup() throws ResourceException {
        Iterator i = ((AbstractList)this.connectionHandles).iterator();
        while (i.hasNext()) {
            ((FBConnection)i.next()).setManagedConnection(null);
        }
        this.connectionHandles.clear();
    }

    public void clearWarnings() {
        this.currentDbHandle.clearWarnings();
    }

    public void close(FBConnection c) {
        c.setManagedConnection(null);
        ((AbstractCollection)this.connectionHandles).remove(c);
        ConnectionEvent ce = new ConnectionEvent(this, 1, null);
        ce.setConnectionHandle(c);
        this.notify(connectionClosedNotifier, ce);
    }

    public void closeBlob(isc_blob_handle blob) throws GDSException {
        try {
            this.mcf.gds.isc_close_blob(blob);
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public void closeStatement(isc_stmt_handle stmt, boolean deallocate) throws GDSException {
        try {
            this.mcf.gds.isc_dsql_free_statement(stmt, deallocate ? 2 : 1);
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public void commit(Xid id, boolean twoPhase) throws XAException {
        try {
            this.internalCommit(id, twoPhase);
        }
        catch (GDSException ge) {
            throw new XAException(ge.getXAErrorCode());
        }
    }

    public isc_blob_handle createBlobHandle() throws GDSException {
        try {
            isc_blob_handle blob = this.mcf.gds.get_new_isc_blob_handle();
            this.mcf.gds.isc_create_blob2(this.currentDbHandle, this.currentTr, blob, null);
            return blob;
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public void destroy() throws ResourceException {
        if (this.currentTr != null) {
            throw new IllegalStateException("Can't destroy managed connection  with active transaction");
        }
        if (this.currentDbHandle != null) {
            try {
                try {
                    this.mcf.releaseDbHandle(this.currentDbHandle, this.cri);
                }
                catch (GDSException ge) {
                    throw new FBResourceException("Can't detach from db.", ge);
                }
                Object var2_2 = null;
                this.currentDbHandle = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.currentDbHandle = null;
                throw throwable;
            }
        }
    }

    public void end(Xid id, int flags) throws XAException {
        try {
            this.internalEnd(id, flags);
        }
        catch (GDSException ge) {
            throw new XAException(ge.getXAErrorCode());
        }
    }

    public void executeStatement(isc_stmt_handle stmt, boolean sendOutSqlda) throws GDSException {
        try {
            this.mcf.gds.isc_dsql_execute2(this.currentTr, stmt, 1, stmt.getInSqlda(), sendOutSqlda ? stmt.getOutSqlda() : null);
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public void fetch(isc_stmt_handle stmt, int fetchSize) throws GDSException {
        try {
            this.mcf.gds.isc_dsql_fetch(stmt, 1, stmt.getOutSqlda(), fetchSize);
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    private void findIscTrHandle(Xid xid, int flags) throws GDSException {
        try {
            this.currentTr = this.mcf.getCurrentIscTrHandle(xid, this, flags);
        }
        catch (GDSException ge) {
            block8: {
                if (this.currentDbHandle.isValid()) {
                    try {
                        this.mcf.returnDbHandle(this.currentDbHandle, this.cri);
                    }
                    catch (GDSException ge2) {
                        if (this.log == null) break block8;
                        this.log.debug("Another exception killing a dead connection", ge2);
                    }
                }
            }
            ConnectionEvent ce = new ConnectionEvent(this, 5, ge);
            this.notify(connectionErrorOccurredNotifier, ce);
            ge.setXAErrorCode(-3);
            throw ge;
        }
        if (this.currentTr.getDbHandle() != this.currentDbHandle) {
            try {
                this.mcf.returnDbHandle(this.currentDbHandle, this.cri);
            }
            catch (GDSException ge) {
                ge.setXAErrorCode(-3);
                throw ge;
            }
            this.currentDbHandle = this.currentTr.getDbHandle();
        }
    }

    public void forget(Xid id) throws XAException {
        throw new XAException("Not yet implemented");
    }

    public isc_stmt_handle getAllocatedStatement() throws GDSException {
        if (this.currentTr == null) {
            throw new GDSException("No transaction started for allocate statement");
        }
        isc_stmt_handle stmt = this.mcf.gds.get_new_isc_stmt_handle();
        try {
            this.mcf.gds.isc_dsql_allocate_statement(this.currentTr.getDbHandle(), stmt);
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
        return stmt;
    }

    public Integer getBlobBufferLength() {
        return this.mcf.getBlobBufferLength();
    }

    public byte[] getBlobSegment(isc_blob_handle blob, int len) throws GDSException {
        try {
            return this.mcf.gds.isc_get_segment(blob, len);
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    private FBConnectionRequestInfo getCombinedConnectionRequestInfo(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (cri == null) {
            cri = this.mcf.getDefaultConnectionRequestInfo();
        }
        try {
            FBConnectionRequestInfo fbcri = (FBConnectionRequestInfo)cri;
            if (subject != null) {
                Iterator<Object> i = subject.getPrivateCredentials().iterator();
                while (i.hasNext()) {
                    Object cred = i.next();
                    if (!(cred instanceof PasswordCredential) || !this.mcf.equals(((PasswordCredential)cred).getManagedConnectionFactory())) continue;
                    PasswordCredential pcred = (PasswordCredential)cred;
                    String user = pcred.getUserName();
                    String password = new String(pcred.getPassword());
                    fbcri.setPassword(password);
                    fbcri.setUser(user);
                    break;
                }
            }
            return fbcri;
        }
        catch (ClassCastException classCastException) {
            throw new FBResourceException("Incorrect ConnectionRequestInfo class supplied");
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (!this.matches(subject, cri)) {
            throw new FBResourceException("Incompatible subject or ConnectionRequestInfo in getConnection!");
        }
        FBConnection c = new FBConnection(this);
        this.connectionHandles.add(c);
        return c;
    }

    public String getDatabase() {
        return this.mcf.getDatabase();
    }

    public int getDatabaseProductMajorVersion() {
        return this.currentDbHandle.getDatabaseProductMajorVersion();
    }

    public int getDatabaseProductMinorVersion() {
        return this.currentDbHandle.getDatabaseProductMinorVersion();
    }

    public String getDatabaseProductName() {
        return this.currentDbHandle.getDatabaseProductName();
    }

    public String getDatabaseProductVersion() {
        return this.currentDbHandle.getDatabaseProductVersion();
    }

    public GDS getInternalAPIHandler() {
        return this.mcf.gds;
    }

    public isc_db_handle getIscDBHandle() throws GDSException {
        if (this.currentDbHandle == null) {
            this.currentDbHandle = this.mcf.getDbHandle(this.cri);
        }
        return this.currentDbHandle;
    }

    isc_db_handle getIscDBHandle(Set reserved) throws GDSException {
        if (this.currentDbHandle == null) {
            this.currentDbHandle = this.mcf.getDbHandle(this.cri);
        } else if (reserved.contains(this.currentDbHandle)) {
            this.mcf.releaseDbHandle(this.currentDbHandle, this.cri);
            this.currentDbHandle = this.mcf.getDbHandle(this.cri);
        }
        return this.currentDbHandle;
    }

    public String getIscEncoding() {
        try {
            String result = this.cri.getStringProperty(48);
            if (result == null) {
                result = "NONE";
            }
            return result;
        }
        catch (NullPointerException nullPointerException) {
            return "NONE";
        }
    }

    public int getIscTransactionIsolation() throws ResourceException {
        return this.tpb.getIscTransactionIsolation();
    }

    public LocalTransaction getLocalTransaction() {
        return new FBLocalTransaction(this, null);
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new FBManagedConnectionMetaData(this);
    }

    public void getSqlCounts(isc_stmt_handle stmt) throws GDSException {
        try {
            this.mcf.gds.getSqlCounts(stmt);
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    FBTpb getTpb() {
        return this.tpb;
    }

    public int getTransactionIsolation() throws ResourceException {
        return this.tpb.getTransactionIsolation();
    }

    public String getTransactionIsolationName() throws ResourceException {
        return this.tpb.getTransactionIsolationName();
    }

    public int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    public String getUserName() {
        return this.cri.getUser();
    }

    public List getWarnings() {
        return this.currentDbHandle.getWarnings();
    }

    public XAResource getXAResource() throws ResourceException {
        if (this.log != null) {
            this.log.debug("XAResource requested from FBManagedConnection");
        }
        return this;
    }

    public boolean inTransaction() {
        return this.currentTr != null;
    }

    void internalCommit(Xid id, boolean twoPhase) throws GDSException {
        isc_tr_handle committingTr;
        if (this.log != null) {
            this.log.debug("Commit called: " + id);
        }
        if ((committingTr = this.mcf.getTrHandleForXid(id)) == null) {
            throw GDSException.createWithXAErrorCode("commit called with unknown transaction", -4);
        }
        if (committingTr == this.currentTr) {
            throw GDSException.createWithXAErrorCode("commit called with current xid", -6);
        }
        isc_db_handle committingDbHandle = committingTr.getDbHandle();
        try {
            this.mcf.commit(id);
        }
        catch (GDSException ge) {
            this.checkFatalXA(ge, committingDbHandle);
            if (this.log != null) {
                this.log.debug("Fatal error committing, ", ge);
            }
            ge.setXAErrorCode(-3);
            throw ge;
        }
    }

    void internalEnd(Xid id, int flags) throws GDSException {
        isc_tr_handle endingTr;
        if (flags != 0x2000000 && flags != 0x4000000 && flags != 0x20000000) {
            throw GDSException.createWithXAErrorCode("Invalid flag in end: must be TMSUSPEND, TMSUCCESS, or TMFAIL", -5);
        }
        if (this.log != null) {
            this.log.debug("End called: " + id);
        }
        if ((endingTr = this.mcf.getTrHandleForXid(id)) == null) {
            throw GDSException.createWithXAErrorCode("Unrecognized transaction", -4);
        }
        if (endingTr == this.currentTr) {
            this.currentTr = null;
        } else if (flags == 0x2000000) {
            throw GDSException.createWithXAErrorCode("You are trying to suspend a transaction that is not the current transaction", -5);
        }
    }

    void internalRollback(Xid id) throws GDSException {
        isc_tr_handle committingTr;
        if (this.log != null) {
            this.log.debug("rollback called: " + id);
        }
        if ((committingTr = this.mcf.getTrHandleForXid(id)) == null) {
            if (this.log != null) {
                this.log.warn("rollback called with unknown transaction: " + id);
            }
            return;
        }
        if (committingTr == this.currentTr) {
            throw GDSException.createWithXAErrorCode("Rollback called with current xid", -6);
        }
        isc_db_handle committingDbHandle = committingTr.getDbHandle();
        try {
            this.mcf.rollback(id);
        }
        catch (GDSException ge) {
            this.checkFatalXA(ge, committingDbHandle);
            if (this.log != null) {
                this.log.debug("Exception in rollback", ge);
            }
            ge.setXAErrorCode(-3);
            throw ge;
        }
    }

    public void internalStart(Xid id, int flags) throws GDSException {
        if (this.log != null) {
            this.log.debug("start called: " + id);
        }
        if (this.currentTr != null) {
            throw GDSException.createWithXAErrorCode("start called while there is an active transaction", -6);
        }
        this.findIscTrHandle(id, flags);
    }

    public boolean isReadOnly() {
        return this.tpb.isReadOnly();
    }

    public boolean isSameRM(XAResource res) throws XAException {
        return res instanceof FBManagedConnection && this.mcf == ((FBManagedConnection)res).mcf;
    }

    boolean matches(Subject subj, ConnectionRequestInfo cri) {
        try {
            return this.cri.equals(this.getCombinedConnectionRequestInfo(subj, cri));
        }
        catch (ResourceException resourceException) {
            return false;
        }
    }

    void notify(CELNotifier notifier, ConnectionEvent ce) {
        if (this.connectionEventListeners.size() == 0) {
            return;
        }
        if (this.connectionEventListeners.size() == 1) {
            ConnectionEventListener cel = (ConnectionEventListener)this.connectionEventListeners.get(0);
            notifier.notify(cel, ce);
            return;
        }
        ArrayList cels = (ArrayList)this.connectionEventListeners.clone();
        Iterator i = ((AbstractList)cels).iterator();
        while (i.hasNext()) {
            notifier.notify((ConnectionEventListener)i.next(), ce);
        }
    }

    public isc_blob_handle openBlobHandle(long blob_id) throws GDSException {
        try {
            isc_blob_handle blob = this.mcf.gds.get_new_isc_blob_handle();
            blob.setBlob_id(blob_id);
            this.mcf.gds.isc_open_blob2(this.currentDbHandle, this.currentTr, blob, null);
            return blob;
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public int prepare(Xid id) throws XAException {
        isc_tr_handle committingTr;
        if (this.log != null) {
            this.log.debug("prepare called: " + id);
        }
        if ((committingTr = this.mcf.getTrHandleForXid(id)) == null) {
            throw new XAException(-5);
        }
        if (committingTr == this.currentTr) {
            throw new XAException(-6);
        }
        isc_db_handle committingDbHandle = committingTr.getDbHandle();
        try {
            this.mcf.prepare(id);
        }
        catch (GDSException ge) {
            this.checkFatalXA(ge, committingDbHandle);
            if (this.log != null) {
                this.log.debug("Exception in prepare", ge);
            }
            throw new XAException(-3);
        }
        return 0;
    }

    public void prepareSQL(isc_stmt_handle stmt, String sql, boolean describeBind) throws GDSException {
        if (this.log != null) {
            this.log.debug("preparing sql: " + sql);
        }
        String encoding = this.cri.getStringProperty(48);
        try {
            XSQLDA out = this.mcf.gds.isc_dsql_prepare(this.currentTr, stmt, sql, encoding, 3);
            if (out.sqld != out.sqln) {
                throw new GDSException("Not all columns returned");
            }
            if (describeBind) {
                this.mcf.gds.isc_dsql_describe_bind(stmt, 1);
            }
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public void putBlobSegment(isc_blob_handle blob, byte[] buf) throws GDSException {
        try {
            this.mcf.gds.isc_put_segment(blob, buf);
        }
        catch (GDSException ge) {
            this.checkFatal(ge);
            throw ge;
        }
    }

    public Xid[] recover(int flag) throws XAException {
        ArrayList<FBXid> xids = new ArrayList<FBXid>();
        Connection conn = null;
        try {
            Xid[] xidArray;
            conn = (Connection)this.getConnection(null, null);
            try {
                Statement statement = conn.createStatement();
                ResultSet recoveredRS = statement.executeQuery(RECOVERY_QUERY);
                while (recoveredRS.next()) {
                    try {
                        long transactionID = recoveredRS.getLong(1);
                        InputStream xidIn = recoveredRS.getBinaryStream(2);
                        FBXid xid = new FBXid(xidIn);
                        xids.add(xid);
                    }
                    catch (SQLException sQLException) {
                    }
                    catch (ResourceException resourceException) {}
                }
                xidArray = xids.toArray(new Xid[xids.size()]);
                Object var6_12 = null;
            }
            catch (Throwable throwable) {
                Object var6_13 = null;
                conn.close();
                throw throwable;
            }
            conn.close();
            return xidArray;
        }
        catch (SQLException sqle) {
            if (this.log != null) {
                this.log.debug("can't perform query to fetch xids", sqle);
            }
            throw new XAException(-7);
        }
        catch (ResourceException re) {
            if (this.log != null) {
                this.log.debug("can't perform query to fetch xids", re);
            }
            throw new XAException(-7);
        }
    }

    public void registerStatement(FBStatement fbStatement) {
        if (this.currentTr == null) {
            throw new IllegalStateException("registerStatement called with no transaction");
        }
        this.currentTr.registerStatementWithTransaction(fbStatement);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        ((AbstractCollection)this.connectionEventListeners).remove(listener);
    }

    public void rollback(Xid id) throws XAException {
        try {
            this.internalRollback(id);
        }
        catch (GDSException ge) {
            throw new XAException(ge.getXAErrorCode());
        }
    }

    public void setIscTransactionIsolation(int isolation) throws ResourceException {
        this.tpb.setIscTransactionIsolation(isolation);
    }

    public void setLogWriter(PrintWriter out) {
    }

    public void setReadOnly(boolean readOnly) {
        this.tpb.setReadOnly(readOnly);
    }

    public void setTransactionIsolation(int isolation) throws ResourceException {
        this.tpb.setTransactionIsolation(isolation);
    }

    public void setTransactionIsolationName(String isolation) throws ResourceException {
        this.tpb.setTransactionIsolationName(isolation);
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.timeout = timeout;
        return true;
    }

    public void start(Xid id, int flags) throws XAException {
        try {
            this.internalStart(id, flags);
        }
        catch (GDSException ge) {
            throw new XAException(ge.getXAErrorCode());
        }
    }

    static interface CELNotifier {
        public void notify(ConnectionEventListener var1, ConnectionEvent var2);
    }
}

