/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.xa.Xid;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.GDSFactory;
import org.firebirdsql.gds.isc_db_handle;
import org.firebirdsql.gds.isc_tr_handle;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBStandAloneConnectionManager;
import org.firebirdsql.jca.FBTpb;
import org.firebirdsql.jca.FBTpbMapper;
import org.firebirdsql.jca.FBXid;
import org.firebirdsql.jdbc.FBConnectionHelper;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class FBManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    private static final int MAX_BLOB_BUFFER_LENGTH = Short.MAX_VALUE;
    private static final int MIN_BLOB_BUFFER_LENGTH = 1024;
    private static final Map mcfInstances = new WeakHashMap();
    private String dbAlias;
    private FBConnectionRequestInfo defaultCri;
    private final FBTpb tpb = new FBTpb(FBTpbMapper.DEFAULT_MAPPER);
    private int blobBufferLength = 16384;
    private static final transient Logger log = LoggerFactory.getLogger(class$org$firebirdsql$jca$FBManagedConnectionFactory != null ? class$org$firebirdsql$jca$FBManagedConnectionFactory : (class$org$firebirdsql$jca$FBManagedConnectionFactory = FBManagedConnectionFactory.class$("org.firebirdsql.jca.FBManagedConnectionFactory")), true);
    final transient GDS gds = GDSFactory.newGDS();
    private final transient Map criToFreeDbHandlesMap = new HashMap();
    private final transient Set waitingToClose = Collections.synchronizedSet(new HashSet());
    private final transient Set rolledback = Collections.synchronizedSet(new HashSet());
    private final transient Map xidMap = Collections.synchronizedMap(new HashMap());
    private final transient Object startLock = new Object();
    private transient boolean started = false;
    private volatile int hashCode = 0;
    static /* synthetic */ Class class$org$firebirdsql$jca$FBManagedConnectionFactory;

    public FBManagedConnectionFactory() {
        this.defaultCri = FBConnectionHelper.getDefaultCri();
    }

    public FBManagedConnectionFactory canonicalize() {
        FBManagedConnectionFactory mcf = (FBManagedConnectionFactory)mcfInstances.get(this);
        if (mcf != null) {
            return mcf;
        }
        return this;
    }

    private void checkNotStarted() throws IllegalStateException {
        Object object = this.startLock;
        synchronized (object) {
            if (this.started) {
                throw new IllegalStateException("Operation not permitted after ManagedConnectionFactory in use");
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    void commit(Xid xid) throws GDSException {
        isc_tr_handle tr = this.getTrHandleForXid(xid);
        tr.forgetResultSets();
        try {
            try {
                this.gds.isc_commit_transaction(tr);
            }
            catch (GDSException ge) {
                block6: {
                    try {
                        this.gds.isc_rollback_transaction(tr);
                    }
                    catch (GDSException ge2) {
                        if (log == null) break block6;
                        log.debug("Exception rolling back failed tx: ", ge2);
                    }
                }
                throw ge;
            }
            Object var4_5 = null;
            this.xidMap.remove(xid);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.xidMap.remove(xid);
            throw throwable;
        }
    }

    public Object createConnectionFactory() throws ResourceException {
        this.start();
        return new FBDataSource(this, new FBStandAloneConnectionManager());
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        this.start();
        return new FBDataSource(this, cxManager);
    }

    isc_db_handle createDbHandle(FBConnectionRequestInfo cri) throws GDSException {
        isc_db_handle db = this.gds.get_new_isc_db_handle();
        this.gds.isc_attach_database(this.dbAlias, db, cri.getDpb());
        return db;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        this.start();
        return new FBManagedConnection(subject, cri, this);
    }

    void destroyDbHandle(isc_db_handle db, FBConnectionRequestInfo cri) {
        block6: {
            Collection transactions = db.getTransactions();
            Set xidTrs = this.xidMap.entrySet();
            Iterator i = transactions.iterator();
            while (i.hasNext()) {
                isc_tr_handle tr = (isc_tr_handle)i.next();
                Iterator j = xidTrs.iterator();
                while (j.hasNext()) {
                    Map.Entry pair = j.next();
                    if (pair.getValue() != tr) continue;
                    this.rolledback.add(pair.getKey());
                    j.remove();
                }
                try {
                    this.gds.isc_rollback_transaction(tr);
                }
                catch (GDSException ge) {
                    if (log == null) continue;
                    log.debug("exception rolling back transaction from dying connection: " + ge.getMessage());
                }
            }
            try {
                this.releaseDbHandle(db, cri);
            }
            catch (GDSException ge) {
                if (log == null) break block6;
                log.debug("exception releasing db handle from dying connection: " + ge.getMessage());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FBManagedConnectionFactory)) {
            return false;
        }
        FBManagedConnectionFactory mcf = (FBManagedConnectionFactory)other;
        if (this.dbAlias == null) {
            if (mcf.dbAlias != null) {
                return false;
            }
        } else {
            boolean bl = this.dbAlias.equals(mcf.dbAlias);
            if (!bl) return false;
        }
        if (!this.defaultCri.equals(mcf.defaultCri)) return false;
        if (!this.tpb.equals(mcf.tpb)) return false;
        if (this.blobBufferLength == mcf.blobBufferLength) return true;
        return false;
    }

    public Integer getBlobBufferLength() {
        return new Integer(this.blobBufferLength);
    }

    isc_tr_handle getCurrentIscTrHandle(Xid xid, FBManagedConnection mc, int flags) throws GDSException {
        isc_tr_handle tr = this.getTrHandleForXid(xid);
        if (tr == null) {
            if (flags != 0) {
                throw GDSException.createWithXAErrorCode("You are trying to resume a transaction that has is new", -5);
            }
            isc_db_handle db = mc.getIscDBHandle(this.waitingToClose);
            tr = this.gds.get_new_isc_tr_handle();
            try {
                this.gds.isc_start_transaction(tr, db, mc.getTpb().getArray());
            }
            catch (GDSException ge) {
                this.destroyDbHandle(db, mc.cri);
                throw ge;
            }
            this.xidMap.put(xid, tr);
        } else if (flags != 0x200000 && flags != 0x8000000) {
            throw GDSException.createWithXAErrorCode("You are trying to start a transaction as new that is already known to this XAResource", -5);
        }
        return tr;
    }

    public String getDatabase() {
        return this.dbAlias;
    }

    isc_db_handle getDbHandle(FBConnectionRequestInfo cri) throws GDSException {
        try {
            LinkedList freeDbHandles = null;
            Map map = this.criToFreeDbHandlesMap;
            synchronized (map) {
                freeDbHandles = (LinkedList)this.criToFreeDbHandlesMap.get(cri);
            }
            if (freeDbHandles != null) {
                isc_db_handle db = null;
                LinkedList linkedList = freeDbHandles;
                synchronized (linkedList) {
                    db = (isc_db_handle)freeDbHandles.removeLast();
                }
                return db;
            }
            return this.createDbHandle(cri);
        }
        catch (NoSuchElementException noSuchElementException) {
            return this.createDbHandle(cri);
        }
    }

    public FBConnectionRequestInfo getDefaultConnectionRequestInfo() {
        return new FBConnectionRequestInfo(this.defaultCri);
    }

    public String getEncoding() {
        String result = this.defaultCri.getStringProperty(48);
        if (result == null) {
            result = "NONE";
        }
        return result;
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    public String getPassword() {
        return this.defaultCri.getPassword();
    }

    public FBTpb getTpb() {
        return new FBTpb(this.tpb);
    }

    isc_tr_handle getTrHandleForXid(Xid xid) {
        return (isc_tr_handle)this.xidMap.get(xid);
    }

    public Integer getTransactionIsolation() throws ResourceException {
        return new Integer(this.tpb.getTransactionIsolation());
    }

    public String getTransactionIsolationName() throws ResourceException {
        return this.tpb.getTransactionIsolationName();
    }

    public String getUserName() {
        return this.defaultCri.getUser();
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int result = 17;
        result = 37 * result + (this.dbAlias == null ? 0 : this.dbAlias.hashCode());
        result = 37 * result + this.defaultCri.hashCode();
        result = 37 * result + this.tpb.hashCode();
        this.hashCode = result = 37 * result + this.blobBufferLength;
        return this.hashCode;
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        Iterator i = connectionSet.iterator();
        while (i.hasNext()) {
            FBManagedConnection mc = (FBManagedConnection)i.next();
            if (!mc.matches(subject, (FBConnectionRequestInfo)cxRequestInfo)) continue;
            return mc;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void prepare(Xid xid) throws GDSException {
        isc_tr_handle tr = this.getTrHandleForXid(xid);
        try {
            FBXid fbxid = xid instanceof FBXid ? (FBXid)xid : new FBXid(xid);
            this.gds.isc_prepare_transaction2(tr, fbxid.toBytes());
        }
        catch (GDSException ge) {
            void fbxid;
            try {
                block7: {
                    try {
                        this.gds.isc_rollback_transaction(tr);
                    }
                    catch (GDSException ge2) {
                        if (log == null) break block7;
                        log.debug("Exception rolling back failed tx: ", ge2);
                    }
                }
                Object var5_6 = null;
                this.xidMap.remove(xid);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.xidMap.remove(xid);
                throw throwable;
            }
            if (log != null) {
                log.warn("error in prepare", ge);
            }
            throw fbxid;
        }
    }

    private Object readResolve() throws ObjectStreamException {
        FBManagedConnectionFactory mcf = (FBManagedConnectionFactory)mcfInstances.get(this);
        if (mcf != null) {
            return mcf;
        }
        mcf = new FBManagedConnectionFactory();
        mcf.setDatabase(this.getDatabase());
        mcf.setConnectionRequestInfo(this.getDefaultConnectionRequestInfo());
        mcf.setTpb(this.getTpb());
        mcf.setBlobBufferLength(this.getBlobBufferLength());
        return mcf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void releaseDbHandle(isc_db_handle db, FBConnectionRequestInfo cri) throws GDSException {
        if (db == null) {
            throw new IllegalArgumentException("Attempt to release a null db handle!");
        }
        isc_db_handle isc_db_handle2 = db;
        synchronized (isc_db_handle2) {
            LinkedList freeDbHandles = null;
            Object object = this.criToFreeDbHandlesMap;
            synchronized (object) {
                freeDbHandles = (LinkedList)this.criToFreeDbHandlesMap.get(cri);
            }
            if (freeDbHandles != null) {
                object = freeDbHandles;
                synchronized (object) {
                    freeDbHandles.remove(db);
                }
            }
            try {
                if (db.hasTransactions()) {
                    if (log != null) {
                        log.debug("db has transactions!");
                    }
                    object = this.waitingToClose;
                    synchronized (object) {
                        if (this.waitingToClose.contains(db)) return;
                        this.waitingToClose.add(db);
                        return;
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.waitingToClose.remove(db);
                return;
            }
            if (log != null) {
                log.debug("About to detach db");
            }
            this.waitingToClose.remove(db);
            this.gds.isc_detach_database(db);
            return;
        }
    }

    void returnDbHandle(isc_db_handle db, FBConnectionRequestInfo cri) throws GDSException {
        if (db == null) {
            return;
        }
        if (this.waitingToClose.contains(db)) {
            this.releaseDbHandle(db, cri);
        } else {
            LinkedList<isc_db_handle> freeDbHandles = null;
            Object object = this.criToFreeDbHandlesMap;
            synchronized (object) {
                freeDbHandles = (LinkedList<isc_db_handle>)this.criToFreeDbHandlesMap.get(cri);
                if (freeDbHandles == null) {
                    freeDbHandles = new LinkedList<isc_db_handle>();
                    this.criToFreeDbHandlesMap.put(cri, freeDbHandles);
                }
            }
            object = freeDbHandles;
            synchronized (object) {
                if (!freeDbHandles.contains(db)) {
                    freeDbHandles.addLast(db);
                }
            }
        }
    }

    void rollback(Xid xid) throws GDSException {
        isc_tr_handle tr = this.getTrHandleForXid(xid);
        tr.forgetResultSets();
        try {
            this.gds.isc_rollback_transaction(tr);
        }
        finally {
            Object var4_3 = null;
            this.xidMap.remove(xid);
        }
    }

    public void setBlobBufferLength(Integer blobBufferLengthWrapper) {
        this.checkNotStarted();
        this.hashCode = 0;
        int blobBufferLength = blobBufferLengthWrapper;
        if (blobBufferLength > Short.MAX_VALUE) {
            this.blobBufferLength = Short.MAX_VALUE;
            if (log != null) {
                log.warn("Supplied blob buffer length greater than maximum of 32767");
            }
        } else if (blobBufferLength < 1024) {
            this.blobBufferLength = 1024;
            if (log != null) {
                log.warn("Supplied blob buffer length less than minimum of 1024");
            }
        } else {
            this.blobBufferLength = blobBufferLength;
        }
    }

    public void setConnectionRequestInfo(FBConnectionRequestInfo cri) {
        this.checkNotStarted();
        this.hashCode = 0;
        this.defaultCri = new FBConnectionRequestInfo(cri);
    }

    public void setDatabase(String database) {
        this.checkNotStarted();
        this.hashCode = 0;
        this.dbAlias = database;
    }

    public void setEncoding(String encoding) {
        this.checkNotStarted();
        this.hashCode = 0;
        this.defaultCri.setProperty(48, encoding);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
    }

    public void setPassword(String password) {
        this.checkNotStarted();
        this.hashCode = 0;
        this.defaultCri.setPassword(password);
    }

    public void setTpb(FBTpb tpb) {
        this.checkNotStarted();
        this.hashCode = 0;
        this.tpb.setTpb(tpb);
    }

    public void setTpbMapper(FBTpbMapper mapper) {
        this.tpb.setMapper(mapper);
    }

    public void setTransactionIsolation(Integer level) throws ResourceException {
        this.checkNotStarted();
        this.hashCode = 0;
        if (level == null) {
            throw new FBResourceException("You must supply a isolation level");
        }
        this.tpb.setTransactionIsolation(level);
    }

    public void setTransactionIsolationName(String level) throws ResourceException {
        this.checkNotStarted();
        this.hashCode = 0;
        this.tpb.setTransactionIsolationName(level);
    }

    public void setUserName(String userName) {
        this.checkNotStarted();
        this.hashCode = 0;
        this.defaultCri.setUser(userName);
    }

    private void start() {
        Object object = this.startLock;
        synchronized (object) {
            if (!this.started) {
                Map map = mcfInstances;
                synchronized (map) {
                    mcfInstances.put(this, this);
                }
                this.started = true;
            }
        }
    }
}

