/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.ManagedConnectionPool;

public class FBPoolingConnectionManager
implements ConnectionManager {
    private ManagedConnectionPool.PoolParams poolParams;
    private ManagedConnectionFactory mcf;
    private PoolingStrategy poolingStrategy;

    public FBPoolingConnectionManager(ManagedConnectionPool.PoolParams poolParams, ManagedConnectionFactory mcf) {
        this.poolParams = poolParams;
        this.mcf = mcf;
        this.poolingStrategy = new PoolByCri();
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cri) throws ResourceException {
        if (this.mcf != mcf) {
            throw new FBResourceException("Wrong ManagedConnectionFactory sent to PoolingConnectionManager!");
        }
        ManagedConnection mc = this.getManagedConnection(cri);
        mc.addConnectionEventListener(new ConnectionEventListener(mc){
            final ManagedConnection localmc;
            {
                this.localmc = val$mc;
            }

            public void connectionClosed(ConnectionEvent event) {
                this.localmc.removeConnectionEventListener(this);
                this.returnManagedConnection(this.localmc, false);
            }

            public void connectionErrorOccurred(ConnectionEvent event) {
                this.localmc.removeConnectionEventListener(this);
                this.returnManagedConnection(this.localmc, true);
            }

            public void localTransactionCommitted(ConnectionEvent event) {
            }

            public void localTransactionRolledback(ConnectionEvent event) {
            }

            public void localTransactionStarted(ConnectionEvent event) {
            }
        });
        return mc.getConnection(null, cri);
    }

    public int getConnectionCount() {
        return this.poolingStrategy.getConnectionCount();
    }

    ManagedConnection getManagedConnection(ConnectionRequestInfo cri) throws ResourceException {
        return this.poolingStrategy.getConnection(cri);
    }

    void returnManagedConnection(ManagedConnection mc, boolean kill) {
        this.poolingStrategy.returnConnection(mc, kill);
    }

    void shutdown() {
        this.poolingStrategy.shutdown();
    }

    private static interface PoolingStrategy {
        public ManagedConnection getConnection(ConnectionRequestInfo var1) throws ResourceException;

        public int getConnectionCount();

        public void returnConnection(ManagedConnection var1, boolean var2);

        public void shutdown();
    }

    private class PoolByCri
    implements PoolingStrategy {
        private final Map pools = new HashMap();
        private final Map mcToPoolMap = new HashMap();

        PoolByCri() {
        }

        public ManagedConnection getConnection(ConnectionRequestInfo cri) throws ResourceException {
            ManagedConnectionPool mcp = null;
            Map map = this.pools;
            synchronized (map) {
                mcp = (ManagedConnectionPool)this.pools.get(cri);
                if (mcp == null) {
                    mcp = new ManagedConnectionPool(FBPoolingConnectionManager.this.mcf, cri, FBPoolingConnectionManager.this.poolParams);
                    this.pools.put(cri, mcp);
                }
            }
            ManagedConnection mc = mcp.getConnection(cri);
            this.mcToPoolMap.put(mc, mcp);
            return mc;
        }

        public int getConnectionCount() {
            int count = 0;
            Iterator i = this.pools.values().iterator();
            while (i.hasNext()) {
                count += ((ManagedConnectionPool)i.next()).getConnectionCount();
            }
            return count;
        }

        public void returnConnection(ManagedConnection mc, boolean kill) {
            ManagedConnectionPool mcp = (ManagedConnectionPool)this.mcToPoolMap.get(mc);
            if (mcp == null) {
                throw new IllegalArgumentException("Returned to wrong Pool!!");
            }
            mcp.returnConnection(mc, kill);
        }

        public void shutdown() {
            Iterator i = this.pools.values().iterator();
            while (i.hasNext()) {
                ((ManagedConnectionPool)i.next()).shutdown();
            }
        }
    }
}

