/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.io.IOException;
import java.io.InputStream;
import javax.resource.ResourceException;
import javax.transaction.xa.Xid;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jgds.XdrInputStream;

class FBXid
implements Xid {
    public static final int TDR_VERSION = 1;
    public static final int TDR_HOST_SITE = 1;
    public static final int TDR_DATABASE_PATH = 2;
    public static final int TDR_TRANSACTION_ID = 3;
    public static final int TDR_REMOTE_SITE = 4;
    public static final int TDR_XID_FORMAT_ID = 5;
    public static final int TDR_XID_GLOBAL_ID = 6;
    public static final int TDR_XID_BRANCH_ID = 4;
    private int formatId;
    private byte[] globalId;
    private byte[] branchId;

    FBXid(InputStream rawIn) throws ResourceException {
        try {
            XdrInputStream in = new XdrInputStream(rawIn);
            if (in.read() != 1) {
                throw new FBResourceException("Wrong TDR_VERSION for xid");
            }
            if (in.read() != 5) {
                throw new FBResourceException("Wrong TDR_XID_FORMAT_ID for xid");
            }
            this.formatId = in.readInt();
            if (in.read() != 6) {
                throw new FBResourceException("Wrong TDR_XID_GLOBAL_ID for xid");
            }
            this.globalId = in.readBuffer();
            if (in.read() != 4) {
                throw new FBResourceException("Wrong TDR_XID_BRANCH_ID for xid");
            }
            this.branchId = in.readBuffer();
        }
        catch (IOException ioe) {
            throw new FBResourceException("IOException: " + ioe);
        }
    }

    public FBXid(Xid xid) {
        this.formatId = xid.getFormatId();
        this.globalId = xid.getGlobalTransactionId();
        this.branchId = xid.getBranchQualifier();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Xid) {
            Xid other = (Xid)obj;
            if (this.formatId != other.getFormatId()) {
                return false;
            }
            byte[] otherGlobalID = other.getGlobalTransactionId();
            byte[] otherBranchID = other.getBranchQualifier();
            if (this.globalId.length != otherGlobalID.length || this.branchId.length != otherBranchID.length) {
                return false;
            }
            int i = 0;
            while (i < this.globalId.length) {
                if (this.globalId[i] != otherGlobalID[i]) {
                    return false;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.branchId.length) {
                if (this.branchId[i2] != otherBranchID[i2]) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        return false;
    }

    public byte[] getBranchQualifier() {
        return (byte[])this.branchId.clone();
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        return (byte[])this.globalId.clone();
    }

    int getLength() {
        return 8 + this.globalId.length + 1 + 1 + this.branchId.length;
    }

    byte[] toBytes() {
        byte[] b = new byte[this.getLength()];
        int i = 0;
        b[i++] = 1;
        b[i++] = 5;
        b[i++] = (byte)(this.formatId >>> 24 & 0xFF);
        b[i++] = (byte)(this.formatId >>> 16 & 0xFF);
        b[i++] = (byte)(this.formatId >>> 8 & 0xFF);
        b[i++] = (byte)(this.formatId & 0xFF);
        b[i++] = 6;
        b[i++] = (byte)this.globalId.length;
        System.arraycopy(this.globalId, 0, b, i, this.globalId.length);
        i += this.globalId.length;
        b[i++] = 4;
        b[i++] = (byte)this.branchId.length;
        System.arraycopy(this.branchId, 0, b, i, this.branchId.length);
        return b;
    }

    public String toString() {
        return FBXid.toString(this);
    }

    static String toString(Xid id) {
        if (id == null) {
            return "[NULL Xid]";
        }
        String s = id.getClass().getName();
        s = s.substring(s.lastIndexOf(46) + 1);
        s = String.valueOf(s) + " [FormatId=" + id.getFormatId() + ", GlobalId=" + new String(id.getGlobalTransactionId()).trim() + ", BranchQual=" + new String(id.getBranchQualifier()).trim() + "]";
        return s;
    }
}

