/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.firebirdsql.jca.ManagedConnectionPool;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class IdleRemover {
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$jca$IdleRemover != null ? class$org$firebirdsql$jca$IdleRemover : (class$org$firebirdsql$jca$IdleRemover = IdleRemover.class$("org.firebirdsql.jca.IdleRemover")), false);
    private final Collection pools = new ArrayList();
    private long interval = Long.MAX_VALUE;
    private long next = Long.MAX_VALUE;
    private static final IdleRemover remover = new IdleRemover();
    private final Thread removerThread = new Thread(new Runnable(){

        public void run() {
            Collection collection = IdleRemover.this.pools;
            synchronized (collection) {
                try {
                    while (true) {
                        IdleRemover.this.pools.wait(IdleRemover.this.interval);
                        if (log != null) {
                            log.debug("run: IdleRemover notifying pools, interval: " + IdleRemover.this.interval);
                        }
                        Iterator i = IdleRemover.this.pools.iterator();
                        while (i.hasNext()) {
                            ((ManagedConnectionPool)i.next()).removeTimedOut();
                        }
                        IdleRemover.this.next = System.currentTimeMillis() + IdleRemover.this.interval;
                        if (IdleRemover.this.next >= 0L) continue;
                        IdleRemover.this.next = Long.MAX_VALUE;
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (log != null) {
                        log.info("run: IdleRemover has been interrupted, returning");
                    }
                    Object var2_3 = null;
                    return;
                }
            }
        }
    });
    static /* synthetic */ Class class$org$firebirdsql$jca$IdleRemover;

    private IdleRemover() {
        this.removerThread.setDaemon(true);
        this.removerThread.start();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void internalRegisterPool(ManagedConnectionPool mcp, long interval) {
        if (log != null) {
            log.debug("internalRegisterPool: registering pool with interval " + interval + " old interval: " + this.interval);
        }
        Collection collection = this.pools;
        synchronized (collection) {
            this.pools.add(mcp);
            if (interval > 1L && interval / 2L < this.interval) {
                this.interval = interval / 2L;
                long maybeNext = System.currentTimeMillis() + this.interval;
                if (this.next > maybeNext && maybeNext > 0L) {
                    if (log != null) {
                        log.debug("internalRegisterPool: about to notify thread: old next: " + this.next + ", new next: " + maybeNext);
                    }
                    this.next = maybeNext;
                    this.pools.notify();
                }
            }
        }
    }

    private void internalUnregisterPool(ManagedConnectionPool mcp) {
        Collection collection = this.pools;
        synchronized (collection) {
            this.pools.remove(mcp);
            if (this.pools.size() == 0) {
                if (log != null) {
                    log.debug("internalUnregisterPool: setting interval to Long.MAX_VALUE");
                }
                this.interval = Long.MAX_VALUE;
            }
        }
    }

    public static void registerPool(ManagedConnectionPool mcp, long interval) {
        remover.internalRegisterPool(mcp, interval);
    }

    private void stop() {
        if (log != null) {
            log.debug("stop: stopping IdleRemover");
        }
        this.interval = -1L;
        this.removerThread.interrupt();
    }

    public static void unregisterPool(ManagedConnectionPool mcp) {
        remover.internalUnregisterPool(mcp);
    }
}

