/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.sql.DataSource;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jdbc.FBSQLException;

public class FBDataSource
implements DataSource,
Serializable,
Referenceable {
    private ConnectionManager cm;
    private FBManagedConnectionFactory mcf;
    private transient PrintWriter log;
    private Reference jndiReference;
    private int loginTimeout = 0;

    public FBDataSource(FBManagedConnectionFactory mcf, ConnectionManager cm) {
        this.mcf = mcf;
        this.cm = cm;
    }

    public Connection getConnection() throws SQLException {
        try {
            return (Connection)this.cm.allocateConnection(this.mcf, this.mcf.getDefaultConnectionRequestInfo());
        }
        catch (ResourceException re) {
            throw new SQLException("Problem getting connection: " + re);
        }
    }

    public Connection getConnection(String username, String password) throws SQLException {
        try {
            FBConnectionRequestInfo subjectCri = this.mcf.getDefaultConnectionRequestInfo();
            subjectCri.setUser(username);
            subjectCri.setPassword(password);
            return (Connection)this.cm.allocateConnection(this.mcf, subjectCri);
        }
        catch (ResourceException re) {
            throw new FBSQLException(re);
        }
    }

    public PrintWriter getLogWriter() {
        return this.log;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public Reference getReference() {
        return this.jndiReference;
    }

    public void setLogWriter(PrintWriter out) {
        this.log = out;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    public void setReference(Reference ref) {
        this.jndiReference = ref;
    }
}

