/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBPreparedStatement;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class FBDatabaseMetaData
implements DatabaseMetaData {
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$jdbc$FBDatabaseMetaData != null ? class$org$firebirdsql$jdbc$FBDatabaseMetaData : (class$org$firebirdsql$jdbc$FBDatabaseMetaData = FBDatabaseMetaData.class$("org.firebirdsql.jdbc.FBDatabaseMetaData")), false);
    private static final String SPACES = "                               ";
    private FBConnection c;
    HashMap statements = new HashMap();
    private static final String fbSQLKeywords = "ACTIVE,ADMIN,AFTER,ASCENDING,AUTO,BASE_NAME,BEFORE,BIGINT,BLOB,BREAK,CACHE,CHECK_POINT_LENGTH,COMPUTED,CONDITIONAL,CONNECTION_ID,CONTAINING,CSTRING,CURRENT_ROLE,DATABASE,DEBUG,DESCENDING,DO,ENTRY_POINT,EXIT,FILE,FILTER,FREE_IT,FUNCTION,GDSCODE,GENERATOR,GEN_ID,GROUP_COMMIT_WAIT_TIME,IF,INACTIVE,INDEX,INPUT_TYPE,LOGFILE,LOG_BUFFER_SIZE,LONG,MANUAL,MAXIMUM_SEGMENT,MERGE,MESSAGE,MODULE_NAME,NULLS,LOCK,NUM_LOG_BUFFERS,OUTPUT_TYPE,OVERFLOW,PAGE,PAGES,PAGE_SIZE,PARAMETER,PASSWORD,PLAN,POST_EVENT,PROTECTED,RAW_PARTITIONS,RDB$DB_KEY,RECORD_VERSION,RECREATE,RESERV,RESERVING,RETAIN,RETURNING_VALUES,RETURNS,ROLE,ROWS_AFFECTED,SAVEPOINT,SEGMENT,SHADOW,SHARED,SINGULAR,SKIP,SNAPSHOT,SORT,STABILITY,STARTING,STARTS,STATISTICS,SUB_TYPE,SUSPEND,TRANSACTION_ID,TRIGGER,VARIABLE,WAIT,WEEKDAY,WHILE,YEARDAY";
    private static final String GET_PROCEDURES_START = "select  RDB$PROCEDURE_NAME as PROCEDURE_NAME, RDB$DESCRIPTION as REMARKS, RDB$PROCEDURE_OUTPUTS as PROCEDURE_TYPE from RDB$PROCEDURES where ";
    private static final String GET_PROCEDURES_END = "1 = 1 order by 1";
    private static final String GET_PROCEDURE_COLUMNS_START = "select PP.RDB$PROCEDURE_NAME as PROCEDURE_NAME, PP.RDB$PARAMETER_NAME as COLUMN_NAME, PP.RDB$PARAMETER_TYPE as COLUMN_TYPE, F.RDB$FIELD_TYPE as FIELD_TYPE, F.RDB$FIELD_SUB_TYPE as FIELD_SUB_TYPE, F.RDB$FIELD_PRECISION as FIELD_PRECISION, F.RDB$FIELD_SCALE as FIELD_SCALE, F.RDB$FIELD_LENGTH as FIELD_LENGTH, F.RDB$NULL_FLAG as NULL_FLAG, PP.RDB$DESCRIPTION as REMARKS from RDB$PROCEDURE_PARAMETERS PP, RDB$FIELDS F where ";
    private static final String GET_PROCEDURE_COLUMNS_END = " PP.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME order by PP.RDB$PROCEDURE_NAME, PP.RDB$PARAMETER_TYPE desc, PP.RDB$PARAMETER_NUMBER ";
    public static final String TABLE = "TABLE";
    public static final String SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String VIEW = "VIEW";
    public static final String[] ALL_TYPES = new String[]{"TABLE", "SYSTEM TABLE", "VIEW"};
    private static final String GET_TABLES_ALL = "select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('SYSTEM TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$SYSTEM_FLAG = 1 and RDB$VIEW_SOURCE is null union select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$SYSTEM_FLAG = 0 and RDB$VIEW_SOURCE is null union select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('VIEW' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$VIEW_SOURCE is not null  order by 3 ";
    private static final String GET_TABLES_EXACT = "select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('SYSTEM TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$SYSTEM_FLAG = 1 and RDB$VIEW_SOURCE is null and ? = RDB$RELATION_NAME union select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$SYSTEM_FLAG = 0 and RDB$VIEW_SOURCE is null and ? = RDB$RELATION_NAME union select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('VIEW' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$VIEW_SOURCE is not null and ? = RDB$RELATION_NAME";
    private static final String GET_TABLES_LIKE = "select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('SYSTEM TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$SYSTEM_FLAG = 1 and RDB$VIEW_SOURCE is null and RDB$RELATION_NAME || '                               ' like ? escape '\\' union select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$SYSTEM_FLAG = 0 and RDB$VIEW_SOURCE is null and RDB$RELATION_NAME || '                               ' like ? escape '\\' union select null as TABLE_CAT, null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, cast('VIEW' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where ? = 'T' and RDB$VIEW_SOURCE is not null and RDB$RELATION_NAME || '                               ' like ? escape '\\'  order by 3 ";
    private static final String GET_COLUMNS_START = "select  RF.RDB$RELATION_NAME as RELATION_NAME, RF.RDB$FIELD_NAME as FIELD_NAME, F.RDB$FIELD_TYPE as FIELD_TYPE, F.RDB$FIELD_SUB_TYPE as FIELD_SUB_TYPE, F.RDB$FIELD_PRECISION as FIELD_PRECISION, F.RDB$FIELD_SCALE as FIELD_SCALE, F.RDB$FIELD_LENGTH as FIELD_LENGTH, RF.RDB$DESCRIPTION, RF.RDB$DEFAULT_SOURCE, RF.RDB$FIELD_POSITION as FIELD_POSITION,  RF.RDB$NULL_FLAG as NULL_FLAG from RDB$RELATION_FIELDS RF, RDB$FIELDS F where ";
    public static final String GET_COLUMNS_END = " RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME order by 1, 10";
    private static final short smallint_type = 7;
    private static final short integer_type = 8;
    private static final short quad_type = 9;
    private static final short float_type = 10;
    private static final short d_float_type = 11;
    private static final short date_type = 12;
    private static final short time_type = 13;
    private static final short char_type = 14;
    private static final short int64_type = 16;
    private static final short double_type = 27;
    private static final short timestamp_type = 35;
    private static final short varchar_type = 37;
    private static final short cstring_type = 40;
    private static final short blob_type = 261;
    private static final String GET_COLUMN_PRIVILEGES_START = "select null as TABLE_CAT,null as TABLE_SCHEM,RF.RDB$RELATION_NAME as TABLE_NAME, RF.RDB$FIELD_NAME as COLUMN_NAME, UP.RDB$GRANTOR as GRANTOR, UP.RDB$USER as GRANTEE, UP.RDB$PRIVILEGE as PRIVILEGE, UP.RDB$GRANT_OPTION as IS_GRANTABLE from RDB$RELATION_FIELDS RF, RDB$FIELDS F, RDB$USER_PRIVILEGES UP where RF.RDB$RELATION_NAME = UP.RDB$RELATION_NAME and RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME  and (UP.RDB$FIELD_NAME is null or UP.RDB$FIELD_NAME = RF.RDB$FIELD_NAME) and UP.RDB$RELATION_NAME = ? and ((";
    private static final String GET_COLUMN_PRIVILEGES_END = " UP.RDB$OBJECT_TYPE = 0) or (RF.RDB$FIELD_NAME is null and UP.RDB$OBJECT_TYPE = 0)) order by 4,7 ";
    private static final String GET_TABLE_PRIVILEGES_START = "select null as TABLE_CAT,  null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, RDB$GRANTOR as GRANTOR,  RDB$USER as GRANTEE,  RDB$PRIVILEGE as PRIVILEGE,  RDB$GRANT_OPTION as IS_GRANTABLE from RDB$USER_PRIVILEGES where ";
    private static final String GET_TABLE_PRIVILEGES_END = " RDB$OBJECT_TYPE = 0 and RDB$FIELD_NAME is null order by 3, 6";
    private static final String GET_PRIMARY_KEYS_START = "select  null as TABLE_CAT,  null as TABLE_SCHEM, RC.RDB$RELATION_NAME as TABLE_NAME, ISGMT.RDB$FIELD_NAME as COLUMN_NAME, CAST ((ISGMT.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ, RC.RDB$CONSTRAINT_NAME as PK_NAME from RDB$RELATION_CONSTRAINTS RC, RDB$INDEX_SEGMENTS ISGMT where ";
    private static final String GET_PRIMARY_KEYS_END = "RC.RDB$INDEX_NAME = ISGMT.RDB$INDEX_NAME and RC.RDB$CONSTRAINT_TYPE = 'PRIMARY KEY' order by ISGMT.RDB$FIELD_NAME ";
    private static final String GET_IMPORTED_KEYS_START = "select null as PKTABLE_CAT  ,null as PKTABLE_SCHEM  ,PK.RDB$RELATION_NAME as PKTABLE_NAME  ,ISP.RDB$FIELD_NAME as PKCOLUMN_NAME  ,null as FKTABLE_CAT  ,null as FKTABLE_SCHEM  ,FK.RDB$RELATION_NAME as FKTABLE_NAME  ,ISF.RDB$FIELD_NAME as FKCOLUMN_NAME  ,CAST ((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ  ,RC.RDB$UPDATE_RULE as UPDATE_RULE  ,RC.RDB$DELETE_RULE as DELETE_RULE  ,PK.RDB$CONSTRAINT_NAME as PK_NAME  ,FK.RDB$CONSTRAINT_NAME as FK_NAME  ,null as DEFERRABILITY  from  RDB$RELATION_CONSTRAINTS PK  ,RDB$RELATION_CONSTRAINTS FK  ,RDB$REF_CONSTRAINTS RC  ,RDB$INDEX_SEGMENTS ISP  ,RDB$INDEX_SEGMENTS ISF  WHERE ";
    private static final String GET_IMPORTED_KEYS_END = " FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME  and PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ  and ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME  and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME  and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION  order by 3, 9 ";
    private static final String GET_EXPORTED_KEYS_START = "select null as PKTABLE_CAT  ,null as PKTABLE_SCHEM  ,PK.RDB$RELATION_NAME as PKTABLE_NAME  ,ISP.RDB$FIELD_NAME as PKCOLUMN_NAME  ,null as FKTABLE_CAT  ,null as FKTABLE_SCHEM  ,FK.RDB$RELATION_NAME as FKTABLE_NAME  ,ISF.RDB$FIELD_NAME as FKCOLUMN_NAME  ,CAST ((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ  ,RC.RDB$UPDATE_RULE as UPDATE_RULE  ,RC.RDB$DELETE_RULE as DELETE_RULE  ,PK.RDB$CONSTRAINT_NAME as PK_NAME  ,FK.RDB$CONSTRAINT_NAME as FK_NAME  ,null as DEFERRABILITY  from  RDB$RELATION_CONSTRAINTS PK  ,RDB$RELATION_CONSTRAINTS FK  ,RDB$REF_CONSTRAINTS RC  ,RDB$INDEX_SEGMENTS ISP  ,RDB$INDEX_SEGMENTS ISF  WHERE ";
    private static final String GET_EXPORTED_KEYS_END = " FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME  and PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ  and ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME  and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME  and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION  order by 7, 9 ";
    private static final String GET_CROSS_KEYS_START = "select null as PKTABLE_CAT  ,null as PKTABLE_SCHEM  ,PK.RDB$RELATION_NAME as PKTABLE_NAME  ,ISP.RDB$FIELD_NAME as PKCOLUMN_NAME  ,null as FKTABLE_CAT  ,null as FKTABLE_SCHEM  ,FK.RDB$RELATION_NAME as FKTABLE_NAME  ,ISF.RDB$FIELD_NAME as FKCOLUMN_NAME  ,CAST ((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ  ,RC.RDB$UPDATE_RULE as UPDATE_RULE  ,RC.RDB$DELETE_RULE as DELETE_RULE  ,PK.RDB$CONSTRAINT_NAME as PK_NAME  ,FK.RDB$CONSTRAINT_NAME as FK_NAME  ,null as DEFERRABILITY  from  RDB$RELATION_CONSTRAINTS PK  ,RDB$RELATION_CONSTRAINTS FK  ,RDB$REF_CONSTRAINTS RC  ,RDB$INDEX_SEGMENTS ISP  ,RDB$INDEX_SEGMENTS ISF  WHERE ";
    private static final String GET_CROSS_KEYS_END = " FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME  and PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ  and ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME  and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME  and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION  order by 7, 9 ";
    private static final String GET_INDEX_INFO = "select null as TABLE_CAT  ,null as TABLE_SCHEM  ,ind.RDB$RELATION_NAME AS TABLE_NAME  ,ind.RDB$UNIQUE_FLAG AS NON_UNIQUE  ,null as INDEX_QUALIFIER  ,ind.RDB$INDEX_NAME as INDEX_NAME  ,null as ITYPE  ,ise.rdb$field_position+1 as ORDINAL_POSITION  ,ise.rdb$field_name as COLUMN_NAME  ,ind.RDB$INDEX_TYPE as ASC_OR_DESC  ,0 as CARDINALITY  ,0 as IPAGES  ,null as FILTER_CONDITION  from rdb$indices ind, rdb$index_segments ise  where ind.rdb$index_name = ise.rdb$index_name  and ind.rdb$relation_name = ?  order by 4, 6, 8";
    static /* synthetic */ Class class$org$firebirdsql$jdbc$FBDatabaseMetaData;

    FBDatabaseMetaData(FBConnection c) {
        this.c = c;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    private void checkCatalogAndSchema(String catalog, String schema) throws SQLException {
        if (catalog != null && !catalog.equals("") && !catalog.equals("%")) {
            throw new SQLException("Catalogs not supported");
        }
        if (schema != null && !schema.equals("") && !schema.equals("%")) {
            throw new SQLException("Schemas not supported");
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    void close() {
        block3: {
            try {
                Iterator i = this.statements.values().iterator();
                while (i.hasNext()) {
                    FBPreparedStatement stmt = (FBPreparedStatement)i.next();
                    if (stmt.isClosed()) continue;
                    stmt.close();
                }
                this.statements.clear();
            }
            catch (SQLException e) {
                if (log == null) break block3;
                log.warn("error in DatabaseMetaData.close", e);
            }
        }
    }

    private byte[] createShort(int value) throws SQLException {
        if (value > Short.MAX_VALUE) {
            throw new SQLException("Cannot convert integer to short.");
        }
        return XSQLVAR.encodeShort((short)value);
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public ResultSet getAttributes(String param1, String param2, String param3, String param4) throws SQLException {
        throw new SQLException("not yet supported");
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[8];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 500;
        xsqlvars[0].sqlname = "SCOPE";
        xsqlvars[0].relname = "ROWIDENTIFIER";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "COLUMN_NAME";
        xsqlvars[1].relname = "ROWIDENTIFIER";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 500;
        xsqlvars[2].sqlname = "DATA_TYPE";
        xsqlvars[2].relname = "ROWIDENTIFIER";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "TYPE_NAME";
        xsqlvars[3].relname = "ROWIDENTIFIER";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 496;
        xsqlvars[4].sqlname = "COLUMN_SIZE";
        xsqlvars[4].relname = "ROWIDENTIFIER";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 496;
        xsqlvars[5].sqlname = "BUFFER_LENGTH";
        xsqlvars[5].relname = "ROWIDENTIFIER";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 500;
        xsqlvars[6].sqlname = "DECIMAL_DIGITS";
        xsqlvars[6].relname = "ROWIDENTIFIER";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 500;
        xsqlvars[7].sqlname = "PSEUDO_COLUMN";
        xsqlvars[7].relname = "ROWIDENTIFIER";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    private byte[] getBytes(String value) {
        if (value != null) {
            return value.getBytes();
        }
        return null;
    }

    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    public String getCatalogTerm() throws SQLException {
        return "";
    }

    public ResultSet getCatalogs() throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[]{new XSQLVAR()};
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "TABLECATALOGS";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        this.checkCatalogAndSchema(catalog, schema);
        Clause columnClause = new Clause("RF.RDB$FIELD_NAME", columnNamePattern);
        String sql = GET_COLUMN_PRIVILEGES_START;
        sql = String.valueOf(sql) + columnClause.getCondition();
        sql = String.valueOf(sql) + GET_COLUMN_PRIVILEGES_END;
        ArrayList<String> params = new ArrayList<String>();
        params.add(table);
        if (!columnClause.getCondition().equals("")) {
            params.add(columnClause.getValue());
        }
        return this.c.doQuery(sql, params, this.statements);
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this.checkCatalogAndSchema(catalog, schemaPattern);
        Clause tableClause = new Clause("RF.RDB$RELATION_NAME", tableNamePattern);
        Clause columnClause = new Clause("RF.RDB$FIELD_NAME", columnNamePattern);
        String sql = GET_COLUMNS_START;
        sql = String.valueOf(sql) + tableClause.getCondition();
        sql = String.valueOf(sql) + columnClause.getCondition();
        sql = String.valueOf(sql) + GET_COLUMNS_END;
        ArrayList<String> params = new ArrayList<String>();
        if (!tableClause.getCondition().equals("")) {
            params.add(tableClause.getValue());
        }
        if (!columnClause.getCondition().equals("")) {
            params.add(columnClause.getValue());
        }
        ResultSet rs = this.c.doQuery(sql, params, this.statements);
        XSQLVAR[] xsqlvars = new XSQLVAR[18];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TABLE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TABLE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "COLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 500;
        xsqlvars[4].sqlname = "DATA_TYPE";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 449;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "TYPE_NAME";
        xsqlvars[5].relname = "COLUMNINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 496;
        xsqlvars[6].sqlname = "COLUMN_SIZE";
        xsqlvars[6].relname = "COLUMNINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 500;
        xsqlvars[7].sqlname = "BUFFER_LENGTH";
        xsqlvars[7].relname = "COLUMNINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 496;
        xsqlvars[8].sqlname = "DECIMAL_DIGITS";
        xsqlvars[8].relname = "COLUMNINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 496;
        xsqlvars[9].sqlname = "NUM_PREC_RADIX";
        xsqlvars[9].relname = "COLUMNINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 496;
        xsqlvars[10].sqlname = "NULLABLE";
        xsqlvars[10].relname = "COLUMNINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 449;
        xsqlvars[11].sqllen = 31;
        xsqlvars[11].sqlname = "REMARKS";
        xsqlvars[11].relname = "COLUMNINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 449;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "COLUMN_DEF";
        xsqlvars[12].relname = "COLUMNINFO";
        xsqlvars[13] = new XSQLVAR();
        xsqlvars[13].sqltype = 496;
        xsqlvars[13].sqlname = "SQL_DATA_TYPE";
        xsqlvars[13].relname = "COLUMNINFO";
        xsqlvars[14] = new XSQLVAR();
        xsqlvars[14].sqltype = 496;
        xsqlvars[14].sqlname = "SQL_DATETIME_SUB";
        xsqlvars[14].relname = "COLUMNINFO";
        xsqlvars[15] = new XSQLVAR();
        xsqlvars[15].sqltype = 496;
        xsqlvars[15].sqlname = "CHAR_OCTET_LENGTH";
        xsqlvars[15].relname = "COLUMNINFO";
        xsqlvars[16] = new XSQLVAR();
        xsqlvars[16].sqltype = 496;
        xsqlvars[16].sqlname = "ORDINAL_POSITION";
        xsqlvars[16].relname = "COLUMNINFO";
        xsqlvars[17] = new XSQLVAR();
        xsqlvars[17].sqltype = 448;
        xsqlvars[17].sqllen = 3;
        xsqlvars[17].sqlname = "IS_NULLABLE";
        xsqlvars[17].relname = "COLUMNINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            byte[][] row = new byte[18][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("RELATION_NAME").trim());
            row[3] = this.getBytes(rs.getString("FIELD_NAME").trim());
            short fieldType = rs.getShort("FIELD_TYPE");
            short fieldSubType = rs.getShort("FIELD_SUB_TYPE");
            short fieldScale = rs.getShort("FIELD_SCALE");
            int dataType = this.getDataType(fieldType, fieldSubType, fieldScale);
            row[4] = XSQLVAR.encodeShort((short)dataType);
            row[5] = this.getBytes(this.getDataTypeName(fieldType, fieldSubType, fieldScale));
            switch (dataType) {
                case 2: 
                case 3: {
                    row[6] = XSQLVAR.encodeInt(rs.getShort("FIELD_PRECISION"));
                    break;
                }
                case 1: 
                case 12: {
                    row[6] = XSQLVAR.encodeInt(rs.getShort("FIELD_LENGTH"));
                    break;
                }
                case 6: {
                    row[6] = XSQLVAR.encodeInt(7);
                    break;
                }
                case 8: {
                    row[6] = XSQLVAR.encodeInt(15);
                    break;
                }
                case 4: {
                    row[6] = XSQLVAR.encodeInt(10);
                    break;
                }
                case 5: {
                    row[6] = XSQLVAR.encodeInt(5);
                    break;
                }
                case 91: {
                    row[6] = XSQLVAR.encodeInt(10);
                    break;
                }
                case 92: {
                    row[6] = XSQLVAR.encodeInt(8);
                    break;
                }
                case 93: {
                    row[6] = XSQLVAR.encodeInt(19);
                    break;
                }
                default: {
                    row[6] = XSQLVAR.encodeInt(0);
                }
            }
            row[7] = XSQLVAR.encodeShort((short)0);
            row[8] = XSQLVAR.encodeInt(fieldScale * -1);
            row[9] = XSQLVAR.encodeInt(10);
            short nullFlag = rs.getShort("NULL_FLAG");
            row[10] = nullFlag == 1 ? XSQLVAR.encodeInt(0) : XSQLVAR.encodeInt(1);
            row[11] = null;
            row[12] = null;
            row[13] = null;
            row[14] = null;
            row[15] = XSQLVAR.encodeInt(0);
            row[16] = XSQLVAR.encodeInt(rs.getShort("FIELD_POSITION") + 1);
            row[17] = nullFlag == 1 ? this.getBytes("NO") : this.getBytes("YES");
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    public Connection getConnection() throws SQLException {
        return this.c;
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        this.checkCatalogAndSchema(primaryCatalog, primarySchema);
        this.checkCatalogAndSchema(foreignCatalog, foreignSchema);
        Clause primaryTableClause = new Clause("PK.RDB$RELATION_NAME", primaryTable);
        Clause foreignTableClause = new Clause("FK.RDB$RELATION_NAME", foreignTable);
        String sql = "select null as PKTABLE_CAT  ,null as PKTABLE_SCHEM  ,PK.RDB$RELATION_NAME as PKTABLE_NAME  ,ISP.RDB$FIELD_NAME as PKCOLUMN_NAME  ,null as FKTABLE_CAT  ,null as FKTABLE_SCHEM  ,FK.RDB$RELATION_NAME as FKTABLE_NAME  ,ISF.RDB$FIELD_NAME as FKCOLUMN_NAME  ,CAST ((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ  ,RC.RDB$UPDATE_RULE as UPDATE_RULE  ,RC.RDB$DELETE_RULE as DELETE_RULE  ,PK.RDB$CONSTRAINT_NAME as PK_NAME  ,FK.RDB$CONSTRAINT_NAME as FK_NAME  ,null as DEFERRABILITY  from  RDB$RELATION_CONSTRAINTS PK  ,RDB$RELATION_CONSTRAINTS FK  ,RDB$REF_CONSTRAINTS RC  ,RDB$INDEX_SEGMENTS ISP  ,RDB$INDEX_SEGMENTS ISF  WHERE ";
        sql = String.valueOf(sql) + primaryTableClause.getCondition();
        sql = String.valueOf(sql) + foreignTableClause.getCondition();
        sql = String.valueOf(sql) + " FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME  and PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ  and ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME  and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME  and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION  order by 7, 9 ";
        ArrayList<String> params = new ArrayList<String>();
        if (!primaryTableClause.getCondition().equals("")) {
            params.add(primaryTableClause.getValue());
        }
        if (!foreignTableClause.getCondition().equals("")) {
            params.add(foreignTableClause.getValue());
        }
        ResultSet rs = this.c.doQuery(sql, params, this.statements);
        XSQLVAR[] xsqlvars = new XSQLVAR[14];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "PKTABLE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "PKTABLE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "PKTABLE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "PKCOLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "FKTABLE_CAT";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "FKTABLE_SCHEM";
        xsqlvars[5].relname = "COLUMNINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 31;
        xsqlvars[6].sqlname = "FKTABLE_NAME";
        xsqlvars[6].relname = "COLUMNINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 448;
        xsqlvars[7].sqllen = 31;
        xsqlvars[7].sqlname = "FKCOLUMN_NAME";
        xsqlvars[7].relname = "COLUMNINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 500;
        xsqlvars[8].sqlname = "KEY_SEQ";
        xsqlvars[8].relname = "COLUMNINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 500;
        xsqlvars[9].sqlname = "UPDATE_RULE";
        xsqlvars[9].relname = "COLUMNINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 500;
        xsqlvars[10].sqlname = "DELETE_RULE";
        xsqlvars[10].relname = "COLUMNINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 448;
        xsqlvars[11].sqllen = 31;
        xsqlvars[11].sqlname = "FK_NAME";
        xsqlvars[11].relname = "COLUMNINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "PK_NAME";
        xsqlvars[12].relname = "COLUMNINFO";
        xsqlvars[13] = new XSQLVAR();
        xsqlvars[13].sqltype = 500;
        xsqlvars[13].sqlname = "DEFERRABILITY";
        xsqlvars[13].relname = "COLUMNINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            byte[][] row = new byte[14][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("PKTABLE_NAME").trim());
            row[3] = this.getBytes(rs.getString("PKCOLUMN_NAME").trim());
            row[4] = null;
            row[5] = null;
            row[6] = this.getBytes(rs.getString("PKTABLE_NAME").trim());
            row[7] = this.getBytes(rs.getString("PKCOLUMN_NAME").trim());
            row[8] = XSQLVAR.encodeShort(rs.getShort("KEY_SEQ"));
            String updateRule = rs.getString("UPDATE_RULE");
            if (updateRule.equals("NO ACTION") || updateRule.equals("RESTRICT")) {
                row[9] = XSQLVAR.encodeShort((short)3);
            } else if (updateRule.equals("CASCADE")) {
                row[9] = XSQLVAR.encodeShort((short)0);
            } else if (updateRule.equals("SET NULL")) {
                row[9] = XSQLVAR.encodeShort((short)2);
            } else if (updateRule.equals("SET DEFAULT")) {
                row[9] = XSQLVAR.encodeShort((short)4);
            }
            String deleteRule = rs.getString("DELETE_RULE");
            if (deleteRule.equals("NO ACTION") || deleteRule.equals("RESTRICT")) {
                row[10] = XSQLVAR.encodeShort((short)3);
            } else if (deleteRule.equals("CASCADE")) {
                row[10] = XSQLVAR.encodeShort((short)0);
            } else if (deleteRule.equals("SET NULL")) {
                row[10] = XSQLVAR.encodeShort((short)2);
            } else if (deleteRule.equals("SET DEFAULT")) {
                row[10] = XSQLVAR.encodeShort((short)4);
            }
            row[11] = this.getBytes(rs.getString("FK_NAME"));
            row[12] = this.getBytes(rs.getString("PK_NAME"));
            row[13] = XSQLVAR.encodeShort((short)7);
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    private int getDataType(short fieldType, short fieldSubType, short fieldScale) {
        if (fieldScale < 0) {
            switch (fieldType) {
                case 7: 
                case 8: 
                case 16: 
                case 27: {
                    if (fieldSubType == 2) {
                        return 3;
                    }
                    return 2;
                }
            }
        }
        switch (fieldType) {
            case 7: {
                return 5;
            }
            case 8: {
                return 4;
            }
            case 11: 
            case 27: {
                return 8;
            }
            case 10: {
                return 6;
            }
            case 14: {
                return 1;
            }
            case 37: {
                return 12;
            }
            case 35: {
                return 93;
            }
            case 13: {
                return 92;
            }
            case 12: {
                return 91;
            }
            case 16: {
                if (fieldSubType == 2) {
                    return 3;
                }
                return 2;
            }
            case 261: {
                if (fieldSubType < 0) {
                    return 2004;
                }
                if (fieldSubType == 0) {
                    return -4;
                }
                if (fieldSubType == 1) {
                    return -1;
                }
                return 1111;
            }
            case 9: {
                return 1111;
            }
        }
        return 0;
    }

    private String getDataTypeName(short fieldType, short fieldSubType, short fieldScale) {
        if (fieldScale < 0) {
            switch (fieldType) {
                case 7: 
                case 8: 
                case 16: 
                case 27: {
                    if (fieldSubType == 2) {
                        return "DECIMAL";
                    }
                    return "NUMERIC";
                }
            }
        }
        switch (fieldType) {
            case 7: {
                return "SMALLINT";
            }
            case 8: {
                return "INTEGER";
            }
            case 11: 
            case 27: {
                return "DOUBLE PRECISION";
            }
            case 10: {
                return "FLOAT";
            }
            case 14: {
                return "CHAR";
            }
            case 37: {
                return "VARCHAR";
            }
            case 35: {
                return "TIMESTAMP";
            }
            case 13: {
                return "TIME";
            }
            case 12: {
                return "DATE";
            }
            case 16: {
                if (fieldSubType == 2) {
                    return "DECIMAL";
                }
                return "NUMERIC";
            }
            case 261: {
                if (fieldSubType < 0) {
                    return "BLOB SUB_TYPE <0";
                }
                if (fieldSubType == 0) {
                    return "BLOB SUB_TYPE 0";
                }
                if (fieldSubType == 1) {
                    return "BLOB SUB_TYPE 1";
                }
                return "BLOB SUB_TYPE >1";
            }
            case 9: {
                return "ARRAY";
            }
        }
        return "NULL";
    }

    public int getDatabaseMajorVersion() throws SQLException {
        throw new SQLException("not yet supported");
    }

    public int getDatabaseMinorVersion() throws SQLException {
        throw new SQLException("not yet supported");
    }

    public String getDatabaseProductName() throws SQLException {
        return this.c.getDatabaseProductName();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.c.getDatabaseProductVersion();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 4;
    }

    public int getDriverMajorVersion() {
        return 0;
    }

    public int getDriverMinorVersion() {
        return 1;
    }

    public String getDriverName() throws SQLException {
        return "firebirdsql jca/jdbc resource adapter";
    }

    public String getDriverVersion() throws SQLException {
        return "0.1";
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        this.checkCatalogAndSchema(catalog, schema);
        Clause tableClause = new Clause("PK.RDB$RELATION_NAME", table);
        String sql = "select null as PKTABLE_CAT  ,null as PKTABLE_SCHEM  ,PK.RDB$RELATION_NAME as PKTABLE_NAME  ,ISP.RDB$FIELD_NAME as PKCOLUMN_NAME  ,null as FKTABLE_CAT  ,null as FKTABLE_SCHEM  ,FK.RDB$RELATION_NAME as FKTABLE_NAME  ,ISF.RDB$FIELD_NAME as FKCOLUMN_NAME  ,CAST ((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ  ,RC.RDB$UPDATE_RULE as UPDATE_RULE  ,RC.RDB$DELETE_RULE as DELETE_RULE  ,PK.RDB$CONSTRAINT_NAME as PK_NAME  ,FK.RDB$CONSTRAINT_NAME as FK_NAME  ,null as DEFERRABILITY  from  RDB$RELATION_CONSTRAINTS PK  ,RDB$RELATION_CONSTRAINTS FK  ,RDB$REF_CONSTRAINTS RC  ,RDB$INDEX_SEGMENTS ISP  ,RDB$INDEX_SEGMENTS ISF  WHERE ";
        sql = String.valueOf(sql) + tableClause.getCondition();
        sql = String.valueOf(sql) + " FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME  and PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ  and ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME  and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME  and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION  order by 7, 9 ";
        ArrayList<String> params = new ArrayList<String>();
        if (!tableClause.getCondition().equals("")) {
            params.add(tableClause.getValue());
        }
        ResultSet rs = this.c.doQuery(sql, params, this.statements);
        XSQLVAR[] xsqlvars = new XSQLVAR[14];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "PKTABLE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "PKTABLE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "PKTABLE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "PKCOLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "FKTABLE_CAT";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "FKTABLE_SCHEM";
        xsqlvars[5].relname = "COLUMNINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 31;
        xsqlvars[6].sqlname = "FKTABLE_NAME";
        xsqlvars[6].relname = "COLUMNINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 448;
        xsqlvars[7].sqllen = 31;
        xsqlvars[7].sqlname = "FKCOLUMN_NAME";
        xsqlvars[7].relname = "COLUMNINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 500;
        xsqlvars[8].sqlname = "KEY_SEQ";
        xsqlvars[8].relname = "COLUMNINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 500;
        xsqlvars[9].sqlname = "UPDATE_RULE";
        xsqlvars[9].relname = "COLUMNINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 500;
        xsqlvars[10].sqlname = "DELETE_RULE";
        xsqlvars[10].relname = "COLUMNINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 448;
        xsqlvars[11].sqllen = 31;
        xsqlvars[11].sqlname = "FK_NAME";
        xsqlvars[11].relname = "COLUMNINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "PK_NAME";
        xsqlvars[12].relname = "COLUMNINFO";
        xsqlvars[13] = new XSQLVAR();
        xsqlvars[13].sqltype = 500;
        xsqlvars[13].sqlname = "DEFERRABILITY";
        xsqlvars[13].relname = "COLUMNINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            byte[][] row = new byte[14][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("PKTABLE_NAME").trim());
            row[3] = this.getBytes(rs.getString("PKCOLUMN_NAME").trim());
            row[4] = null;
            row[5] = null;
            row[6] = this.getBytes(rs.getString("FKTABLE_NAME").trim());
            row[7] = this.getBytes(rs.getString("FKCOLUMN_NAME").trim());
            row[8] = XSQLVAR.encodeShort(rs.getShort("KEY_SEQ"));
            String updateRule = rs.getString("UPDATE_RULE");
            if (updateRule.equals("NO ACTION") || updateRule.equals("RESTRICT")) {
                row[9] = XSQLVAR.encodeShort((short)3);
            } else if (updateRule.equals("CASCADE")) {
                row[9] = XSQLVAR.encodeShort((short)0);
            } else if (updateRule.equals("SET NULL")) {
                row[9] = XSQLVAR.encodeShort((short)2);
            } else if (updateRule.equals("SET DEFAULT")) {
                row[9] = XSQLVAR.encodeShort((short)4);
            }
            String deleteRule = rs.getString("DELETE_RULE");
            if (deleteRule.equals("NO ACTION") || deleteRule.equals("RESTRICT")) {
                row[10] = XSQLVAR.encodeShort((short)3);
            } else if (deleteRule.equals("CASCADE")) {
                row[10] = XSQLVAR.encodeShort((short)0);
            } else if (deleteRule.equals("SET NULL")) {
                row[10] = XSQLVAR.encodeShort((short)2);
            } else if (deleteRule.equals("SET DEFAULT")) {
                row[10] = XSQLVAR.encodeShort((short)4);
            }
            row[11] = this.getBytes(rs.getString("FK_NAME"));
            row[12] = this.getBytes(rs.getString("PK_NAME"));
            row[13] = XSQLVAR.encodeShort((short)7);
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    public String getExtraNameCharacters() throws SQLException {
        return "$";
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        this.checkCatalogAndSchema(catalog, schema);
        Clause tableClause = new Clause("FK.RDB$RELATION_NAME", table);
        String sql = "select null as PKTABLE_CAT  ,null as PKTABLE_SCHEM  ,PK.RDB$RELATION_NAME as PKTABLE_NAME  ,ISP.RDB$FIELD_NAME as PKCOLUMN_NAME  ,null as FKTABLE_CAT  ,null as FKTABLE_SCHEM  ,FK.RDB$RELATION_NAME as FKTABLE_NAME  ,ISF.RDB$FIELD_NAME as FKCOLUMN_NAME  ,CAST ((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ  ,RC.RDB$UPDATE_RULE as UPDATE_RULE  ,RC.RDB$DELETE_RULE as DELETE_RULE  ,PK.RDB$CONSTRAINT_NAME as PK_NAME  ,FK.RDB$CONSTRAINT_NAME as FK_NAME  ,null as DEFERRABILITY  from  RDB$RELATION_CONSTRAINTS PK  ,RDB$RELATION_CONSTRAINTS FK  ,RDB$REF_CONSTRAINTS RC  ,RDB$INDEX_SEGMENTS ISP  ,RDB$INDEX_SEGMENTS ISF  WHERE ";
        sql = String.valueOf(sql) + tableClause.getCondition();
        sql = String.valueOf(sql) + GET_IMPORTED_KEYS_END;
        ArrayList<String> params = new ArrayList<String>();
        if (!tableClause.getCondition().equals("")) {
            params.add(tableClause.getValue());
        }
        ResultSet rs = this.c.doQuery(sql, params, this.statements);
        XSQLVAR[] xsqlvars = new XSQLVAR[14];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "PKTABLE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "PKTABLE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "PKTABLE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "PKCOLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "FKTABLE_CAT";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "FKTABLE_SCHEM";
        xsqlvars[5].relname = "COLUMNINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 31;
        xsqlvars[6].sqlname = "FKTABLE_NAME";
        xsqlvars[6].relname = "COLUMNINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 448;
        xsqlvars[7].sqllen = 31;
        xsqlvars[7].sqlname = "FKCOLUMN_NAME";
        xsqlvars[7].relname = "COLUMNINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 500;
        xsqlvars[8].sqlname = "KEY_SEQ";
        xsqlvars[8].relname = "COLUMNINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 500;
        xsqlvars[9].sqlname = "UPDATE_RULE";
        xsqlvars[9].relname = "COLUMNINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 500;
        xsqlvars[10].sqlname = "DELETE_RULE";
        xsqlvars[10].relname = "COLUMNINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 448;
        xsqlvars[11].sqllen = 31;
        xsqlvars[11].sqlname = "FK_NAME";
        xsqlvars[11].relname = "COLUMNINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "PK_NAME";
        xsqlvars[12].relname = "COLUMNINFO";
        xsqlvars[13] = new XSQLVAR();
        xsqlvars[13].sqltype = 500;
        xsqlvars[13].sqlname = "DEFERRABILITY";
        xsqlvars[13].relname = "COLUMNINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            byte[][] row = new byte[14][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("PKTABLE_NAME").trim());
            row[3] = this.getBytes(rs.getString("PKCOLUMN_NAME").trim());
            row[4] = null;
            row[5] = null;
            row[6] = this.getBytes(rs.getString("FKTABLE_NAME").trim());
            row[7] = this.getBytes(rs.getString("FKCOLUMN_NAME").trim());
            row[8] = XSQLVAR.encodeShort(rs.getShort("KEY_SEQ"));
            String updateRule = rs.getString("UPDATE_RULE");
            if (updateRule.equals("NO ACTION") || updateRule.equals("RESTRICT")) {
                row[9] = XSQLVAR.encodeShort((short)3);
            } else if (updateRule.equals("CASCADE")) {
                row[9] = XSQLVAR.encodeShort((short)0);
            } else if (updateRule.equals("SET NULL")) {
                row[9] = XSQLVAR.encodeShort((short)2);
            } else if (updateRule.equals("SET DEFAULT")) {
                row[9] = XSQLVAR.encodeShort((short)4);
            }
            String deleteRule = rs.getString("DELETE_RULE");
            if (deleteRule.equals("NO ACTION") || deleteRule.equals("RESTRICT")) {
                row[10] = XSQLVAR.encodeShort((short)3);
            } else if (deleteRule.equals("CASCADE")) {
                row[10] = XSQLVAR.encodeShort((short)0);
            } else if (deleteRule.equals("SET NULL")) {
                row[10] = XSQLVAR.encodeShort((short)2);
            } else if (deleteRule.equals("SET DEFAULT")) {
                row[10] = XSQLVAR.encodeShort((short)4);
            }
            row[11] = this.getBytes(rs.getString("FK_NAME"));
            row[12] = this.getBytes(rs.getString("PK_NAME"));
            row[13] = XSQLVAR.encodeShort((short)7);
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        this.checkCatalogAndSchema(catalog, schema);
        String sql = GET_INDEX_INFO;
        ArrayList<String> params = new ArrayList<String>();
        params.add(table.toUpperCase());
        ResultSet rs = this.c.doQuery(sql, params, this.statements);
        XSQLVAR[] xsqlvars = new XSQLVAR[13];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "INDEXINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TABLE_SCHEM";
        xsqlvars[1].relname = "INDEXINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TABLE_NAME";
        xsqlvars[2].relname = "INDEXINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 452;
        xsqlvars[3].sqllen = 1;
        xsqlvars[3].sqlname = "NON_UNIQUE";
        xsqlvars[3].relname = "INDEXINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "INDEX_QUALIFIER";
        xsqlvars[4].relname = "INDEXINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "INDEX_NAME";
        xsqlvars[5].relname = "INDEXINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 500;
        xsqlvars[6].sqlname = "TYPE";
        xsqlvars[6].relname = "INDEXINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 500;
        xsqlvars[7].sqlname = "ORDINAL_POSITION";
        xsqlvars[7].relname = "INDEXINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 448;
        xsqlvars[8].sqllen = 31;
        xsqlvars[8].sqlname = "COLUMN_NAME";
        xsqlvars[8].relname = "INDEXINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 448;
        xsqlvars[9].sqllen = 31;
        xsqlvars[9].sqlname = "ASC_OR_DESC";
        xsqlvars[9].relname = "INDEXINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 496;
        xsqlvars[10].sqlname = "CARDINALITY";
        xsqlvars[10].relname = "INDEXINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 496;
        xsqlvars[11].sqlname = "PAGES";
        xsqlvars[11].relname = "INDEXINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "FILTER_CONDITION";
        xsqlvars[12].relname = "INDEXINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            byte[][] row = new byte[13][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("TABLE_NAME").trim());
            int nonUnique = rs.getInt("NON_UNIQUE");
            row[3] = nonUnique == 0 ? this.getBytes("T") : this.getBytes("F");
            row[4] = null;
            row[5] = this.getBytes(rs.getString("INDEX_NAME").trim());
            row[6] = XSQLVAR.encodeShort((short)3);
            row[7] = XSQLVAR.encodeShort(rs.getShort("ORDINAL_POSITION"));
            row[8] = this.getBytes(rs.getString("COLUMN_NAME").trim());
            int index_type = rs.getInt("ASC_OR_DESC");
            row[9] = index_type == 1 ? this.getBytes("D") : this.getBytes("A");
            row[10] = XSQLVAR.encodeInt(0);
            row[11] = XSQLVAR.encodeInt(0);
            row[12] = null;
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    public int getJDBCMajorVersion() throws SQLException {
        throw new SQLException("not yet supported");
    }

    public int getJDBCMinorVersion() throws SQLException {
        throw new SQLException("not yet supported");
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 31;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 31;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 31;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 31;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 31;
    }

    public String getNumericFunctions() throws SQLException {
        return "";
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        this.checkCatalogAndSchema(catalog, schema);
        Clause tableClause = new Clause("RC.RDB$RELATION_NAME", table);
        String sql = GET_PRIMARY_KEYS_START;
        sql = String.valueOf(sql) + tableClause.getCondition();
        sql = String.valueOf(sql) + GET_PRIMARY_KEYS_END;
        ArrayList<String> params = new ArrayList<String>();
        if (!tableClause.getCondition().equals("")) {
            params.add(tableClause.getValue());
        }
        ResultSet rs = this.c.doQuery(sql, params, this.statements);
        XSQLVAR[] xsqlvars = new XSQLVAR[6];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TABLE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TABLE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "COLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 500;
        xsqlvars[4].sqlname = "KEY_SEQ";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "PK_NAME";
        xsqlvars[5].relname = "COLUMNINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            byte[][] row = new byte[][]{null, null, this.getBytes(rs.getString("TABLE_NAME").trim()), this.getBytes(rs.getString("COLUMN_NAME").trim()), XSQLVAR.encodeShort(rs.getShort("KEY_SEQ")), this.getBytes(rs.getString("PK_NAME"))};
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        this.checkCatalogAndSchema(catalog, schemaPattern);
        Clause procedureClause = new Clause("PP.RDB$PROCEDURE_NAME", procedureNamePattern);
        Clause columnClause = new Clause("PP.RDB$PARAMETER_NAME", columnNamePattern);
        String sql = GET_PROCEDURE_COLUMNS_START;
        sql = String.valueOf(sql) + procedureClause.getCondition();
        sql = String.valueOf(sql) + columnClause.getCondition();
        sql = String.valueOf(sql) + GET_PROCEDURE_COLUMNS_END;
        ArrayList<String> params = new ArrayList<String>();
        if (!procedureClause.getCondition().equals("")) {
            params.add(procedureClause.getValue());
        }
        if (!columnClause.getCondition().equals("")) {
            params.add(columnClause.getValue());
        }
        ResultSet rs = this.c.doQuery(sql, params, this.statements);
        XSQLVAR[] xsqlvars = new XSQLVAR[13];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "PROCEDURE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "PROCEDURE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "PROCEDURE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "COLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 500;
        xsqlvars[4].sqlname = "COLUMN_TYPE";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 500;
        xsqlvars[5].sqlname = "DATA_TYPE";
        xsqlvars[5].relname = "COLUMNINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 31;
        xsqlvars[6].sqlname = "TYPE_NAME";
        xsqlvars[6].relname = "COLUMNINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 496;
        xsqlvars[7].sqlname = "PRECISION";
        xsqlvars[7].relname = "COLUMNINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 496;
        xsqlvars[8].sqlname = "LENGTH";
        xsqlvars[8].relname = "COLUMNINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 500;
        xsqlvars[9].sqlname = "SCALE";
        xsqlvars[9].relname = "COLUMNINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 500;
        xsqlvars[10].sqlname = "RADIX";
        xsqlvars[10].relname = "COLUMNINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 500;
        xsqlvars[11].sqlname = "NULLABLE";
        xsqlvars[11].relname = "COLUMNINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 80;
        xsqlvars[12].sqlname = "REMARKS";
        xsqlvars[12].relname = "COLUMNINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            byte[][] row = new byte[13][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("PROCEDURE_NAME").trim());
            row[3] = this.getBytes(rs.getString("COLUMN_NAME").trim());
            short columnType = rs.getShort("COLUMN_TYPE");
            row[4] = columnType == 0 ? XSQLVAR.encodeShort((short)1) : XSQLVAR.encodeShort((short)4);
            short fieldType = rs.getShort("FIELD_TYPE");
            short fieldSubType = rs.getShort("FIELD_SUB_TYPE");
            short fieldScale = rs.getShort("FIELD_SCALE");
            int dataType = this.getDataType(fieldType, fieldSubType, fieldScale);
            row[5] = XSQLVAR.encodeShort((short)dataType);
            row[6] = this.getBytes(this.getDataTypeName(fieldType, fieldSubType, fieldScale));
            row[7] = null;
            row[7] = dataType == 3 || dataType == 2 ? XSQLVAR.encodeInt(rs.getShort("FIELD_PRECISION")) : XSQLVAR.encodeInt(rs.getShort("FIELD_LENGTH"));
            row[8] = XSQLVAR.encodeInt(rs.getShort("FIELD_LENGTH"));
            row[9] = XSQLVAR.encodeShort((short)(fieldScale * -1));
            row[10] = XSQLVAR.encodeShort((short)10);
            short nullFlag = rs.getShort("NULL_FLAG");
            row[11] = nullFlag == 1 ? XSQLVAR.encodeShort((short)0) : XSQLVAR.encodeShort((short)1);
            String remarks = rs.getString("REMARKS");
            row[12] = this.getBytes(remarks);
            if (remarks != null && remarks.length() > xsqlvars[12].sqllen) {
                xsqlvars[12].sqllen = remarks.length();
            }
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    public String getProcedureTerm() throws SQLException {
        return "PROCEDURE";
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        this.checkCatalogAndSchema(catalog, schemaPattern);
        Clause procedureClause = new Clause("RDB$PROCEDURE_NAME", procedureNamePattern);
        String sql = GET_PROCEDURES_START;
        sql = String.valueOf(sql) + procedureClause.getCondition();
        sql = String.valueOf(sql) + GET_PROCEDURES_END;
        ArrayList<String> params = new ArrayList<String>();
        if (!procedureClause.getCondition().equals("")) {
            params.add(procedureClause.getValue());
        }
        ResultSet rs = this.c.doQuery(sql, params, this.statements);
        XSQLVAR[] xsqlvars = new XSQLVAR[8];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "PROCEDURE_CAT";
        xsqlvars[0].relname = "RDB$PROCEDURES";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "PROCEDURE_SCHEM";
        xsqlvars[1].relname = "RDB$PROCEDURES";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "PROCEDURE_NAME";
        xsqlvars[2].relname = "RDB$PROCEDURES";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "FUTURE1";
        xsqlvars[3].relname = "RDB$PROCEDURES";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "FUTURE2";
        xsqlvars[4].relname = "RDB$PROCEDURES";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "FUTURE3";
        xsqlvars[5].relname = "RDB$PROCEDURES";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 80;
        xsqlvars[6].sqlname = "REMARKS";
        xsqlvars[6].relname = "RDB$PROCEDURES";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 500;
        xsqlvars[7].sqlname = "PROCEDURE_TYPE";
        xsqlvars[7].relname = "RDB$PROCEDURES";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            short procedureType;
            byte[][] row = new byte[8][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("PROCEDURE_NAME").trim());
            row[3] = null;
            row[4] = null;
            row[5] = null;
            String remarks = rs.getString("REMARKS");
            row[6] = this.getBytes(remarks);
            if (remarks != null && remarks.length() > xsqlvars[6].sqllen) {
                xsqlvars[6].sqllen = remarks.length();
            }
            row[7] = (procedureType = rs.getShort("PROCEDURE_TYPE")) == 0 ? XSQLVAR.encodeShort((short)1) : XSQLVAR.encodeShort((short)2);
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("not yet supported");
    }

    public String getSQLKeywords() throws SQLException {
        return fbSQLKeywords;
    }

    public int getSQLStateType() throws SQLException {
        throw new SQLException("not yet supported");
    }

    public String getSchemaTerm() throws SQLException {
        return "";
    }

    public ResultSet getSchemas() throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[]{new XSQLVAR()};
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_SCHEM";
        xsqlvars[0].relname = "TABLESCHEMAS";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getStringFunctions() throws SQLException {
        return "SUBSTRING";
    }

    public ResultSet getSuperTables(String param1, String param2, String param3) throws SQLException {
        throw new SQLException("not yet supported");
    }

    public ResultSet getSuperTypes(String param1, String param2, String param3) throws SQLException {
        throw new SQLException("not yet supported");
    }

    public String getSystemFunctions() throws SQLException {
        return "";
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.checkCatalogAndSchema(catalog, schemaPattern);
        Clause tableClause = new Clause("RDB$RELATION_NAME", tableNamePattern);
        String sql = GET_TABLE_PRIVILEGES_START;
        sql = String.valueOf(sql) + tableClause.getCondition();
        sql = String.valueOf(sql) + GET_TABLE_PRIVILEGES_END;
        ArrayList<String> params = new ArrayList<String>();
        if (!tableClause.getCondition().equals("")) {
            params.add(tableClause.getValue());
        }
        ResultSet rs = this.c.doQuery(sql, params, this.statements);
        XSQLVAR[] xsqlvars = new XSQLVAR[7];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "TABLEPRIV";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TABLE_SCHEM";
        xsqlvars[1].relname = "TABLEPRIV";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TABLE_NAME";
        xsqlvars[2].relname = "TABLEPRIV";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "GRANTOR";
        xsqlvars[3].relname = "TABLEPRIV";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "GRANTEE";
        xsqlvars[4].relname = "TABLEPRIV";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "PRIVILEGE";
        xsqlvars[5].relname = "TABLEPRIV";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 31;
        xsqlvars[6].sqlname = "IS_GRANTABLE";
        xsqlvars[6].relname = "TABLEPRIV";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        while (rs.next()) {
            byte[][] row = new byte[7][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("TABLE_NAME"));
            row[3] = this.getBytes(rs.getString("GRANTOR"));
            row[4] = this.getBytes(rs.getString("GRANTEE"));
            String privilege = rs.getString("PRIVILEGE");
            if (privilege.equals("A")) {
                row[5] = this.getBytes("ALL");
            } else if (privilege.equals("S")) {
                row[5] = this.getBytes("SELECT");
            } else if (privilege.equals("D")) {
                row[5] = this.getBytes("DELETE");
            } else if (privilege.equals("I")) {
                row[5] = this.getBytes("INSERT");
            } else if (privilege.equals("U")) {
                row[5] = this.getBytes("UPDATE");
            } else if (privilege.equals("R")) {
                row[5] = this.getBytes("REFERENCE");
            } else if (privilege.equals("M")) {
                row[5] = this.getBytes("MEMBEROF");
            }
            short isGrantable = rs.getShort("IS_GRANTABLE");
            row[6] = isGrantable == 0 ? this.getBytes("NO") : this.getBytes("YES");
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getTableTypes() throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[]{new XSQLVAR()};
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_TYPE";
        xsqlvars[0].relname = "TABLETYPES";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>(ALL_TYPES.length);
        int i = 0;
        while (i < ALL_TYPES.length) {
            rows.add(new byte[][]{this.getBytes(ALL_TYPES[i])});
            ++i;
        }
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (tableNamePattern == null || "".equals(tableNamePattern)) {
            tableNamePattern = "%";
        }
        this.checkCatalogAndSchema(catalog, schemaPattern);
        if (types == null) {
            types = ALL_TYPES;
        }
        String sql = "";
        ArrayList<String> params = new ArrayList<String>();
        if (this.isAllCondition(tableNamePattern)) {
            sql = GET_TABLES_ALL;
            params.add(this.getWantsSystemTables(types));
            params.add(this.getWantsTables(types));
            params.add(this.getWantsViews(types));
        } else if (this.hasNoWildcards(tableNamePattern)) {
            tableNamePattern = this.stripQuotes(this.stripEscape(tableNamePattern));
            sql = GET_TABLES_EXACT;
            params.add(this.getWantsSystemTables(types));
            params.add(tableNamePattern);
            params.add(this.getWantsTables(types));
            params.add(tableNamePattern);
            params.add(this.getWantsViews(types));
            params.add(tableNamePattern);
        } else {
            tableNamePattern = String.valueOf(this.stripQuotes(tableNamePattern)) + SPACES + "%";
            sql = GET_TABLES_LIKE;
            params.add(this.getWantsSystemTables(types));
            params.add(tableNamePattern);
            params.add(this.getWantsTables(types));
            params.add(tableNamePattern);
            params.add(this.getWantsViews(types));
            params.add(tableNamePattern);
        }
        return this.c.doQuery(sql, params, this.statements);
    }

    public String getTimeDateFunctions() throws SQLException {
        return "NOT,YET,IMPLEMENTED";
    }

    public ResultSet getTypeInfo() throws SQLException {
        byte[] shortZero = XSQLVAR.encodeShort((short)0);
        byte[] CASESENSITIVE = this.getBytes("T");
        byte[] CASEINSENSITIVE = this.getBytes("F");
        byte[] UNSIGNED = this.getBytes("T");
        byte[] SIGNED = this.getBytes("F");
        byte[] FIXEDSCALE = this.getBytes("T");
        byte[] VARIABLESCALE = this.getBytes("F");
        byte[] NOTAUTOINC = this.getBytes("F");
        byte[] BINARY = XSQLVAR.encodeInt(2);
        byte[] PREDNONE = XSQLVAR.encodeShort((short)0);
        byte[] PREDBASIC = XSQLVAR.encodeShort((short)2);
        byte[] SEARCHABLE = XSQLVAR.encodeShort((short)3);
        byte[] NULLABLE = XSQLVAR.encodeShort((short)1);
        XSQLVAR[] xsqlvars = new XSQLVAR[18];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TYPE_NAME";
        xsqlvars[0].relname = "TYPEINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 500;
        xsqlvars[1].sqlname = "DATA_TYPE";
        xsqlvars[1].relname = "TYPEINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 496;
        xsqlvars[2].sqlname = "PRECISION";
        xsqlvars[2].relname = "TYPEINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 1;
        xsqlvars[3].sqlname = "LITERAL_PREFIX";
        xsqlvars[3].relname = "TYPEINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 1;
        xsqlvars[4].sqlname = "LITERAL_SUFFIX";
        xsqlvars[4].relname = "TYPEINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "CREATE_PARAMS";
        xsqlvars[5].relname = "TYPEINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 500;
        xsqlvars[6].sqlname = "NULLABLE";
        xsqlvars[6].relname = "TYPEINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 452;
        xsqlvars[7].sqllen = 1;
        xsqlvars[7].sqlname = "CASE_SENSITIVE";
        xsqlvars[7].relname = "TYPEINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 500;
        xsqlvars[8].sqlname = "SEARCHABLE";
        xsqlvars[8].relname = "TYPEINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 452;
        xsqlvars[9].sqllen = 1;
        xsqlvars[9].sqlname = "UNSIGNED_ATTRIBUTE";
        xsqlvars[9].relname = "TYPEINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 452;
        xsqlvars[10].sqllen = 1;
        xsqlvars[10].sqlname = "FIXED_PREC_SCALE";
        xsqlvars[10].relname = "TYPEINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 452;
        xsqlvars[11].sqllen = 1;
        xsqlvars[11].sqlname = "AUTO_INCREMENT";
        xsqlvars[11].relname = "TYPEINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "LOCAL_TYPE_NAME";
        xsqlvars[12].relname = "TYPEINFO";
        xsqlvars[13] = new XSQLVAR();
        xsqlvars[13].sqltype = 500;
        xsqlvars[13].sqlname = "MINIMUM_SCALE";
        xsqlvars[13].relname = "TYPEINFO";
        xsqlvars[14] = new XSQLVAR();
        xsqlvars[14].sqltype = 500;
        xsqlvars[14].sqlname = "MAXIMUM_SCALE";
        xsqlvars[14].relname = "TYPEINFO";
        xsqlvars[15] = new XSQLVAR();
        xsqlvars[15].sqltype = 496;
        xsqlvars[15].sqlname = "SQL_DATA_TYPE";
        xsqlvars[15].relname = "TYPEINFO";
        xsqlvars[16] = new XSQLVAR();
        xsqlvars[16].sqltype = 496;
        xsqlvars[16].sqlname = "SQL_DATETIME_SUB";
        xsqlvars[16].relname = "TYPEINFO";
        xsqlvars[17] = new XSQLVAR();
        xsqlvars[17].sqltype = 496;
        xsqlvars[17].sqlname = "NUM_PREC_RADIX";
        xsqlvars[17].relname = "TYPEINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        rows.add(new byte[][]{this.getBytes("BLOB SUB_TYPE 0"), this.createShort(-4), XSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASESENSITIVE, PREDNONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, XSQLVAR.encodeInt(520), null, BINARY});
        rows.add(new byte[][]{this.getBytes("BLOB SUB_TYPE 1"), this.createShort(-1), XSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASESENSITIVE, PREDNONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, XSQLVAR.encodeInt(520), null, BINARY});
        rows.add(new byte[][]{this.getBytes("CHAR"), this.createShort(1), XSQLVAR.encodeInt(32664), this.getBytes("'"), this.getBytes("'"), this.getBytes("length"), NULLABLE, CASESENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, XSQLVAR.encodeInt(452), null, BINARY});
        rows.add(new byte[][]{this.getBytes("NUMERIC"), this.createShort(2), XSQLVAR.encodeInt(18), null, null, this.getBytes("precision,scale"), NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, this.createShort(18), XSQLVAR.encodeInt(580), null, BINARY});
        rows.add(new byte[][]{this.getBytes("DECIMAL"), this.createShort(3), XSQLVAR.encodeInt(18), null, null, this.getBytes("precision,scale"), NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, this.createShort(18), XSQLVAR.encodeInt(580), null, BINARY});
        rows.add(new byte[][]{this.getBytes("INTEGER"), this.createShort(4), XSQLVAR.encodeInt(32), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, XSQLVAR.encodeInt(496), null, BINARY});
        rows.add(new byte[][]{this.getBytes("SMALLINT"), this.createShort(5), XSQLVAR.encodeInt(16), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, XSQLVAR.encodeInt(500), null, BINARY});
        rows.add(new byte[][]{this.getBytes("FLOAT"), this.createShort(6), XSQLVAR.encodeInt(7), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, VARIABLESCALE, NOTAUTOINC, null, this.createShort(0), this.createShort(7), XSQLVAR.encodeInt(482), null, BINARY});
        rows.add(new byte[][]{this.getBytes("DOUBLE PRECISION"), this.createShort(8), XSQLVAR.encodeInt(15), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, VARIABLESCALE, NOTAUTOINC, null, this.createShort(0), this.createShort(15), XSQLVAR.encodeInt(480), null, BINARY});
        rows.add(new byte[][]{this.getBytes("VARCHAR"), this.createShort(12), XSQLVAR.encodeInt(32664), this.getBytes("'"), this.getBytes("'"), this.getBytes("length"), NULLABLE, CASESENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, XSQLVAR.encodeInt(448), null, BINARY});
        rows.add(new byte[][]{this.getBytes("DATE"), this.createShort(91), XSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, XSQLVAR.encodeInt(570), null, BINARY});
        rows.add(new byte[][]{this.getBytes("TIME"), this.createShort(92), XSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, XSQLVAR.encodeInt(560), null, BINARY});
        rows.add(new byte[][]{this.getBytes("TIMESTAMP"), this.createShort(93), XSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, XSQLVAR.encodeInt(510), null, BINARY});
        rows.add(new byte[][]{this.getBytes("ARRAY"), this.createShort(1111), XSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASESENSITIVE, PREDNONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, XSQLVAR.encodeInt(540), null, BINARY});
        rows.add(new byte[][]{this.getBytes("BLOB SUB_TYPE <0 "), this.createShort(2004), XSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASESENSITIVE, PREDNONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, XSQLVAR.encodeInt(520), null, BINARY});
        return new FBResultSet(xsqlvars, rows);
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[6];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TYPE_CAT";
        xsqlvars[0].relname = "UDT";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TYPE_SCHEM";
        xsqlvars[1].relname = "UDT";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TYPE_NAME";
        xsqlvars[2].relname = "UDT";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "CLASS_NAME";
        xsqlvars[3].relname = "UDT";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "DATA_TYPE";
        xsqlvars[4].relname = "UDT";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "REMARKS";
        xsqlvars[5].relname = "UDT";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    public String getURL() throws SQLException {
        return "jdbc:firebirdsql:" + this.c.getDatabase();
    }

    public String getUserName() throws SQLException {
        return this.c.getUserName();
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[8];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 500;
        xsqlvars[0].sqlname = "SCOPE";
        xsqlvars[0].relname = "VERSIONCOL";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "COLUMN_NAME";
        xsqlvars[1].relname = "VERSIONCOL";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 500;
        xsqlvars[2].sqlname = "DATA_TYPE";
        xsqlvars[2].relname = "VERSIONCOL";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "TYPE_NAME";
        xsqlvars[3].relname = "VERSIONCOL";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 496;
        xsqlvars[4].sqlname = "COLUMN_SIZE";
        xsqlvars[4].relname = "VERSIONCOL";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 496;
        xsqlvars[5].sqlname = "BUFFER_LENGTH";
        xsqlvars[5].relname = "VERSIONCOL";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 500;
        xsqlvars[6].sqlname = "DECIMAL_DIGITS";
        xsqlvars[6].relname = "VERSIONCOL";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 500;
        xsqlvars[7].sqlname = "PSEUDO_COLUMN";
        xsqlvars[7].relname = "VERSIONCOL";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    private String getWantsSystemTables(String[] types) {
        int i = 0;
        while (i < types.length) {
            if (SYSTEM_TABLE.equals(types[i])) {
                return "T";
            }
            ++i;
        }
        return "F";
    }

    private String getWantsTables(String[] types) {
        int i = 0;
        while (i < types.length) {
            if (TABLE.equals(types[i])) {
                return "T";
            }
            ++i;
        }
        return "F";
    }

    private String getWantsViews(String[] types) {
        int i = 0;
        while (i < types.length) {
            if (VIEW.equals(types[i])) {
                return "T";
            }
            ++i;
        }
        return "F";
    }

    public boolean hasNoWildcards(String pattern) {
        int pos;
        if (pattern == null) {
            return true;
        }
        int scannedTo = 0;
        while ((pos = pattern.indexOf(37, scannedTo)) < pattern.length()) {
            if (pos == -1) break;
            if (pos == 0 || pattern.charAt(pos - 1) != '\\') {
                return false;
            }
            scannedTo = ++pos;
        }
        scannedTo = 0;
        while ((pos = pattern.indexOf(95, scannedTo)) < pattern.length()) {
            if (pos == -1) break;
            if (pos == 0 || pattern.charAt(pos - 1) != '\\') {
                return false;
            }
            scannedTo = ++pos;
        }
        return true;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    private boolean isAllCondition(String pattern) {
        return "%".equals(pattern);
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public String stripEscape(String pattern) {
        StringBuffer stripped = new StringBuffer(pattern.length());
        int pos = 0;
        while (pos < pattern.length()) {
            if (pattern.charAt(pos) != '\\') {
                stripped.append(pattern.charAt(pos));
            }
            ++pos;
        }
        return stripped.toString();
    }

    public String stripQuotes(String pattern) {
        if (pattern.length() >= 2 && pattern.charAt(0) == '\"' && pattern.charAt(pattern.length() - 1) == '\"') {
            return pattern.substring(1, pattern.length() - 1);
        }
        return pattern.toUpperCase();
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        throw new SQLException("not yet supported");
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return type == 1003 && concurrency == 1007;
    }

    public boolean supportsResultSetHoldability(int param1) throws SQLException {
        throw new SQLException("not yet supported");
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        switch (type) {
            case 1003: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsSavepoints() throws SQLException {
        throw new SQLException("not yet supported");
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 0: {
                return false;
            }
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
            case 4: {
                return true;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    private class Clause {
        private String condition = "";
        private String value;

        public Clause(String columnName, String pattern) {
            if (pattern == null) {
                return;
            }
            if (FBDatabaseMetaData.this.isAllCondition(pattern)) {
                return;
            }
            if (FBDatabaseMetaData.this.hasNoWildcards(pattern)) {
                this.value = FBDatabaseMetaData.this.stripQuotes(FBDatabaseMetaData.this.stripEscape(pattern));
                this.condition = String.valueOf(columnName) + " = ? and ";
            } else {
                this.value = String.valueOf(FBDatabaseMetaData.this.stripQuotes(pattern)) + FBDatabaseMetaData.SPACES + "%";
                this.condition = String.valueOf(columnName) + " || '" + FBDatabaseMetaData.SPACES + "' like ? escape '\\' and ";
            }
        }

        public String getCondition() {
            return this.condition;
        }

        public String getValue() {
            return this.value;
        }
    }
}

