/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBField;
import org.firebirdsql.jdbc.FBResultSet;

class FBDateField
extends FBField {
    FBDateField(XSQLVAR field, FBResultSet rs, int numCol) throws SQLException {
        super(field, rs, numCol);
    }

    java.sql.Date getDate() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return XSQLVAR.decodeDate(this.rs.row[this.numCol]);
    }

    java.sql.Date getDate(Calendar cal) throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return XSQLVAR.decodeDate(this.getDate(), cal);
    }

    Object getObject() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return XSQLVAR.decodeDate(this.rs.row[this.numCol]);
    }

    String getString() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return XSQLVAR.decodeDate(this.rs.row[this.numCol]).toString();
    }

    Timestamp getTimestamp() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return new Timestamp(this.getDate().getTime());
    }

    Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return XSQLVAR.decodeTimestamp(this.getTimestamp(), cal);
    }

    void setDate(java.sql.Date value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.field.sqldata = XSQLVAR.encodeDate(value);
    }

    void setDate(java.sql.Date value, Calendar cal) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setDate(XSQLVAR.encodeDate(value, cal));
    }

    void setString(String value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setDate(java.sql.Date.valueOf(value));
    }

    void setTimestamp(Timestamp value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setDate(new java.sql.Date(((Date)value).getTime()));
    }

    void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setTimestamp(XSQLVAR.encodeTimestamp(value, cal));
    }
}

