/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBField;
import org.firebirdsql.jdbc.FBResultSet;

class FBDoubleField
extends FBField {
    FBDoubleField(XSQLVAR field, FBResultSet rs, int numCol) throws SQLException {
        super(field, rs, numCol);
    }

    BigDecimal getBigDecimal() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return new BigDecimal(XSQLVAR.decodeDouble(this.rs.row[this.numCol]));
    }

    boolean getBoolean() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return false;
        }
        return XSQLVAR.decodeDouble(this.rs.row[this.numCol]) == 1.0;
    }

    byte getByte() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Double value = new Double(XSQLVAR.decodeDouble(this.rs.row[this.numCol]));
        if (value > 127.0 || value < -128.0) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.BYTE_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        return value.byteValue();
    }

    double getDouble() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0;
        }
        return XSQLVAR.decodeDouble(this.rs.row[this.numCol]);
    }

    float getFloat() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0f;
        }
        Double value = new Double(XSQLVAR.decodeDouble(this.rs.row[this.numCol]));
        float cValue = value.floatValue();
        if (cValue == Float.POSITIVE_INFINITY || cValue == Float.NEGATIVE_INFINITY) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.FLOAT_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        return value.floatValue();
    }

    int getInt() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Double value = new Double(XSQLVAR.decodeDouble(this.rs.row[this.numCol]));
        if (value > 2.147483647E9 || value < -2.147483648E9) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.INT_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        return value.intValue();
    }

    long getLong() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0L;
        }
        Double value = new Double(XSQLVAR.decodeDouble(this.rs.row[this.numCol]));
        if (value > 9.223372036854776E18 || value < -9.223372036854776E18) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.LONG_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        return value.longValue();
    }

    Object getObject() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return new Double(XSQLVAR.decodeDouble(this.rs.row[this.numCol]));
    }

    short getShort() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Double value = new Double(XSQLVAR.decodeDouble(this.rs.row[this.numCol]));
        if (value > 32767.0 || value < -32768.0) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.SHORT_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        return value.shortValue();
    }

    String getString() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return String.valueOf(XSQLVAR.decodeDouble(this.rs.row[this.numCol]));
    }

    void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        if (value.compareTo(new BigDecimal(Double.MAX_VALUE)) > 0 || value.compareTo(new BigDecimal(-1.7976931348623157E308)) < 0) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.BIGDECIMAL_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        this.setDouble(value.doubleValue());
    }

    void setBoolean(boolean value) throws SQLException {
        this.setDouble(value ? 1 : 0);
    }

    void setByte(byte value) throws SQLException {
        this.setDouble(value);
    }

    void setDouble(double value) throws SQLException {
        this.field.sqldata = XSQLVAR.encodeDouble(value);
    }

    void setFloat(float value) throws SQLException {
        this.setDouble(value);
    }

    void setInteger(int value) throws SQLException {
        this.setDouble(value);
    }

    void setLong(long value) throws SQLException {
        this.setDouble(value);
    }

    void setShort(short value) throws SQLException {
        this.setDouble(value);
    }

    void setString(String value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        try {
            this.setDouble(Double.parseDouble(value));
        }
        catch (NumberFormatException numberFormatException) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.STRING_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
    }
}

