/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.sql.DataSource;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBTpbMapper;
import org.firebirdsql.jdbc.FBDataSource;

public class FBSimpleDataSource
implements DataSource,
Serializable,
Referenceable {
    protected transient FBManagedConnectionFactory mcf = new FBManagedConnectionFactory();
    protected transient FBDataSource ds;
    protected transient PrintWriter log;
    protected Reference jndiReference;
    protected String description;
    protected int loginTimeout;
    protected String tpbMapping;

    public Integer getBlobBufferLength() {
        return this.mcf.getBlobBufferLength();
    }

    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getDataSource().getConnection(username, password);
    }

    protected synchronized DataSource getDataSource() throws SQLException {
        if (this.ds != null) {
            return this.ds;
        }
        if (this.mcf.getDatabase() == null || "".equals(this.mcf.getDatabase().trim())) {
            throw new SQLException("Database was not specified. Cannot provide connections.");
        }
        try {
            this.ds = (FBDataSource)this.mcf.createConnectionFactory();
            return this.ds;
        }
        catch (ResourceException rex) {
            throw new SQLException(rex.getMessage());
        }
    }

    public String getDatabase() {
        return this.mcf.getDatabase();
    }

    public String getDatabaseName() {
        return this.getDatabase();
    }

    public String getDescription() {
        return this.description;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.log;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public String getPassword() {
        return this.mcf.getPassword();
    }

    public Reference getReference() throws NamingException {
        return this.jndiReference;
    }

    public String getTpbMapping() {
        return this.tpbMapping;
    }

    public String getUser() {
        return this.getUserName();
    }

    public String getUserName() {
        return this.mcf.getUserName();
    }

    public void setBlobBufferLength(Integer length) {
        this.mcf.setBlobBufferLength(length);
    }

    public void setDatabase(String name) {
        this.mcf.setDatabase(name);
    }

    public void setDatabaseName(String name) throws ResourceException {
        this.setDatabase(name);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLogWriter(PrintWriter log) throws SQLException {
        this.log = log;
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.loginTimeout = loginTimeout;
    }

    public void setPassword(String password) {
        this.mcf.setPassword(password);
    }

    public void setReference(Reference reference) {
        this.jndiReference = reference;
    }

    public void setTpbMapping(String tpbMapping) throws FBResourceException {
        this.mcf.setTpbMapper(new FBTpbMapper(tpbMapping, this.getClass().getClassLoader()));
        this.tpbMapping = tpbMapping;
    }

    public void setUser(String user) {
        this.setUserName(user);
    }

    public void setUserName(String userName) {
        this.mcf.setUserName(userName);
    }
}

