/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.isc_stmt_handle;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class FBStatement
implements Statement {
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$jdbc$FBStatement != null ? class$org$firebirdsql$jdbc$FBStatement : (class$org$firebirdsql$jdbc$FBStatement = FBStatement.class$("org.firebirdsql.jdbc.FBStatement")), false);
    protected FBConnection c;
    protected isc_stmt_handle fixedStmt;
    private FBResultSet currentRs;
    private boolean closed;
    private boolean escapedProcessing = true;
    protected SQLWarning firstWarning = null;
    protected boolean isResultSet;
    private ResultSet currentCachedResultSet;
    protected int maxRows = 0;
    protected int fetchSize = 0;
    private int maxFieldSize = 0;
    private int queryTimeout = 0;
    static /* synthetic */ Class class$org$firebirdsql$jdbc$FBStatement;

    FBStatement(FBConnection c) {
        this.c = c;
        this.closed = false;
    }

    public void addBatch(String sql) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    protected void addWarning(SQLWarning warning) {
        if (this.firstWarning == null) {
            this.firstWarning = warning;
        } else {
            SQLWarning lastWarning = this.firstWarning;
            while (lastWarning.getNextWarning() != null) {
                lastWarning = lastWarning.getNextWarning();
            }
            lastWarning.setNextWarning(warning);
        }
    }

    public void cancel() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void clearBatch() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
    }

    public void close() throws SQLException {
        block8: {
            if (this.closed) {
                throw new SQLException("This statement is already closed.");
            }
            try {
                if (this.fixedStmt != null) {
                    try {
                        try {
                            this.c.closeStatement(this.fixedStmt, true);
                        }
                        catch (GDSException ge) {
                            throw new FBSQLException(ge);
                        }
                        Object var4_2 = null;
                        this.fixedStmt = null;
                        this.currentRs = null;
                        this.currentCachedResultSet = null;
                        this.closed = true;
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var4_3 = null;
                        this.fixedStmt = null;
                        this.currentRs = null;
                        this.currentCachedResultSet = null;
                        this.closed = true;
                        throw throwable;
                    }
                }
                this.closed = true;
            }
            catch (Throwable throwable) {
                Object var2_6 = null;
                this.c.notifyStatementClosed(this);
                throw throwable;
            }
        }
        Object var2_5 = null;
        this.c.notifyStatementClosed(this);
    }

    void closeResultSet() throws SQLException {
        this.currentCachedResultSet = null;
        if (this.currentRs != null) {
            try {
                this.c.closeStatement(this.fixedStmt, false);
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
            this.currentRs = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(String sql) throws SQLException {
        boolean bl;
        if (this.closed) {
            throw new SQLException("Statement is closed");
        }
        try {
            try {
                this.c.ensureInTransaction();
                boolean hasResultSet = this.internalExecute(sql);
                if (hasResultSet && this.c.willEndTransaction()) {
                    this.getCachedResultSet(false);
                }
                bl = hasResultSet;
                Object var4_5 = null;
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.c.checkEndTransaction();
            throw throwable;
        }
        this.c.checkEndTransaction();
        return bl;
    }

    public boolean execute(String param1, int param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public boolean execute(String param1, int[] param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public boolean execute(String param1, String[] param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public int[] executeBatch() throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet resultSet;
        block8: {
            ResultSet resultSet2;
            block7: {
                if (this.closed) {
                    throw new SQLException("Statement is closed");
                }
                try {
                    try {
                        this.c.ensureInTransaction();
                        if (!this.internalExecute(sql)) {
                            throw new SQLException("query did not return a result set: " + sql);
                        }
                        if (this.c.willEndTransaction()) {
                            ResultSet rs;
                            resultSet2 = rs = this.getCachedResultSet(false);
                            Object var4_6 = null;
                            break block7;
                        }
                        resultSet = this.getResultSet();
                        break block8;
                    }
                    catch (GDSException ge) {
                        throw new FBSQLException(ge);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    this.c.checkEndTransaction();
                    throw throwable;
                }
            }
            this.c.checkEndTransaction();
            return resultSet2;
        }
        Object var4_7 = null;
        this.c.checkEndTransaction();
        return resultSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String sql) throws SQLException {
        int n;
        if (this.closed) {
            throw new SQLException("Statement is closed");
        }
        try {
            try {
                this.c.ensureInTransaction();
                if (this.internalExecute(sql)) {
                    throw new SQLException("update statement returned results!");
                }
                n = this.getUpdateCount();
                Object var4_3 = null;
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.c.checkEndTransaction();
            throw throwable;
        }
        this.c.checkEndTransaction();
        return n;
    }

    public int executeUpdate(String param1, int param2) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public int executeUpdate(String param1, int[] param2) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public int executeUpdate(String param1, String[] param2) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void forgetResultSet() {
        this.currentRs = null;
        if (this.fixedStmt != null) {
            this.fixedStmt.clearRows();
        }
    }

    ResultSet getCachedResultSet(boolean trimStrings) throws SQLException {
        if (this.currentRs != null) {
            throw new SQLException("Only one resultset at a time/statement!");
        }
        if (this.fixedStmt == null) {
            throw new SQLException("No statement just executed");
        }
        this.currentCachedResultSet = new FBResultSet(this.c, this, this.fixedStmt, trimStrings);
        return this.currentCachedResultSet;
    }

    public Connection getConnection() {
        return this.c;
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public boolean getMoreResults() throws SQLException {
        return false;
    }

    public boolean getMoreResults(int param1) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.currentRs != null) {
            throw new SQLException("Only one resultset at a time/statement!");
        }
        if (this.fixedStmt == null) {
            throw new SQLException("No statement just executed");
        }
        if (this.currentCachedResultSet != null) {
            ResultSet rs = this.currentCachedResultSet;
            this.currentCachedResultSet = null;
            return rs;
        }
        if (this.isResultSet) {
            this.currentRs = new FBResultSet(this.c, this, this.fixedStmt);
            return this.currentRs;
        }
        return null;
    }

    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public int getResultSetType() throws SQLException {
        return 1003;
    }

    public int getUpdateCount() throws SQLException {
        if (this.isResultSet) {
            return -1;
        }
        try {
            this.c.getSqlCounts(this.fixedStmt);
            int insCount = this.fixedStmt.getInsertCount();
            int updCount = this.fixedStmt.getUpdateCount();
            int delCount = this.fixedStmt.getDeleteCount();
            int resCount = updCount > delCount ? updCount : delCount;
            resCount = resCount > insCount ? resCount : insCount;
            return resCount;
        }
        catch (GDSException ge) {
            throw new FBSQLException(ge);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.firstWarning;
    }

    protected boolean internalExecute(String sql) throws GDSException, SQLException {
        if (this.closed) {
            throw new SQLException("Statement is already closed.");
        }
        this.closeResultSet();
        this.prepareFixedStatement(sql, false);
        this.c.executeStatement(this.fixedStmt, this.isExecuteProcedureStatement(sql));
        this.isResultSet = this.fixedStmt.getOutSqlda().sqld > 0;
        return this.fixedStmt.getOutSqlda().sqld > 0;
    }

    boolean isClosed() {
        return this.closed;
    }

    protected boolean isExecuteProcedureStatement(String sql) throws SQLException {
        String trimmedSql = this.c.nativeSQL(sql).trim();
        return trimmedSql.startsWith("EXECUTE");
    }

    protected void prepareFixedStatement(String sql, boolean describeBind) throws GDSException, SQLException {
        if (this.fixedStmt == null) {
            this.fixedStmt = this.c.getAllocatedStatement();
        }
        this.c.prepareSQL(this.fixedStmt, this.escapedProcessing ? this.c.nativeSQL(sql) : sql, describeBind);
    }

    public void setCursorName(String name) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapedProcessing = enable;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLException("can't set fetch direction");
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new SQLException("can't set negative fetch size");
        }
        if (this.maxRows > 0 && rows > this.maxRows) {
            throw new SQLException("can't set fetch size > maxRows");
        }
        this.fetchSize = rows;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("can't set max field size negative");
        }
        this.maxFieldSize = max;
    }

    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("Max rows can't be less than 0");
        }
        this.maxRows = max;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new SQLException("can't set query timeout negative");
        }
        this.queryTimeout = seconds;
    }
}

