/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.isc_stmt_handle;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.jgds.isc_stmt_handle_impl;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

class FBStatementFetcher
implements FBFetcher {
    private FBConnection c;
    private FBStatement fbStatement;
    private FBResultSet rs;
    private isc_stmt_handle_impl stmt;
    private Object[] rowsArray;
    private int size;
    private byte[][] nextRow;
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$jdbc$FBStatementFetcher != null ? class$org$firebirdsql$jdbc$FBStatementFetcher : (class$org$firebirdsql$jdbc$FBStatementFetcher = FBStatementFetcher.class$("org.firebirdsql.jdbc.FBStatementFetcher")), false);
    private int rowNum = 0;
    private int rowPosition = 0;
    private boolean isEmpty = false;
    private boolean isBeforeFirst = false;
    private boolean isFirst = false;
    private boolean isLast = false;
    private boolean isAfterLast = false;
    static /* synthetic */ Class class$org$firebirdsql$jdbc$FBStatementFetcher;

    FBStatementFetcher(FBConnection c, FBStatement fbStatement, isc_stmt_handle stmth, FBResultSet rs) throws SQLException {
        this.c = c;
        this.fbStatement = fbStatement;
        this.stmt = (isc_stmt_handle_impl)stmth;
        this.rs = rs;
        c.registerStatement(fbStatement);
        this.isEmpty = false;
        this.isBeforeFirst = false;
        this.isFirst = false;
        this.isLast = false;
        this.isAfterLast = false;
        if (this.stmt.getAllRowsFetched()) {
            this.rowsArray = this.stmt.getRows();
            this.size = this.stmt.size();
        }
        this.fetch();
        if (this.nextRow == null) {
            this.isEmpty = true;
        } else {
            this.isBeforeFirst = true;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void close() throws SQLException {
        this.fbStatement.closeResultSet();
    }

    public void fetch() throws SQLException {
        int fetchSize;
        int maxRows = 0;
        if (this.fbStatement.maxRows != 0) {
            maxRows = this.fbStatement.maxRows - this.rowNum;
        }
        if ((fetchSize = this.fbStatement.fetchSize) == 0) {
            fetchSize = 400;
        }
        if (maxRows != 0 && fetchSize > maxRows) {
            fetchSize = maxRows;
        }
        if (!(this.stmt.getAllRowsFetched() || this.rowsArray != null && this.size != this.rowPosition)) {
            try {
                this.c.fetch(this.stmt, fetchSize);
                this.rowPosition = 0;
                this.rowsArray = this.stmt.getRows();
                this.size = this.stmt.size();
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
        }
        if (this.rowsArray != null && this.size > this.rowPosition) {
            this.nextRow = (byte[][])this.rowsArray[this.rowPosition];
            this.rowsArray[this.rowPosition] = null;
            ++this.rowPosition;
        } else {
            this.nextRow = null;
        }
    }

    public boolean getIsAfterLast() {
        return this.isAfterLast;
    }

    public boolean getIsBeforeFirst() {
        return this.isBeforeFirst;
    }

    public boolean getIsEmpty() {
        return this.isEmpty;
    }

    public boolean getIsFirst() {
        return this.isFirst;
    }

    public boolean getIsLast() {
        return this.isLast;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public Statement getStatement() {
        return this.fbStatement;
    }

    public boolean next() throws SQLException {
        this.isBeforeFirst = false;
        this.isFirst = false;
        this.isLast = false;
        this.isAfterLast = false;
        if (log != null) {
            log.debug("FBResultSet next - FBStatementFetcher");
        }
        if (this.isEmpty) {
            return false;
        }
        if (this.nextRow == null || this.fbStatement.maxRows != 0 && this.rowNum == this.fbStatement.maxRows) {
            this.isAfterLast = true;
            this.rowNum = 0;
            return false;
        }
        this.rs.row = this.nextRow;
        this.fetch();
        ++this.rowNum;
        if (this.rowNum == 1) {
            this.isFirst = true;
        }
        if (this.nextRow == null || this.fbStatement.maxRows != 0 && this.rowNum == this.fbStatement.maxRows) {
            this.isLast = true;
        }
        return true;
    }
}

