/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBField;
import org.firebirdsql.jdbc.FBResultSet;

public class FBStringField
extends FBField {
    private static final String SHORT_TRUE = "Y";
    private static final String SHORT_FALSE = "N";
    private static final String LONG_TRUE = "TRUE";
    private static final String LONG_FALSE = "FALSE";
    private static final String SHORT_TRUE_2 = "T";
    private static final String SHORT_FALSE_2 = "F";

    FBStringField(XSQLVAR field, FBResultSet rs, int numCol) throws SQLException {
        super(field, rs, numCol);
    }

    InputStream getAsciiStream() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return this.getBinaryStream();
    }

    BigDecimal getBigDecimal() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return new BigDecimal(this.getString().trim());
    }

    InputStream getBinaryStream() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return new ByteArrayInputStream(this.rs.row[this.numCol]);
    }

    boolean getBoolean() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return false;
        }
        return this.getString().trim().equalsIgnoreCase(LONG_TRUE) || this.getString().trim().equalsIgnoreCase(SHORT_TRUE) || this.getString().trim().equalsIgnoreCase(SHORT_TRUE_2);
    }

    byte getByte() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        try {
            return Byte.parseByte(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.BYTE_CONVERSION_ERROR) + " " + this.getString().trim()).fillInStackTrace();
        }
    }

    byte[] getBytes() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return FBField.BYTES_NULL_VALUE;
        }
        return this.rs.row[this.numCol];
    }

    Date getDate() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return Date.valueOf(this.getString().trim());
    }

    Date getDate(Calendar cal) throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return XSQLVAR.decodeDate(this.getDate(), cal);
    }

    double getDouble() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.DOUBLE_CONVERSION_ERROR) + " " + this.getString().trim()).fillInStackTrace();
        }
    }

    float getFloat() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.FLOAT_CONVERSION_ERROR) + " " + this.getString().trim()).fillInStackTrace();
        }
    }

    int getInt() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        try {
            return Integer.parseInt(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.INT_CONVERSION_ERROR) + " " + this.getString().trim()).fillInStackTrace();
        }
    }

    long getLong() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0L;
        }
        try {
            return Long.parseLong(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.LONG_CONVERSION_ERROR) + " " + this.getString().trim()).fillInStackTrace();
        }
    }

    Object getObject() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return this.getString();
    }

    short getShort() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        try {
            return Short.parseShort(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.SHORT_CONVERSION_ERROR) + " " + this.getString().trim()).fillInStackTrace();
        }
    }

    String getString() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return this.field.decodeString(this.rs.row[this.numCol], this.javaEncoding);
    }

    Time getTime() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return Time.valueOf(this.getString().trim());
    }

    Time getTime(Calendar cal) throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return XSQLVAR.decodeTime(this.getTime(), cal);
    }

    Timestamp getTimestamp() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return Timestamp.valueOf(this.getString().trim());
    }

    Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return XSQLVAR.decodeTimestamp(this.getTimestamp(), cal);
    }

    InputStream getUnicodeStream() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return this.getBinaryStream();
    }

    void setAsciiStream(InputStream in, int length) throws SQLException {
        if (in == null) {
            this.field.sqldata = null;
            return;
        }
        this.setBinaryStream(in, length);
    }

    void setBigDecimal(BigDecimal value) throws SQLException {
        this.setString(value.toString());
    }

    void setBinaryStream(InputStream in, int length) throws SQLException {
        if (in == null) {
            this.field.sqldata = null;
            return;
        }
        if (length > this.field.sqllen) {
            throw new DataTruncation(-1, true, false, length, this.field.sqllen);
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buff = new byte[4096];
            int counter = 0;
            int toRead = length;
            while ((counter = in.read(buff, 0, toRead > buff.length ? buff.length : toRead)) != -1) {
                out.write(buff, 0, counter);
                toRead -= counter;
            }
            this.setBytes(out.toByteArray());
        }
        catch (IOException iOException) {
            throw (SQLException)FBField.createException(FBField.BINARY_STREAM_CONVERSION_ERROR).fillInStackTrace();
        }
    }

    void setBoolean(boolean value) throws SQLException {
        if (this.field.sqllen == 1) {
            this.setString(value ? SHORT_TRUE : SHORT_FALSE);
        } else if (this.field.sqllen > 4) {
            this.setString(value ? LONG_TRUE : LONG_FALSE);
        }
    }

    void setByte(byte value) throws SQLException {
        this.setString(Byte.toString(value));
    }

    void setBytes(byte[] value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.field.sqldata = this.field.encodeString(value, this.javaEncoding);
        if (this.field.sqldata.length > this.field.sqllen) {
            throw new DataTruncation(-1, true, false, this.field.sqldata.length, this.field.sqllen);
        }
    }

    void setCharacterStream(Reader in, int length) throws SQLException {
        if (in == null) {
            this.field.sqldata = null;
            return;
        }
        try {
            StringWriter out = new StringWriter();
            char[] buff = new char[4096];
            int counter = 0;
            while ((counter = in.read(buff)) != -1) {
                out.write(buff, 0, counter);
            }
            String outString = out.toString();
            this.setString(outString.substring(0, length));
        }
        catch (IOException iOException) {
            throw (SQLException)FBField.createException(FBField.CHARACTER_STREAM_CONVERSION_ERROR).fillInStackTrace();
        }
    }

    void setDate(Date value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setString(value.toString());
    }

    void setDate(Date value, Calendar cal) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setDate(XSQLVAR.encodeDate(value, cal));
    }

    void setDouble(double value) throws SQLException {
        this.setString(Double.toString(value));
    }

    void setFloat(float value) throws SQLException {
        this.setString(Float.toString(value));
    }

    void setInteger(int value) throws SQLException {
        this.setString(Integer.toString(value));
    }

    void setLong(long value) throws SQLException {
        this.setString(Long.toString(value));
    }

    void setShort(short value) throws SQLException {
        this.setString(Short.toString(value));
    }

    void setString(String value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.field.sqldata = this.field.encodeString(value, this.javaEncoding);
        if (this.field.sqldata.length > this.field.sqllen) {
            throw new DataTruncation(-1, true, false, this.field.sqldata.length, this.field.sqllen);
        }
    }

    void setTime(Time value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setString(value.toString());
    }

    void setTime(Time value, Calendar cal) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setTime(XSQLVAR.encodeTime(value, cal));
    }

    void setTimestamp(Timestamp value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setString(value.toString());
    }

    void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        this.setTimestamp(XSQLVAR.encodeTimestamp(value, cal));
    }

    void setUnicodeStream(InputStream in, int length) throws SQLException {
        if (in == null) {
            this.field.sqldata = null;
            return;
        }
        this.setBinaryStream(in, length);
    }
}

