/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jgds;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.firebirdsql.gds.Clumplet;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.XSQLDA;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.isc_blob_handle;
import org.firebirdsql.gds.isc_db_handle;
import org.firebirdsql.gds.isc_stmt_handle;
import org.firebirdsql.gds.isc_tr_handle;
import org.firebirdsql.jgds.ClumpletImpl;
import org.firebirdsql.jgds.StringClumplet;
import org.firebirdsql.jgds.XdrInputStream;
import org.firebirdsql.jgds.XdrOutputStream;
import org.firebirdsql.jgds.Xdrable;
import org.firebirdsql.jgds.isc_blob_handle_impl;
import org.firebirdsql.jgds.isc_db_handle_impl;
import org.firebirdsql.jgds.isc_stmt_handle_impl;
import org.firebirdsql.jgds.isc_tr_handle_impl;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public final class GDS_Impl
implements GDS {
    private static Logger log = LoggerFactory.getLogger(class$org$firebirdsql$jgds$GDS_Impl != null ? class$org$firebirdsql$jgds$GDS_Impl : (class$org$firebirdsql$jgds$GDS_Impl = GDS_Impl.class$("org.firebirdsql.jgds.GDS_Impl")), false);
    static final int op_void = 0;
    static final int op_connect = 1;
    static final int op_exit = 2;
    static final int op_accept = 3;
    static final int op_reject = 4;
    static final int op_protocol = 5;
    static final int op_disconnect = 6;
    static final int op_credit = 7;
    static final int op_continuation = 8;
    static final int op_response = 9;
    static final int op_open_file = 10;
    static final int op_create_file = 11;
    static final int op_close_file = 12;
    static final int op_read_page = 13;
    static final int op_write_page = 14;
    static final int op_lock = 15;
    static final int op_convert_lock = 16;
    static final int op_release_lock = 17;
    static final int op_blocking = 18;
    static final int op_attach = 19;
    static final int op_create = 20;
    static final int op_detach = 21;
    static final int op_compile = 22;
    static final int op_start = 23;
    static final int op_start_and_send = 24;
    static final int op_send = 25;
    static final int op_receive = 26;
    static final int op_unwind = 27;
    static final int op_release = 28;
    static final int op_transaction = 29;
    static final int op_commit = 30;
    static final int op_rollback = 31;
    static final int op_prepare = 32;
    static final int op_reconnect = 33;
    static final int op_create_blob = 34;
    static final int op_open_blob = 35;
    static final int op_get_segment = 36;
    static final int op_put_segment = 37;
    static final int op_cancel_blob = 38;
    static final int op_close_blob = 39;
    static final int op_info_database = 40;
    static final int op_info_request = 41;
    static final int op_info_transaction = 42;
    static final int op_info_blob = 43;
    static final int op_batch_segments = 44;
    static final int op_mgr_set_affinity = 45;
    static final int op_mgr_clear_affinity = 46;
    static final int op_mgr_report = 47;
    static final int op_que_events = 48;
    static final int op_cancel_events = 49;
    static final int op_commit_retaining = 50;
    static final int op_prepare2 = 51;
    static final int op_event = 52;
    static final int op_connect_request = 53;
    static final int op_aux_connect = 54;
    static final int op_ddl = 55;
    static final int op_open_blob2 = 56;
    static final int op_create_blob2 = 57;
    static final int op_get_slice = 58;
    static final int op_put_slice = 59;
    static final int op_slice = 60;
    static final int op_seek_blob = 61;
    static final int op_allocate_statement = 62;
    static final int op_execute = 63;
    static final int op_exec_immediate = 64;
    static final int op_fetch = 65;
    static final int op_fetch_response = 66;
    static final int op_free_statement = 67;
    static final int op_prepare_statement = 68;
    static final int op_set_cursor = 69;
    static final int op_info_sql = 70;
    static final int op_dummy = 71;
    static final int op_response_piggyback = 72;
    static final int op_start_and_receive = 73;
    static final int op_start_send_and_receive = 74;
    static final int op_exec_immediate2 = 75;
    static final int op_execute2 = 76;
    static final int op_insert = 77;
    static final int op_sql_response = 78;
    static final int op_transact = 79;
    static final int op_transact_response = 80;
    static final int op_drop_database = 81;
    static final int op_service_attach = 82;
    static final int op_service_detach = 83;
    static final int op_service_info = 84;
    static final int op_service_start = 85;
    static final int op_rollback_retaining = 86;
    static final int MAX_BUFFER_SIZE = 1024;
    static final byte[] describe_database_info = new byte[]{62, 12, 32, 33, 1};
    static final byte[] describe_select_info = new byte[]{4, 7, 9, 11, 12, 13, 14, 16, 17, 18, 19, 8};
    static final byte[] describe_bind_info = new byte[]{5, 7, 9, 11, 12, 13, 14, 16, 17, 18, 19, 8};
    static final byte[] sql_prepare_info = new byte[]{4, 7, 9, 11, 12, 13, 14, 16, 17, 18, 19, 8};
    private static byte[] stmtInfo = new byte[]{23, 21, 1};
    private static int INFO_SIZE = 128;
    static /* synthetic */ Class class$org$firebirdsql$jgds$GDS_Impl;

    public static void calculateBLR(XSQLDA xsqlda) throws GDSException {
        int blr_len = 0;
        if (xsqlda != null) {
            blr_len = 8;
            int par_count = 0;
            int i = 0;
            while (i < xsqlda.sqld) {
                int dtype = xsqlda.sqlvar[i].sqltype & 0xFFFFFFFE;
                blr_len = dtype == 448 || dtype == 452 ? (blr_len += 3) : (dtype == 500 || dtype == 496 || dtype == 580 || dtype == 550 || dtype == 520 || dtype == 540 ? (blr_len += 2) : ++blr_len);
                blr_len += 2;
                par_count += 2;
                ++i;
            }
            byte[] blr = new byte[blr_len];
            int n = 0;
            blr[n++] = 5;
            blr[n++] = 2;
            blr[n++] = 4;
            blr[n++] = 0;
            blr[n++] = (byte)(par_count & 0xFF);
            blr[n++] = (byte)(par_count >> 8);
            int i2 = 0;
            while (i2 < xsqlda.sqld) {
                int dtype = xsqlda.sqlvar[i2].sqltype & 0xFFFFFFFE;
                int len = xsqlda.sqlvar[i2].sqllen;
                if (dtype == 448) {
                    blr[n++] = 37;
                    blr[n++] = (byte)(len & 0xFF);
                    blr[n++] = (byte)(len >> 8);
                } else if (dtype == 452) {
                    blr[n++] = 14;
                    blr[n++] = (byte)(len & 0xFF);
                    blr[n++] = (byte)(len >> 8);
                } else if (dtype == 480) {
                    blr[n++] = 27;
                } else if (dtype == 482) {
                    blr[n++] = 10;
                } else if (dtype == 530) {
                    blr[n++] = 11;
                } else if (dtype == 570) {
                    blr[n++] = 12;
                } else if (dtype == 560) {
                    blr[n++] = 13;
                } else if (dtype == 510) {
                    blr[n++] = 35;
                } else if (dtype == 520) {
                    blr[n++] = 9;
                    blr[n++] = 0;
                } else if (dtype == 540) {
                    blr[n++] = 9;
                    blr[n++] = 0;
                } else if (dtype == 496) {
                    blr[n++] = 8;
                    blr[n++] = (byte)xsqlda.sqlvar[i2].sqlscale;
                } else if (dtype == 500) {
                    blr[n++] = 7;
                    blr[n++] = (byte)xsqlda.sqlvar[i2].sqlscale;
                } else if (dtype == 580) {
                    blr[n++] = 16;
                    blr[n++] = (byte)xsqlda.sqlvar[i2].sqlscale;
                } else if (dtype == 550) {
                    blr[n++] = 9;
                    blr[n++] = (byte)xsqlda.sqlvar[i2].sqlscale;
                }
                blr[n++] = 7;
                blr[n++] = 0;
                ++i2;
            }
            blr[n++] = -1;
            blr[n++] = 76;
            xsqlda.blr = blr;
        }
    }

    public static void calculateIOLength(XSQLDA xsqlda) {
        xsqlda.ioLength = new int[xsqlda.sqld];
        int i = 0;
        while (i < xsqlda.sqld) {
            switch (xsqlda.sqlvar[i].sqltype & 0xFFFFFFFE) {
                case 452: {
                    xsqlda.ioLength[i] = xsqlda.sqlvar[i].sqllen + 1;
                    break;
                }
                case 448: {
                    xsqlda.ioLength[i] = 0;
                    break;
                }
                case 482: 
                case 496: 
                case 500: 
                case 560: 
                case 570: {
                    xsqlda.ioLength[i] = -4;
                    break;
                }
                case 480: 
                case 510: 
                case 520: 
                case 540: 
                case 550: 
                case 580: {
                    xsqlda.ioLength[i] = -8;
                    break;
                }
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static Clumplet cloneClumplet(Clumplet c) {
        if (c == null) {
            return null;
        }
        return ((ClumpletImpl)c).cloneClumplet();
    }

    public void connect(isc_db_handle_impl db, String host, Integer port, String filename, Clumplet dpb) throws GDSException {
        DbAttachInfo dbai = new DbAttachInfo(host, port, filename);
        this.connect(db, dbai, dpb);
    }

    private void connect(isc_db_handle_impl db, DbAttachInfo dbai, Clumplet dpb) throws GDSException {
        block18: {
            boolean debug = log != null && log.isDebugEnabled();
            int socketBufferSize = -1;
            String iscSocketBufferLength = dpb.findString(129);
            if (iscSocketBufferLength != null) {
                try {
                    socketBufferSize = Integer.parseInt(iscSocketBufferLength);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new GDSException(1, 335544325);
                }
            }
            try {
                try {
                    db.socket = new Socket(dbai.getServer(), dbai.getPort());
                    db.socket.setTcpNoDelay(true);
                    if (socketBufferSize != -1) {
                        db.socket.setReceiveBufferSize(socketBufferSize);
                        db.socket.setSendBufferSize(socketBufferSize);
                    }
                    if (debug) {
                        log.debug("Got socket");
                    }
                }
                catch (UnknownHostException ex2) {
                    String message = "Cannot resolve host " + dbai.getServer();
                    if (debug) {
                        log.error(message, ex2);
                    }
                    throw new GDSException(1, 335544721, dbai.getServer());
                }
                db.out = new XdrOutputStream(db.socket.getOutputStream());
                db.in = new XdrInputStream(db.socket.getInputStream());
                String user = System.getProperty("user.name");
                if (debug) {
                    log.debug("user.name: " + user);
                }
                String host = InetAddress.getLocalHost().getHostName();
                byte[] user_id = new byte[6 + user.length() + host.length()];
                int n = 0;
                user_id[n++] = 1;
                user_id[n++] = (byte)user.length();
                System.arraycopy(user.getBytes(), 0, user_id, n, user.length());
                n += user.length();
                user_id[n++] = 4;
                user_id[n++] = (byte)host.length();
                System.arraycopy(host.getBytes(), 0, user_id, n, host.length());
                n += host.length();
                user_id[n++] = 6;
                user_id[n++] = 0;
                if (debug) {
                    log.debug("op_connect ");
                }
                db.out.writeInt(1);
                db.out.writeInt(19);
                db.out.writeInt(2);
                db.out.writeInt(1);
                db.out.writeString(dbai.getFileName());
                db.out.writeInt(1);
                db.out.writeBuffer(user_id);
                db.out.writeInt(10);
                db.out.writeInt(1);
                db.out.writeInt(2);
                db.out.writeInt(3);
                db.out.writeInt(2);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                if (debug) {
                    log.debug("op_accept ");
                }
                if (this.nextOperation(db) == 3) {
                    db.setProtocol(db.in.readInt());
                    int arch = db.in.readInt();
                    int min = db.in.readInt();
                    if (debug) {
                        log.debug("received");
                    }
                    break block18;
                }
                this.disconnect(db);
                if (debug) {
                    log.debug("not received");
                }
                throw new GDSException(335544421);
            }
            catch (IOException ex) {
                if (debug) {
                    log.debug("IOException while trying to connect to db:", ex);
                }
                throw new GDSException(1, 335544721, dbai.getServer());
            }
        }
    }

    public void disconnect(isc_db_handle_impl db) throws IOException {
        if (log != null) {
            log.debug("About to invalidate db handle");
        }
        db.invalidate();
        if (log != null) {
            log.debug("successfully invalidated db handle");
        }
    }

    /*
     * Exception decompiling
     */
    public void getSqlCounts(isc_stmt_handle stmt_handle) throws GDSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: First case is not immediately after switch.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:442)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public isc_blob_handle get_new_isc_blob_handle() {
        return new isc_blob_handle_impl();
    }

    public isc_db_handle get_new_isc_db_handle() {
        return new isc_db_handle_impl();
    }

    public isc_stmt_handle get_new_isc_stmt_handle() {
        return new isc_stmt_handle_impl();
    }

    public isc_tr_handle get_new_isc_tr_handle() {
        return new isc_tr_handle_impl();
    }

    public void isc_attach_database(String host, Integer port, String file_name, isc_db_handle db_handle, Clumplet dpb) throws GDSException {
        DbAttachInfo dbai = new DbAttachInfo(host, port, file_name);
        this.isc_attach_database(dbai, db_handle, dpb);
    }

    public void isc_attach_database(String connectString, isc_db_handle db_handle, Clumplet dpb) throws GDSException {
        DbAttachInfo dbai = new DbAttachInfo(connectString);
        this.isc_attach_database(dbai, db_handle, dpb);
    }

    public void isc_attach_database(DbAttachInfo dbai, isc_db_handle db_handle, Clumplet dpb) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            this.connect(db, dbai, dpb);
            try {
                if (debug) {
                    log.debug("op_attach ");
                }
                db.out.writeInt(19);
                db.out.writeInt(0);
                db.out.writeString(dbai.getFileName());
                dpb = this.removeInternalDPB(dpb);
                db.out.writeTyped(1, (Xdrable)((Object)dpb));
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                try {
                    this.receiveResponse(db, -1);
                    db.setRdb_id(db.getResp_object());
                }
                catch (GDSException ge) {
                    this.disconnect(db);
                    throw ge;
                }
                this.parseAttachDatabaseInfo(this.isc_database_info(db, describe_database_info, 1024), db);
            }
            catch (IOException iOException) {
                throw new GDSException(335544727);
            }
        }
    }

    public void isc_close_blob(isc_blob_handle blob_handle) throws GDSException {
        isc_blob_handle_impl blob = (isc_blob_handle_impl)blob_handle;
        isc_db_handle_impl db = blob.getDb();
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_tr_handle_impl tr = blob.getTr();
        if (tr == null) {
            throw new GDSException(335544332);
        }
        this.releaseObject(db, 39, blob.getRbl_id());
        tr.removeBlob(blob);
    }

    public void isc_commit_retaining(isc_tr_handle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2 && tr.getState() != 4) {
                throw new GDSException(335544468);
            }
            tr.setState(5);
            try {
                if (debug) {
                    log.debug("op_commit_retaining ");
                }
                db.out.writeInt(50);
                db.out.writeInt(tr.getTransactionId());
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException iOException) {
                throw new GDSException(335544726);
            }
            tr.setState(2);
        }
    }

    public void isc_commit_transaction(isc_tr_handle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        boolean debug;
        boolean bl = debug = log != null && log.isDebugEnabled();
        if (tr_handle == null) {
            throw new GDSException(335544332);
        }
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2 && tr.getState() != 4) {
                throw new GDSException(335544468);
            }
            tr.setState(5);
            try {
                if (debug) {
                    log.debug("op_commit ");
                    log.debug("tr.rtr_id: " + tr.getTransactionId());
                }
                db.out.writeInt(30);
                db.out.writeInt(tr.getTransactionId());
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException iOException) {
                throw new GDSException(335544726);
            }
            tr.setState(0);
            tr.unsetDbHandle();
        }
    }

    public void isc_create_blob2(isc_db_handle db_handle, isc_tr_handle tr_handle, isc_blob_handle blob_handle, Clumplet bpb) throws GDSException {
        this.openOrCreateBlob(db_handle, tr_handle, blob_handle, bpb, bpb == null ? 34 : 57);
        ((isc_blob_handle_impl)blob_handle).rbl_flagsAdd(8);
    }

    public void isc_create_database(String file_name, isc_db_handle db_handle, Clumplet c) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            DbAttachInfo dbai = new DbAttachInfo(file_name);
            this.connect(db, dbai, c);
            try {
                if (debug) {
                    log.debug("op_create ");
                }
                db.out.writeInt(20);
                db.out.writeInt(0);
                db.out.writeString(dbai.getFileName());
                c = this.removeInternalDPB(c);
                db.out.writeTyped(1, (Xdrable)((Object)c));
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                try {
                    this.receiveResponse(db, -1);
                    db.setRdb_id(db.getResp_object());
                }
                catch (GDSException g) {
                    this.disconnect(db);
                    throw g;
                }
            }
            catch (IOException iOException) {
                throw new GDSException(335544727);
            }
        }
    }

    public byte[] isc_database_info(isc_db_handle handle, byte[] items, int buffer_length) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)handle;
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_info_database ");
                }
                db.out.writeInt(40);
                db.out.writeInt(db.getRdb_id());
                db.out.writeInt(0);
                db.out.writeBuffer(items);
                db.out.writeInt(buffer_length);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
                if (debug) {
                    log.debug("parseSqlInfo: first 2 bytes are " + this.isc_vax_integer(db.getResp_data(), 0, 2) + " or: " + db.getResp_data()[0] + ", " + db.getResp_data()[1]);
                }
                byte[] byArray = db.getResp_data();
                Object var8_8 = null;
                return byArray;
            }
            catch (IOException iOException) {
                throw new GDSException(335544721);
            }
        }
    }

    public void isc_detach_database(isc_db_handle db_handle) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            if (db_handle.hasTransactions()) {
                throw new GDSException(335544357, db.getOpenTransactionCount());
            }
            try {
                try {
                    if (debug) {
                        log.debug("op_detach ");
                    }
                    db.out.writeInt(21);
                    db.out.writeInt(db.getRdb_id());
                    db.out.flush();
                    if (debug) {
                        log.debug("sent");
                    }
                    this.receiveResponse(db, -1);
                }
                catch (IOException iOException) {
                    throw new GDSException(335544721);
                }
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    this.disconnect(db);
                }
                catch (IOException iOException) {
                    throw new GDSException(335544721);
                }
                throw throwable;
            }
            try {
                this.disconnect(db);
            }
            catch (IOException iOException) {
                throw new GDSException(335544721);
            }
        }
    }

    public void isc_drop_database(isc_db_handle db_handle) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_drop_database ");
                }
                db.out.writeInt(81);
                db.out.writeInt(db.getRdb_id());
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException iOException) {
                throw new GDSException(335544721);
            }
        }
    }

    public void isc_dsql_alloc_statement2(isc_db_handle db_handle, isc_stmt_handle stmt_handle) throws GDSException {
        throw new GDSException(335544378);
    }

    public void isc_dsql_allocate_statement(isc_db_handle db_handle, isc_stmt_handle stmt_handle) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        if (db_handle == null) {
            throw new GDSException(0x14000004);
        }
        if (stmt_handle == null) {
            throw new GDSException(335544327);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_allocate_statement ");
                }
                db.out.writeInt(62);
                db.out.writeInt(db.getRdb_id());
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
                stmt.setRsr_id(db.getResp_object());
            }
            catch (IOException iOException) {
                throw new GDSException(335544726);
            }
            stmt.setRsr_rdb(db);
            stmt.setAllRowsFetched(false);
        }
    }

    public XSQLDA isc_dsql_describe(isc_stmt_handle stmt_handle, int da_version) throws GDSException {
        byte[] buffer = this.isc_dsql_sql_info(stmt_handle, describe_select_info, 1024);
        return this.parseSqlInfo(stmt_handle, buffer, describe_select_info);
    }

    public XSQLDA isc_dsql_describe_bind(isc_stmt_handle stmt_handle, int da_version) throws GDSException {
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        byte[] buffer = this.isc_dsql_sql_info(stmt_handle, describe_bind_info, 1024);
        stmt.setInSqlda(this.parseSqlInfo(stmt_handle, buffer, describe_bind_info));
        return stmt.getInSqlda();
    }

    public void isc_dsql_exec_immed2(isc_db_handle db_handle, isc_tr_handle tr_handle, String statement, int dialect, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        this.isc_dsql_exec_immed2(db_handle, tr_handle, statement, "NONE", dialect, in_xsqlda, out_xsqlda);
    }

    public void isc_dsql_exec_immed2(isc_db_handle db_handle, isc_tr_handle tr_handle, String statement, String encoding, int dialect, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)db_handle;
        synchronized (isc_db_handle_impl2) {
            XdrOutputStream out = db.out;
            try {
                int op;
                if (in_xsqlda == null && out_xsqlda == null) {
                    if (debug) {
                        log.debug("op_exec_immediate ");
                    }
                    out.writeInt(64);
                } else {
                    if (debug) {
                        log.debug("op_exec_immediate2 ");
                    }
                    out.writeInt(75);
                    if (in_xsqlda != null) {
                        out.writeBuffer(in_xsqlda.blr);
                        out.writeInt(0);
                        out.writeInt(1);
                        out.writeSQLData(in_xsqlda);
                    } else {
                        out.writeBuffer(null);
                        out.writeInt(0);
                        out.writeInt(0);
                    }
                    if (out_xsqlda != null) {
                        out.writeBuffer(out_xsqlda.blr);
                    } else {
                        out.writeBuffer(null);
                    }
                    out.writeInt(0);
                }
                out.writeInt(tr.getTransactionId());
                out.writeInt(0);
                out.writeInt(dialect);
                out.writeString(statement, encoding);
                out.writeString("");
                out.writeInt(0);
                out.flush();
                if (debug) {
                    log.debug("sent");
                }
                if ((op = this.nextOperation(db)) == 78) {
                    this.receiveSqlResponse(db, out_xsqlda, null);
                    op = this.nextOperation(db);
                }
                this.receiveResponse(db, op);
            }
            catch (IOException iOException) {
                throw new GDSException(335544726);
            }
        }
    }

    public void isc_dsql_execute(isc_tr_handle tr_handle, isc_stmt_handle stmt_handle, int da_version, XSQLDA xsqlda) throws GDSException {
        this.isc_dsql_execute2(tr_handle, stmt_handle, da_version, xsqlda, null);
    }

    public void isc_dsql_execute2(isc_tr_handle tr_handle, isc_stmt_handle stmt_handle, int da_version, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            XdrOutputStream out = db.out;
            try {
                int op;
                if (debug) {
                    log.debug(out_xsqlda == null ? "op_execute " : "op_execute2 ");
                }
                out.writeInt(out_xsqlda == null ? 63 : 76);
                out.writeInt(stmt.getRsr_id());
                out.writeInt(tr.getTransactionId());
                if (in_xsqlda != null) {
                    out.writeBuffer(in_xsqlda.blr);
                    out.writeInt(0);
                    out.writeInt(1);
                    out.writeSQLData(in_xsqlda);
                } else {
                    out.writeBuffer(null);
                    out.writeInt(0);
                    out.writeInt(0);
                }
                if (out_xsqlda != null) {
                    stmt.clearRows();
                    out.writeBuffer(out_xsqlda.blr);
                    out.writeInt(0);
                }
                out.flush();
                if (debug) {
                    log.debug("sent");
                }
                if ((op = this.nextOperation(db)) == 78) {
                    stmt.ensureCapacity(1);
                    this.receiveSqlResponse(db, out_xsqlda, stmt);
                    op = this.nextOperation(db);
                    stmt.setAllRowsFetched(true);
                    stmt.setIsSingletonResult(true);
                } else {
                    stmt.setIsSingletonResult(false);
                }
                this.receiveResponse(db, op);
            }
            catch (IOException iOException) {
                throw new GDSException(335544726);
            }
        }
    }

    public void isc_dsql_execute_immediate(isc_db_handle db_handle, isc_tr_handle tr_handle, String statement, int dialect, XSQLDA xsqlda) throws GDSException {
        this.isc_dsql_exec_immed2(db_handle, tr_handle, statement, dialect, xsqlda, null);
    }

    public void isc_dsql_execute_immediate(isc_db_handle db_handle, isc_tr_handle tr_handle, String statement, String encoding, int dialect, XSQLDA xsqlda) throws GDSException {
        this.isc_dsql_exec_immed2(db_handle, tr_handle, statement, encoding, dialect, xsqlda, null);
    }

    public void isc_dsql_fetch(isc_stmt_handle stmt_handle, int da_version, XSQLDA xsqlda, int fetchSize) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl db = stmt.getRsr_rdb();
        if (stmt_handle == null) {
            throw new GDSException(335544327);
        }
        if (xsqlda == null) {
            throw new GDSException(335544583);
        }
        if (fetchSize <= 0) {
            throw new GDSException(335544583);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            XdrOutputStream out = db.out;
            XdrInputStream in = db.in;
            try {
                int op;
                stmt.ensureCapacity(fetchSize);
                if (debug) {
                    log.debug("op_fetch ");
                }
                out.writeInt(65);
                out.writeInt(stmt.getRsr_id());
                out.writeBuffer(xsqlda.blr);
                out.writeInt(0);
                out.writeInt(fetchSize);
                out.flush();
                if (debug) {
                    log.debug("sent");
                }
                if ((op = this.nextOperation(db)) == 66) {
                    int sqldata_status;
                    int sqldata_messages;
                    do {
                        sqldata_status = in.readInt();
                        sqldata_messages = in.readInt();
                        if (sqldata_messages <= 0 || sqldata_status != 0) continue;
                        in.readSQLData(xsqlda.ioLength, stmt);
                        this.nextOperation(db);
                    } while (sqldata_messages > 0 && sqldata_status == 0);
                    if (sqldata_status == 100) {
                        if (debug) {
                            log.debug("all rows successfully fetched");
                        }
                        stmt.setAllRowsFetched(true);
                    }
                } else {
                    this.receiveResponse(db, op);
                }
            }
            catch (IOException iOException) {
                throw new GDSException(335544726);
            }
        }
    }

    public void isc_dsql_free_statement(isc_stmt_handle stmt_handle, int option) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl db = stmt.getRsr_rdb();
        if (stmt_handle == null) {
            throw new GDSException(335544327);
        }
        if (stmt.getIsSingletonResult() && option == 1) {
            return;
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (!db.isValid()) {
                    Object var7_7 = null;
                    return;
                }
                if (debug) {
                    log.debug("op_free_statement ");
                }
                db.out.writeInt(67);
                db.out.writeInt(stmt.getRsr_id());
                db.out.writeInt(option);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
                if (option == 2) {
                    stmt.setInSqlda(null);
                    stmt.setOutSqlda(null);
                }
                stmt.clearRows();
            }
            catch (IOException iOException) {
                throw new GDSException(335544726);
            }
        }
    }

    public XSQLDA isc_dsql_prepare(isc_tr_handle tr_handle, isc_stmt_handle stmt_handle, String statement, int dialect) throws GDSException {
        return this.isc_dsql_prepare(tr_handle, stmt_handle, statement, "NONE", dialect);
    }

    public XSQLDA isc_dsql_prepare(isc_tr_handle tr_handle, isc_stmt_handle stmt_handle, String statement, String encoding, int dialect) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl db = stmt.getRsr_rdb();
        if (tr_handle == null) {
            throw new GDSException(335544332);
        }
        if (stmt_handle == null) {
            throw new GDSException(335544327);
        }
        stmt.setInSqlda(null);
        stmt.setOutSqlda(null);
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_prepare_statement ");
                }
                db.out.writeInt(68);
                db.out.writeInt(tr.getTransactionId());
                db.out.writeInt(stmt.getRsr_id());
                db.out.writeInt(dialect);
                db.out.writeString(statement, encoding);
                db.out.writeBuffer(sql_prepare_info);
                db.out.writeInt(1024);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
                stmt.setOutSqlda(this.parseSqlInfo(stmt_handle, db.getResp_data(), sql_prepare_info));
                XSQLDA xSQLDA = stmt.getOutSqlda();
                Object var12_12 = null;
                return xSQLDA;
            }
            catch (IOException iOException) {
                throw new GDSException(335544726);
            }
        }
    }

    public void isc_dsql_set_cursor_name(isc_stmt_handle stmt_handle, String cursor_name, int type) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl db = stmt.getRsr_rdb();
        if (stmt_handle == null) {
            throw new GDSException(335544327);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_set_cursor ");
                }
                db.out.writeInt(69);
                db.out.writeInt(stmt.getRsr_id());
                byte[] buffer = new byte[cursor_name.length() + 1];
                System.arraycopy(cursor_name.getBytes(), 0, buffer, 0, cursor_name.length());
                buffer[cursor_name.length()] = 0;
                db.out.writeBuffer(buffer);
                db.out.writeInt(0);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException iOException) {
                throw new GDSException(335544726);
            }
        }
    }

    public byte[] isc_dsql_sql_info(isc_stmt_handle stmt_handle, byte[] items, int buffer_length) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_info_sql ");
                }
                db.out.writeInt(70);
                db.out.writeInt(stmt.getRsr_id());
                db.out.writeInt(0);
                db.out.writeBuffer(items);
                db.out.writeInt(buffer_length);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
                byte[] byArray = db.getResp_data();
                Object var9_9 = null;
                return byArray;
            }
            catch (IOException iOException) {
                throw new GDSException(335544726);
            }
        }
    }

    public byte[] isc_expand_dpb(byte[] dpb, int dpb_length, int param, Object[] params) throws GDSException {
        return dpb;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] isc_get_segment(isc_blob_handle blob_handle, int requested) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_blob_handle_impl blob = (isc_blob_handle_impl)blob_handle;
        isc_db_handle_impl db = blob.getDb();
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_tr_handle_impl tr = blob.getTr();
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_get_segment ");
                }
                db.out.writeInt(36);
                db.out.writeInt(blob.getRbl_id());
                if (debug) {
                    log.debug("trying to read bytes: " + (requested + 2 < Short.MAX_VALUE ? requested + 2 : Short.MAX_VALUE));
                }
                db.out.writeInt(requested + 2 < Short.MAX_VALUE ? requested + 2 : Short.MAX_VALUE);
                db.out.writeInt(0);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
                blob.rbl_flagsRemove(2);
                if (db.getResp_object() == 1) {
                    blob.rbl_flagsAdd(2);
                } else if (db.getResp_object() == 2) {
                    blob.rbl_flagsAdd(4);
                }
                byte[] buffer = db.getResp_data();
                if (buffer.length == 0) {
                    return buffer;
                }
                int len = 0;
                int srcpos = 0;
                int destpos = 0;
                while (srcpos < buffer.length) {
                    len = this.isc_vax_integer(buffer, srcpos, 2);
                    System.arraycopy(buffer, srcpos += 2, buffer, destpos, len);
                    srcpos += len;
                    destpos += len;
                }
                byte[] result = new byte[destpos];
                System.arraycopy(buffer, 0, result, 0, destpos);
                return result;
            }
            catch (IOException iOException) {
                throw new GDSException(335544726);
            }
        }
    }

    public void isc_open_blob2(isc_db_handle db_handle, isc_tr_handle tr_handle, isc_blob_handle blob_handle, Clumplet bpb) throws GDSException {
        this.openOrCreateBlob(db_handle, tr_handle, blob_handle, bpb, bpb == null ? 35 : 56);
    }

    public void isc_prepare_transaction(isc_tr_handle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2) {
                throw new GDSException(335544468);
            }
            tr.setState(3);
            try {
                if (debug) {
                    log.debug("op_prepare ");
                }
                db.out.writeInt(32);
                db.out.writeInt(tr.getTransactionId());
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException iOException) {
                throw new GDSException(335544726);
            }
            tr.setState(4);
        }
    }

    public void isc_prepare_transaction2(isc_tr_handle tr_handle, byte[] bytes) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2) {
                throw new GDSException(335544468);
            }
            tr.setState(3);
            try {
                if (debug) {
                    log.debug("op_prepare2 ");
                }
                db.out.writeInt(51);
                db.out.writeInt(tr.getTransactionId());
                db.out.writeBuffer(bytes);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException iOException) {
                throw new GDSException(335544726);
            }
            tr.setState(4);
        }
    }

    public void isc_put_segment(isc_blob_handle blob_handle, byte[] buffer) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_blob_handle_impl blob = (isc_blob_handle_impl)blob_handle;
        isc_db_handle_impl db = blob.getDb();
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_tr_handle_impl tr = blob.getTr();
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug("op_batch_segments ");
                }
                db.out.writeInt(44);
                if (debug) {
                    log.debug("blob.rbl_id:  " + blob.getRbl_id());
                }
                db.out.writeInt(blob.getRbl_id());
                if (debug) {
                    log.debug("buffer.length " + buffer.length);
                }
                db.out.writeBlobBuffer(buffer);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException iOException) {
                throw new GDSException(335544726);
            }
        }
    }

    public void isc_rollback_retaining(isc_tr_handle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2 && tr.getState() != 4) {
                throw new GDSException(335544468);
            }
            tr.setState(6);
            try {
                if (debug) {
                    log.debug("op_rollback_retaining ");
                }
                db.out.writeInt(86);
                db.out.writeInt(tr.getTransactionId());
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException iOException) {
                throw new GDSException(335544726);
            }
            tr.setState(2);
        }
    }

    public void isc_rollback_transaction(isc_tr_handle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() == 0) {
                throw new GDSException(335544468);
            }
            tr.setState(6);
            try {
                try {
                    if (debug) {
                        log.debug("op_rollback ");
                    }
                    db.out.writeInt(31);
                    db.out.writeInt(tr.getTransactionId());
                    db.out.flush();
                    if (debug) {
                        log.debug("sent");
                    }
                    this.receiveResponse(db, -1);
                }
                catch (IOException iOException) {
                    throw new GDSException(335544726);
                }
                Object var8_6 = null;
                tr.setState(0);
                tr.unsetDbHandle();
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                tr.setState(0);
                tr.unsetDbHandle();
                throw throwable;
            }
        }
    }

    public void isc_start_transaction(isc_tr_handle tr_handle, isc_db_handle db_handle, byte[] tpb) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        if (tr_handle == null) {
            throw new GDSException(335544332);
        }
        if (db_handle == null) {
            throw new GDSException(0x14000004);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 0) {
                throw new GDSException(335544468);
            }
            tr.setState(1);
            try {
                if (debug) {
                    log.debug("op_transaction ");
                }
                db.out.writeInt(29);
                db.out.writeInt(db.getRdb_id());
                db.out.writeSet(3, tpb);
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
            }
            catch (IOException iOException) {
                throw new GDSException(335544721);
            }
            tr.setTransactionId(db.getResp_object());
            tr.setDbHandle(db);
            tr.setState(2);
        }
    }

    public int isc_vax_integer(byte[] buffer, int pos, int length) {
        int shift = 0;
        int value = 0;
        int i = pos;
        while (--length >= 0) {
            value += (buffer[i++] & 0xFF) << shift;
            shift += 8;
        }
        return value;
    }

    public static Clumplet newClumplet(int type) {
        return new ClumpletImpl(type, new byte[0]);
    }

    public static Clumplet newClumplet(int type, int c) {
        return new ClumpletImpl(type, new byte[]{(byte)(c >> 24), (byte)(c >> 16), (byte)(c >> 8), (byte)c});
    }

    public static Clumplet newClumplet(int type, String content) {
        return new StringClumplet(type, content);
    }

    public static Clumplet newClumplet(int type, byte[] content) {
        return new ClumpletImpl(type, content);
    }

    private int nextOperation(isc_db_handle_impl db) throws IOException {
        boolean debug = log != null && log.isDebugEnabled();
        int op = 0;
        do {
            op = db.in.readInt();
            if (!debug || op != 71) continue;
            log.debug("op_dummy received");
        } while (op == 71);
        return op;
    }

    private final void openOrCreateBlob(isc_db_handle db_handle, isc_tr_handle tr_handle, isc_blob_handle blob_handle, Clumplet bpb, int op) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_blob_handle_impl blob = (isc_blob_handle_impl)blob_handle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        if (tr == null) {
            throw new GDSException(335544332);
        }
        if (blob == null) {
            throw new GDSException(335544328);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                if (debug) {
                    log.debug(bpb == null ? "op_open/create_blob " : "op_open/create_blob2 ");
                    log.debug("op: " + op);
                }
                db.out.writeInt(op);
                if (bpb != null) {
                    db.out.writeTyped(1, (Xdrable)((Object)bpb));
                }
                db.out.writeInt(tr.getTransactionId());
                if (debug) {
                    log.debug("sending blob_id: " + blob.getBlob_id());
                }
                db.out.writeLong(blob.getBlob_id());
                db.out.flush();
                if (debug) {
                    log.debug("sent");
                }
                this.receiveResponse(db, -1);
                blob.setDb(db);
                blob.setTr(tr);
                blob.setRbl_id(db.getResp_object());
                blob.setBlob_id(db.getResp_blob_id());
                tr.addBlob(blob);
            }
            catch (IOException iOException) {
                throw new GDSException(335544726);
            }
        }
    }

    private void parseAttachDatabaseInfo(byte[] info, isc_db_handle handle) throws GDSException {
        boolean debug;
        boolean bl = debug = log != null && log.isDebugEnabled();
        if (debug) {
            log.debug("parseDatabaseInfo: first 2 bytes are " + this.isc_vax_integer(info, 0, 2) + " or: " + info[0] + ", " + info[1]);
        }
        int value = 0;
        int len = 0;
        int i = 0;
        isc_db_handle_impl db = (isc_db_handle_impl)handle;
        block7: while (info[i] != 1) {
            switch (info[i++]) {
                case 62: {
                    len = this.isc_vax_integer(info, i, 2);
                    value = this.isc_vax_integer(info, i += 2, len);
                    i += len;
                    db.setDialect(value);
                    if (!debug) continue block7;
                    log.debug("isc_info_db_sql_dialect:" + value);
                    break;
                }
                case 12: {
                    len = this.isc_vax_integer(info, i, 2);
                    i += 2;
                    if (debug) {
                        log.debug("isc_info_version len:" + len);
                    }
                    byte[] vers = new byte[len - 2];
                    System.arraycopy(info, i + 2, vers, 0, len - 2);
                    String versS = new String(vers);
                    i += len;
                    db.setVersion(versS);
                    if (!debug) continue block7;
                    log.debug("isc_info_version:" + versS);
                    break;
                }
                case 32: {
                    len = this.isc_vax_integer(info, i, 2);
                    value = this.isc_vax_integer(info, i += 2, len);
                    i += len;
                    db.setODSMajorVersion(value);
                    if (!debug) continue block7;
                    log.debug("isc_info_ods_version:" + value);
                    break;
                }
                case 33: {
                    len = this.isc_vax_integer(info, i, 2);
                    value = this.isc_vax_integer(info, i += 2, len);
                    i += len;
                    db.setODSMinorVersion(value);
                    if (!debug) continue block7;
                    log.debug("isc_info_ods_minor_version:" + value);
                    break;
                }
                case 2: {
                    if (debug) {
                        log.debug("isc_info_truncated ");
                    }
                    return;
                }
                default: {
                    throw new GDSException(335544583);
                }
            }
        }
    }

    private XSQLDA parseSqlInfo(isc_stmt_handle stmt_handle, byte[] info, byte[] items) throws GDSException {
        boolean debug;
        boolean bl = debug = log != null && log.isDebugEnabled();
        if (debug) {
            log.debug("parseSqlInfo started");
        }
        XSQLDA xsqlda = new XSQLDA();
        int lastindex = 0;
        while ((lastindex = this.parseTruncSqlInfo(info, xsqlda, lastindex)) > 0) {
            byte[] new_items = new byte[4 + items.length];
            new_items[0] = 20;
            new_items[1] = 2;
            new_items[2] = (byte)(--lastindex & 0xFF);
            new_items[3] = (byte)(lastindex >> 8);
            System.arraycopy(items, 0, new_items, 4, items.length);
            info = this.isc_dsql_sql_info(stmt_handle, new_items, info.length);
        }
        if (debug) {
            log.debug("parseSqlInfo ended");
        }
        GDS_Impl.calculateBLR(xsqlda);
        GDS_Impl.calculateIOLength(xsqlda);
        return xsqlda;
    }

    /*
     * Unable to fully structure code
     */
    private int parseTruncSqlInfo(byte[] info, XSQLDA xsqlda, int lastindex) throws GDSException {
        debug = GDS_Impl.log != null && GDS_Impl.log.isDebugEnabled() != false;
        index = 0;
        if (debug) {
            GDS_Impl.log.debug("parseSqlInfo: first 2 bytes are " + this.isc_vax_integer(info, 0, 2) + " or: " + info[0] + ", " + info[1]);
        }
        i = 2;
        len = this.isc_vax_integer(info, i, 2);
        n = this.isc_vax_integer(info, i += 2, len);
        i += len;
        if (xsqlda.sqlvar == null) {
            xsqlda.sqld = xsqlda.sqln = n;
            xsqlda.sqlvar = new XSQLVAR[xsqlda.sqln];
        }
        if (!debug) ** GOTO lbl89
        GDS_Impl.log.debug("xsqlda.sqln read as " + xsqlda.sqln);
        ** GOTO lbl89
        {
            switch (item) {
                case 9: {
                    len = this.isc_vax_integer(info, i, 2);
                    index = this.isc_vax_integer(info, i += 2, len);
                    i += len;
                    xsqlda.sqlvar[index - 1] = new XSQLVAR();
                    if (!debug) break;
                    GDS_Impl.log.debug("new xsqlvar " + (index - 1));
                    break;
                }
                case 11: {
                    len = this.isc_vax_integer(info, i, 2);
                    xsqlda.sqlvar[index - 1].sqltype = this.isc_vax_integer(info, i += 2, len);
                    i += len;
                    if (!debug) break;
                    GDS_Impl.log.debug("isc_info_sql_type " + xsqlda.sqlvar[index - 1].sqltype);
                    break;
                }
                case 12: {
                    len = this.isc_vax_integer(info, i, 2);
                    xsqlda.sqlvar[index - 1].sqlsubtype = this.isc_vax_integer(info, i += 2, len);
                    i += len;
                    if (!debug) break;
                    GDS_Impl.log.debug("isc_info_sql_sub_type " + xsqlda.sqlvar[index - 1].sqlsubtype);
                    break;
                }
                case 13: {
                    len = this.isc_vax_integer(info, i, 2);
                    xsqlda.sqlvar[index - 1].sqlscale = this.isc_vax_integer(info, i += 2, len);
                    i += len;
                    if (!debug) break;
                    GDS_Impl.log.debug("isc_info_sql_scale " + xsqlda.sqlvar[index - 1].sqlscale);
                    break;
                }
                case 14: {
                    len = this.isc_vax_integer(info, i, 2);
                    xsqlda.sqlvar[index - 1].sqllen = this.isc_vax_integer(info, i += 2, len);
                    i += len;
                    if (!debug) break;
                    GDS_Impl.log.debug("isc_info_sql_length " + xsqlda.sqlvar[index - 1].sqllen);
                    break;
                }
                case 16: {
                    len = this.isc_vax_integer(info, i, 2);
                    xsqlda.sqlvar[index - 1].sqlname = new String(info, i += 2, len);
                    i += len;
                    if (!debug) break;
                    GDS_Impl.log.debug("isc_info_sql_field " + xsqlda.sqlvar[index - 1].sqlname);
                    break;
                }
                case 17: {
                    len = this.isc_vax_integer(info, i, 2);
                    xsqlda.sqlvar[index - 1].relname = new String(info, i += 2, len);
                    i += len;
                    if (!debug) break;
                    GDS_Impl.log.debug("isc_info_sql_relation " + xsqlda.sqlvar[index - 1].relname);
                    break;
                }
                case 18: {
                    len = this.isc_vax_integer(info, i, 2);
                    xsqlda.sqlvar[index - 1].ownname = new String(info, i += 2, len);
                    i += len;
                    if (!debug) break;
                    GDS_Impl.log.debug("isc_info_sql_owner " + xsqlda.sqlvar[index - 1].ownname);
                    break;
                }
                case 19: {
                    len = this.isc_vax_integer(info, i, 2);
                    xsqlda.sqlvar[index - 1].aliasname = new String(info, i += 2, len);
                    i += len;
                    if (!debug) break;
                    GDS_Impl.log.debug("isc_info_sql_alias " + xsqlda.sqlvar[index - 1].aliasname);
                    break;
                }
                case 2: {
                    if (debug) {
                        GDS_Impl.log.debug("isc_info_truncated ");
                    }
                    return lastindex;
                }
                default: {
                    throw new GDSException(335544583);
                }
            }
            do {
                if ((item = info[i++]) != 8) continue block12;
                lastindex = index;
lbl89:
                // 3 sources

            } while (info[i] != 1);
        }
        return 0;
    }

    private void readStatusVector(isc_db_handle_impl db) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        try {
            GDSException head = null;
            GDSException tail = null;
            block8: while (true) {
                GDSException td;
                int arg = db.in.readInt();
                switch (arg) {
                    case 1: {
                        int er = db.in.readInt();
                        if (debug) {
                            log.debug("readStatusVector arg:isc_arg_gds int: " + er);
                        }
                        if (er == 0) continue block8;
                        GDSException td2 = new GDSException(arg, er);
                        if (head == null) {
                            head = td2;
                            tail = td2;
                            continue block8;
                        }
                        tail.setNext(td2);
                        tail = td2;
                        continue block8;
                    }
                    case 0: {
                        if (head != null && !head.isWarning()) {
                            throw head;
                        }
                        if (head != null && head.isWarning()) {
                            db.addWarning(head);
                        }
                        return;
                    }
                    case 2: 
                    case 5: {
                        GDSException ts = new GDSException(arg, db.in.readString());
                        if (debug) {
                            log.debug("readStatusVector string: " + ts.getMessage());
                        }
                        if (head == null) {
                            head = ts;
                            tail = ts;
                            continue block8;
                        }
                        tail.setNext(ts);
                        tail = ts;
                        continue block8;
                    }
                    case 4: {
                        int arg_value = db.in.readInt();
                        if (debug) {
                            log.debug("readStatusVector arg:isc_arg_number int: " + arg_value);
                        }
                        td = new GDSException(arg, arg_value);
                        if (head == null) {
                            head = td;
                            tail = td;
                            continue block8;
                        }
                        tail.setNext(td);
                        tail = td;
                        continue block8;
                    }
                }
                int e = db.in.readInt();
                if (debug) {
                    log.debug("readStatusVector arg: " + arg + " int: " + e);
                }
                if (e == 0) continue;
                td = new GDSException(arg, e);
                if (head == null) {
                    head = td;
                    tail = td;
                    continue;
                }
                tail.setNext(td);
                tail = td;
            }
        }
        catch (IOException ioe) {
            throw new GDSException(1, 335544726, ioe.getMessage());
        }
    }

    public void receiveResponse(isc_db_handle_impl db, int op) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        try {
            if (op == -1) {
                op = this.nextOperation(db);
            }
            if (debug) {
                log.debug("op_response ");
            }
            if (op == 9) {
                db.setResp_object(db.in.readInt());
                db.setResp_blob_id(db.in.readLong());
                db.setResp_data(db.in.readBuffer());
                if (debug) {
                    log.debug("op_response resp_object: " + db.getResp_object());
                    log.debug("op_response resp_blob_id: " + db.getResp_blob_id());
                    log.debug("op_response resp_data size: " + db.getResp_data().length);
                }
                this.readStatusVector(db);
                if (debug) {
                    log.debug("received");
                }
            } else if (debug) {
                log.debug("not received: op is " + op);
            }
        }
        catch (IOException ex) {
            if (debug) {
                log.warn("IOException in receiveResponse", ex);
            }
            throw new GDSException(1, 335544726, ex.getMessage());
        }
    }

    private void receiveSqlResponse(isc_db_handle_impl db, XSQLDA xsqlda, isc_stmt_handle_impl stmt) throws GDSException {
        boolean debug = log != null && log.isDebugEnabled();
        try {
            if (debug) {
                log.debug("op_sql_response ");
            }
            int messages = db.in.readInt();
            if (debug) {
                log.debug("received");
            }
            if (messages > 0) {
                db.in.readSQLData(xsqlda.ioLength, stmt);
            }
        }
        catch (IOException ex) {
            if (debug) {
                log.warn("IOException in receiveSQLResponse", ex);
            }
            throw new GDSException(1, 335544726, ex.getMessage());
        }
    }

    private void releaseObject(isc_db_handle_impl db, int op, int id) throws GDSException {
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            try {
                db.out.writeInt(op);
                db.out.writeInt(id);
                db.out.flush();
                this.receiveResponse(db, -1);
            }
            catch (IOException iOException) {
                throw new GDSException(335544726);
            }
        }
    }

    private Clumplet removeInternalDPB(Clumplet dpb) {
        Clumplet result = dpb;
        result = result.remove(129);
        return result;
    }

    protected static class DbAttachInfo {
        private String server = "localhost";
        private int port = 3050;
        private String fileName;

        public DbAttachInfo(String connectInfo) throws GDSException {
            char portSepChar;
            char hostSepChar;
            if (connectInfo == null) {
                throw new GDSException("Connection string missing");
            }
            if ((connectInfo = connectInfo.trim()).startsWith("//")) {
                connectInfo = connectInfo.substring(2);
                hostSepChar = '/';
                portSepChar = ':';
            } else {
                hostSepChar = ':';
                portSepChar = '/';
            }
            int sep = connectInfo.indexOf(hostSepChar);
            if (sep == 0 || sep == connectInfo.length() - 1) {
                throw new GDSException("Bad connection string: '" + hostSepChar + "' at beginning or end of:" + connectInfo + 335544323);
            }
            if (sep > 0) {
                this.server = connectInfo.substring(0, sep);
                this.fileName = connectInfo.substring(sep + 1);
                int portSep = this.server.indexOf(portSepChar);
                if (portSep == 0 || portSep == this.server.length() - 1) {
                    throw new GDSException("Bad server string: '" + portSepChar + "' at beginning or end of: " + this.server + 335544323);
                }
                if (portSep > 0) {
                    this.port = Integer.parseInt(this.server.substring(portSep + 1));
                    this.server = this.server.substring(0, portSep);
                }
            } else if (sep == -1) {
                this.fileName = connectInfo;
            }
        }

        public DbAttachInfo(String server, Integer port, String fileName) throws GDSException {
            if (fileName == null || fileName.equals("")) {
                throw new GDSException("null filename in DbAttachInfo");
            }
            if (server != null) {
                this.server = server;
            }
            if (port != null) {
                this.port = port;
            }
            this.fileName = fileName;
            if (fileName == null || fileName.equals("")) {
                throw new GDSException("null filename in DbAttachInfo");
            }
        }

        public String getFileName() {
            return this.fileName;
        }

        public int getPort() {
            return this.port;
        }

        public String getServer() {
            return this.server;
        }
    }
}

