/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import org.firebirdsql.gds.Clumplet;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSFactory;
import org.firebirdsql.gds.isc_db_handle;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.management.FBManagerMBean;

public class FBManager
implements FBManagerMBean {
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$management$FBManager != null ? class$org$firebirdsql$management$FBManager : (class$org$firebirdsql$management$FBManager = FBManager.class$("org.firebirdsql.management.FBManager")), true);
    private GDS gds;
    private Clumplet c;
    private String host = "localhost";
    private int port = 3050;
    private String fileName;
    private String userName;
    private String password;
    private boolean forceCreate = false;
    private boolean createOnStart = false;
    private boolean dropOnStop = false;
    private String state = "Stopped";
    private static final String STOPPED = "Stopped";
    private static final String STARTED = "Started";
    static /* synthetic */ Class class$org$firebirdsql$management$FBManager;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void createDatabase(String fileName, String user, String password) throws Exception {
        isc_db_handle db = null;
        if (!this.forceCreate) {
            db = this.gds.get_new_isc_db_handle();
            try {
                Clumplet dpb = GDSFactory.cloneClumplet(this.c);
                dpb.append(GDSFactory.newClumplet(28, user));
                dpb.append(GDSFactory.newClumplet(29, password));
                this.gds.isc_attach_database(this.getConnectString(fileName), db, dpb);
                this.gds.isc_detach_database(db);
                return;
            }
            catch (Exception exception) {}
        }
        db = this.gds.get_new_isc_db_handle();
        try {
            Clumplet dpb = GDSFactory.cloneClumplet(this.c);
            dpb.append(GDSFactory.newClumplet(28, user));
            dpb.append(GDSFactory.newClumplet(29, password));
            this.gds.isc_create_database(this.getConnectString(fileName), db, dpb);
            this.gds.isc_detach_database(db);
        }
        catch (Exception e) {
            if (log != null) {
                log.error("Exception creating database", e);
            }
            throw e;
        }
    }

    public void dropDatabase(String fileName, String user, String password) throws Exception {
        try {
            isc_db_handle db = this.gds.get_new_isc_db_handle();
            Clumplet dpb = GDSFactory.cloneClumplet(this.c);
            dpb.append(GDSFactory.newClumplet(28, user));
            dpb.append(GDSFactory.newClumplet(29, password));
            this.gds.isc_attach_database(this.getConnectString(fileName), db, dpb);
            this.gds.isc_drop_database(db);
        }
        catch (Exception e) {
            if (log != null) {
                log.error("Exception dropping database", e);
            }
            throw e;
        }
    }

    private String getConnectString(String filename) {
        String fileString = String.valueOf(this.getServer()) + "/" + this.getPort() + ":" + filename;
        return fileString;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return "Firebird Database manager";
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getServer() {
        return this.host;
    }

    public String getState() {
        return this.state;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isCreateOnStart() {
        return this.createOnStart;
    }

    public boolean isDropOnStop() {
        return this.dropOnStop;
    }

    public boolean isForceCreate() {
        return this.forceCreate;
    }

    public void setCreateOnStart(boolean createOnStart) {
        this.createOnStart = createOnStart;
    }

    public void setDropOnStop(boolean dropOnStop) {
        this.dropOnStop = dropOnStop;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setForceCreate(boolean forceCreate) {
        this.forceCreate = forceCreate;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setServer(String host) {
        this.host = host;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void start() throws Exception {
        this.gds = GDSFactory.newGDS();
        this.c = GDSFactory.newClumplet(5, new byte[]{90});
        byte[] byArray = new byte[4];
        byArray[0] = 120;
        byArray[1] = 10;
        this.c.append(GDSFactory.newClumplet(58, byArray));
        byte[] byArray2 = new byte[4];
        byArray2[0] = 3;
        this.c.append(GDSFactory.newClumplet(63, byArray2));
        this.state = STARTED;
        if (this.isCreateOnStart()) {
            this.createDatabase(this.getFileName(), this.getUserName(), this.getPassword());
        }
    }

    public void stop() throws Exception {
        if (this.isDropOnStop()) {
            this.dropDatabase(this.getFileName(), this.getUserName(), this.getPassword());
        }
        this.c = null;
        this.gds = null;
        this.state = STOPPED;
    }
}

